/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.dom;

import com.aspose.pdf.internal.html.MimeType;
import com.aspose.pdf.internal.html.collections.HTMLCollection;
import com.aspose.pdf.internal.html.collections.NamedNodeMap;
import com.aspose.pdf.internal.html.collections.NodeList;
import com.aspose.pdf.internal.html.dom.Attr;
import com.aspose.pdf.internal.html.dom.Document;
import com.aspose.pdf.internal.html.dom.IChildNode;
import com.aspose.pdf.internal.html.dom.IParentNode;
import com.aspose.pdf.internal.html.dom.Node;
import com.aspose.pdf.internal.html.dom.ShadowRoot;
import com.aspose.pdf.internal.html.dom.TypeInfo;
import com.aspose.pdf.internal.html.dom.attributes.DOMInitDictParameterAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMNameAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMNullableAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMObjectAttribute;
import com.aspose.pdf.internal.html.dom.lI;
import com.aspose.pdf.internal.html.dom.lu;
import com.aspose.pdf.internal.html.dom.traversal.ITreeWalker;
import com.aspose.pdf.internal.html.dom.traversal.filters.lI;
import com.aspose.pdf.internal.html.dom.traversal.filters.lb;
import com.aspose.pdf.internal.html.dom.traversal.filters.ld;
import com.aspose.pdf.internal.html.dom.traversal.filters.le;
import com.aspose.pdf.internal.html.dom.traversal.filters.lt;
import com.aspose.pdf.internal.html.l0v;
import com.aspose.pdf.internal.html.lf;
import com.aspose.pdf.internal.html.services.l0if;
import com.aspose.pdf.internal.html.services.l1l;
import com.aspose.pdf.internal.l35t.lj;
import com.aspose.pdf.internal.ms.System.Collections.Generic.l0t;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l5f;
import com.aspose.pdf.internal.ms.System.l8t;

@DOMObjectAttribute
@DOMNameAttribute(name="Element")
public class Element
extends Node
implements IChildNode,
IParentNode {
    private static final l0t<l0v> ShadowSupportedElements = new l0t();
    private final lu domName;
    private ShadowRoot shadowRoot;
    private NamedNodeMap _attributes;
    private com.aspose.pdf.internal.l29u.lb cssProperty;
    private l0v auto_Tag;

    public Element(lu name, Document doc) {
        super(doc);
        this.domName = name;
        this.setTag(l0v.lI(name.lI()));
        this._attributes = new NamedNodeMap(this);
    }

    public l0v getTag() {
        return this.auto_Tag;
    }

    private void setTag(l0v value) {
        this.auto_Tag = value;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this._attributes;
    }

    @Override
    public boolean hasAttributes() {
        return this._attributes != null && this._attributes.getLength() > 0;
    }

    @Override
    @DOMNameAttribute(name="localName")
    public String getLocalName() {
        return this.domName.lI();
    }

    @Override
    @DOMNameAttribute(name="namespaceURI")
    @DOMNullableAttribute
    public String getNamespaceURI() {
        return this.domName.lt();
    }

    @Override
    @DOMNameAttribute(name="prefix")
    @DOMNullableAttribute
    public String getPrefix() {
        return this.domName.ld();
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public int getNodeType() {
        return 1;
    }

    @DOMNameAttribute(name="tagName")
    public String getTagName() {
        return this.domName.lj();
    }

    @DOMNameAttribute(name="id")
    public String getId() {
        String string = this.getAttribute("id");
        if (string == null) {
            string = l10l.lI;
        }
        return string;
    }

    @DOMNameAttribute(name="id")
    public void setId(String value) {
        this.setAttribute("id", value);
    }

    @DOMNameAttribute(name="className")
    public String getClassName() {
        String string = this.getAttribute("class");
        if (string == null) {
            string = l10l.lI;
        }
        return string;
    }

    @DOMNameAttribute(name="className")
    public void setClassName(String value) {
        this.setAttribute("class", value);
    }

    @DOMNameAttribute(name="getAttribute")
    @DOMNullableAttribute
    public String getAttribute(String name) {
        Attr attr = this._attributes.getNamedItem(name);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    @DOMNameAttribute(name="getAttributeNS")
    @DOMNullableAttribute
    public String getAttributeNS(String namespaceURI, String localName) {
        Attr attr = this._attributes.getNamedItemNS(namespaceURI, localName);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    @DOMNameAttribute(name="setAttribute")
    public void setAttribute(String name, String value) {
        Attr attr;
        if (!com.aspose.pdf.internal.l35t.lt.lI(name)) {
            throw com.aspose.pdf.internal.l31k.lI.lI().lf("InvalidCharacterError");
        }
        if (lj.lI(this.getNamespaceURI(), new String[]{"http://www.w3.org/1999/xhtml"}) && com.aspose.pdf.internal.l35t.lI.lI(MimeType.to_MimeType(this.getOwnerDocument().getContentType()), lI.ld.lI, lI.ld.ld)) {
            name = l10l.ld(name);
        }
        if ((attr = this._attributes.getNamedItem(name)) == null) {
            attr = new Attr(lu.lI(name, null, null, this.getOwnerDocument()), this.getOwnerDocument());
            attr.setValue(value);
            this._attributes.append(attr);
        } else {
            this._attributes.change(attr, value);
        }
    }

    @DOMNameAttribute(name="setAttributeNS")
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        String string = null;
        String string2 = null;
        String[] stringArray = new String[]{namespaceURI};
        String[] stringArray2 = new String[]{string2};
        String[] stringArray3 = new String[]{string};
        lu.lI(qualifiedName, stringArray, stringArray2, stringArray3, this.getOwnerDocument());
        namespaceURI = stringArray[0];
        string2 = stringArray2[0];
        string = stringArray3[0];
        this._attributes.setAttributeValue(namespaceURI, string2, string, value);
    }

    @DOMNameAttribute(name="removeAttribute")
    public void removeAttribute(String name) {
        this._attributes.removeNamedItem(name);
    }

    @DOMNameAttribute(name="removeAttributeNS")
    public void removeAttributeNS(String namespaceURI, String localName) {
        this._attributes.removeNamedItemNS(namespaceURI, localName);
    }

    @DOMNameAttribute(name="hasAttribute")
    public boolean hasAttribute(String name) {
        return this._attributes.getNamedItem(name) != null;
    }

    @DOMNameAttribute(name="hasAttributeNS")
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this._attributes.getNamedItemNS(namespaceURI, localName) != null;
    }

    @DOMNameAttribute(name="getAttributeNode")
    public Attr getAttributeNode(String name) {
        return this._attributes.getNamedItem(name);
    }

    @DOMNameAttribute(name="setAttributeNode")
    public Attr setAttributeNode(Attr newAttr) {
        return this._attributes.setNamedItem(newAttr);
    }

    @DOMNameAttribute(name="removeAttributeNode")
    public Attr removeAttributeNode(Attr oldAttr) {
        return this._attributes.removeNamedItem(oldAttr.getName());
    }

    @DOMNameAttribute(name="getAttributeNodeNS")
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return this._attributes.getNamedItemNS(namespaceURI, localName);
    }

    @DOMNameAttribute(name="setAttributeNodeNS")
    public Attr setAttributeNodeNS(Attr newAttr) {
        return this._attributes.setNamedItem(newAttr);
    }

    @DOMNameAttribute(name="getElementsByTagName")
    public HTMLCollection getElementsByTagName(String name) {
        return new com.aspose.pdf.internal.html.collections.lj(this, new ld(name));
    }

    @DOMNameAttribute(name="getElementsByTagNameNS")
    public HTMLCollection getElementsByTagNameNS(String namespaceURI, String localName) {
        return new com.aspose.pdf.internal.html.collections.lj(this, new lb(namespaceURI, localName, this.getOwnerDocument().getNameTable().lI("*")));
    }

    @Override
    public void remove() {
        if (this.getParentNode() != null) {
            this.getParentNode().removeChild(this);
        }
    }

    @Override
    public Element getFirstElementChild() {
        ITreeWalker iTreeWalker = this.getOwnerDocument().createTreeWalker(this, 1L, null);
        try {
            Element element = (Element)((Object)com.aspose.pdf.internal.l82h.lb.lI(iTreeWalker.firstChild(), Element.class));
            return element;
        }
        finally {
            if (iTreeWalker != null) {
                iTreeWalker.dispose();
            }
        }
    }

    @Override
    public Element getLastElementChild() {
        ITreeWalker iTreeWalker = this.getOwnerDocument().createTreeWalker(this, 1L, null);
        try {
            Element element = (Element)((Object)com.aspose.pdf.internal.l82h.lb.lI(iTreeWalker.lastChild(), Element.class));
            return element;
        }
        finally {
            if (iTreeWalker != null) {
                iTreeWalker.dispose();
            }
        }
    }

    @Override
    public Element getPreviousElementSibling() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (com.aspose.pdf.internal.l82h.lb.lt((Object)node.getNodeType(), 8) != com.aspose.pdf.internal.l82h.lb.lt((Object)1, 8)) continue;
            return (Element)node;
        }
        return null;
    }

    @Override
    public Element getNextElementSibling() {
        for (Node node = this.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (com.aspose.pdf.internal.l82h.lb.lt((Object)node.getNodeType(), 8) != com.aspose.pdf.internal.l82h.lb.lt((Object)1, 8)) continue;
            return (Element)node;
        }
        return null;
    }

    @Override
    public int getChildElementCount() {
        return this.getChildren().getLength();
    }

    @Override
    public HTMLCollection getChildren() {
        return new com.aspose.pdf.internal.html.collections.lj(this, new lI(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node cloneNode(boolean deep) {
        Object object;
        Element element = this.getOwnerDocument().createElementNS(this.getNamespaceURI(), this.getNodeName());
        if (this._attributes.getLength() != 0) {
            object = this._attributes.iterator();
            try {
                while (object.hasNext()) {
                    Attr attr = (Attr)object.next();
                    Attr attr2 = (Attr)attr.cloneNode(true);
                    element._attributes.setNamedItem(attr2);
                }
            }
            finally {
                if (com.aspose.pdf.internal.l82h.lb.lf(object, l5f.class)) {
                    ((l5f)object).dispose();
                }
            }
        }
        if (deep) {
            for (object = this.getFirstChild(); object != null; object = ((Node)object).getNextSibling()) {
                element.appendChild(((Node)object).cloneNode(deep));
            }
        }
        return element;
    }

    @Override
    public NodeList querySelectorAll(String selector) {
        return ((l1l)this.getOwnerDocument().getContext().getService(com.aspose.pdf.internal.html.services.ld.class)).lf(selector, this);
    }

    @Override
    public Element querySelector(String selector) {
        return ((l1l)this.getOwnerDocument().getContext().getService(com.aspose.pdf.internal.html.services.ld.class)).lI(selector, this);
    }

    @DOMNameAttribute(name="schemaTypeInfo")
    public TypeInfo getSchemaTypeInfo() {
        return new TypeInfo(this);
    }

    @DOMNameAttribute(name="setIdAttribute")
    public void setIdAttribute(String name, boolean isId) {
        Attr attr = this.getAttributeNode(name);
        if (attr != null) {
            attr.setId(isId);
        }
    }

    @DOMNameAttribute(name="setIdAttributeNS")
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) {
        Attr attr = this.getAttributeNodeNS(namespaceURI, localName);
        if (attr != null) {
            attr.setId(isId);
        }
    }

    @DOMNameAttribute(name="setIdAttributeNode")
    public void setIdAttributeNode(Attr idAttr, boolean isId) {
        Attr attr = this.getAttributeNode(idAttr.getName());
        if (attr != null) {
            attr.setId(isId);
        }
    }

    @DOMNameAttribute(name="innerHTML")
    public String getInnerHTML() {
        return ((l0if)this.getOwnerDocument().getContext().getService(l0if.class)).lI().lI((Node)this, new le(this), true);
    }

    @DOMNameAttribute(name="innerHTML")
    public void setInnerHTML(String value) {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            this.removeChild(node);
            node = node2;
        }
        ((lf)this.getOwnerDocument().getContext()).lI(this, value);
    }

    @DOMNameAttribute(name="outerHTML")
    public String getOuterHTML() {
        return ((l0if)this.getOwnerDocument().getContext().getService(l0if.class)).lI().lI((Node)this, true);
    }

    @DOMNameAttribute(name="outerHTML")
    public void setOuterHTML(String value) {
    }

    @DOMNameAttribute(name="attachShadow")
    @DOMInitDictParameterAttribute(name="mode")
    public ShadowRoot attachShadow(int mode) {
        if (!"http://www.w3.org/1999/xhtml".equals(this.getNamespaceURI())) {
            throw com.aspose.pdf.internal.l31k.lI.lI().lI("NotSupportedError");
        }
        if (!ShadowSupportedElements.containsItem(this.getTag())) {
            throw com.aspose.pdf.internal.l31k.lI.lI().lI("NotSupportedError");
        }
        if (this.shadowRoot != null) {
            throw com.aspose.pdf.internal.l31k.lI.lI().lI("InvalidStateError");
        }
        this.shadowRoot = new ShadowRoot(this.getOwnerDocument(), mode, this);
        return this.shadowRoot;
    }

    @DOMNameAttribute(name="shadowRoot")
    public ShadowRoot getShadowRoot() {
        if (this.shadowRoot == null || this.shadowRoot.getMode() == 1) {
            return null;
        }
        return this.shadowRoot;
    }

    @DOMNameAttribute(name="getElementsByClassName")
    public HTMLCollection getElementsByClassName(String classNames) {
        return new com.aspose.pdf.internal.html.collections.lj(this, new lt(classNames));
    }

    public com.aspose.pdf.internal.l29u.lb getCSSProperty() {
        com.aspose.pdf.internal.l29u.lb lb2 = this.cssProperty;
        if (lb2 == null) {
            lb2 = this.cssProperty = this.getOwnerDocument().getCSSService().lI(this);
        }
        return lb2;
    }

    public boolean equals(l0v other) {
        if (l8t.lf(null, other)) {
            return false;
        }
        return l8t.lf(this.getTag(), other);
    }

    static {
        ShadowSupportedElements.addItem(lI.le.lh);
        ShadowSupportedElements.addItem(lI.le.lc);
        ShadowSupportedElements.addItem(lI.le.l0f);
        ShadowSupportedElements.addItem(lI.le.le);
        ShadowSupportedElements.addItem(lI.le.l1y);
        ShadowSupportedElements.addItem(lI.le.l0j);
        ShadowSupportedElements.addItem(lI.le.ly);
        ShadowSupportedElements.addItem(lI.le.l0if);
        ShadowSupportedElements.addItem(lI.le.l0l);
        ShadowSupportedElements.addItem(lI.le.l0t);
        ShadowSupportedElements.addItem(lI.le.l0v);
        ShadowSupportedElements.addItem(lI.le.l0p);
        ShadowSupportedElements.addItem(lI.le.l0u);
        ShadowSupportedElements.addItem(lI.le.l1n);
        ShadowSupportedElements.addItem(lI.le.lv);
        ShadowSupportedElements.addItem(lI.le.l0y);
        ShadowSupportedElements.addItem(lI.le.lk);
        ShadowSupportedElements.addItem(lI.le.l4t);
    }
}

