/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html;

import com.aspose.pdf.internal.html.HTMLElement;
import com.aspose.pdf.internal.html.HTMLTableCaptionElement;
import com.aspose.pdf.internal.html.HTMLTableSectionElement;
import com.aspose.pdf.internal.html.collections.HTMLCollection;
import com.aspose.pdf.internal.html.collections.lj;
import com.aspose.pdf.internal.html.dom.Document;
import com.aspose.pdf.internal.html.dom.Element;
import com.aspose.pdf.internal.html.dom.Node;
import com.aspose.pdf.internal.html.dom.attributes.DOMNameAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMNullableAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMObjectAttribute;
import com.aspose.pdf.internal.html.dom.lu;
import com.aspose.pdf.internal.html.dom.traversal.filters.ld;
import com.aspose.pdf.internal.l31k.lI;
import com.aspose.pdf.internal.l82h.lb;
import com.aspose.pdf.internal.ms.System.l10l;

@DOMObjectAttribute
@DOMNameAttribute(name="HTMLTableElement")
public class HTMLTableElement
extends HTMLElement {
    private HTMLTableSectionElement body;

    public HTMLTableElement(lu name, Document doc) {
        super(name, doc);
    }

    @DOMNameAttribute(name="caption")
    public HTMLTableCaptionElement getCaption() {
        return this.getChildOfType(HTMLTableCaptionElement.class);
    }

    @DOMNameAttribute(name="tHead")
    @DOMNullableAttribute
    public HTMLTableSectionElement getTHead() {
        return this.getTableSection("THEAD");
    }

    @DOMNameAttribute(name="tFoot")
    @DOMNullableAttribute
    public HTMLTableSectionElement getTFoot() {
        return this.getTableSection("TFOOT");
    }

    private HTMLTableSectionElement getTableSection(String sectionName) {
        lj lj2 = new lj(this, new ld(sectionName));
        if (lj2.getLength() > 0) {
            return (HTMLTableSectionElement)((Object)lb.lI(lj2.get_Item(0), HTMLTableSectionElement.class));
        }
        return null;
    }

    @DOMNameAttribute(name="rows")
    public HTMLCollection getRows() {
        return new lj(this, new ld("TR"));
    }

    @DOMNameAttribute(name="tBodies")
    public HTMLCollection getTBodies() {
        return new lj(this, new ld("TBODY"));
    }

    public HTMLTableSectionElement getBody() {
        HTMLCollection hTMLCollection;
        if (this.body == null && (hTMLCollection = this.getTBodies()).getLength() != 0) {
            this.body = (HTMLTableSectionElement)((Object)lb.lI(hTMLCollection.get_Item(hTMLCollection.getLength() - 1), HTMLTableSectionElement.class));
        }
        return this.body;
    }

    @DOMNameAttribute(name="align")
    public String getAlign() {
        return this.getAttributeOrDefault("align", l10l.lI);
    }

    @DOMNameAttribute(name="align")
    public void setAlign(String value) {
        this.setAttribute("align", value);
    }

    @DOMNameAttribute(name="bgColor")
    public String getBgColor() {
        return this.getAttributeOrDefault("bgcolor", l10l.lI);
    }

    @DOMNameAttribute(name="bgColor")
    public void setBgColor(String value) {
        this.setAttribute("bgcolor", value);
    }

    @DOMNameAttribute(name="border")
    public String getBorder() {
        return this.getAttributeOrDefault("border", l10l.lI);
    }

    @DOMNameAttribute(name="border")
    public void setBorder(String value) {
        this.setAttribute("border", value);
    }

    @DOMNameAttribute(name="cellPadding")
    public String getCellPadding() {
        return this.getAttributeOrDefault("cellpadding", l10l.lI);
    }

    @DOMNameAttribute(name="cellPadding")
    public void setCellPadding(String value) {
        this.setAttribute("cellpadding", value);
    }

    @DOMNameAttribute(name="cellSpacing")
    public String getCellSpacing() {
        return this.getAttributeOrDefault("cellspacing", l10l.lI);
    }

    @DOMNameAttribute(name="cellSpacing")
    public void setCellSpacing(String value) {
        this.setAttribute("cellspacing", value);
    }

    @DOMNameAttribute(name="frame")
    public String getFrame() {
        return this.getAttributeOrDefault("frame", l10l.lI);
    }

    @DOMNameAttribute(name="frame")
    public void setFrame(String value) {
        this.setAttribute("frame", value);
    }

    @DOMNameAttribute(name="rules")
    public String getRules() {
        return this.getAttributeOrDefault("rules", "none");
    }

    @DOMNameAttribute(name="rules")
    public void setRules(String value) {
        this.setAttribute("rules", value);
    }

    @DOMNameAttribute(name="summary")
    public String getSummary() {
        return this.getAttributeOrDefault("summary", l10l.lI);
    }

    @DOMNameAttribute(name="summary")
    public void setSummary(String value) {
        this.setAttribute("summary", value);
    }

    @DOMNameAttribute(name="width")
    public String getWidth() {
        return this.getAttributeOrDefault("width", l10l.lI);
    }

    @DOMNameAttribute(name="width")
    public void setWidth(String value) {
        this.setAttribute("width", value);
    }

    @DOMNameAttribute(name="createTHead")
    public Element createTHead() {
        HTMLElement hTMLElement = (HTMLElement)((Object)lb.lI(this.getTHead(), HTMLElement.class));
        if (hTMLElement != null) {
            return hTMLElement;
        }
        HTMLElement hTMLElement2 = (HTMLElement)((Object)lb.lI(this.getOwnerDocument().createElement("THEAD"), HTMLElement.class));
        HTMLElement hTMLElement3 = (HTMLElement)((Object)lb.lI(this.getCaption(), HTMLElement.class));
        if (hTMLElement3 != null) {
            return (Element)((Object)lb.lI(this.insertBefore(hTMLElement2, hTMLElement3.getNextSibling()), HTMLElement.class));
        }
        return (Element)((Object)lb.lI(this.insertBefore(hTMLElement2, (Node)((Object)lb.lI(this.getFirstElementChild(), Element.class))), HTMLElement.class));
    }

    @DOMNameAttribute(name="deleteTHead")
    public void deleteTHead() {
        this.removeSectionElement((HTMLElement)((Object)lb.lI(this.getTHead(), HTMLElement.class)));
    }

    @DOMNameAttribute(name="createTFoot")
    public Element createTFoot() {
        if (this.getTFoot() == null) {
            this.appendChild(this.getOwnerDocument().createElement("TFOOT"));
        }
        return this.getTFoot();
    }

    @DOMNameAttribute(name="deleteTFoot")
    public void deleteTFoot() {
        this.removeSectionElement((HTMLElement)((Object)lb.lI(this.getTFoot(), HTMLElement.class)));
    }

    @DOMNameAttribute(name="createCaption")
    public Element createCaption() {
        if (this.getCaption() == null) {
            this.insertBefore(this.getOwnerDocument().createElement("CAPTION"), this.getFirstElementChild());
        }
        return this.getCaption();
    }

    @DOMNameAttribute(name="deleteCaption")
    public void deleteCaption() {
        this.removeSectionElement((HTMLElement)((Object)lb.lI(this.getCaption(), HTMLElement.class)));
    }

    private void removeSectionElement(HTMLElement element) {
        if (element != null) {
            this.removeChild(element);
        }
    }

    @DOMNameAttribute(name="insertRow")
    public Node insertRow(int index) {
        HTMLElement hTMLElement;
        Element element;
        HTMLCollection hTMLCollection = this.getRows();
        if (index < -1 || index > hTMLCollection.getLength()) {
            throw lI.lI().lf("IndexSizeError");
        }
        HTMLElement hTMLElement2 = hTMLCollection.getLength() > index && index != -1 ? (HTMLElement)((Object)lb.lI(hTMLCollection.get_Item(index), HTMLElement.class)) : null;
        HTMLTableSectionElement hTMLTableSectionElement = hTMLElement2 != null ? hTMLElement2.getParentOfType(HTMLTableSectionElement.class) : null;
        HTMLCollection hTMLCollection2 = this.getTBodies();
        if (hTMLCollection2.getLength() == 0) {
            element = (HTMLElement)((Object)lb.lI(this.getTHead(), HTMLElement.class));
            if (element == null) {
                element = (HTMLElement)((Object)lb.lI(this.getCaption(), HTMLElement.class));
            }
            hTMLElement = (HTMLElement)((Object)lb.lI(this.getOwnerDocument().createElement("TBODY"), HTMLElement.class));
            hTMLElement = element != null ? (HTMLElement)((Object)lb.lI(this.insertBefore(hTMLElement, element.getNextSibling()), HTMLElement.class)) : (HTMLElement)((Object)lb.lI(this.insertBefore(hTMLElement, (Node)((Object)lb.lI(this.getFirstElementChild(), Element.class))), HTMLElement.class));
        } else {
            element = hTMLTableSectionElement;
            if (element == null) {
                element = (HTMLElement)((Object)lb.lI(hTMLCollection2.get_Item(hTMLCollection2.getLength() - 1), HTMLElement.class));
            }
            hTMLElement = element;
        }
        element = this.getOwnerDocument().createElement("TR");
        if (hTMLTableSectionElement == hTMLElement && index != -1) {
            return (Node)((Object)lb.lI(hTMLElement.insertBefore((Node)((Object)lb.lI(element, Element.class)), hTMLElement2), HTMLElement.class));
        }
        return (Node)((Object)lb.lI(hTMLElement.appendChild((Node)((Object)lb.lI(element, Element.class))), HTMLElement.class));
    }

    @DOMNameAttribute(name="deleteRow")
    public void deleteRow(int index) {
        HTMLCollection hTMLCollection = this.getRows();
        if (index < -1 || index >= hTMLCollection.getLength()) {
            throw lI.lI().lf("IndexSizeError");
        }
        HTMLElement hTMLElement = (HTMLElement)((Object)lb.lI(index != -1 ? hTMLCollection.get_Item(index) : hTMLCollection.get_Item(hTMLCollection.getLength() - 1), HTMLElement.class));
        Element element = hTMLElement.getParentElement();
        element.removeChild(hTMLElement);
    }
}

