/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import com.aspose.pdf.Annotation;
import com.aspose.pdf.FileAttachmentAnnotation;
import com.aspose.pdf.FileSpecification;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.ImagePlacement;
import com.aspose.pdf.ImagePlacementAbsorber;
import com.aspose.pdf.ImageType;
import com.aspose.pdf.InternalHelper;
import com.aspose.pdf.Page;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.TextAbsorber;
import com.aspose.pdf.TextEncodingInternal;
import com.aspose.pdf.TextExtractionOptions;
import com.aspose.pdf.TextSearchOptions;
import com.aspose.pdf.XForm;
import com.aspose.pdf.XImage;
import com.aspose.pdf.facades.Facade;
import com.aspose.pdf.facades.lj;
import com.aspose.pdf.internal.l5n.l0if;
import com.aspose.pdf.internal.l5n.lh;
import com.aspose.pdf.internal.l70y.l0p;
import com.aspose.pdf.internal.l82h.lb;
import com.aspose.pdf.internal.l9y.l0l;
import com.aspose.pdf.internal.ms.System.Collections.Generic.l0t;
import com.aspose.pdf.internal.ms.System.Collections.Generic.lf;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.IO.l1j;
import com.aspose.pdf.internal.ms.System.IO.l1y;
import com.aspose.pdf.internal.ms.System.IO.l2h;
import com.aspose.pdf.internal.ms.System.IO.lf;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l5if;
import com.aspose.pdf.internal.ms.System.l7n;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PdfExtractor
extends Facade {
    private static final Logger lI = Logger.getLogger(PdfExtractor.class.getName());
    private int lf;
    private int lj;
    private int lt;
    private l0t<XImage> lb;
    private int ld;
    private int lu;
    private String le;
    private l0t<String> lh;
    private int lk = 0;
    private int lc = 0;
    private TextSearchOptions ly = new TextSearchOptions(Rectangle.getEmpty());
    private int l0if = 150;
    private String l0l = null;
    private l0p l0t;
    private com.aspose.pdf.internal.ms.System.Collections.Generic.lf<Integer, Integer> l0v = new com.aspose.pdf.internal.ms.System.Collections.Generic.lf();
    private l0l l0p = null;

    boolean lI() {
        if (this.l0p != null) {
            int n = (Integer)this.l0p.lI;
            return InternalHelper.lt() || n == 2;
        }
        return InternalHelper.lt();
    }

    void lI(l0l l0l2) {
        this.l0p = l0l2;
    }

    l0l lf() {
        return this.l0p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lI(FileSpecification fileSpecification, String string) {
        String string2 = l1y.lI(fileSpecification.getName());
        if (string2 == null) {
            string2 = l10l.lI("NoName{0}", new Object[]{this.lu++});
        }
        if (string == null) {
            string = l10l.lI;
        }
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileOutputStream = new FileOutputStream(l1y.lf(string, string2));
            l1j l1j2 = (l1j)((Object)com.aspose.pdf.internal.l82h.lb.lI(fileSpecification.getContentsInternal(), l1j.class));
            if (l1j2 == null) {
                throw new l7n("Use for stream data only MemoryStream");
            }
            l1j2.seek(0L, 0);
            byte[] byArray = new byte[1024];
            while ((n = l1j2.read(byArray, 0, byArray.length)) == byArray.length) {
                fileOutputStream.write(byArray, 0, byArray.length);
            }
            fileOutputStream.write(byArray, 0, n);
        }
        catch (IOException iOException) {
            lI.log(Level.INFO, "Exception occur", iOException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    private l1j[] lI(String string, boolean bl) {
        int n;
        Object object;
        this.ld();
        l0t<Stream> l0t2 = new l0t<Stream>();
        if (this.le == null) {
            object = new com.aspose.pdf.internal.ms.System.Collections.Generic.lf();
            if (this.getDocument().getEmbeddedFiles().size() != 0) {
                for (Object object2 : this.getDocument().getEmbeddedFiles()) {
                    if (object2 == null || ((FileSpecification)object2).getContentsInternal() == null || ((com.aspose.pdf.internal.ms.System.Collections.Generic.lf)object).containsKey(((FileSpecification)object2).getName())) continue;
                    if (bl) {
                        this.lI((FileSpecification)object2, string);
                    } else {
                        l0t2.addItem(((FileSpecification)object2).getContentsInternal());
                    }
                    ((com.aspose.pdf.internal.ms.System.Collections.Generic.lf)object).set_Item(((FileSpecification)object2).getName(), 1);
                }
            }
            for (n = this.lf; n <= this.lj; ++n) {
                if (this.getDocument().getPages().get_Item(n).getAnnotations().size() == 0) continue;
                for (Annotation object3 : this.getDocument().getPages().get_Item(n).getAnnotations()) {
                    FileSpecification fileSpecification;
                    if (!(object3 instanceof FileAttachmentAnnotation) || (fileSpecification = ((FileAttachmentAnnotation)((Object)com.aspose.pdf.internal.l82h.lb.lI(object3, FileAttachmentAnnotation.class))).getFile()) == null || fileSpecification.getName() == null || ((com.aspose.pdf.internal.ms.System.Collections.Generic.lf)object).containsKey(fileSpecification.getName())) continue;
                    if (bl) {
                        this.lI(fileSpecification, string);
                    } else {
                        l0t2.addItem(fileSpecification.getContentsInternal());
                    }
                    ((com.aspose.pdf.internal.ms.System.Collections.Generic.lf)object).set_Item(fileSpecification.getName(), 1);
                }
            }
        } else {
            object = this.getDocument().getEmbeddedFiles().get_Item(this.le);
            if (object != null) {
                if (bl) {
                    this.lI((FileSpecification)object, string);
                } else {
                    l0t2.addItem(((FileSpecification)object).getContentsInternal());
                }
            }
            for (n = this.lf; n <= this.lj; ++n) {
                if (this.getDocument().getPages().get_Item(n).getAnnotations().size() == 0) continue;
                for (Annotation annotation : this.getDocument().getPages().get_Item(n).getAnnotations()) {
                    if (!(annotation instanceof FileAttachmentAnnotation) || (object = ((FileAttachmentAnnotation)((Object)com.aspose.pdf.internal.l82h.lb.lI(annotation, FileAttachmentAnnotation.class))).getFile()) == null || !l10l.lb(((FileSpecification)object).getName(), this.le)) continue;
                    if (bl) {
                        this.lI((FileSpecification)object, string);
                        continue;
                    }
                    l0t2.addItem(((FileSpecification)object).getContentsInternal());
                }
            }
        }
        object = null;
        if (!bl && l0t2.size() > 0) {
            object = new l1j[l0t2.size()];
            n = 0;
            for (Stream stream : l0t2) {
                object[n++] = (l1j)stream;
            }
        }
        return object;
    }

    private List<FileSpecification> lj() {
        ArrayList<FileSpecification> arrayList = new ArrayList<FileSpecification>();
        com.aspose.pdf.internal.ms.System.Collections.Generic.lf<String, Integer> lf2 = new com.aspose.pdf.internal.ms.System.Collections.Generic.lf<String, Integer>();
        if (this.getDocument().getEmbeddedFiles().size() != 0) {
            for (Object object : this.getDocument().getEmbeddedFiles()) {
                if (object == null || ((FileSpecification)object).getContentsInternal() == null || lf2.containsKey(((FileSpecification)object).getName())) continue;
                arrayList.add((FileSpecification)object);
                lf2.set_Item(((FileSpecification)object).getName(), 1);
            }
        }
        for (int i = this.lf; i <= this.lj; ++i) {
            if (this.getDocument().getPages().get_Item(i).getAnnotations().size() == 0) continue;
            for (Annotation annotation : this.getDocument().getPages().get_Item(i).getAnnotations()) {
                FileSpecification fileSpecification;
                if (!(annotation instanceof FileAttachmentAnnotation) || (fileSpecification = ((FileAttachmentAnnotation)((Object)com.aspose.pdf.internal.l82h.lb.lI(annotation, FileAttachmentAnnotation.class))).getFile()) == null || fileSpecification.getName() == null || lf2.containsKey(fileSpecification.getName())) continue;
                arrayList.add(fileSpecification);
                lf2.set_Item(fileSpecification.getName(), 1);
            }
        }
        return arrayList;
    }

    private void lb() {
        this.lt();
        if (this.lf == 0) {
            this.lf = 1;
        }
        if (this.lj == 0) {
            this.lj = this.getDocument().getPages().size();
        }
        if (this.lt == 0) {
            this.lt = 1;
        }
        if (this.lj > this.getDocument().getPages().size()) {
            this.lj = this.getDocument().getPages().size();
        }
        if (this.lf > this.getDocument().getPages().size()) {
            this.lf = this.getDocument().getPages().size();
        }
        if (this.lj < this.lf) {
            this.lj = this.lf;
        }
        if (!this.lI() && this.lj > 4) {
            this.lj = 4;
        }
    }

    static void lI(l0t<XImage> l0t2, XForm xForm) {
        int n;
        for (n = xForm.getResources().getForms().size(); n >= 1; --n) {
            PdfExtractor.lI(l0t2, xForm.getResources().getForms().get_Item(n));
        }
        for (n = xForm.getResources().getImages().size(); n >= 1; --n) {
            l0t2.insertItem(0, xForm.getResources().getImages().get_Item(n));
        }
    }

    void lI(l0t<XImage> l0t2, IDocument iDocument, int n, int n2) {
        if (this.lc == 0) {
            this.lj(l0t2, iDocument, n, n2);
        } else {
            PdfExtractor.lf(l0t2, iDocument, n, n2);
        }
    }

    static void lf(l0t<XImage> l0t2, IDocument iDocument, int n, int n2) {
        l0t2.clear();
        ImagePlacementAbsorber imagePlacementAbsorber = new ImagePlacementAbsorber();
        if (n <= n2) {
            iDocument.getPages().get_Item(n).accept(imagePlacementAbsorber);
            for (ImagePlacement imagePlacement : imagePlacementAbsorber.getImagePlacements()) {
                l0t2.addItem(imagePlacement.getImage());
            }
        }
    }

    void lj(l0t<XImage> l0t2, IDocument iDocument, int n, int n2) {
        int n3;
        l0t2.clear();
        if (n <= n2) {
            for (n3 = iDocument.getPages().get_Item(n).getResources().getForms().size(); n3 >= 1; --n3) {
                PdfExtractor.lI(l0t2, iDocument.getPages().get_Item(n).getResources().getForms().get_Item(n3));
            }
        }
        for (n3 = iDocument.getPages().get_Item(n).getResources().getImages().size(); n3 >= 1; --n3) {
            l0t2.insertItem(0, iDocument.getPages().get_Item(n).getResources().getImages().get_Item(n3));
        }
        if (iDocument.getPages().get_Item(n).getResources().getEngineDict().lt("Pattern")) {
            lh lh2 = iDocument.getPages().get_Item(n).getResources().getEngineDict().lj("Pattern").l5if();
            lf.lf.lI<String, com.aspose.pdf.internal.l5n.l0t> lI2 = lh2.l1j().lI();
            while (lI2.hasNext()) {
                lh lh3;
                String string = (String)lI2.next();
                lh lh4 = lh2.lj(string).l5if();
                if (lh4 == null || !lh4.lt("Resources") || (lh3 = lh4.lj("Resources").l5if()) == null || !lh3.lt("XObject")) continue;
                lh lh5 = lh3.lj("XObject").l5if();
                lf.lf.lI<String, com.aspose.pdf.internal.l5n.l0t> lI3 = lh5.l1j().lI();
                while (lI3.hasNext()) {
                    String string2 = (String)lI3.next();
                    com.aspose.pdf.internal.l5n.l0t l0t3 = lh5.lj(string2);
                    if (!XImage.isImage(l0t3)) continue;
                    l0if l0if2 = l0t3.l5p();
                    XImage xImage = InternalHelper.lI(l0t3.l4n());
                    if (l0if2 == null) {
                        l0t2.addItem(xImage);
                        continue;
                    }
                    if (this.l0v.containsKey(l0if2.l3u())) continue;
                    this.l0v.addItem(l0if2.l3u(), l0if2.l3u());
                    l0t2.addItem(xImage);
                }
            }
        }
    }

    private boolean lI(char c) {
        return c >= '\u0600' && c <= '\u06ff' || c >= '\u0750' && c <= '\u077f' || c >= '\ufb50' && c <= '\ufdff' || c >= '\ufe70' && c <= '\ufeff';
    }

    private boolean lf(char c) {
        return c >= '\u0590' && c <= '\u05ff';
    }

    public int getStartPage() {
        return this.lf;
    }

    public void setStartPage(int value) {
        int n = this.lf = value < 1 ? 1 : value;
        if (this.lj < this.lf) {
            this.lj = this.lf;
        }
    }

    public int getEndPage() {
        return this.lj;
    }

    public void setEndPage(int value) {
        int n = this.lj = value < 1 ? 1 : value;
        if (this.lf > this.lj) {
            this.lf = this.lj;
        }
    }

    public int getExtractTextMode() {
        return this.lk;
    }

    public void setExtractTextMode(int value) {
        if (value == 0 || value == 1) {
            this.lk = value;
        }
    }

    public TextSearchOptions getTextSearchOptions() {
        return this.ly;
    }

    public void setTextSearchOptions(TextSearchOptions value) {
        if (value != null) {
            this.ly = value;
        }
    }

    public int getExtractImageMode() {
        return this.lc;
    }

    public void setExtractImageMode(int value) {
        this.lc = value;
    }

    public boolean isBidi() {
        l1j l1j2 = new l1j();
        this.getText(l1j2.toOutputStream());
        l1j2.setPosition(0L);
        l2h l2h2 = new l2h((Stream)l1j2, com.aspose.pdf.internal.l70y.l0p.l1l());
        String string = l2h2.ly();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!this.lI(c) && !this.lf(c)) continue;
            return true;
        }
        return false;
    }

    public void extractText() {
        this.ld();
        this.extractTextInternal(TextEncodingInternal.getUnicode());
    }

    public void extractText(Charset encoding) {
        this.extractTextInternal(TextEncodingInternal.getEncoding(encoding.displayName()));
    }

    public void extractTextInternal(TextEncodingInternal encoding) {
        this.ld();
        this.l0t = encoding.getInternalFormat();
        this.lh = new l0t();
        for (int i = this.getStartPage(); i <= this.getEndPage(); ++i) {
            if (InternalHelper.lI(this.l0p, i)) continue;
            long l = 0L;
            TextExtractionOptions textExtractionOptions = this.lk == 0 ? new TextExtractionOptions(0) : new TextExtractionOptions(1);
            TextAbsorber textAbsorber = new TextAbsorber(textExtractionOptions);
            textAbsorber.setTextSearchOptions(this.getTextSearchOptions());
            textAbsorber.visit(this.getDocument().getPages().get_Item(i));
            this.lh.addItem(textAbsorber.getText());
        }
    }

    public void getText(String outputFile) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getText(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lI.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage(), fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getText(OutputStream outputStream) {
        this.lI(l1j2);
        try (l1j l1j2 = new l1j();){
            if (((Stream)l1j2).canSeek()) {
                ((Stream)l1j2).seek(0L, 0);
            }
            byte[] byArray = new byte[l1j2.toInputStream().available()];
            l1j2.toInputStream().read(byArray);
            outputStream.write(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lI(Stream stream) {
        if (this.getDocument() == null) {
            throw new IllegalStateException("PdfExtractor hasn't been bound yet. Please provide pdf document to process.");
        }
        if (this.lh == null) {
            return;
        }
        lf lf2 = new lf(stream);
        try {
            for (int i = 0; i < this.lh.size(); ++i) {
                String string = this.lh.get_Item(i);
                if (string == null) continue;
                if (i > 0) {
                    lf2.lI(this.l0t.lj("\r\n"));
                }
                lf2.lI(this.l0t.lj(string));
            }
        }
        finally {
            lf2.lj();
        }
    }

    @Override
    public void bindPdf(String inputFile) {
        this.bindPdf(inputFile, this.l0l);
        this.ld();
    }

    @Override
    public void bindPdf(InputStream inputStream) {
        this.lI(Stream.fromJava(inputStream), this.l0l);
        this.ld();
    }

    public void extractImage() {
        this.ld();
        this.lb = new l0t();
        this.lI(this.lb, this.getDocument(), this.lt, this.lj);
        this.ld = 0;
    }

    public boolean hasNextImage() {
        this.lb();
        if (this.lb == null) {
            throw new IllegalStateException("PdfExtractor hasn't been prepared for extracting images. Please call ExtractImage.");
        }
        if (this.lt > this.lj) {
            return false;
        }
        if (this.ld >= this.lb.size()) {
            ++this.lt;
            this.ld = 0;
            while (this.lt <= this.lj) {
                this.lI(this.lb, this.getDocument(), this.lt, this.lj);
                if (this.lb.size() != 0) break;
                ++this.lt;
            }
        }
        return this.lt <= this.lj && this.ld < this.lb.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getNextImage(String outputFile) {
        boolean bl = false;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            bl = this.getNextImage(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lI.log(Level.INFO, "Exception occur", fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
        return bl;
    }

    public boolean getNextImage(String outputFile, ImageType format) {
        boolean bl = false;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            bl = this.getNextImage(fileOutputStream, format);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lI.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
        return bl;
    }

    public boolean getNextImage(OutputStream outputStream, ImageType format) {
        if (this.hasNextImage()) {
            try {
                ((XImage)((Object)com.aspose.pdf.internal.l82h.lb.lI(this.lb.get_Item(this.ld++), XImage.class))).save(outputStream, format, this.l0if);
                return true;
            }
            catch (l5if l5if2) {
                lI.log(Level.INFO, "Exception occur", l5if2);
                return false;
            }
        }
        return false;
    }

    public boolean getNextImage(OutputStream outputStream) {
        if (this.hasNextImage()) {
            try {
                ((XImage)((Object)com.aspose.pdf.internal.l82h.lb.lI(this.lb.get_Item(this.ld++), XImage.class))).save(outputStream, this.l0if);
                return true;
            }
            catch (l5if l5if2) {
                lI.log(Level.INFO, "Exception occur", l5if2);
                return false;
            }
        }
        return false;
    }

    public List<String> getAttachNames() {
        this.ld();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getDocument().getEmbeddedFiles().size() != 0) {
            for (Object object : this.getDocument().getEmbeddedFiles()) {
                arrayList.add(((FileSpecification)object).getName());
            }
        }
        for (int i = this.lf; i <= this.lj; ++i) {
            if (this.getDocument().getPages().get_Item(i).getAnnotations().size() == 0) continue;
            for (Annotation annotation : this.getDocument().getPages().get_Item(i).getAnnotations()) {
                if (!(annotation instanceof FileAttachmentAnnotation)) continue;
                arrayList.add(((FileAttachmentAnnotation)((Object)com.aspose.pdf.internal.l82h.lb.lI(annotation, FileAttachmentAnnotation.class))).getFile().getName());
            }
        }
        return arrayList;
    }

    public void extractAttachment() {
        this.ld();
        this.le = null;
        this.lu = 1;
    }

    private void ld() {
        this.lb();
        this.lt = this.lf;
    }

    public void extractAttachment(String attachmentFileName) {
        this.le = attachmentFileName;
    }

    public void getAttachment(String outputPath) {
        this.lI(outputPath, true);
    }

    public boolean hasNextPageText() {
        return this.lh != null && this.lt <= this.getEndPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNextPageText(String outputFile) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextPageText(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lI.log(Level.INFO, "Exception occur", fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNextPageText(OutputStream outputStream) {
        this.lf(l1j2);
        try (l1j l1j2 = new l1j();){
            if (((Stream)l1j2).canSeek()) {
                ((Stream)l1j2).seek(0L, 0);
            }
            byte[] byArray = new byte[l1j2.toInputStream().available()];
            l1j2.toInputStream().read(byArray);
            outputStream.write(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lf(Stream stream) {
        if (this.hasNextPageText() && this.lh.size() >= this.lt) {
            lf lf2 = new lf(stream);
            try {
                String string = this.lh.get_Item(this.lt - 1);
                if (string != null) {
                    lf2.lI(this.l0t.lj(string));
                }
            }
            finally {
                lf2.lj();
            }
            ++this.lt;
        }
    }

    public PdfExtractor() {
    }

    public PdfExtractor(IDocument document) {
        super(document);
    }

    public void getText(OutputStream outputStream, boolean filterNotAscii) {
        if (!filterNotAscii) {
            this.getText(outputStream);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.getText(byteArrayOutputStream);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            outputStreamWriter.write(new String(byteArrayOutputStream.toByteArray(), "UTF-8").replaceAll("[^\\u0000-\\u007F]", l10l.lI));
        }
        catch (Exception exception) {
            lI.log(Level.INFO, "Exception occur", exception);
            throw new RuntimeException(exception.getMessage());
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
        try {
            outputStream.flush();
        }
        catch (IOException iOException) {
            lI.log(Level.INFO, "Exception occur", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream[] getAttachment() {
        l1j[] l1jArray = this.lu();
        if (l1jArray != null && l1jArray.length > 0) {
            ByteArrayOutputStream[] byteArrayOutputStreamArray = new ByteArrayOutputStream[l1jArray.length];
            for (int i = 0; i < l1jArray.length; ++i) {
                InputStream inputStream = l1jArray[i].toInputStream();
                byteArrayOutputStreamArray[i] = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                try {
                    int n;
                    while ((n = inputStream.read(byArray)) != -1) {
                        byteArrayOutputStreamArray[i].write(byArray, 0, n);
                    }
                    continue;
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                    continue;
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (l1jArray[i] != null) {
                            l1jArray[i].close();
                        }
                    }
                    catch (IOException iOException) {
                        lI.log(Level.INFO, "Exception occur", iOException);
                    }
                }
            }
            return byteArrayOutputStreamArray;
        }
        return null;
    }

    private l1j[] lu() {
        return this.lI(null, false);
    }

    public List<FileSpecification> getAttachmentInfo() {
        return this.lj();
    }

    public int getResolution() {
        return this.l0if;
    }

    public void setResolution(int value) {
        this.l0if = value;
    }

    public String getPassword() {
        return this.l0l;
    }

    public void setPassword(String value) {
        this.l0l = value;
    }

    public void extractMarkedContentAsImages(Page page, String path) {
        lj lj2 = new lj();
        lj2.process(page, path);
    }

    static {
        lI.setUseParentHandlers(false);
    }

    static final class lI
    extends Enum<lI> {
        public static final /* enum */ lI lI = new lI();
        public static final /* enum */ lI lf = new lI();
        private static final /* synthetic */ lI[] lj;

        public static lI[] lI() {
            return (lI[])lj.clone();
        }

        public static lI lI(String string) {
            return Enum.valueOf(lI.class, string);
        }

        static {
            lj = new lI[]{lI, lf};
        }
    }
}

