/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.devices;

import com.aspose.pdf.Page;
import com.aspose.pdf.PageSize;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.RenderingOptions;
import com.aspose.pdf.devices.PageDevice;
import com.aspose.pdf.devices.Resolution;
import com.aspose.pdf.devices.lI;
import com.aspose.pdf.exceptions.IndexOutOfRangeException;
import com.aspose.pdf.internal.l10if.lu;
import com.aspose.pdf.internal.l10v.le;
import com.aspose.pdf.internal.l68l.l0n;
import com.aspose.pdf.internal.l68l.l13j;
import com.aspose.pdf.internal.ms.System.l13p;
import com.aspose.pdf.internal.ms.System.l7f;

public abstract class ImageDevice
extends PageDevice {
    private int lI;
    private int lf;
    private boolean lj;
    private Resolution lt;
    private Point lb = new Point(0.0, 0.0);
    private float ld = 1.0f;
    private int lu;
    private int le;
    private int lh;
    private l13j lk = new l13j();
    private boolean lv = false;
    private int lc;
    private int ly;
    private int l0if = 0;
    private RenderingOptions l0l = new RenderingOptions();
    private int l0t = 1;
    private static boolean l0v = true;
    private Rectangle l0p = null;

    public static boolean isShadingPerformanceHigh() {
        return l0v;
    }

    public static void setShadingPerformanceHigh(boolean value) {
        l0v = value;
    }

    public int getCoordinateType() {
        return this.l0t;
    }

    public void setCoordinateType(int value) {
        this.l0t = value;
    }

    public RenderingOptions getRenderingOptions() {
        return this.l0l;
    }

    public void setRenderingOptions(RenderingOptions value) {
        this.l0l = value;
    }

    public int getFormPresentationMode() {
        return this.l0if;
    }

    public void setFormPresentationMode(int value) {
        this.l0if = value;
    }

    public Resolution getResolution() {
        return this.lt;
    }

    public int getWidth() {
        return this.lI;
    }

    public int getHeight() {
        return this.lf;
    }

    public ImageDevice() {
        this.lt = new Resolution(150);
    }

    public ImageDevice(Resolution resolution) {
        this.lt = resolution;
    }

    public ImageDevice(int width, int height) {
        this(width, height, new Resolution(150));
    }

    public ImageDevice(PageSize pageSize) {
        this(pageSize, new Resolution(150));
    }

    public ImageDevice(int width, int height, Resolution resolution) {
        this.lI = width;
        this.lf = height;
        this.lt = resolution;
    }

    public ImageDevice(PageSize pageSize, Resolution resolution) {
        float f = pageSize.getWidth();
        float f2 = pageSize.getHeight();
        this.lI = (int)l13p.lt((float)resolution.getX() * f / 72.0f);
        this.lf = (int)l13p.lt((float)resolution.getY() * f2 / 72.0f);
        this.lt = resolution;
    }

    ImageDevice(Point origin, int paperWidth, int paperHeight, l13j marginBounds, float scaleFactor, Resolution resolution, int rotateDegrees, boolean autoSize, int verticalAlignment, int horizontalAlignment, boolean isIsXpsPrinting) {
        this.lj = autoSize;
        this.lb = origin;
        this.lt = resolution;
        this.ld = scaleFactor;
        this.lu = paperWidth;
        this.le = paperHeight;
        this.lh = rotateDegrees;
        marginBounds.lt(this.lk);
        this.lv = isIsXpsPrinting;
        this.lc = verticalAlignment;
        this.ly = horizontalAlignment;
    }

    lu lI(Page page) {
        if (page == null) {
            throw new l7f("Page is null");
        }
        lI lI2 = new lI(page, this.lb, this.getWidth(), this.getHeight(), this.getResolution(), this.getFormPresentationMode(), this.getRenderingOptions(), this.l0t);
        if (this.l0p != null) {
            if (this.l0p.getHeight() <= 0.0 || this.l0p.getHeight() > page.getMediaBox().getHeight() || this.l0p.getWidth() <= 0.0 || this.l0p.getWidth() > page.getMediaBox().getWidth()) {
                throw new IndexOutOfRangeException("Rectangle has falls parametrs");
            }
            le le2 = (le)lI2.lI();
            le2.lI(this.l0p);
            return le2;
        }
        return lI2.lI();
    }

    void lI(Page page, String string) {
        if (page == null) {
            throw new l7f("Page is null");
        }
        if (string == null) {
            throw new l7f("path is null");
        }
        lI lI2 = new lI(page, this.lb, this.getWidth(), this.getHeight(), this.getResolution(), this.getFormPresentationMode(), this.getRenderingOptions(), this.l0t);
        lI2.lI(string);
    }

    lu lI(Page page, l0n l0n2) {
        if (page == null) {
            throw new l7f("Page is null");
        }
        lI lI2 = new lI(page, this.lb, this.getWidth(), this.getHeight(), this.lu, this.le, this.lk.ly(), this.ld, this.getResolution(), this.lh, l0n2, this.lj, this.lc, this.ly, this.lv, this.getFormPresentationMode(), this.getRenderingOptions(), this.l0t);
        if (this.l0p != null) {
            if (this.l0p.getHeight() <= 0.0 || this.l0p.getHeight() > page.getMediaBox().getHeight() || this.l0p.getWidth() <= 0.0 || this.l0p.getWidth() > page.getMediaBox().getWidth()) {
                throw new l7f("Rectangle has falls parametrs");
            }
            le le2 = (le)lI2.lI();
            le2.lI(this.l0p);
            return le2;
        }
        return lI2.lI();
    }

    public Rectangle getCropRectangle() {
        return this.l0p;
    }

    public void setCropRectangle(Rectangle cropRectangle) {
        this.l0p = cropRectangle;
    }
}

