/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Page;
import com.aspose.pdf.TextStamp;
import com.aspose.pdf.facades.FormattedText;
import com.aspose.pdf.internal.l82h.lb;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l6u;

public final class PageNumberStamp
extends TextStamp {
    private String lt;
    private int lb = 1;
    private int ld = 0;

    public String getFormat() {
        return this.lt;
    }

    public void setFormat(String value) {
        this.lt = value;
    }

    public int getStartingNumber() {
        return this.lb;
    }

    public void setStartingNumber(int value) {
        this.lb = value;
    }

    public PageNumberStamp(String format) {
        super((String)null);
        this.lt = format;
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(3);
        this.setBottomMargin(10.0);
    }

    private String lI(int n) {
        String string = "";
        String[][] stringArrayArray = new String[][]{{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"}, {"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"}, {"", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM"}};
        while (n > 1000) {
            string = l10l.lI(new String[]{string, "M"});
            n -= 1000;
        }
        String string2 = "";
        for (int i = 0; i < 3; ++i) {
            string2 = l10l.lI(new String[]{stringArrayArray[i][n % 10], string2});
            n /= 10;
        }
        string = l10l.lI(new String[]{string, string2});
        return string;
    }

    private String lf(int n) {
        String string = "";
        int n2 = --n / 26 + 1;
        char c = (char)(65 + n % 26);
        for (int i = 1; i <= n2; ++i) {
            string = l10l.lI(string, com.aspose.pdf.internal.l82h.lb.lI(Character.valueOf(c)));
        }
        return string;
    }

    private String lj(int n) {
        switch (this.getNumberingStyle()) {
            case 0: {
                return l6u.lf(n);
            }
            case 2: {
                return l10l.lu(this.lI(n));
            }
            case 1: {
                return l10l.ly(this.lI(n));
            }
            case 4: {
                return l10l.lu(this.lf(n));
            }
            case 3: {
                return l10l.ly(this.lf(n));
            }
        }
        return l6u.lf(n);
    }

    @Override
    public void put(Page page) {
        this.setValue(l10l.lI(this.lt, "#", this.lj(page.getNumber() + this.getStartingNumber() - 1)));
        super.put(page);
    }

    public PageNumberStamp() {
        this("#");
    }

    public PageNumberStamp(FormattedText formattedText) {
        super(formattedText);
        this.lt = formattedText.getFirstLine();
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(3);
        this.setBottomMargin(10.0);
    }

    public int getNumberingStyle() {
        return this.ld;
    }

    public void setNumberingStyle(int value) {
        this.ld = value;
    }
}

