/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.l2001;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class I1
extends FilterInputStream
implements DataInput {
    protected byte[] lif = new byte[8];

    public I1(InputStream inputStream) {
        super(inputStream);
    }

    public int read(byte[] b) throws IOException {
        return this.in.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        int n;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; i += n) {
            n = this.in.read(b, off + i, len - i);
            if (n >= 0) continue;
            throw new EOFException();
        }
    }

    public int skipBytes(int n) throws IOException {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n && (n3 = (int)this.in.skip(n - n2)) > 0; n2 += n3) {
        }
        return n2;
    }

    public boolean readBoolean() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public byte readByte() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public int readUnsignedByte() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public short readShort() throws IOException {
        this.readFully(this.lif, 0, 2);
        return (short)((this.lif[1] & 0xFF) << 8 | this.lif[0] & 0xFF);
    }

    public int readUnsignedShort() throws IOException {
        this.readFully(this.lif, 0, 2);
        return (this.lif[1] & 0xFF) << 8 | this.lif[0] & 0xFF;
    }

    public char readChar() throws IOException {
        this.readFully(this.lif, 0, 2);
        return (char)((this.lif[1] & 0xFF) << 8 | this.lif[0] & 0xFF);
    }

    public int readInt() throws IOException {
        this.readFully(this.lif, 0, 4);
        return this.lif[3] << 24 | (this.lif[2] & 0xFF) << 16 | (this.lif[1] & 0xFF) << 8 | this.lif[0] & 0xFF;
    }

    public long readLong() throws IOException {
        this.readFully(this.lif, 0, 8);
        return (long)this.lif[7] << 56 | (long)(this.lif[6] & 0xFF) << 48 | (long)(this.lif[5] & 0xFF) << 40 | (long)(this.lif[4] & 0xFF) << 32 | (long)(this.lif[3] & 0xFF) << 24 | (long)(this.lif[2] & 0xFF) << 16 | (long)(this.lif[1] & 0xFF) << 8 | (long)(this.lif[0] & 0xFF);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Deprecated
    public String readLine() throws IOException {
        throw new UnsupportedOperationException("readLine() method is not implemented.");
    }
}

