/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.l1871;

import com.aspose.pdf.internal.l165l.I5l;
import com.aspose.pdf.internal.l1851.I0l;
import com.aspose.pdf.internal.l1851.I37;
import com.aspose.pdf.internal.l1867.I7;
import com.aspose.pdf.internal.l1867.II;
import com.aspose.pdf.internal.l186l.I07;
import com.aspose.pdf.internal.l186l.I4;
import com.aspose.pdf.internal.l1871.I04;
import com.aspose.pdf.internal.l1871.I11;
import com.aspose.pdf.internal.l1871.I27;
import com.aspose.pdf.internal.l1871.I2I;
import com.aspose.pdf.internal.ms.System.I331;
import com.aspose.pdf.internal.ms.System.I9l;
import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;

public class I1I
extends I27 {
    private final CertificateList lif;
    private final String ll;
    private final byte[] lI;
    private final boolean l1;

    public I1I(CertificateList certificateList) {
        this.lif = certificateList;
        try {
            this.ll = I2I.lif(certificateList.getSignatureAlgorithm());
            this.lI = (byte[])(certificateList.getSignatureAlgorithm().getParameters() != null ? certificateList.getSignatureAlgorithm().getParameters().toASN1Primitive().getEncoded("DER") : null);
            this.l1 = this.l0I();
        }
        catch (Exception exception) {
            throw new com.aspose.pdf.internal.l1854.I07("CRL contents invalid: " + exception);
        }
    }

    @Override
    protected X509Extensions l1lf() {
        return this.ll() == 2 ? X509Extensions.getInstance((Object)this.lif.getTBSCertList().getExtensions()) : null;
    }

    public byte[] lif() {
        try {
            return this.lif.getEncoded("DER");
        }
        catch (Exception exception) {
            throw new com.aspose.pdf.internal.l1854.I07(exception.toString());
        }
    }

    public void lif(AsymmetricKeyParameter asymmetricKeyParameter) {
        if (!this.lif.getSignatureAlgorithm().equals((Object)this.lif.getTBSCertList().getSignature())) {
            throw new com.aspose.pdf.internal.l1854.I07("Signature algorithm on CertificateList does not match TbsCertList.");
        }
        Signer signer = I37.lI(this.lf());
        signer.init(false, (CipherParameters)asymmetricKeyParameter);
        byte[] byArray = this.liF();
        signer.update(byArray, 0, byArray.length);
        if (!signer.verifySignature(this.lIf())) {
            throw new I0l("CRL does not verify with supplied public key.");
        }
    }

    public int ll() {
        return this.lif.getVersionNumber();
    }

    public X509Name lI() {
        return X509Name.getInstance((Object)this.lif.getIssuer());
    }

    public I9l l1() {
        return I9l.lif(this.lif.getThisUpdate().getDate());
    }

    public com.aspose.pdf.internal.l186I.I7 lIF() {
        return this.lif.getNextUpdate() == null ? null : new com.aspose.pdf.internal.l186I.I7(I9l.lif(this.lif.getNextUpdate().getDate()).l2iF());
    }

    private I07 l0lf() {
        I4 i4 = new I4();
        Enumeration enumeration = this.lif.getRevokedCertificateEnumeration();
        X509Name x509Name = this.lI();
        while (enumeration.hasMoreElements()) {
            TBSCertList.CRLEntry cRLEntry = (TBSCertList.CRLEntry)enumeration.nextElement();
            I11 i11 = new I11(cRLEntry, this.l1, x509Name);
            i4.lif(i11);
            x509Name = i11.lif();
        }
        return i4;
    }

    public I11 lif(BigInteger bigInteger) {
        Enumeration enumeration = this.lif.getRevokedCertificateEnumeration();
        X509Name x509Name = this.lI();
        while (enumeration.hasMoreElements()) {
            TBSCertList.CRLEntry cRLEntry = (TBSCertList.CRLEntry)enumeration.nextElement();
            I11 i11 = new I11(cRLEntry, this.l1, x509Name);
            if (bigInteger.equals(cRLEntry.getUserCertificate().getValue())) {
                return i11;
            }
            x509Name = i11.lif();
        }
        return null;
    }

    public I07 llf() {
        I07 i07 = this.l0lf();
        if (i07.size() > 0) {
            return i07;
        }
        return null;
    }

    public byte[] liF() {
        try {
            return this.lif.getTBSCertList().getEncoded("DER");
        }
        catch (Exception exception) {
            throw new com.aspose.pdf.internal.l1854.I07(exception.toString());
        }
    }

    public byte[] lIf() {
        return this.lif.getSignature().getBytes();
    }

    public String lf() {
        return this.ll;
    }

    public String l0if() {
        return this.lif.getSignatureAlgorithm().getObjectId().getId();
    }

    public byte[] l0l() {
        return I7.ll(this.lI);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        I1I i1I = (I1I)((Object)com.aspose.pdf.internal.l1934.I4.lif(obj, I1I.class));
        if (i1I == null) {
            return false;
        }
        return this.lif.equals((Object)i1I.lif);
    }

    public int hashCode() {
        return this.lif.hashCode();
    }

    public String toString() {
        I07 i07;
        ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray;
        I5l i5l = new I5l();
        String string = II.lif;
        i5l.lif("              Version: ").lIF(this.ll()).lif(string);
        i5l.lif("             IssuerDN: ").lif(this.lI()).lif(string);
        i5l.lif("          This update: ").lif(com.aspose.pdf.internal.l1934.I4.lif(this.l1())).lif(string);
        i5l.lif("          Next update: ").lif(this.lIF()).lif(string);
        i5l.lif("  Signature Algorithm: ").lif(this.lf()).lif(string);
        byte[] byArray = this.lIf();
        i5l.lif("            Signature: ");
        i5l.lif(com.aspose.pdf.internal.l1861.I4.lif(byArray, 0, 20)).lif(string);
        for (int i = 20; i < byArray.length; i += 20) {
            int n = I331.l1(20, byArray.length - i);
            i5l.lif("                       ");
            i5l.lif(com.aspose.pdf.internal.l1861.I4.lif(byArray, i, n)).lif(string);
        }
        X509Extensions x509Extensions = X509Extensions.getInstance((Object)this.lif.getTBSCertList().getExtensions());
        if (x509Extensions != null && (aSN1ObjectIdentifierArray = x509Extensions.getExtensionOIDs()).length > 0) {
            i5l.lif("           Extensions: ").lif(string);
            for (ASN1ObjectIdentifier aSN1ObjectIdentifier : aSN1ObjectIdentifierArray) {
                X509Extension x509Extension = x509Extensions.getExtension(aSN1ObjectIdentifier);
                if (x509Extension.getValue() != null) {
                    ASN1Primitive aSN1Primitive = com.aspose.pdf.internal.l1874.II.lif(x509Extension.getValue());
                    i5l.lif("                       critical(").lif(x509Extension.isCritical()).lif(") ");
                    try {
                        if (aSN1ObjectIdentifier.equals((Object)X509Extensions.CRLNumber)) {
                            i5l.lif(new CRLNumber(DERInteger.getInstance((Object)aSN1Primitive).getPositiveValue())).lif(string);
                            continue;
                        }
                        if (aSN1ObjectIdentifier.equals((Object)X509Extensions.DeltaCRLIndicator)) {
                            i5l.lif("Base CRL: " + new CRLNumber(DERInteger.getInstance((Object)aSN1Primitive).getPositiveValue())).lif(string);
                            continue;
                        }
                        if (aSN1ObjectIdentifier.equals((Object)X509Extensions.IssuingDistributionPoint)) {
                            i5l.lif(IssuingDistributionPoint.getInstance((Object)((ASN1Sequence)aSN1Primitive))).lif(string);
                            continue;
                        }
                        if (aSN1ObjectIdentifier.equals((Object)X509Extensions.CRLDistributionPoints)) {
                            i5l.lif(CRLDistPoint.getInstance((Object)((ASN1Sequence)aSN1Primitive))).lif(string);
                            continue;
                        }
                        if (aSN1ObjectIdentifier.equals((Object)X509Extensions.FreshestCRL)) {
                            i5l.lif(CRLDistPoint.getInstance((Object)((ASN1Sequence)aSN1Primitive))).lif(string);
                            continue;
                        }
                        i5l.lif(aSN1ObjectIdentifier.getId());
                        i5l.lif(" value = ").lif(ASN1Dump.dumpAsString((Object)aSN1Primitive)).lif(string);
                    }
                    catch (RuntimeException runtimeException) {
                        i5l.lif(aSN1ObjectIdentifier.getId());
                        i5l.lif(" value = ").lif("*****").lif(string);
                    }
                    continue;
                }
                i5l.lif(string);
            }
        }
        if ((i07 = this.llf()) != null) {
            for (I11 i11 : i07) {
                i5l.lif(i11);
                i5l.lif(string);
            }
        }
        return i5l.toString();
    }

    public boolean lif(I04 i04) {
        TBSCertList.CRLEntry[] cRLEntryArray = this.lif.getRevokedCertificates();
        if (cRLEntryArray != null) {
            BigInteger bigInteger = i04.lIF();
            for (int i = 0; i < cRLEntryArray.length; ++i) {
                if (!cRLEntryArray[i].getUserCertificate().getValue().equals(bigInteger)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean l0I() {
        ASN1OctetString aSN1OctetString = this.lif(X509Extensions.IssuingDistributionPoint);
        boolean bl = false;
        try {
            if (aSN1OctetString != null) {
                bl = IssuingDistributionPoint.getInstance((Object)com.aspose.pdf.internal.l1874.II.lif(aSN1OctetString)).isIndirectCRL();
            }
        }
        catch (RuntimeException runtimeException) {
            throw new com.aspose.pdf.internal.l1854.I07("Exception reading IssuingDistributionPoint" + runtimeException);
        }
        return bl;
    }
}

