/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.l1871;

import com.aspose.pdf.internal.l165l.I5l;
import com.aspose.pdf.internal.l1854.I07;
import com.aspose.pdf.internal.l1867.II;
import com.aspose.pdf.internal.l1871.I27;
import com.aspose.pdf.internal.l1934.I4;
import com.aspose.pdf.internal.ms.System.I9l;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;

public class I11
extends I27 {
    private TBSCertList.CRLEntry lif;
    private boolean ll;
    private X509Name lI;
    private X509Name l1;

    public I11(TBSCertList.CRLEntry cRLEntry) {
        this.lif = cRLEntry;
        this.l1 = this.llf();
    }

    public I11(TBSCertList.CRLEntry cRLEntry, boolean bl, X509Name x509Name) {
        this.lif = cRLEntry;
        this.ll = bl;
        this.lI = x509Name;
        this.l1 = this.llf();
    }

    private X509Name llf() {
        if (!this.ll) {
            return null;
        }
        ASN1OctetString aSN1OctetString = this.lif(X509Extensions.CertificateIssuer);
        if (aSN1OctetString == null) {
            return this.lI;
        }
        try {
            GeneralName[] generalNameArray = GeneralNames.getInstance((Object)com.aspose.pdf.internal.l1874.II.lif(aSN1OctetString)).getNames();
            for (int i = 0; i < generalNameArray.length; ++i) {
                if (generalNameArray[i].getTagNo() != 4) continue;
                return X509Name.getInstance((Object)generalNameArray[i].getName());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    public X509Name lif() {
        return this.l1;
    }

    @Override
    protected X509Extensions l1lf() {
        return X509Extensions.getInstance((Object)this.lif.getExtensions());
    }

    public byte[] ll() {
        try {
            return this.lif.getEncoded("DER");
        }
        catch (Exception exception) {
            throw new I07(exception.toString());
        }
    }

    public BigInteger lI() {
        return this.lif.getUserCertificate().getValue();
    }

    public I9l l1() {
        return I9l.lif(this.lif.getRevocationDate().getDate());
    }

    public boolean lIF() {
        return this.lif.getExtensions() != null;
    }

    public String toString() {
        ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray;
        I5l i5l = new I5l();
        String string = II.lif;
        i5l.lif("        userCertificate: ").lif(this.lI()).lif(string);
        i5l.lif("         revocationDate: ").lif(I4.lif(this.l1())).lif(string);
        i5l.lif("      certificateIssuer: ").lif(this.lif()).lif(string);
        X509Extensions x509Extensions = X509Extensions.getInstance((Object)this.lif.getExtensions());
        if (x509Extensions != null && (aSN1ObjectIdentifierArray = x509Extensions.getExtensionOIDs()).length > 0) {
            i5l.lif("   crlEntryExtensions:").lif(string);
            for (ASN1ObjectIdentifier aSN1ObjectIdentifier : aSN1ObjectIdentifierArray) {
                X509Extension x509Extension = x509Extensions.getExtension(aSN1ObjectIdentifier);
                if (x509Extension.getValue() != null) {
                    try {
                        ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray((byte[])x509Extension.getValue().getOctets());
                        i5l.lif("                       critical(").lif(x509Extension.isCritical()).lif(") ");
                        if (aSN1ObjectIdentifier.equals((Object)X509Extensions.ReasonCode)) {
                            i5l.lif(CRLReason.getInstance((Object)DEREnumerated.getInstance((Object)aSN1Primitive)));
                        } else if (aSN1ObjectIdentifier.equals((Object)X509Extensions.CertificateIssuer)) {
                            i5l.lif("Certificate issuer: ").lif(GeneralNames.getInstance((Object)((ASN1Sequence)aSN1Primitive)));
                        } else {
                            i5l.lif(aSN1ObjectIdentifier.getId());
                            i5l.lif(" value = ").lif(ASN1Dump.dumpAsString((Object)aSN1Primitive));
                        }
                        i5l.lif(string);
                    }
                    catch (Exception exception) {
                        i5l.lif(aSN1ObjectIdentifier.getId());
                        i5l.lif(" value = ").lif("*****").lif(string);
                    }
                    continue;
                }
                i5l.lif(string);
            }
        }
        return i5l.toString();
    }
}

