/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.l184l;

import com.aspose.pdf.internal.l1851.I2l;
import com.aspose.pdf.internal.l1934.I4;
import com.aspose.pdf.internal.ms.System.I04;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.agreement.ECMQVBasicAgreement;
import org.bouncycastle.crypto.agreement.kdf.DHKDFParameters;
import org.bouncycastle.crypto.params.MQVPrivateParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;

public class Il
extends ECMQVBasicAgreement {
    private final String lif;
    private final DerivationFunction ll;
    private MQVPrivateParameters lI;

    public Il(String string, DerivationFunction derivationFunction) {
        if (string == null) {
            throw new I04("algorithm");
        }
        if (derivationFunction == null) {
            throw new I04("kdf");
        }
        this.lif = string;
        this.ll = derivationFunction;
    }

    public void init(CipherParameters parameters) {
        super.init(parameters);
        if (I4.ll((Object)parameters, ParametersWithRandom.class)) {
            parameters = ((ParametersWithRandom)parameters).getParameters();
        }
        this.lI = (MQVPrivateParameters)parameters;
    }

    public BigInteger calculateAgreement(CipherParameters pubKey) {
        BigInteger bigInteger = super.calculateAgreement(pubKey);
        int n = I2l.lIF(this.lif);
        DHKDFParameters dHKDFParameters = new DHKDFParameters(new ASN1ObjectIdentifier(this.lif), n, this.lif(bigInteger));
        this.ll.init((DerivationParameters)dHKDFParameters);
        byte[] byArray = new byte[n / 8];
        this.ll.generateBytes(byArray, 0, byArray.length);
        return new BigInteger(1, byArray);
    }

    private byte[] lif(BigInteger bigInteger) {
        int n = new X9IntegerConverter().getByteLength(this.lI.getStaticPrivateKey().getParameters().getG().getX());
        return new X9IntegerConverter().integerToBytes(bigInteger, n);
    }
}

