/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.l1844;

import com.aspose.pdf.internal.l1934.I4;
import com.aspose.pdf.internal.ms.System.I01;
import com.aspose.pdf.internal.ms.System.I1I;
import com.aspose.pdf.internal.ms.System.I254;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class I07
implements BlockCipher {
    private byte[] lif;
    private byte[] ll;
    private byte[] lI;
    private final int l1;
    private final BlockCipher lIF;
    private boolean llf = true;
    private int liF;
    private int lIf;
    private static final int lf = 0x1010104;
    private static final int l0if = 0x1010101;

    public I07(BlockCipher blockCipher) {
        this.lIF = blockCipher;
        this.l1 = blockCipher.getBlockSize();
        if (this.l1 != 8) {
            throw new I01("GCTR only for 64 bit block ciphers");
        }
        this.lif = new byte[blockCipher.getBlockSize()];
        this.ll = new byte[blockCipher.getBlockSize()];
        this.lI = new byte[blockCipher.getBlockSize()];
    }

    public BlockCipher lif() {
        return this.lIF;
    }

    public void init(boolean forEncryption, CipherParameters parameters) {
        this.llf = true;
        this.liF = 0;
        this.lIf = 0;
        if (I4.ll((Object)parameters, ParametersWithIV.class)) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)parameters;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length < this.lif.length) {
                I1I.ll(I1I.lif((Object)byArray), 0, I1I.lif((Object)this.lif), this.lif.length - byArray.length, byArray.length);
                for (int i = 0; i < this.lif.length - byArray.length; ++i) {
                    this.lif[i] = 0;
                }
            } else {
                I1I.ll(I1I.lif((Object)byArray), 0, I1I.lif((Object)this.lif), 0, this.lif.length);
            }
            parameters = parametersWithIV.getParameters();
        }
        this.reset();
        this.lIF.init(true, parameters);
    }

    public String getAlgorithmName() {
        return I254.lif(new String[]{this.lIF.getAlgorithmName(), "/GCTR"});
    }

    public boolean ll() {
        return true;
    }

    public int getBlockSize() {
        return this.l1;
    }

    public int processBlock(byte[] input, int inOff, byte[] output, int outOff) {
        if (inOff + this.l1 > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + this.l1 > output.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (this.llf) {
            this.llf = false;
            this.lIF.processBlock(this.ll, 0, this.lI, 0);
            this.liF = this.lif(this.lI, 0);
            this.lIf = this.lif(this.lI, 4);
        }
        this.liF += 0x1010101;
        this.lIf += 0x1010104;
        this.lif(this.liF, this.ll, 0);
        this.lif(this.lIf, this.ll, 4);
        this.lIF.processBlock(this.ll, 0, this.lI, 0);
        for (int i = 0; i < this.l1; ++i) {
            output[outOff + i] = I4.ll((Object)(I4.lIF((Object)this.lI[i], 6) ^ I4.lIF((Object)input[inOff + i], 6)), 9);
        }
        I1I.ll(I1I.lif((Object)this.ll), this.l1, I1I.lif((Object)this.ll), 0, this.ll.length - this.l1);
        I1I.ll(I1I.lif((Object)this.lI), 0, I1I.lif((Object)this.ll), this.ll.length - this.l1, this.l1);
        return this.l1;
    }

    public void reset() {
        I1I.ll(I1I.lif((Object)this.lif), 0, I1I.lif((Object)this.ll), 0, this.lif.length);
        this.lIF.reset();
    }

    private int lif(byte[] byArray, int n) {
        return I4.lIF((Object)(I4.llf((Object)(I4.lIF((Object)byArray[n + 3], 6) << 24), 9) & 0xFF000000L), 10) + (I4.lIF((Object)byArray[n + 2], 6) << 16 & 0xFF0000) + (I4.lIF((Object)byArray[n + 1], 6) << 8 & 0xFF00) + (I4.lIF((Object)byArray[n], 6) & 0xFF);
    }

    private void lif(int n, byte[] byArray, int n2) {
        byArray[n2 + 3] = I4.ll((Object)(n >> 24), 9);
        byArray[n2 + 2] = I4.ll((Object)(n >> 16), 9);
        byArray[n2 + 1] = I4.ll((Object)(n >> 8), 9);
        byArray[n2] = I4.ll((Object)n, 9);
    }
}

