/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.l1834;

import com.aspose.pdf.internal.l1834.I14;
import com.aspose.pdf.internal.l1834.I44;
import com.aspose.pdf.internal.ms.System.I01;
import com.aspose.pdf.internal.ms.System.I254;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.KEKIdentifier;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;

public class I1
implements I14 {
    private static final I44 lif = I44.lif;
    private KeyParameter ll;
    private String lI;
    private KEKIdentifier l1;
    private AlgorithmIdentifier lIF;

    public void lif(KEKIdentifier kEKIdentifier) {
        this.l1 = kEKIdentifier;
    }

    public void lif(KeyParameter keyParameter) {
        this.ll = keyParameter;
        this.lIF = I1.lif(this.lI, this.ll);
    }

    public void lif(String string) {
        this.lI = string;
    }

    @Override
    public RecipientInfo lif(KeyParameter keyParameter, SecureRandom secureRandom) {
        byte[] byArray = keyParameter.getKey();
        Wrapper wrapper = lif.ll(this.lIF.getObjectId().getId());
        wrapper.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)this.ll, secureRandom));
        DEROctetString dEROctetString = new DEROctetString(wrapper.wrap(byArray, 0, byArray.length));
        return new RecipientInfo(new KEKRecipientInfo(this.l1, this.lIF, (ASN1OctetString)dEROctetString));
    }

    private static AlgorithmIdentifier lif(String string, KeyParameter keyParameter) {
        if (I254.ll(string, "DES")) {
            return new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_CMS3DESwrap, (ASN1Encodable)DERNull.INSTANCE);
        }
        if (I254.ll(string, "RC2")) {
            return new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_CMSRC2wrap, (ASN1Encodable)new DERInteger(58L));
        }
        if (I254.ll(string, "AES")) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            int n = keyParameter.getKey().length * 8;
            if (n == 128) {
                aSN1ObjectIdentifier = NISTObjectIdentifiers.id_aes128_wrap;
            } else if (n == 192) {
                aSN1ObjectIdentifier = NISTObjectIdentifiers.id_aes192_wrap;
            } else if (n == 256) {
                aSN1ObjectIdentifier = NISTObjectIdentifiers.id_aes256_wrap;
            } else {
                throw new I01("illegal keysize in AES");
            }
            return new AlgorithmIdentifier(aSN1ObjectIdentifier);
        }
        if (I254.ll(string, "SEED")) {
            return new AlgorithmIdentifier(KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap);
        }
        if (I254.ll(string, "CAMELLIA")) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            int n = keyParameter.getKey().length * 8;
            if (n == 128) {
                aSN1ObjectIdentifier = NTTObjectIdentifiers.id_camellia128_wrap;
            } else if (n == 192) {
                aSN1ObjectIdentifier = NTTObjectIdentifiers.id_camellia192_wrap;
            } else if (n == 256) {
                aSN1ObjectIdentifier = NTTObjectIdentifiers.id_camellia256_wrap;
            } else {
                throw new I01("illegal keysize in Camellia");
            }
            return new AlgorithmIdentifier(aSN1ObjectIdentifier);
        }
        throw new I01("unknown algorithm");
    }
}

