/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.l1834;

import com.aspose.pdf.internal.l1574.I21;
import com.aspose.pdf.internal.l1834.I11;
import com.aspose.pdf.internal.l1834.I17;
import com.aspose.pdf.internal.l1834.I27;
import com.aspose.pdf.internal.l1834.I41;
import com.aspose.pdf.internal.l1834.I6l;
import com.aspose.pdf.internal.l1834.I7;
import com.aspose.pdf.internal.l1834.I7l;
import com.aspose.pdf.internal.l1851.I07;
import com.aspose.pdf.internal.l1851.I0I;
import com.aspose.pdf.internal.l1851.I2l;
import com.aspose.pdf.internal.l1851.Il;
import com.aspose.pdf.internal.l1934.I4;
import com.aspose.pdf.internal.ms.System.I01;
import com.aspose.pdf.internal.ms.System.I254;
import com.aspose.pdf.internal.ms.System.IO.I44;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.I3l;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import org.bouncycastle.asn1.cms.OriginatorPublicKey;
import org.bouncycastle.asn1.cms.RecipientEncryptedKey;
import org.bouncycastle.asn1.cms.RecipientKeyIdentifier;
import org.bouncycastle.asn1.cms.ecc.MQVuserKeyingMaterial;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.MQVPrivateParameters;
import org.bouncycastle.crypto.params.MQVPublicParameters;
import org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;

public class I0l
extends I27 {
    private KeyAgreeRecipientInfo l1;
    private ASN1OctetString lIF;

    public static void lif(I21 i21, KeyAgreeRecipientInfo keyAgreeRecipientInfo, I6l i6l) {
        try {
            for (ASN1Encodable aSN1Encodable : keyAgreeRecipientInfo.getRecipientEncryptedKeys().toArray()) {
                RecipientEncryptedKey recipientEncryptedKey = RecipientEncryptedKey.getInstance((Object)aSN1Encodable.toASN1Primitive());
                I11 i11 = new I11();
                KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier = recipientEncryptedKey.getIdentifier();
                IssuerAndSerialNumber issuerAndSerialNumber = keyAgreeRecipientIdentifier.getIssuerAndSerialNumber();
                if (issuerAndSerialNumber != null) {
                    i11.lif(X509Name.getInstance((Object)issuerAndSerialNumber.getName()));
                    i11.lif(issuerAndSerialNumber.getSerialNumber().getValue());
                } else {
                    RecipientKeyIdentifier recipientKeyIdentifier = keyAgreeRecipientIdentifier.getRKeyID();
                    i11.lI(recipientKeyIdentifier.getSubjectKeyIdentifier().getOctets());
                }
                i21.addItem(new I0l(keyAgreeRecipientInfo, i11, recipientEncryptedKey.getEncryptedKey(), i6l));
            }
        }
        catch (I44 i44) {
            throw new I01("invalid rid in KeyAgreeRecipientInformation", i44);
        }
    }

    public I0l(KeyAgreeRecipientInfo keyAgreeRecipientInfo, I11 i11, ASN1OctetString aSN1OctetString, I6l i6l) {
        super(keyAgreeRecipientInfo.getKeyEncryptionAlgorithm(), i6l);
        this.l1 = keyAgreeRecipientInfo;
        this.lif = i11;
        this.lIF = aSN1OctetString;
    }

    private AsymmetricKeyParameter lif(AsymmetricKeyParameter asymmetricKeyParameter, OriginatorIdentifierOrKey originatorIdentifierOrKey) {
        OriginatorPublicKey originatorPublicKey = originatorIdentifierOrKey.getOriginatorKey();
        if (originatorPublicKey != null) {
            return this.lif(asymmetricKeyParameter, originatorPublicKey);
        }
        I17 i17 = new I17();
        IssuerAndSerialNumber issuerAndSerialNumber = originatorIdentifierOrKey.getIssuerAndSerialNumber();
        if (issuerAndSerialNumber != null) {
            i17.lif(X509Name.getInstance((Object)issuerAndSerialNumber.getName()));
            i17.lif(issuerAndSerialNumber.getSerialNumber().getValue());
        } else {
            SubjectKeyIdentifier subjectKeyIdentifier = originatorIdentifierOrKey.getSubjectKeyIdentifier();
            i17.lI(subjectKeyIdentifier.getKeyIdentifier());
        }
        return this.lif(i17);
    }

    private AsymmetricKeyParameter lif(AsymmetricKeyParameter asymmetricKeyParameter, OriginatorPublicKey originatorPublicKey) {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)asymmetricKeyParameter).getEncoded());
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(privateKeyInfo.getAlgorithmId(), originatorPublicKey.getPublicKey().getBytes());
            return PublicKeyFactory.createKey((byte[])subjectPublicKeyInfo.getEncoded());
        }
        catch (IOException iOException) {
            throw new I3l(iOException.getMessage());
        }
    }

    private AsymmetricKeyParameter lif(I17 i17) {
        throw new I7("No support for 'originator' as IssuerAndSerialNumber or SubjectKeyIdentifier");
    }

    private KeyParameter lif(String string, AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricKeyParameter asymmetricKeyParameter2) throws IOException {
        Object object;
        Object object2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = this.ll.getObjectId();
        AsymmetricKeyParameter asymmetricKeyParameter3 = asymmetricKeyParameter;
        AsymmetricKeyParameter asymmetricKeyParameter4 = asymmetricKeyParameter2;
        if (I254.lIF(aSN1ObjectIdentifier.getId(), I41.l11)) {
            object2 = this.l1.getUserKeyingMaterial().getOctets();
            object = MQVuserKeyingMaterial.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object2));
            AsymmetricKeyParameter asymmetricKeyParameter5 = this.lif(asymmetricKeyParameter2, object.getEphemeralPublicKey());
            asymmetricKeyParameter3 = new MQVPublicParameters((ECPublicKeyParameters)asymmetricKeyParameter3, (ECPublicKeyParameters)asymmetricKeyParameter5);
            asymmetricKeyParameter4 = new MQVPrivateParameters((ECPrivateKeyParameters)asymmetricKeyParameter4, (ECPrivateKeyParameters)asymmetricKeyParameter4);
        }
        object2 = I0I.lif(aSN1ObjectIdentifier, string);
        object2.init((CipherParameters)asymmetricKeyParameter4);
        object = object2.calculateAgreement((CipherParameters)asymmetricKeyParameter3);
        int n = I2l.lIF(string) / 8;
        byte[] byArray = new X9IntegerConverter().integerToBytes((BigInteger)object, n);
        return com.aspose.pdf.internal.l1851.I21.lif(string, byArray);
    }

    private KeyParameter lif(String string, KeyParameter keyParameter) {
        byte[] byArray = this.lIF.getOctets();
        Wrapper wrapper = com.aspose.pdf.internal.l1851.I3l.lif(string);
        wrapper.init(false, (CipherParameters)keyParameter);
        byte[] byArray2 = new byte[]{};
        try {
            byArray2 = wrapper.unwrap(byArray, 0, byArray.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new I3l(invalidCipherTextException.getMessage());
        }
        return com.aspose.pdf.internal.l1851.I21.lif(this.ll(), byArray2);
    }

    public KeyParameter lif(AsymmetricKeyParameter asymmetricKeyParameter) {
        try {
            String string = ASN1ObjectIdentifier.getInstance((Object)ASN1Sequence.getInstance((Object)this.ll.getParameters()).getObjectAt(0)).getId();
            AsymmetricKeyParameter asymmetricKeyParameter2 = this.lif(asymmetricKeyParameter, this.l1.getOriginator());
            KeyParameter keyParameter = this.lif(string, asymmetricKeyParameter2, asymmetricKeyParameter);
            return this.lif(string, keyParameter);
        }
        catch (I07 i07) {
            throw new I7("couldn't create cipher.", i07);
        }
        catch (Il il) {
            throw new I7("key invalid in message.", il);
        }
        catch (Exception exception) {
            throw new I7("originator key invalid.", exception);
        }
    }

    public byte[] lif() {
        return this.lIF.getOctets();
    }

    @Override
    public I7l lif(CipherParameters cipherParameters) {
        if (!I4.ll((Object)cipherParameters, AsymmetricKeyParameter.class)) {
            throw new I01("KeyAgreement requires asymmetric key", "key");
        }
        AsymmetricKeyParameter asymmetricKeyParameter = (AsymmetricKeyParameter)cipherParameters;
        if (!asymmetricKeyParameter.isPrivate()) {
            throw new I01("Expected private key", "key");
        }
        KeyParameter keyParameter = this.lif(asymmetricKeyParameter);
        return this.lif(keyParameter);
    }
}

