/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.l1834;

import com.aspose.pdf.internal.l1834.I11;
import com.aspose.pdf.internal.l1834.I27;
import com.aspose.pdf.internal.l1834.I6l;
import com.aspose.pdf.internal.l1834.I7;
import com.aspose.pdf.internal.l1834.I7l;
import com.aspose.pdf.internal.l1851.I07;
import com.aspose.pdf.internal.l1851.I21;
import com.aspose.pdf.internal.l1851.I3l;
import com.aspose.pdf.internal.l1851.Il;
import com.aspose.pdf.internal.ms.System.IO.I44;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.params.KeyParameter;

public class I01
extends I27 {
    private KeyTransRecipientInfo l1;

    public I01(KeyTransRecipientInfo keyTransRecipientInfo, I6l i6l) {
        super(keyTransRecipientInfo.getKeyEncryptionAlgorithm(), i6l);
        this.l1 = keyTransRecipientInfo;
        this.lif = new I11();
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        try {
            if (recipientIdentifier.isTagged()) {
                ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance((Object)recipientIdentifier.getId());
                this.lif.lI(aSN1OctetString.getOctets());
            } else {
                IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance((Object)recipientIdentifier.getId());
                this.lif.lif(X509Name.getInstance((Object)issuerAndSerialNumber.getName()));
                this.lif.lif(issuerAndSerialNumber.getSerialNumber().getValue());
            }
        }
        catch (I44 i44) {
            throw new com.aspose.pdf.internal.ms.System.I01("invalid rid in KeyTransRecipientInformation");
        }
    }

    private String lif(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (PKCSObjectIdentifiers.rsaEncryption.equals((Object)aSN1ObjectIdentifier)) {
            return "RSA//PKCS1Padding";
        }
        return aSN1ObjectIdentifier.getId();
    }

    public KeyParameter ll(CipherParameters cipherParameters) {
        byte[] byArray = this.l1.getEncryptedKey().getOctets();
        String string = this.lif(this.ll.getObjectId());
        try {
            Wrapper wrapper = I3l.lif(string);
            wrapper.init(false, cipherParameters);
            return I21.lif(this.ll(), wrapper.unwrap(byArray, 0, byArray.length));
        }
        catch (I07 i07) {
            throw new I7("couldn't create cipher.", i07);
        }
        catch (Il il) {
            throw new I7("key invalid in message.", il);
        }
        catch (DataLengthException dataLengthException) {
            throw new I7("illegal blocksize in message.", dataLengthException);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new I7("bad padding in message.", invalidCipherTextException);
        }
    }

    @Override
    public I7l lif(CipherParameters cipherParameters) {
        KeyParameter keyParameter = this.ll(cipherParameters);
        return this.lif(keyParameter);
    }
}

