/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import com.aspose.pdf.Annotation;
import com.aspose.pdf.Document;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.Matrix;
import com.aspose.pdf.Operator;
import com.aspose.pdf.Page;
import com.aspose.pdf.PageSize;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.XForm;
import com.aspose.pdf.facades.AlignmentType;
import com.aspose.pdf.facades.SaveableFacade;
import com.aspose.pdf.facades.VerticalAlignmentType;
import com.aspose.pdf.internal.l144.I11;
import com.aspose.pdf.internal.l144.I27;
import com.aspose.pdf.internal.l144.I44;
import com.aspose.pdf.internal.l144.I47;
import com.aspose.pdf.internal.l144.I4I;
import com.aspose.pdf.internal.l1597.I34l;
import com.aspose.pdf.internal.l1934.I01;
import com.aspose.pdf.internal.l1934.I4;
import com.aspose.pdf.internal.l4l.I14;
import com.aspose.pdf.internal.l4l.I21;
import com.aspose.pdf.internal.ms.System.Collections.Generic.Il;
import com.aspose.pdf.internal.ms.System.I0I;
import com.aspose.pdf.internal.ms.System.I20I;
import com.aspose.pdf.internal.ms.System.I254;
import com.aspose.pdf.internal.ms.System.I331;
import com.aspose.pdf.internal.ms.System.IO.I5l;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PdfPageEditor
extends SaveableFacade {
    private static final Logger lif = Logger.getLogger(PdfPageEditor.class.getName());
    private static final int ll = 1;
    private static final int lI = 2;
    private static final int l1 = 4;
    private int lIF = 0;
    private int llf;
    private int liF;
    private int lIf;
    private int[] lf = null;
    private int l0if = 0;
    private Il<Integer, Integer> l0I = new Il();
    private float l01 = 1.0f;
    private PageSize l0IF;
    private int l0lf = 1;
    private int l0iF = 3;
    private Point l0If = null;
    public static final int SPLITVOUT = 1;
    public static final int SPLITHOUT = 2;
    public static final int SPLITVIN = 3;
    public static final int SPLITHIN = 4;
    public static final int BLINDV = 5;
    public static final int BLINDH = 6;
    public static final int INBOX = 7;
    public static final int OUTBOX = 8;
    public static final int LRWIPE = 9;
    public static final int RLWIPE = 10;
    public static final int BTWIPE = 11;
    public static final int TBWIPE = 12;
    public static final int DISSOLVE = 13;
    public static final int LRGLITTER = 14;
    public static final int TBGLITTER = 15;
    public static final int DGLITTER = 16;
    private static final String l0f = "Invalid rotate value. Page rotate must be  expressed in degrees and be multiple of 90.";
    private static final I01 l1if;

    public PdfPageEditor() {
    }

    public PdfPageEditor(Document document) {
        super(document);
    }

    public int getTransitionDuration() {
        this.l1();
        return this.lIf;
    }

    public void setTransitionDuration(int value) {
        this.l1();
        this.lIF |= 1;
        this.lIf = value;
    }

    public int getTransitionType() {
        this.l1();
        return this.liF;
    }

    public void setTransitionType(int value) {
        this.l1();
        this.lIF |= 2;
        this.liF = value;
    }

    public int getDisplayDuration() {
        this.l1();
        return this.llf;
    }

    public void setDisplayDuration(int value) {
        this.l1();
        this.lIF |= 4;
        this.llf = value;
    }

    public int[] getProcessPages() {
        this.l1();
        return this.lf;
    }

    public void setProcessPages(int[] value) {
        this.lf = value;
    }

    public int getRotation() {
        this.l1();
        if (this.l0if < 0) {
            this.l1();
            this.l0if = Page.rotationToInt(this.getDocument().getPages().get_Item(0).getRotate());
        }
        return this.l0if;
    }

    public void setRotation(int value) {
        this.l1();
        this.lI(value);
        this.l0if = value;
    }

    public Map<Integer, Integer> getPageRotations() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (Integer n : this.lif().llf()) {
            hashMap.put(n, this.lif().get_Item(n));
        }
        return hashMap;
    }

    Il<Integer, Integer> lif() {
        this.l1();
        if (this.l0I == null) {
            this.l0I = new Il();
        }
        return this.l0I;
    }

    public void setPageRotations(Map<Integer, Integer> value) {
        Il<Integer, Integer> il = new Il<Integer, Integer>();
        for (Integer n : value.keySet()) {
            il.addItem(n, value.get(n));
        }
        this.lif(il);
    }

    void lif(Il<Integer, Integer> il) {
        this.l1();
        this.ll(il);
        this.l0I = il;
    }

    public float getZoom() {
        this.l1();
        return this.l01;
    }

    public void setZoom(float value) {
        this.l01 = value;
    }

    public PageSize getPageSize() {
        this.l1();
        if (this.l0IF == null) {
            this.l0IF = new PageSize(-1.0f, -1.0f);
        }
        return this.l0IF;
    }

    public void setPageSize(PageSize value) {
        this.l1();
        this.l0IF = value;
    }

    @Deprecated
    public AlignmentType getAlignment() {
        int n = this.getHorizontalAlignment();
        switch (n) {
            case 1: {
                return AlignmentType.Left;
            }
            case 2: {
                return AlignmentType.Center;
            }
            case 3: {
                return AlignmentType.Right;
            }
        }
        throw new I0I("Unknown Alignment type");
    }

    @Deprecated
    public void setAlignment(AlignmentType value) {
        AlignmentType alignmentType = value;
        switch (l1if.lif(alignmentType.toString())) {
            case 0: {
                this.setHorizontalAlignment(2);
                break;
            }
            case 1: {
                this.setHorizontalAlignment(1);
                break;
            }
            case 2: {
                this.setHorizontalAlignment(3);
                break;
            }
            default: {
                throw new I20I("Center, Right, Left values are valid only");
            }
        }
    }

    public int getHorizontalAlignment() {
        this.l1();
        return this.l0lf;
    }

    public void setHorizontalAlignment(int value) {
        this.l1();
        this.l0lf = value;
    }

    @Deprecated
    public VerticalAlignmentType getVerticalAlignment() {
        int n = this.getVerticalAlignmentType();
        switch (n) {
            case 1: {
                return VerticalAlignmentType.Top;
            }
            case 2: {
                return VerticalAlignmentType.Center;
            }
            case 3: {
                return VerticalAlignmentType.Bottom;
            }
        }
        throw new I0I("Unknown Alignment type");
    }

    @Deprecated
    public void setVerticalAlignment(VerticalAlignmentType value) {
        VerticalAlignmentType verticalAlignmentType = value;
        switch (l1if.lif(verticalAlignmentType.toString())) {
            case 3: {
                this.setVerticalAlignmentType(1);
                break;
            }
            case 4: {
                this.setVerticalAlignmentType(3);
                break;
            }
            case 0: {
                this.setVerticalAlignmentType(2);
                break;
            }
            default: {
                this.setVerticalAlignmentType(0);
            }
        }
    }

    public int getVerticalAlignmentType() {
        this.l1();
        return this.l0iF;
    }

    public void setVerticalAlignmentType(int value) {
        this.l1();
        this.l0iF = value;
    }

    public void movePosition(float moveX, float moveY) {
        this.l1();
        this.l0If = new Point(moveX, moveY);
    }

    public int getPages() {
        this.l1();
        return this.getDocument().getPages().size();
    }

    public PageSize getPageSize(int page) {
        this.l1();
        I14 i14 = this.getDocument().getPages().get_Item((int)page).EnginePage.q_();
        I21 i21 = null;
        if (i14.l1() != null) {
            i21 = i14.l1();
        } else if (i14.lI() != null) {
            i21 = i14.lI();
        } else {
            throw new com.aspose.pdf.internal.ms.System.I01("Page doesn't have required entry MediaBox");
        }
        double d = I331.lif(i21.l1() - i21.ll());
        double d2 = I331.lif(i21.lIF() - i21.lI());
        for (int i = Page.rotationToInt(this.getDocument().getPages().get_Item(page).getRotate()); i > 0; i -= 90) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return new PageSize((float)d, (float)d2);
    }

    public int getPageRotation(int page) {
        this.l1();
        return Page.rotationToInt(this.getDocument().getPages().get_Item(page).getRotate());
    }

    public java.awt.Rectangle getPageBoxSize(int page, String pageBoxName) {
        return this.lif(page, pageBoxName).lif();
    }

    I34l lif(int n, String string) {
        this.l1();
        switch (l1if.lif(string)) {
            case 5: {
                return this.lif(this.getDocument().getPages().get_Item(n).getTrimBox());
            }
            case 6: {
                return this.lif(this.getDocument().getPages().get_Item(n).getArtBox());
            }
            case 7: {
                return this.lif(this.getDocument().getPages().get_Item(n).getBleedBox());
            }
            case 8: {
                return this.lif(this.getDocument().getPages().get_Item(n).getCropBox());
            }
            case 9: {
                return this.lif(this.getDocument().getPages().get_Item(n).getMediaBox());
            }
        }
        throw new com.aspose.pdf.internal.ms.System.I01(I254.lif("\"{0}\" is invalid box name", new Object[]{string}));
    }

    @Override
    public void save(String outputFile) {
        this.ll();
        super.save(outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(OutputStream outputStream) {
        I5l i5l = new I5l();
        this.lif(i5l);
        try {
            if (((Stream)i5l).canSeek()) {
                ((Stream)i5l).seek(0L, 0);
            }
            byte[] byArray = new byte[i5l.toInputStream().available()];
            i5l.toInputStream().read(byArray);
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            lif.log(Level.INFO, "Exception occur", iOException);
        }
        finally {
            if (i5l != null) {
                i5l.close();
            }
        }
    }

    @Override
    void lif(Stream stream) {
        this.ll();
        super.lif(stream);
    }

    public void applyChanges() {
        this.ll();
        this.lf = new int[0];
    }

    private void ll() {
        this.l1();
        if (this.lf == null) {
            for (int i = 1; i <= this.getDocument().getPages().size(); ++i) {
                this.ll(i);
            }
        } else {
            for (int n : this.lf) {
                this.ll(n);
            }
        }
    }

    private int lif(int n) {
        int n2 = this.l0if;
        if (this.lif().containsKey(n)) {
            n2 = this.lif().get_Item(n);
        }
        return n2 % 360;
    }

    private boolean lif(Page page, String string) {
        return ((I11)((Object)I4.lif(page.EnginePage, I11.class))).l6IF().ll(string) != null;
    }

    private Rectangle lif(I21 i21) {
        return new Rectangle(i21.ll(), i21.lI(), i21.l1(), i21.lIF());
    }

    private Rectangle lif(Page page) {
        I21 i21 = null;
        if (page.EnginePage.q_().lI() != null) {
            i21 = page.EnginePage.q_().lI();
        }
        if (page.EnginePage.q_().l1() != null) {
            i21 = page.EnginePage.q_().l1();
        }
        Rectangle rectangle = this.lif(i21);
        Matrix matrix = Matrix.rotation(-Matrix.getAngle(page.getRotate()));
        Rectangle rectangle2 = new Rectangle(0.0, 0.0, rectangle.getWidth(), rectangle.getHeight());
        rectangle2 = matrix.transform(rectangle2);
        matrix.setE(matrix.getE() - rectangle2.getLLX());
        matrix.setF(matrix.getF() - rectangle2.getLLY());
        rectangle = matrix.transform(rectangle);
        return rectangle;
    }

    private void ll(int n) {
        Object object;
        Page page = this.getDocument().getPages().get_Item(n);
        XForm xForm = XForm.createNewForm(page, this.getDocument());
        xForm.getContents().insert(1, new Operator.GSave());
        xForm.getContents().add(new Operator.GRestore());
        page.getResources().getForms().add(xForm);
        xForm.setBBox(page.getMediaBox());
        page.clearContents();
        Matrix matrix = new Matrix(new double[]{this.l01, 0.0, 0.0, this.l01, 0.0, 0.0});
        int n2 = this.lif(n);
        Matrix matrix2 = Matrix.rotation(Math.PI * (double)(-n2) / 180.0);
        matrix = matrix2.multiply(matrix);
        Rectangle rectangle = this.lif(page);
        Rectangle rectangle2 = new Rectangle(rectangle.getLLX(), rectangle.getLLY(), rectangle.getURX(), rectangle.getURY());
        Rectangle rectangle3 = matrix2.transform(rectangle2);
        Rectangle rectangle4 = matrix.transform(rectangle2);
        matrix.setE(-rectangle4.getLLX());
        matrix.setF(-rectangle4.getLLY());
        PageSize pageSize = this.l0IF != null ? new PageSize(this.l0IF.getWidth(), this.l0IF.getHeight()) : new PageSize((float)rectangle3.getWidth(), (float)rectangle3.getHeight());
        if (Float.compare(pageSize.getWidth(), -1.0f) == 0) {
            pageSize.setWidth((float)page.getRect().getWidth());
        }
        if (Float.compare(pageSize.getHeight(), -1.0f) == 0) {
            pageSize.setHeight((float)page.getRect().getHeight());
        }
        PageSize pageSize2 = new PageSize((float)rectangle4.getWidth(), (float)rectangle4.getHeight());
        Point point = new Point(0.0, 0.0);
        if (this.l0lf == 3) {
            point.setX(pageSize.getWidth() - pageSize2.getWidth());
        } else if (this.l0lf == 2) {
            point.setX((pageSize.getWidth() - pageSize2.getWidth()) / 2.0f);
        }
        if (this.l0iF == 1) {
            point.setY(pageSize.getHeight() - pageSize2.getHeight());
        } else if (this.l0iF == 2) {
            point.setY((pageSize.getHeight() - pageSize2.getHeight()) / 2.0f);
        }
        matrix.setE(matrix.getE() + point.getX());
        matrix.setF(matrix.getF() + point.getY());
        if (this.l0If != null) {
            matrix.setE(matrix.getE() + this.l0If.getX());
            matrix.setF(matrix.getF() + this.l0If.getY());
        }
        if (page.getRotate() == 3 || page.getRotate() == 1) {
            pageSize = new PageSize(pageSize.getHeight(), pageSize.getWidth());
        }
        page.setMediaBox(new Rectangle(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight()));
        if (this.lif(page, "CropBox")) {
            page.setCropBox(new Rectangle(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight()));
        }
        if (this.lif(page, "ArtBox")) {
            page.setArtBox(new Rectangle(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight()));
        }
        if (this.lif(page, "BleedBox")) {
            page.setBleedBox(new Rectangle(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight()));
        }
        if (this.lif(page, "TrimBox")) {
            page.setTrimBox(new Rectangle(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight()));
        }
        if ((this.lIF & 2) != 0) {
            object = new I7(this.getDocument(), this.getTransitionType());
            if ((this.lIF & 1) != 0) {
                ((I7)object).lif(this.getTransitionDuration());
            }
            page.setTransition(((I7)object).ll());
        }
        if ((this.lIF & 4) != 0) {
            page.setDuration(this.getDisplayDuration());
        }
        object = new ArrayList();
        ((ArrayList)object).add(new Operator.GSave());
        ((ArrayList)object).add(new Operator.ConcatenateMatrix(matrix));
        ((ArrayList)object).add(new Operator.Do(xForm.getName()));
        ((ArrayList)object).add(new Operator.GRestore());
        page.getContents().add((Iterable<Operator>)object);
        for (Annotation annotation : page.getAnnotations()) {
            annotation.setRect(matrix.transform(annotation.getRect()));
            for (String string : annotation.getAppearance().getKeys()) {
                XForm xForm2 = annotation.getAppearance().get_Item(string);
                Matrix matrix3 = xForm2.getMatrix();
                if (matrix3 == null) {
                    matrix3 = new Matrix();
                }
                if (xForm2.getEngineObj().l6IF().l1("BBox")) {
                    // empty if block
                }
                xForm2.setMatrix(matrix.multiply(matrix3));
            }
        }
    }

    private void lI(int n) {
        if (n % 90 != 0) {
            throw new com.aspose.pdf.internal.ms.System.I01(l0f);
        }
    }

    private void ll(Il<Integer, Integer> il) {
        for (Integer n : il.llf()) {
            int n2 = il.get_Item(n);
            int n3 = n;
            int n4 = n2;
            this.lI(n4);
            this.getDocument().getPages().get_Item(n3);
        }
    }

    private I34l lif(Rectangle rectangle) {
        return new I34l((int)rectangle.getLLX(), (int)rectangle.getLLY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
    }

    static {
        lif.setUseParentHandlers(false);
        l1if = new I01("Center", "Left", "Right", "Top", "Bottom", "trim", "art", "bleed", "crop", "media");
    }

    private static class I7 {
        public int lif;
        public IDocument ll;
        public int lI = 1;

        public I7(IDocument iDocument, int n) {
            this.lif = n;
            this.ll = iDocument;
        }

        public int lif() {
            return this.lI;
        }

        public void lif(int n) {
            this.lI = n;
        }

        public com.aspose.pdf.internal.l144.I01 ll() {
            I47 i47 = new I47(this.ll.getEngineDoc().ll());
            i47.ll("Type", (I27)new I4I("Trans"));
            i47.ll("D", (I27)new I44(this.lI));
            String string = I254.lif;
            String string2 = null;
            String string3 = null;
            I44 i44 = null;
            switch (this.lif) {
                case 1: {
                    string = "Split";
                    string2 = "V";
                    string3 = "O";
                    break;
                }
                case 2: {
                    string = "Split";
                    string2 = "H";
                    string3 = "O";
                    break;
                }
                case 3: {
                    string = "Split";
                    string2 = "V";
                    string3 = "I";
                    break;
                }
                case 4: {
                    string = "Split";
                    string2 = "H";
                    string3 = "I";
                    break;
                }
                case 5: {
                    string = "Blinds";
                    string2 = "V";
                    break;
                }
                case 6: {
                    string = "Blinds";
                    string2 = "H";
                    break;
                }
                case 7: {
                    string = "Box";
                    string3 = "I";
                    break;
                }
                case 8: {
                    string = "Box";
                    string3 = "O";
                    break;
                }
                case 9: {
                    string = "Wipe";
                    i44 = new I44(0.0);
                    break;
                }
                case 10: {
                    string = "Wipe";
                    i44 = new I44(180.0);
                    break;
                }
                case 11: {
                    string = "Wipe";
                    i44 = new I44(90.0);
                    break;
                }
                case 12: {
                    string = "Wipe";
                    i44 = new I44(270.0);
                    break;
                }
                case 13: {
                    string = "Dissolve";
                    break;
                }
                case 14: {
                    string = "Glitter";
                    i44 = new I44(0.0);
                    break;
                }
                case 15: {
                    string = "Glitter";
                    i44 = new I44(270.0);
                    break;
                }
                case 16: {
                    string = "Glitter";
                    i44 = new I44(315.0);
                }
            }
            i47.ll("S", (I27)new I4I(string));
            if (string2 != null) {
                i47.ll("Dm", (I27)new I4I(string2));
            }
            if (string3 != null) {
                i47.ll("M", (I27)new I4I(string3));
            }
            if (i44 != null) {
                i47.ll("Di", (I27)i44);
            }
            return i47;
        }
    }
}

