/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import com.aspose.pdf.DocMDPSignature;
import com.aspose.pdf.Document;
import com.aspose.pdf.Field;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.InternalHelper;
import com.aspose.pdf.PKCS1;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.Signature;
import com.aspose.pdf.SignatureField;
import com.aspose.pdf.facades.SaveableFacade;
import com.aspose.pdf.internal.l144.I11;
import com.aspose.pdf.internal.l1934.I4;
import com.aspose.pdf.internal.l27I.I07;
import com.aspose.pdf.internal.l27I.Il;
import com.aspose.pdf.internal.ms.System.Collections.Generic.I1I;
import com.aspose.pdf.internal.ms.System.I01;
import com.aspose.pdf.internal.ms.System.I0I;
import com.aspose.pdf.internal.ms.System.I254;
import com.aspose.pdf.internal.ms.System.IO.I21;
import com.aspose.pdf.internal.ms.System.IO.I4I;
import com.aspose.pdf.internal.ms.System.IO.I5l;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PdfFileSignature
extends SaveableFacade {
    private static final Logger lif = Logger.getLogger(PdfFileSignature.class.getName());
    private String ll;
    private String lI;
    private InputStream l1;
    private Signature lIF;
    private int llf;
    private String liF;
    private boolean lIf;
    private Rectangle lf;
    private String l0if;
    private String l0I;
    private int l01;

    private void lI(String string) {
        this.l1();
        if (!(this.getDocument().getForm().get_Item(string) instanceof SignatureField) || ((SignatureField)((Object)I4.lif(this.getDocument().getForm().get_Item(string), SignatureField.class))).getSignature() == null) {
            throw new I01(I254.lif("The name '{0}' doesn't represent valid signature field or signature field is empty.", new Object[]{string}));
        }
    }

    private void l1(String string) {
        this.l1();
        if (!(this.getDocument().getForm().get_Item(string) instanceof SignatureField) || ((SignatureField)((Object)I4.lif(this.getDocument().getForm().get_Item(string), SignatureField.class))).getSignature() != null) {
            throw new I01(I254.lif("The name '{0}' doesn't represent valid signature field or signature field is not empty.", new Object[]{string}));
        }
    }

    private void lif() {
        if (this.lIF != null) {
            throw new I0I("Several signatures can't be placed at once. Please, after each Sign invoke Save.");
        }
    }

    private String ll() {
        int n = 1;
        String string = "Signature";
        do {
            string = I254.lif("Signature{0}", new Object[]{I4.lif(n)});
            ++n;
        } while (this.getDocument().getForm().get(string) != null);
        return string;
    }

    public String getSignatureAppearance() {
        return this.lI;
    }

    public void setSignatureAppearance(String value) {
        this.lI = value;
        if (value != null) {
            this.l1 = null;
        }
    }

    public PdfFileSignature() {
    }

    @Deprecated
    public PdfFileSignature(String inputFile) {
        this.bindPdf(inputFile);
    }

    @Deprecated
    public PdfFileSignature(String inputFile, String outputFile) {
        this.bindPdf(inputFile);
        this.ll = outputFile;
    }

    @Override
    public void bindPdf(String inputFile) {
        this.l01 = (int)new I21(inputFile).lI();
        super.bindPdf(inputFile);
    }

    @Override
    public void bindPdf(InputStream inputStream) {
        this.liF(Stream.fromJava(inputStream));
    }

    @Override
    void liF(Stream stream) {
        this.l01 = (int)stream.getLength();
        super.liF(stream);
    }

    @Override
    public void save(String outputFile) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.save(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lif.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage(), fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(OutputStream outputStream) {
        this.l1();
        String string = null;
        if (this.getDocument().getEngineDoc().lif() != null && this.getDocument().getEngineDoc().lif().lif() != null && !I254.ll(this.getDocument().getEngineDoc().lif().lif().l7lf())) {
            string = this.getDocument().getEngineDoc().lif().lif().l7lf();
        }
        I5l i5l = new I5l();
        this.lif(this.getDocument().getEngineDoc().l0I(), i5l, string);
        try {
            if (((Stream)i5l).canSeek()) {
                ((Stream)i5l).seek(0L, 0);
            }
            byte[] byArray = new byte[i5l.toInputStream().available()];
            i5l.toInputStream().read(byArray);
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            lif.log(Level.INFO, "Exception occur", iOException);
        }
        finally {
            if (i5l != null) {
                i5l.close();
            }
        }
    }

    private void lif(Stream stream, Stream stream2, String string) {
        if (this.lIF != null) {
            Object object;
            Document document;
            int n;
            if (stream.canSeek()) {
                stream.seek(0L, 0);
            }
            byte[] byArray = new byte[1024];
            while ((n = stream.read(byArray, 0, com.aspose.pdf.internal.ms.System.I1I.lif((Object)byArray).llf())) == com.aspose.pdf.internal.ms.System.I1I.lif((Object)byArray).llf()) {
                stream2.write(byArray, 0, com.aspose.pdf.internal.ms.System.I1I.lif((Object)byArray).llf());
            }
            stream2.write(byArray, 0, n);
            if (stream2.canSeek()) {
                stream2.seek(0L, 0);
            }
            if (string != null) {
                document = InternalHelper.lif(stream2, string, false);
                document.decrypt();
            } else {
                document = new Document(stream2);
            }
            for (int i = 0; i < document.getEngineDoc().ll().l7IF().lf().length; ++i) {
                object = document.getEngineDoc().ll().l7IF();
                com.aspose.pdf.internal.l3I.Il il = object.lf()[i];
                I11 i11 = object.lif(il);
                object.lif(i11, false);
            }
            if (this.lI != null) {
                this.lIF.setImageInternal(new I4I(this.lI, 3, 1, 1));
            } else if (this.l1 != null) {
                this.lIF.setImage(this.l1);
            }
            if (this.liF != null) {
                SignatureField signatureField = (SignatureField)((Object)I4.lif(document.getForm().get_Item(this.liF), SignatureField.class));
                if (signatureField != null) {
                    if (!this.lIf) {
                        signatureField.setRect(Rectangle.getTrivial());
                    } else if (this.lf != null) {
                        signatureField.setRect(this.lf);
                    }
                    signatureField.sign(this.lIF);
                }
            } else {
                SignatureField signatureField;
                if (!this.lIf) {
                    signatureField = new SignatureField(document.getPages().get_Item(this.llf), Rectangle.getTrivial());
                } else {
                    object = this.lf == null ? new Rectangle(10.0, 10.0, 110.0, 110.0) : this.lf;
                    signatureField = new SignatureField(document.getPages().get_Item(this.llf), (Rectangle)object);
                }
                object = this.ll();
                signatureField.setPartialName((String)object);
                document.getForm().add(signatureField, this.llf);
                document.getEngineDoc().lif(false);
                document.save();
                signatureField = (SignatureField)((Object)I4.lif(document.getForm().get_Item((String)object), SignatureField.class));
                signatureField.sign(this.lIF);
            }
        } else {
            this.getDocument().save(stream2.toOutputStream());
        }
        if (this.lIF != null && this.lIF.getImageInternal() != null) {
            this.lIF.getImageInternal().dispose();
        }
        this.lIF = null;
    }

    public void sign(int page, String SigReason, String SigContact, String SigLocation, boolean visible, java.awt.Rectangle annotRect) {
        if (this.l0if == null) {
            throw new IllegalStateException("Certificate file and password was not set. Please call SetCertificate.");
        }
        this.sign(page, SigReason, SigContact, SigLocation, visible, annotRect, new PKCS1(this.l0if, this.l0I));
    }

    public void sign(int page, String SigReason, String SigContact, String SigLocation, boolean visible, java.awt.Rectangle annotRect, Signature sig) {
        this.lif();
        this.llf = page;
        this.lIF = sig;
        this.lIF.setReason(SigReason);
        this.lIF.setContactInfo(SigContact);
        this.lIF.setLocation(SigLocation);
        this.lIf = visible;
        this.lf = new Rectangle(annotRect.getX(), annotRect.getY() + annotRect.getHeight(), annotRect.getX() + annotRect.getWidth(), annotRect.getY());
    }

    public void sign(int page, boolean visible, java.awt.Rectangle annotRect, Signature sig) {
        this.sign(page, sig.getReason(), sig.getContactInfo(), sig.getLocation(), visible, annotRect, sig);
    }

    public void sign(String SigName, String SigReason, String SigContact, String SigLocation, Signature sig) {
        this.lif();
        this.l1(SigName);
        this.liF = SigName;
        this.lIF = sig;
        this.lIF.setReason(SigReason);
        this.lIF.setContactInfo(SigContact);
        this.lIF.setLocation(SigLocation);
        this.lIf = true;
    }

    public void sign(int page, String SigName, String SigReason, String SigContact, String SigLocation, boolean visible, java.awt.Rectangle annotRect, Signature sig) {
        this.lif();
        this.llf = page;
        this.lIF = sig;
        this.liF = SigName;
        this.lIF.setReason(SigReason);
        this.lIF.setContactInfo(SigContact);
        this.lIF.setLocation(SigLocation);
        this.lIf = visible;
        this.lf = new Rectangle(annotRect.getX(), annotRect.getY(), annotRect.getX() + annotRect.getWidth(), annotRect.getY() - annotRect.getHeight());
    }

    public void sign(String SigName, Signature sig) {
        this.sign(SigName, sig.getReason(), sig.getContactInfo(), sig.getLocation(), sig);
    }

    public boolean isCertified() {
        this.l1();
        for (Field field : this.getDocument().getForm()) {
            SignatureField signatureField = (SignatureField)((Object)I4.lif(field, SignatureField.class));
            if (signatureField == null || signatureField.getSignature() == null || signatureField.getSignature().getSignatureReferences() == null) continue;
            for (I07 i07 : signatureField.getSignature().getSignatureReferences()) {
                if (!I254.lIF(i07.ll().toString(), "DocMDP")) continue;
                return true;
            }
        }
        return false;
    }

    public int getAccessPermissions() {
        this.l1();
        for (Field field : this.getDocument().getForm()) {
            SignatureField signatureField = (SignatureField)((Object)I4.lif(field, SignatureField.class));
            if (signatureField == null || signatureField.getSignature() == null || signatureField.getSignature().getSignatureReferences() == null) continue;
            for (I07 i07 : signatureField.getSignature().getSignatureReferences()) {
                Il il;
                if (!I254.lIF(i07.ll().toString(), "DocMDP") || (il = (Il)((Object)I4.lif(i07.lI(), Il.class))) == null) continue;
                return il.ll().ll();
            }
        }
        throw new I0I("The document is not certified.");
    }

    public void certify(int page, String SigReason, String SigContact, String SigLocation, boolean visible, java.awt.Rectangle annotRect, DocMDPSignature docMdpSignature) {
        Signature signature = docMdpSignature.getSignature();
        this.sign(page, signature.getReason(), signature.getContactInfo(), signature.getLocation(), visible, annotRect, signature);
    }

    public List<String> getSignNames() {
        this.l1();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Field field : this.getDocument().getForm()) {
            if (!(field instanceof SignatureField) || ((SignatureField)((Object)I4.lif(field, SignatureField.class))).getSignature() == null) continue;
            arrayList.add(field.getPartialName());
        }
        return arrayList;
    }

    public List<String> getBlankSignNames() {
        this.l1();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Field field : this.getDocument().getForm()) {
            if (!(field instanceof SignatureField) || ((SignatureField)((Object)I4.lif(field, SignatureField.class))).getSignature() != null) continue;
            arrayList.add(field.getPartialName());
        }
        return arrayList;
    }

    @Deprecated
    public boolean isContainSignature() {
        return this.containsSignature();
    }

    public boolean containsSignature() {
        return this.getSignNames().size() > 0;
    }

    public boolean containsUsageRights() {
        for (Object object : this.getDocument().getForm()) {
            SignatureField signatureField = (SignatureField)((Object)I4.lif(object, SignatureField.class));
            if (signatureField == null || signatureField.getSignature() == null) continue;
            for (I07 i07 : signatureField.getSignature().getSignatureReferences()) {
                if (!"UR3".equals(i07.ll().toString())) continue;
                return true;
            }
        }
        if (this.getDocument().getEngineDoc().ll().l0If() != null) {
            for (Object object : this.getDocument().getEngineDoc().ll().l0If()) {
                if (!"UR3".equals(((I1I)object).lif())) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public boolean isCoversWholeDocument(String signName) {
        return this.coversWholeDocument(signName);
    }

    public boolean coversWholeDocument(String signName) {
        this.l1();
        this.lI(signName);
        int n = ((SignatureField)((Object)I4.lif(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getByteRange()[2] + ((SignatureField)((Object)I4.lif(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getByteRange()[3];
        return n == this.l01;
    }

    public int getRevision(String signName) {
        this.l1();
        this.lI(signName);
        int[] nArray = new int[this.getTotalRevision()];
        int n = 0;
        for (String string : this.getSignNames()) {
            nArray[n++] = ((SignatureField)((Object)I4.lif(this.getDocument().getForm().get_Item(string), SignatureField.class))).getSignature().getByteRange()[2] + ((SignatureField)((Object)I4.lif(this.getDocument().getForm().get_Item(string), SignatureField.class))).getSignature().getByteRange()[3];
        }
        com.aspose.pdf.internal.ms.System.I1I.lIF(com.aspose.pdf.internal.ms.System.I1I.lif((Object)nArray));
        int n2 = ((SignatureField)((Object)I4.lif(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getByteRange()[2] + ((SignatureField)((Object)I4.lif(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getByteRange()[3];
        return Arrays.binarySearch(nArray, n2) + 1;
    }

    public int getTotalRevision() {
        this.l1();
        return this.getSignNames().size();
    }

    public void removeUsageRights() {
        for (Object object : this.getDocument().getForm()) {
            SignatureField signatureField = (SignatureField)((Object)I4.lif(object, SignatureField.class));
            if (signatureField == null || signatureField.getSignature() == null) continue;
            for (I07 i07 : signatureField.getSignature().getSignatureReferences()) {
                if (!"UR3".equals(i07.ll().toString())) continue;
                signatureField.clear();
                return;
            }
        }
        if (this.getDocument().getEngineDoc().ll().l0If() != null) {
            for (Object object : this.getDocument().getEngineDoc().ll().l0If()) {
                if (!"UR3".equals(((I1I)object).lif())) continue;
                this.getDocument().getEngineDoc().ll().l0If().lIF("UR3");
                return;
            }
        }
    }

    public void removeSignature(String signName) {
        this.l1();
        if (!(this.getDocument().getForm().get_Item(signName) instanceof SignatureField)) {
            throw new I01(I254.lif("The name '{0}' doesn't represent valid signature field.", new Object[]{signName}));
        }
        this.getDocument().getForm().delete(signName);
    }

    public void removeSignature(String signName, boolean removeField) {
        if (removeField) {
            this.removeSignature(signName);
        } else {
            SignatureField signatureField = (SignatureField)((Object)I4.lif(this.getDocument().getForm().get_Item(signName), SignatureField.class));
            if (signatureField == null) {
                throw new I01(I254.lif("The name '{0}' doesn't represent valid signature field.", new Object[]{signName}));
            }
            signatureField.clear();
        }
    }

    public boolean verifySigned(String signName) {
        return this.verifySignature(signName);
    }

    public String getSignerName(String signName) {
        this.lI(signName);
        return ((SignatureField)((Object)I4.lif(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getAuthority();
    }

    public Date getDateTime(String signName) {
        this.lI(signName);
        return ((SignatureField)((Object)I4.lif(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getDate();
    }

    public String getReason(String signName) {
        this.lI(signName);
        return ((SignatureField)((Object)I4.lif(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getReason();
    }

    public String getLocation(String signName) {
        this.lI(signName);
        return ((SignatureField)((Object)I4.lif(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getLocation();
    }

    public String getContactInfo(String signName) {
        this.lI(signName);
        return ((SignatureField)((Object)I4.lif(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getContactInfo();
    }

    public boolean verifySignature(String signName) {
        this.l1();
        if (this.getDocument().getForm().get_Item(signName) instanceof SignatureField) {
            if (((SignatureField)((Object)I4.lif(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature() != null) {
                return ((SignatureField)((Object)I4.lif(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().verify();
            }
            throw new I01(I254.lif("Signature field '{0}' is empty.", new Object[]{signName}));
        }
        throw new I01(I254.lif("The name '{0}' doesn't represent valid signature field.", new Object[]{signName}));
    }

    public InputStream extractImage(String signName) {
        Stream stream = this.lif(signName);
        if (stream.canSeek()) {
            stream.seek(0L, 0);
        }
        return Stream.toJava(stream);
    }

    Stream lif(String string) {
        this.l1();
        SignatureField signatureField = (SignatureField)((Object)I4.lif(this.getDocument().getForm().get_Item(string), SignatureField.class));
        if (signatureField != null) {
            if (signatureField.getSignature() != null) {
                return Stream.fromJava(signatureField.extractImage());
            }
            throw new I01(I254.lif("Signature field '{0}' is empty.", new Object[]{string}));
        }
        throw new I01(I254.lif("The name '{0}' doesn't represent valid signature field.", new Object[]{string}));
    }

    Stream ll(String string) {
        this.l1();
        SignatureField signatureField = (SignatureField)((Object)I4.lif(this.getDocument().getForm().get_Item(string), SignatureField.class));
        if (signatureField != null) {
            if (signatureField.getSignature() != null) {
                return Stream.fromJava(signatureField.extractCertificate());
            }
            throw new I01(I254.lif("Signature field '{0}' is empty.", new Object[]{string}));
        }
        throw new I01(I254.lif("The name '{0}' doesn't represent valid signature field.", new Object[]{string}));
    }

    public InputStream extractCertificate(String signName) {
        return Stream.toJava(this.ll(signName));
    }

    @Deprecated
    public void save() {
        if (this.ll == null) {
            throw new IllegalStateException("Output file is not defined. Please use proper PdfFileSignature constuctor to set output file.");
        }
        this.save(this.ll);
    }

    public PdfFileSignature(IDocument document) {
        super(document);
        if (document.getEngineDoc() != null && document.getEngineDoc().l0I() != null && document.getEngineDoc().l0I().canRead()) {
            this.l01 = (int)document.getEngineDoc().l0I().getLength();
        }
    }

    @Deprecated
    public PdfFileSignature(IDocument document, String outputFile) {
        super(document);
        this.ll = outputFile;
    }

    public void setCertificate(String pfx, String pass) {
        this.l0if = pfx;
        this.l0I = pass;
    }

    public InputStream getSignatureAppearanceStream() {
        return this.l1;
    }

    public void setSignatureAppearanceStream(InputStream value) {
        this.l1 = value;
        if (value != null) {
            this.lI = null;
        }
    }

    @Override
    public void close() {
        super.close();
        this.ll = null;
        this.lI = null;
        if (this.lIF != null && this.lIF.getImageInternal() != null) {
            this.lIF.getImageInternal().close();
        }
        if (this.l1 != null) {
            try {
                this.l1.close();
            }
            catch (IOException iOException) {
                lif.log(Level.INFO, "Exception occur", iOException);
            }
        }
        this.l1 = null;
        this.lIF = null;
        this.llf = 0;
        this.liF = null;
        this.lIf = false;
        this.lf = null;
        this.l0if = null;
        this.l0I = null;
        this.l01 = 0;
    }

    @Override
    public void dispose() {
        this.close();
    }

    static {
        lif.setUseParentHandlers(false);
    }
}

