/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import com.aspose.pdf.Annotation;
import com.aspose.pdf.FileAttachmentAnnotation;
import com.aspose.pdf.FileSpecification;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.ImagePlacement;
import com.aspose.pdf.ImagePlacementAbsorber;
import com.aspose.pdf.ImageType;
import com.aspose.pdf.InternalHelper;
import com.aspose.pdf.Page;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.TextAbsorber;
import com.aspose.pdf.TextEncodingInternal;
import com.aspose.pdf.TextExtractionOptions;
import com.aspose.pdf.TextSearchOptions;
import com.aspose.pdf.XForm;
import com.aspose.pdf.XImage;
import com.aspose.pdf.facades.Facade;
import com.aspose.pdf.facades.II;
import com.aspose.pdf.internal.l144.I01;
import com.aspose.pdf.internal.l144.I11;
import com.aspose.pdf.internal.l165l.I2I;
import com.aspose.pdf.internal.l1934.I4;
import com.aspose.pdf.internal.l23I.I0I;
import com.aspose.pdf.internal.ms.System.Collections.Generic.I27;
import com.aspose.pdf.internal.ms.System.Collections.Generic.Il;
import com.aspose.pdf.internal.ms.System.I131;
import com.aspose.pdf.internal.ms.System.I20l;
import com.aspose.pdf.internal.ms.System.I254;
import com.aspose.pdf.internal.ms.System.IO.I51;
import com.aspose.pdf.internal.ms.System.IO.I5l;
import com.aspose.pdf.internal.ms.System.IO.I74;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PdfExtractor
extends Facade {
    private static final Logger lif = Logger.getLogger(PdfExtractor.class.getName());
    private int ll;
    private int lI;
    private int l1;
    private I27<XImage> lIF;
    private int llf;
    private int liF;
    private String lIf;
    private I27<String> lf;
    private int l0if = 0;
    private int l0I = 0;
    private TextSearchOptions l01 = new TextSearchOptions(Rectangle.getEmpty());
    private int l0IF = 150;
    private String l0lf = null;
    private I2I l0iF;
    private Il<Integer, Integer> l0If = new Il();
    private I0I l0f = null;

    boolean lif() {
        if (this.l0f != null) {
            int n = (Integer)this.l0f.lif;
            return InternalHelper.lI() || n == 2;
        }
        return InternalHelper.lI();
    }

    void lif(I0I i0I) {
        this.l0f = i0I;
    }

    I0I ll() {
        return this.l0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lif(FileSpecification fileSpecification, String string) {
        String string2 = I51.lif(fileSpecification.getName());
        if (string2 == null) {
            string2 = I254.lif("NoName{0}", new Object[]{this.liF++});
        }
        if (string == null) {
            string = I254.lif;
        }
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileOutputStream = new FileOutputStream(I51.ll(string, string2));
            I5l i5l = (I5l)((Object)I4.lif(fileSpecification.getContentsInternal(), I5l.class));
            if (i5l == null) {
                throw new I20l("Use for stream data only MemoryStream");
            }
            i5l.seek(0L, 0);
            byte[] byArray = new byte[1024];
            while ((n = i5l.read(byArray, 0, byArray.length)) == byArray.length) {
                fileOutputStream.write(byArray, 0, byArray.length);
            }
            fileOutputStream.write(byArray, 0, n);
        }
        catch (IOException iOException) {
            lif.log(Level.INFO, "Exception occur", iOException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    private I5l[] lif(String string, boolean bl) {
        int n;
        Object object;
        this.llf();
        I27<Stream> i27 = new I27<Stream>();
        if (this.lIf == null) {
            object = new Il();
            if (this.getDocument().getEmbeddedFiles().size() != 0) {
                for (Object object2 : this.getDocument().getEmbeddedFiles()) {
                    if (object2 == null || ((FileSpecification)object2).getContentsInternal() == null || ((Il)object).containsKey(((FileSpecification)object2).getName())) continue;
                    if (bl) {
                        this.lif((FileSpecification)object2, string);
                    } else {
                        i27.addItem(((FileSpecification)object2).getContentsInternal());
                    }
                    ((Il)object).set_Item(((FileSpecification)object2).getName(), 1);
                }
            }
            for (n = this.ll; n <= this.lI; ++n) {
                if (this.getDocument().getPages().get_Item(n).getAnnotations().size() == 0) continue;
                for (Annotation object3 : this.getDocument().getPages().get_Item(n).getAnnotations()) {
                    FileSpecification fileSpecification;
                    if (!(object3 instanceof FileAttachmentAnnotation) || (fileSpecification = ((FileAttachmentAnnotation)((Object)I4.lif(object3, FileAttachmentAnnotation.class))).getFile()) == null || fileSpecification.getName() == null || ((Il)object).containsKey(fileSpecification.getName())) continue;
                    if (bl) {
                        this.lif(fileSpecification, string);
                    } else {
                        i27.addItem(fileSpecification.getContentsInternal());
                    }
                    ((Il)object).set_Item(fileSpecification.getName(), 1);
                }
            }
        } else {
            object = this.getDocument().getEmbeddedFiles().get_Item(this.lIf);
            if (object != null) {
                if (bl) {
                    this.lif((FileSpecification)object, string);
                } else {
                    i27.addItem(((FileSpecification)object).getContentsInternal());
                }
            }
            for (n = this.ll; n <= this.lI; ++n) {
                if (this.getDocument().getPages().get_Item(n).getAnnotations().size() == 0) continue;
                for (Annotation annotation : this.getDocument().getPages().get_Item(n).getAnnotations()) {
                    if (!(annotation instanceof FileAttachmentAnnotation) || (object = ((FileAttachmentAnnotation)((Object)I4.lif(annotation, FileAttachmentAnnotation.class))).getFile()) == null || !I254.lIF(((FileSpecification)object).getName(), this.lIf)) continue;
                    if (bl) {
                        this.lif((FileSpecification)object, string);
                        continue;
                    }
                    i27.addItem(((FileSpecification)object).getContentsInternal());
                }
            }
        }
        object = null;
        if (!bl && i27.size() > 0) {
            object = new I5l[i27.size()];
            n = 0;
            for (Stream stream : i27) {
                object[n++] = (I5l)stream;
            }
        }
        return object;
    }

    private List<FileSpecification> lI() {
        ArrayList<FileSpecification> arrayList = new ArrayList<FileSpecification>();
        Il<String, Integer> il = new Il<String, Integer>();
        if (this.getDocument().getEmbeddedFiles().size() != 0) {
            for (Object object : this.getDocument().getEmbeddedFiles()) {
                if (object == null || ((FileSpecification)object).getContentsInternal() == null || il.containsKey(((FileSpecification)object).getName())) continue;
                arrayList.add((FileSpecification)object);
                il.set_Item(((FileSpecification)object).getName(), 1);
            }
        }
        for (int i = this.ll; i <= this.lI; ++i) {
            if (this.getDocument().getPages().get_Item(i).getAnnotations().size() == 0) continue;
            for (Annotation annotation : this.getDocument().getPages().get_Item(i).getAnnotations()) {
                FileSpecification fileSpecification;
                if (!(annotation instanceof FileAttachmentAnnotation) || (fileSpecification = ((FileAttachmentAnnotation)((Object)I4.lif(annotation, FileAttachmentAnnotation.class))).getFile()) == null || fileSpecification.getName() == null || il.containsKey(fileSpecification.getName())) continue;
                arrayList.add(fileSpecification);
                il.set_Item(fileSpecification.getName(), 1);
            }
        }
        return arrayList;
    }

    private void lIF() {
        this.l1();
        if (this.ll == 0) {
            this.ll = 1;
        }
        if (this.lI == 0) {
            this.lI = this.getDocument().getPages().size();
        }
        if (this.l1 == 0) {
            this.l1 = 1;
        }
        if (this.lI > this.getDocument().getPages().size()) {
            this.lI = this.getDocument().getPages().size();
        }
        if (this.ll > this.getDocument().getPages().size()) {
            this.ll = this.getDocument().getPages().size();
        }
        if (this.lI < this.ll) {
            this.lI = this.ll;
        }
        if (!this.lif() && this.lI > 4) {
            this.lI = 4;
        }
    }

    static void lif(I27<XImage> i27, XForm xForm) {
        int n;
        for (n = xForm.getResources().getForms().size(); n >= 1; --n) {
            PdfExtractor.lif(i27, xForm.getResources().getForms().get_Item(n));
        }
        for (n = xForm.getResources().getImages().size(); n >= 1; --n) {
            i27.insertItem(0, xForm.getResources().getImages().get_Item(n));
        }
    }

    void lif(I27<XImage> i27, IDocument iDocument, int n, int n2) {
        if (this.l0I == 0) {
            this.lI(i27, iDocument, n, n2);
        } else {
            PdfExtractor.ll(i27, iDocument, n, n2);
        }
    }

    static void ll(I27<XImage> i27, IDocument iDocument, int n, int n2) {
        i27.clear();
        ImagePlacementAbsorber imagePlacementAbsorber = new ImagePlacementAbsorber();
        if (n <= n2) {
            iDocument.getPages().get_Item(n).accept(imagePlacementAbsorber);
            for (ImagePlacement imagePlacement : imagePlacementAbsorber.getImagePlacements()) {
                i27.addItem(imagePlacement.getImage());
            }
        }
    }

    void lI(I27<XImage> i27, IDocument iDocument, int n, int n2) {
        int n3;
        i27.clear();
        if (n <= n2) {
            for (n3 = iDocument.getPages().get_Item(n).getResources().getForms().size(); n3 >= 1; --n3) {
                PdfExtractor.lif(i27, iDocument.getPages().get_Item(n).getResources().getForms().get_Item(n3));
            }
        }
        for (n3 = iDocument.getPages().get_Item(n).getResources().getImages().size(); n3 >= 1; --n3) {
            i27.insertItem(0, iDocument.getPages().get_Item(n).getResources().getImages().get_Item(n3));
        }
        if (iDocument.getPages().get_Item(n).getResources().getEngineDict().l1("Pattern")) {
            I01 i01 = iDocument.getPages().get_Item(n).getResources().getEngineDict().lI("Pattern").l6IF();
            for (String string : i01.l21()) {
                I01 i012;
                I01 i013 = i01.lI(string).l6IF();
                if (i013 == null || !i013.l1("Resources") || (i012 = i013.lI("Resources").l6IF()) == null || !i012.l1("XObject")) continue;
                I01 i014 = i012.lI("XObject").l6IF();
                for (String string2 : i014.l21()) {
                    com.aspose.pdf.internal.l144.I27 i272 = i014.lI(string2);
                    if (!XImage.isImage(i272)) continue;
                    I11 i11 = i272.l6f();
                    XImage xImage = InternalHelper.lif(i272.l6l());
                    if (i11 == null) {
                        i27.addItem(xImage);
                        continue;
                    }
                    if (this.l0If.containsKey(i11.l4IF())) continue;
                    this.l0If.addItem(i11.l4IF(), i11.l4IF());
                    i27.addItem(xImage);
                }
            }
        }
    }

    private boolean lif(char c) {
        return c >= '\u0600' && c <= '\u06ff' || c >= '\u0750' && c <= '\u077f' || c >= '\ufb50' && c <= '\ufdff' || c >= '\ufe70' && c <= '\ufeff';
    }

    private boolean ll(char c) {
        return c >= '\u0590' && c <= '\u05ff';
    }

    public int getStartPage() {
        return this.ll;
    }

    public void setStartPage(int value) {
        int n = this.ll = value < 1 ? 1 : value;
        if (this.lI < this.ll) {
            this.lI = this.ll;
        }
    }

    public int getEndPage() {
        return this.lI;
    }

    public void setEndPage(int value) {
        int n = this.lI = value < 1 ? 1 : value;
        if (this.ll > this.lI) {
            this.ll = this.lI;
        }
    }

    public int getExtractTextMode() {
        return this.l0if;
    }

    public void setExtractTextMode(int value) {
        if (value == 0 || value == 1) {
            this.l0if = value;
        }
    }

    public TextSearchOptions getTextSearchOptions() {
        return this.l01;
    }

    public void setTextSearchOptions(TextSearchOptions value) {
        if (value != null) {
            this.l01 = value;
        }
    }

    public int getExtractImageMode() {
        return this.l0I;
    }

    public void setExtractImageMode(int value) {
        this.l0I = value;
    }

    public boolean isBidi() {
        I5l i5l = new I5l();
        this.getText(i5l.toOutputStream());
        i5l.setPosition(0L);
        I74 i74 = new I74((Stream)i5l, I2I.l1f());
        String string = i74.l01();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!this.lif(c) && !this.ll(c)) continue;
            return true;
        }
        return false;
    }

    public void extractText() {
        this.llf();
        this.extractTextInternal(TextEncodingInternal.getUnicode());
    }

    public void extractText(Charset encoding) {
        this.extractTextInternal(TextEncodingInternal.getEncoding(encoding.displayName()));
    }

    public void extractTextInternal(TextEncodingInternal encoding) {
        this.llf();
        this.l0iF = encoding.getInternalFormat();
        this.lf = new I27();
        for (int i = this.getStartPage(); i <= this.getEndPage(); ++i) {
            if (InternalHelper.lif(this.l0f, i)) continue;
            long l = 0L;
            TextExtractionOptions textExtractionOptions = this.l0if == 0 ? new TextExtractionOptions(0) : new TextExtractionOptions(1);
            TextAbsorber textAbsorber = new TextAbsorber(textExtractionOptions);
            textAbsorber.setTextSearchOptions(this.getTextSearchOptions());
            textAbsorber.visit(this.getDocument().getPages().get_Item(i));
            this.lf.addItem(textAbsorber.getText());
        }
    }

    public void getText(String outputFile) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getText(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lif.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage(), fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getText(OutputStream outputStream) {
        I5l i5l = new I5l();
        this.lif(i5l);
        try {
            if (((Stream)i5l).canSeek()) {
                ((Stream)i5l).seek(0L, 0);
            }
            byte[] byArray = new byte[i5l.toInputStream().available()];
            i5l.toInputStream().read(byArray);
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            lif.log(Level.INFO, "Exception occur", iOException);
        }
        finally {
            if (i5l != null) {
                i5l.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lif(Stream stream) {
        if (this.getDocument() == null) {
            throw new IllegalStateException("PdfExtractor hasn't been bound yet. Please provide pdf document to process.");
        }
        if (this.lf == null) {
            return;
        }
        com.aspose.pdf.internal.ms.System.IO.Il il = new com.aspose.pdf.internal.ms.System.IO.Il(stream);
        try {
            for (int i = 0; i < this.lf.size(); ++i) {
                String string = this.lf.get_Item(i);
                if (string == null) continue;
                if (i > 0) {
                    il.lif(this.l0iF.lI("\r\n"));
                }
                il.lif(this.l0iF.lI(string));
            }
        }
        finally {
            il.lI();
        }
    }

    @Override
    public void bindPdf(String inputFile) {
        this.bindPdf(inputFile, this.l0lf);
        this.llf();
    }

    @Override
    public void bindPdf(InputStream inputStream) {
        this.lif(Stream.fromJava(inputStream), this.l0lf);
        this.llf();
    }

    public void extractImage() {
        this.llf();
        this.lIF = new I27();
        this.lif(this.lIF, this.getDocument(), this.l1, this.lI);
        this.llf = 0;
    }

    public boolean hasNextImage() {
        this.lIF();
        if (this.lIF == null) {
            throw new IllegalStateException("PdfExtractor hasn't been prepared for extracting images. Please call ExtractImage.");
        }
        if (this.l1 > this.lI) {
            return false;
        }
        if (this.llf >= this.lIF.size()) {
            ++this.l1;
            this.llf = 0;
            while (this.l1 <= this.lI) {
                this.lif(this.lIF, this.getDocument(), this.l1, this.lI);
                if (this.lIF.size() != 0) break;
                ++this.l1;
            }
        }
        return this.l1 <= this.lI && this.llf < this.lIF.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getNextImage(String outputFile) {
        boolean bl = false;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            bl = this.getNextImage(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lif.log(Level.INFO, "Exception occur", fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                    throw new RuntimeException(iOException);
                }
            }
        }
        return bl;
    }

    public boolean getNextImage(String outputFile, ImageType format) {
        boolean bl = false;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            bl = this.getNextImage(fileOutputStream, format);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lif.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
        return bl;
    }

    public boolean getNextImage(OutputStream outputStream, ImageType format) {
        if (this.hasNextImage()) {
            try {
                ((XImage)((Object)I4.lif(this.lIF.get_Item(this.llf++), XImage.class))).save(outputStream, format, this.l0IF);
                return true;
            }
            catch (I131 i131) {
                lif.log(Level.INFO, "Exception occur", i131);
                return false;
            }
        }
        return false;
    }

    public boolean getNextImage(OutputStream outputStream) {
        if (this.hasNextImage()) {
            try {
                ((XImage)((Object)I4.lif(this.lIF.get_Item(this.llf++), XImage.class))).save(outputStream, this.l0IF);
                return true;
            }
            catch (I131 i131) {
                lif.log(Level.INFO, "Exception occur", i131);
                return false;
            }
        }
        return false;
    }

    public List<String> getAttachNames() {
        this.llf();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getDocument().getEmbeddedFiles().size() != 0) {
            for (Object object : this.getDocument().getEmbeddedFiles()) {
                arrayList.add(((FileSpecification)object).getName());
            }
        }
        for (int i = this.ll; i <= this.lI; ++i) {
            if (this.getDocument().getPages().get_Item(i).getAnnotations().size() == 0) continue;
            for (Annotation annotation : this.getDocument().getPages().get_Item(i).getAnnotations()) {
                if (!(annotation instanceof FileAttachmentAnnotation)) continue;
                arrayList.add(((FileAttachmentAnnotation)((Object)I4.lif(annotation, FileAttachmentAnnotation.class))).getFile().getName());
            }
        }
        return arrayList;
    }

    public void extractAttachment() {
        this.llf();
        this.lIf = null;
        this.liF = 1;
    }

    private void llf() {
        this.lIF();
        this.l1 = this.ll;
    }

    public void extractAttachment(String attachmentFileName) {
        this.lIf = attachmentFileName;
    }

    public void getAttachment(String outputPath) {
        this.lif(outputPath, true);
    }

    public boolean hasNextPageText() {
        return this.lf != null && this.l1 <= this.getEndPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNextPageText(String outputFile) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextPageText(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lif.log(Level.INFO, "Exception occur", fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNextPageText(OutputStream outputStream) {
        I5l i5l = new I5l();
        this.ll(i5l);
        try {
            if (((Stream)i5l).canSeek()) {
                ((Stream)i5l).seek(0L, 0);
            }
            byte[] byArray = new byte[i5l.toInputStream().available()];
            i5l.toInputStream().read(byArray);
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            lif.log(Level.INFO, "Exception occur", iOException);
        }
        finally {
            if (i5l != null) {
                i5l.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ll(Stream stream) {
        if (this.hasNextPageText() && this.lf.size() >= this.l1) {
            com.aspose.pdf.internal.ms.System.IO.Il il = new com.aspose.pdf.internal.ms.System.IO.Il(stream);
            try {
                String string = (String)((Object)I4.lif(this.lf.get_Item(this.l1 - 1), String.class));
                if (string != null) {
                    il.lif(this.l0iF.lI(string));
                }
            }
            finally {
                il.lI();
            }
            ++this.l1;
        }
    }

    public PdfExtractor() {
    }

    public PdfExtractor(IDocument document) {
        super(document);
    }

    public void getText(OutputStream outputStream, boolean filterNotAscii) {
        if (!filterNotAscii) {
            this.getText(outputStream);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.getText(byteArrayOutputStream);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            outputStreamWriter.write(new String(byteArrayOutputStream.toByteArray(), "UTF-8").replaceAll("[^\\u0000-\\u007F]", I254.lif));
        }
        catch (Exception exception) {
            lif.log(Level.INFO, "Exception occur", exception);
            throw new RuntimeException(exception.getMessage());
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
        try {
            outputStream.flush();
        }
        catch (IOException iOException) {
            lif.log(Level.INFO, "Exception occur", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream[] getAttachment() {
        I5l[] i5lArray = this.liF();
        if (i5lArray != null && i5lArray.length > 0) {
            ByteArrayOutputStream[] byteArrayOutputStreamArray = new ByteArrayOutputStream[i5lArray.length];
            for (int i = 0; i < i5lArray.length; ++i) {
                InputStream inputStream = i5lArray[i].toInputStream();
                byteArrayOutputStreamArray[i] = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                try {
                    int n;
                    while ((n = inputStream.read(byArray)) != -1) {
                        byteArrayOutputStreamArray[i].write(byArray, 0, n);
                    }
                    continue;
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                    continue;
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (i5lArray[i] != null) {
                            i5lArray[i].close();
                        }
                    }
                    catch (IOException iOException) {
                        lif.log(Level.INFO, "Exception occur", iOException);
                    }
                }
            }
            return byteArrayOutputStreamArray;
        }
        return null;
    }

    private I5l[] liF() {
        return this.lif(null, false);
    }

    public List<FileSpecification> getAttachmentInfo() {
        return this.lI();
    }

    public int getResolution() {
        return this.l0IF;
    }

    public void setResolution(int value) {
        this.l0IF = value;
    }

    public String getPassword() {
        return this.l0lf;
    }

    public void setPassword(String value) {
        this.l0lf = value;
    }

    public void extractMarkedContentAsImages(Page page, String path) {
        II iI = new II();
        iI.process(page, path);
    }

    static {
        lif.setUseParentHandlers(false);
    }
}

