/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import com.aspose.pdf.IDocument;
import com.aspose.pdf.IIndexBitmapConverter;
import com.aspose.pdf.ImageType;
import com.aspose.pdf.InternalHelper;
import com.aspose.pdf.Page;
import com.aspose.pdf.PageSize;
import com.aspose.pdf.Point;
import com.aspose.pdf.RenderingOptions;
import com.aspose.pdf.devices.BmpDevice;
import com.aspose.pdf.devices.EmfDevice;
import com.aspose.pdf.devices.GifDevice;
import com.aspose.pdf.devices.GraphicsDevice;
import com.aspose.pdf.devices.ImageDevice;
import com.aspose.pdf.devices.JpegDevice;
import com.aspose.pdf.devices.PngDevice;
import com.aspose.pdf.devices.Resolution;
import com.aspose.pdf.devices.TiffDevice;
import com.aspose.pdf.devices.TiffSettings;
import com.aspose.pdf.facades.Facade;
import com.aspose.pdf.internal.l144.I01;
import com.aspose.pdf.internal.l144.I07;
import com.aspose.pdf.internal.l1591.I5I;
import com.aspose.pdf.internal.l1597.I31;
import com.aspose.pdf.internal.l1597.I34l;
import com.aspose.pdf.internal.l1597.I44;
import com.aspose.pdf.internal.l1597.I64;
import com.aspose.pdf.internal.l1597.I77;
import com.aspose.pdf.internal.l1597.Il;
import com.aspose.pdf.internal.l166l.I74I;
import com.aspose.pdf.internal.l166l.I75l;
import com.aspose.pdf.internal.l1934.I4;
import com.aspose.pdf.internal.ms.System.I131;
import com.aspose.pdf.internal.ms.System.I254;
import com.aspose.pdf.internal.ms.System.IO.I11;
import com.aspose.pdf.internal.ms.System.IO.I4I;
import com.aspose.pdf.internal.ms.System.IO.I5l;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PdfConverter
extends Facade {
    private static final Logger lif = Logger.getLogger(PdfConverter.class.getName());
    private Resolution ll = new Resolution(150);
    private int lI = 1;
    private int l1 = Integer.MAX_VALUE;
    private int lIF = 1;
    private String llf;
    private String liF;
    private int lIf = 0;
    private RenderingOptions lf = new RenderingOptions();
    private boolean l0if = true;
    private boolean l0I = false;
    private int l01 = 1;

    public int getCoordinateType() {
        return this.l01;
    }

    public void setCoordinateType(int value) {
        this.l01 = value;
    }

    @Deprecated
    public boolean isShowHiddenAreas() {
        return this.l0if;
    }

    @Deprecated
    public void setShowHiddenAreas(boolean value) {
        this.l0I = true;
        this.l0if = value;
    }

    private ImageDevice lif(float f, float f2, int n, int n2, I34l i34l, float f3, Resolution resolution, int n3, boolean bl, int n4, int n5, boolean bl2) {
        GraphicsDevice graphicsDevice = new GraphicsDevice(new Point(f, f2), n, n2, i34l.l01(), f3, resolution, n3, bl, n4, n5, bl2);
        graphicsDevice.setFormPresentationMode(this.getFormPresentationMode());
        graphicsDevice.setRenderingOptions(this.getRenderingOptions());
        return graphicsDevice;
    }

    private ImageDevice lif(ImageType imageType, int n, int n2, Resolution resolution, int n3) {
        ImageDevice imageDevice = null;
        if (InternalHelper.lif(imageType) == I5I.l0if()) {
            imageDevice = new JpegDevice(n, n2, resolution, n3);
        } else if (InternalHelper.lif(imageType) == I5I.l0I()) {
            imageDevice = new PngDevice(n, n2, resolution);
        } else if (InternalHelper.lif(imageType) == I5I.lIF()) {
            imageDevice = new BmpDevice(n, n2, resolution);
        } else if (InternalHelper.lif(imageType) == I5I.lIf()) {
            imageDevice = new GifDevice(n, n2, resolution);
        } else if (InternalHelper.lif(imageType) == I5I.llf()) {
            imageDevice = new EmfDevice(n, n2, resolution);
        } else {
            if (InternalHelper.lif(imageType) == I5I.l01()) {
                throw new I131(I254.lif(new String[]{"Image format ", imageType.toString(), " is not supported. SaveAsTIFF methods should be used in order to generate Tiff files."}));
            }
            throw new I131(I254.lif(new String[]{"Image format ", imageType.toString(), " is not supported"}));
        }
        imageDevice.setFormPresentationMode(this.getFormPresentationMode());
        imageDevice.setRenderingOptions(this.getRenderingOptions());
        return imageDevice;
    }

    private ImageDevice lif(ImageType imageType, PageSize pageSize, Resolution resolution, int n) {
        ImageDevice imageDevice = null;
        if (InternalHelper.lif(imageType) == I5I.l0if()) {
            imageDevice = new JpegDevice(pageSize, resolution, n);
        } else if (InternalHelper.lif(imageType) == I5I.l0I()) {
            imageDevice = new PngDevice(pageSize, resolution);
        } else if (InternalHelper.lif(imageType) == I5I.lIF()) {
            imageDevice = new BmpDevice(pageSize, resolution);
        } else if (InternalHelper.lif(imageType) == I5I.lIf()) {
            imageDevice = new GifDevice(pageSize, resolution);
        } else if (InternalHelper.lif(imageType) == I5I.llf()) {
            imageDevice = new EmfDevice(pageSize, resolution);
        } else {
            if (InternalHelper.lif(imageType) == I5I.l01()) {
                throw new I131(I254.lif(new String[]{"Image format ", imageType.toString(), " is not supported. SaveAsTIFF methods should be used in order to generate Tiff files."}));
            }
            throw new I131(I254.lif(new String[]{"Image format ", imageType.toString(), " is not supported"}));
        }
        imageDevice.setFormPresentationMode(this.getFormPresentationMode());
        imageDevice.setRenderingOptions(this.getRenderingOptions());
        return imageDevice;
    }

    public RenderingOptions getRenderingOptions() {
        return this.lf;
    }

    public void setRenderingOptions(RenderingOptions value) {
        this.lf = value;
    }

    public int getFormPresentationMode() {
        return this.lIf;
    }

    public void setFormPresentationMode(int value) {
        this.lIf = value;
    }

    public Resolution getResolution() {
        return this.ll;
    }

    public void setResolution(Resolution value) {
        this.ll = value.getX() <= 0 || value.getY() <= 0 ? new Resolution(150) : value;
    }

    public int getStartPage() {
        return this.lI;
    }

    public void setStartPage(int value) {
        this.lIF = this.lI = value < 1 ? 1 : value;
    }

    public int getEndPage() {
        this.l1();
        if (this.l1 != Integer.MAX_VALUE) {
            return this.l1;
        }
        return this.getDocument().getPages().size();
    }

    public void setEndPage(int value) {
        this.l1();
        int n = this.l1 = value > this.getDocument().getPages().size() ? this.getDocument().getPages().size() : value;
        if (this.l1 < this.lI) {
            this.l1 = this.lI;
        }
    }

    public void setRangeOfPages(int startPage, int EndPage) {
        if (startPage > EndPage) {
            this.l1 = startPage > this.l0l.getPages().size() ? this.l0l.getPages().size() : startPage;
            this.lI = EndPage < 1 ? 1 : EndPage;
        } else {
            this.l1 = EndPage > this.l0l.getPages().size() ? this.l0l.getPages().size() : EndPage;
            this.lI = startPage < 1 ? 1 : startPage;
        }
    }

    public String getPassword() {
        return this.llf;
    }

    public void setPassword(String value) {
        this.llf = value;
    }

    public String getUserPassword() {
        return this.liF;
    }

    public void setUserPassword(String value) {
        this.liF = value;
    }

    public int getPageCount() {
        this.l1();
        return this.getDocument().getPages().size();
    }

    public void doConvert() {
        this.l1();
        this.lIF = this.lI;
    }

    public void saveAsTIFF(String outputFile) {
        I4I i4I = null;
        try {
            i4I = I11.lIf(outputFile);
            this.lif(i4I);
        }
        catch (I131 i131) {
            lif.log(Level.INFO, "Exception occur", i131);
            throw new RuntimeException(i131.getMessage());
        }
        finally {
            if (i4I != null) {
                try {
                    i4I.close();
                }
                catch (I131 i131) {
                    lif.log(Level.INFO, "Exception occur", i131);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, int compressionType) {
        I4I i4I = null;
        try {
            i4I = I11.lIf(outputFile);
            this.lif((Stream)i4I, 0, 0, compressionType);
        }
        catch (I131 i131) {
            lif.log(Level.INFO, "Exception occur", i131);
            throw new RuntimeException(i131.getMessage());
        }
        finally {
            if (i4I != null) {
                try {
                    i4I.close();
                }
                catch (I131 i131) {
                    lif.log(Level.INFO, "Exception occur", i131);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, int imageWidth, int imageHeight) {
        I4I i4I = null;
        try {
            i4I = I11.lIf(outputFile);
            this.lif((Stream)i4I, imageWidth, imageHeight);
        }
        catch (I131 i131) {
            lif.log(Level.INFO, "Exception occur", i131);
            throw new RuntimeException(i131.getMessage());
        }
        finally {
            if (i4I != null) {
                try {
                    i4I.close();
                }
                catch (I131 i131) {
                    lif.log(Level.INFO, "Exception occur", i131);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, PageSize pageSize) {
        I4I i4I = null;
        try {
            i4I = I11.lIf(outputFile);
            this.lif((Stream)i4I, pageSize);
        }
        catch (I131 i131) {
            lif.log(Level.INFO, "Exception occur", i131);
            throw new RuntimeException(i131.getMessage());
        }
        finally {
            if (i4I != null) {
                try {
                    i4I.close();
                }
                catch (I131 i131) {
                    lif.log(Level.INFO, "Exception occur", i131);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, PageSize pageSize, TiffSettings settings) {
        I4I i4I = null;
        try {
            i4I = I11.lIf(outputFile);
            this.lif((Stream)i4I, pageSize, settings);
        }
        catch (I131 i131) {
            lif.log(Level.INFO, "Exception occur", i131);
            throw new RuntimeException(i131.getMessage());
        }
        finally {
            if (i4I != null) {
                try {
                    i4I.close();
                }
                catch (I131 i131) {
                    lif.log(Level.INFO, "Exception occur", i131);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, int imageWidth, int imageHeight, int compressionType) {
        I4I i4I = null;
        try {
            i4I = I11.lIf(outputFile);
            this.lif((Stream)i4I, imageWidth, imageHeight, compressionType);
        }
        catch (I131 i131) {
            lif.log(Level.INFO, "Exception occur", i131);
            throw new RuntimeException(i131.getMessage());
        }
        finally {
            if (i4I != null) {
                try {
                    i4I.close();
                }
                catch (I131 i131) {
                    lif.log(Level.INFO, "Exception occur", i131);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, int imageWidth, int imageHeight, TiffSettings settings) {
        I4I i4I = null;
        try {
            i4I = I11.lIf(outputFile);
            this.lif((Stream)i4I, imageWidth, imageHeight, settings);
        }
        catch (I131 i131) {
            lif.log(Level.INFO, "Exception occur", i131);
            throw new RuntimeException(i131.getMessage());
        }
        finally {
            if (i4I != null) {
                try {
                    i4I.close();
                }
                catch (I131 i131) {
                    lif.log(Level.INFO, "Exception occur", i131);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, int imageWidth, int imageHeight, TiffSettings settings, IIndexBitmapConverter converter) {
        I4I i4I = null;
        try {
            i4I = I11.lIf(outputFile);
            this.lif(i4I, imageWidth, imageHeight, settings, converter);
        }
        catch (I131 i131) {
            lif.log(Level.INFO, "Exception occur", i131);
            throw new RuntimeException(i131.getMessage());
        }
        finally {
            if (i4I != null) {
                try {
                    i4I.close();
                }
                catch (I131 i131) {
                    lif.log(Level.INFO, "Exception occur", i131);
                }
            }
        }
    }

    public void saveAsTIFFClassF(String outputFile, int imageWidth, int imageHeight) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.saveAsTIFFClassF(fileOutputStream, imageWidth, imageHeight);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lif.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void saveAsTIFFClassF(String outputFile, PageSize pageSize) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.saveAsTIFFClassF(fileOutputStream, pageSize);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lif.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void saveAsTIFFClassF(OutputStream outputStream, int imageWidth, int imageHeight) {
        TiffSettings tiffSettings = new TiffSettings();
        tiffSettings.setDepth(3);
        tiffSettings.setCompression(1);
        this.saveAsTIFF(outputStream, imageWidth, imageHeight, tiffSettings);
    }

    public void saveAsTIFFClassF(OutputStream outputStream, PageSize pageSize) {
        TiffSettings tiffSettings = new TiffSettings();
        tiffSettings.setDepth(3);
        tiffSettings.setCompression(1);
        this.saveAsTIFF(outputStream, pageSize, tiffSettings);
    }

    public void saveAsTIFF(OutputStream outputStream) {
        this.saveAsTIFF(outputStream, 0, 0, new TiffSettings());
    }

    private void lif(Stream stream) {
        this.lif(stream, 0, 0, new TiffSettings());
    }

    public void saveAsTIFF(OutputStream outputStream, int compressionType) {
        this.saveAsTIFF(outputStream, 0, 0, compressionType);
    }

    public void saveAsTIFF(OutputStream outputStream, PageSize pageSize) {
        this.saveAsTIFF(outputStream, pageSize, new TiffSettings());
    }

    public void saveAsTIFF(OutputStream outputStream, PageSize pageSize, TiffSettings settings) {
        this.l1();
        TiffDevice tiffDevice = new TiffDevice(pageSize, this.getResolution(), settings);
        tiffDevice.process(this.l0l, this.getStartPage(), this.getEndPage(), outputStream);
    }

    public void saveAsTIFF(OutputStream outputStream, int imageWidth, int imageHeight) {
        this.saveAsTIFF(outputStream, imageWidth, imageHeight, new TiffSettings());
    }

    public void saveAsTIFF(OutputStream outputStream, int imageWidth, int imageHeight, int compressionType) {
        this.saveAsTIFF(outputStream, imageWidth, imageHeight, new TiffSettings(compressionType));
    }

    public void saveAsTIFF(OutputStream outputStream, int imageWidth, int imageHeight, TiffSettings settings) {
        this.l1();
        TiffDevice tiffDevice = new TiffDevice(imageWidth, imageHeight, this.getResolution(), settings);
        tiffDevice.setFormPresentationMode(this.getFormPresentationMode());
        tiffDevice.setRenderingOptions(this.getRenderingOptions());
        tiffDevice.process(this.getDocument(), this.getStartPage(), this.getEndPage(), outputStream);
    }

    private void lif(Stream stream, int n, int n2, TiffSettings tiffSettings) {
        this.l1();
        TiffDevice tiffDevice = new TiffDevice(n, n2, this.getResolution(), tiffSettings);
        tiffDevice.setFormPresentationMode(this.getFormPresentationMode());
        tiffDevice.setRenderingOptions(this.getRenderingOptions());
        tiffDevice.process(this.getDocument(), this.getStartPage(), this.getEndPage(), stream);
    }

    private void lif(Stream stream, int n, int n2, int n3) {
        this.l1();
        TiffDevice tiffDevice = new TiffDevice(n, n2, this.getResolution(), new TiffSettings(n3));
        tiffDevice.setFormPresentationMode(this.getFormPresentationMode());
        tiffDevice.setRenderingOptions(this.getRenderingOptions());
        tiffDevice.process(this.getDocument(), this.getStartPage(), this.getEndPage(), stream);
    }

    private void lif(Stream stream, int n, int n2) {
        this.lif(stream, n, n2, new TiffSettings());
    }

    private void lif(Stream stream, int n, int n2, TiffSettings tiffSettings, IIndexBitmapConverter iIndexBitmapConverter) {
        this.l1();
        TiffDevice tiffDevice = new TiffDevice(n, n2, this.getResolution(), tiffSettings, iIndexBitmapConverter);
        tiffDevice.process(this.getDocument(), this.getStartPage(), this.getEndPage(), stream);
    }

    private void lif(Stream stream, PageSize pageSize) {
        this.lif(stream, pageSize, new TiffSettings());
    }

    private void lif(Stream stream, PageSize pageSize, TiffSettings tiffSettings) {
        this.l1();
        TiffDevice tiffDevice = new TiffDevice(pageSize, this.getResolution(), tiffSettings);
        tiffDevice.setFormPresentationMode(this.getFormPresentationMode());
        tiffDevice.setRenderingOptions(this.getRenderingOptions());
        tiffDevice.process(this.getDocument(), this.getStartPage(), this.getEndPage(), stream);
    }

    public void saveAsTIFF(OutputStream outputStream, int imageWidth, int imageHeight, TiffSettings settings, IIndexBitmapConverter converter) {
        this.l1();
        TiffDevice tiffDevice = new TiffDevice(imageWidth, imageHeight, this.getResolution(), settings, converter);
        tiffDevice.process(this.getDocument(), this.getStartPage(), this.getEndPage(), outputStream);
    }

    public boolean hasNextImage() {
        this.l1();
        return this.lIF <= this.getEndPage();
    }

    public void getNextImage(String outputFile) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lif.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void getNextImage(String outputFile, PageSize pageSize) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, pageSize);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lif.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public I5l convertPageToPNGMemoryStream(Page page) {
        I5l i5l = new I5l();
        Resolution resolution = new Resolution(300);
        PngDevice pngDevice = new PngDevice(resolution);
        pngDevice.processInternal(page, i5l);
        i5l.seek(0L, 0);
        return i5l;
    }

    byte[] lif(Page page) {
        return this.convertPageToPNGMemoryStream(page).l1();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] ll(Stream stream) {
        byte[] byArray = new byte[16384];
        I5l i5l = new I5l();
        try {
            int n;
            while ((n = stream.read(byArray, 0, byArray.length)) > 0) {
                i5l.write(byArray, 0, n);
            }
            byte[] byArray2 = i5l.l1();
            return byArray2;
        }
        finally {
            if (i5l != null) {
                i5l.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNextImage(String outputFile, ImageType format) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, format);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lif.log(Level.INFO, "Exception occur", fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void getNextImage(String outputFile, PageSize pageSize, ImageType format) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, pageSize, format);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lif.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void getNextImage(OutputStream outputStream) {
        this.getNextImage(outputStream, ImageType.getJpeg(), 0, 0, 100);
    }

    public void getNextImage(OutputStream outputStream, PageSize pageSize) {
        this.getNextImage(outputStream, pageSize, ImageType.getJpeg(), 100);
    }

    public void getNextImage(OutputStream outputStream, ImageType format) {
        this.l1();
        if (this.hasNextImage()) {
            this.getNextImage(outputStream, format, 0, 0, 100);
        }
    }

    public void getNextImage(OutputStream outputStream, PageSize pageSize, ImageType format) {
        this.l1();
        if (this.hasNextImage()) {
            this.getNextImage(outputStream, pageSize, format, 100);
        }
    }

    public void getNextImage(String outputFile, ImageType format, int imageWidth, int imageHeight, int quality) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, format, imageWidth, imageHeight, quality);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lif.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void getNextImage(OutputStream outputStream, ImageType format, int imageWidth, int imageHeight, int quality) {
        this.l1();
        I5l i5l = new I5l();
        if (this.hasNextImage()) {
            ImageDevice imageDevice = this.lif(format, imageWidth, imageHeight, this.getResolution(), quality);
            imageDevice.setCoordinateType(this.l01);
            imageDevice.processInternal(this.l0l.getPages().get_Item(this.lIF), i5l);
            ++this.lIF;
        }
        try {
            if (i5l != null) {
                outputStream.write(i5l.l1());
            }
            i5l.close();
        }
        catch (IOException iOException) {
            lif.log(Level.INFO, "Exception occur", iOException);
        }
    }

    public void getNextImage(String outputFile, ImageType format, double imageWidth, double imageHeight, int quality) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, format, imageWidth, imageHeight, quality);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lif.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void getNextImage(OutputStream outputStream, ImageType format, double imageWidth, double imageHeight, int quality) {
        this.getNextImage(outputStream, format, (int)imageWidth, (int)imageHeight, quality);
    }

    private void lif() {
        I75l i75l;
        if (this.getDocument().getForm().hasXfa() && (i75l = this.getDocument().getForm().getXFA().getConfig()) != null) {
            I07 i07;
            I01 i01;
            I74I i74I = new I74I(this.getDocument().getForm().getXFA().getConfig().lf().l1iF());
            i74I.lI("cfg", this.getDocument().getForm().getXFA().getConfig().llf());
            I75l i75l2 = i75l.ll("cfg:acrobat/cfg:acrobat7/cfg:dynamicRender", i74I);
            if (i75l2 != null && i75l2.l0if() != null && I254.lIf(i75l2.l0if(), "required") != -1 && (i01 = this.getDocument().getEngineDoc().ll().l6IF()).l1("NeedsRendering") && (i07 = i01.lI("NeedsRendering").l6If()).ll()) {
                this.getDocument().getForm().setType(0);
            }
        }
    }

    @Override
    public void bindPdf(String inputFile) {
        if (this.getPassword() != null) {
            this.bindPdf(inputFile, this.getPassword());
        } else if (this.getUserPassword() != null) {
            this.bindPdf(inputFile, this.getUserPassword());
        } else {
            this.bindPdf(inputFile, this.getPassword());
        }
        this.lif();
    }

    @Override
    public void bindPdf(InputStream inputStream) {
        this.liF(Stream.fromJava(inputStream));
    }

    @Override
    void liF(Stream stream) {
        this.lif(stream, this.getPassword());
        this.lif();
    }

    public PdfConverter() {
    }

    public PdfConverter(IDocument document) {
        super(document);
        this.l1 = this.getDocument().getPages().size();
    }

    @Override
    public void close() {
        super.close();
    }

    public void saveAsTIFFClassF(String outputFile) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.saveAsTIFFClassF(fileOutputStream, 0, 0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lif.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void saveAsTIFFClassF(OutputStream outputStream) {
        TiffSettings tiffSettings = new TiffSettings();
        tiffSettings.setDepth(3);
        tiffSettings.setCompression(1);
        this.saveAsTIFF(outputStream, 0, 0, tiffSettings);
    }

    public void saveAsTIFF(String outputFile, TiffSettings settings) {
        I4I i4I = null;
        try {
            i4I = I11.lIf(outputFile);
            this.lif((Stream)i4I, 0, 0, settings);
        }
        catch (I131 i131) {
            lif.log(Level.INFO, "Exception occur", i131);
            throw new RuntimeException(i131.getMessage());
        }
        finally {
            if (i4I != null) {
                try {
                    i4I.close();
                }
                catch (I131 i131) {
                    lif.log(Level.INFO, "Exception occur", i131);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, TiffSettings settings, IIndexBitmapConverter converter) {
        I4I i4I = null;
        try {
            i4I = I11.lIf(outputFile);
            this.lif(i4I, 0, 0, settings, converter);
        }
        catch (I131 i131) {
            lif.log(Level.INFO, "Exception occur", i131);
            throw new RuntimeException(i131.getMessage());
        }
        finally {
            if (i4I != null) {
                try {
                    i4I.close();
                }
                catch (I131 i131) {
                    lif.log(Level.INFO, "Exception occur", i131);
                }
            }
        }
    }

    public void saveAsTIFF(OutputStream outputStream, TiffSettings settings) {
        this.saveAsTIFF(outputStream, 0, 0, settings);
    }

    public void saveAsTIFF(OutputStream outputStream, TiffSettings settings, IIndexBitmapConverter converter) {
        this.saveAsTIFF(outputStream, 0, 0, settings, converter);
    }

    public void getNextImage(String outputFile, ImageType format, int imageWidth, int imageHeight) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, format, imageWidth, imageHeight, 100);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lif.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void getNextImage(OutputStream outputStream, ImageType format, int imageWidth, int imageHeight) {
        this.getNextImage(outputStream, format, 0, 0, 100);
    }

    public void getNextImage(OutputStream outputStream, ImageType format, int quality) {
        this.l1();
        if (this.hasNextImage()) {
            this.getNextImage(outputStream, format, 0, 0, quality);
        }
    }

    public void getNextImage(OutputStream outputStream, PageSize pageSize, ImageType format, int quality) {
        this.l1();
        if (this.hasNextImage()) {
            ImageDevice imageDevice = this.lif(format, pageSize, this.getResolution(), quality);
            if (this.l0I) {
                if (!this.l0if && !this.getDocument().getPages().get_Item(this.lIF).getCropBox().equals(this.getDocument().getPages().get_Item(this.lIF).getMediaBox())) {
                    imageDevice.setCoordinateType(0);
                }
            } else {
                imageDevice.setCoordinateType(this.l01);
            }
            imageDevice.process(this.getDocument().getPages().get_Item(this.lIF), outputStream);
            ++this.lIF;
        }
    }

    public void getNextImage(String outputFile, ImageType format, int quality) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, format, quality);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lif.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNextImage(String outputFile, PageSize pageSize, ImageType format, int quality) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, pageSize, format, quality);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lif.log(Level.INFO, "Exception occur", fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lif(I31 i31, float f, float f2, int n, int n2, I34l i34l, float f3, int n3, boolean bl, int n4, int n5, boolean bl2, boolean bl3, boolean bl4) {
        this.l1();
        if (this.hasNextImage()) {
            block22: {
                ImageDevice imageDevice = !bl3 ? (bl4 ? new PngDevice() : this.lif(f, f2, n, n2, i34l.l01(), f3, this.getResolution(), n3, bl, n4, n5, bl2)) : new PngDevice();
                if (this.l0I) {
                    if (!this.l0if && !this.getDocument().getPages().get_Item(this.lIF).getCropBox().equals(this.getDocument().getPages().get_Item(this.lIF).getMediaBox())) {
                        imageDevice.setCoordinateType(0);
                    }
                } else {
                    imageDevice.setCoordinateType(this.l01);
                }
                if (bl3) {
                    I5l i5l = new I5l();
                    try {
                        imageDevice.processInternal(this.getDocument().getPages().get_Item(this.lIF), i5l);
                        I44 i44 = I44.lif(i5l);
                        try {
                            i31.lif(i44, new I64(I4.lIF((Object)Float.valueOf(f), 13), I4.lIF((Object)Float.valueOf(f2), 13)));
                            break block22;
                        }
                        finally {
                            if (i44 != null) {
                                i44.dispose();
                            }
                        }
                    }
                    finally {
                        if (i5l != null) {
                            i5l.dispose();
                        }
                    }
                }
                if (bl4) {
                    I5l i5l = new I5l();
                    try {
                        imageDevice.processInternal(this.getDocument().getPages().get_Item(this.lIF), i5l);
                        i5l.setPosition(0L);
                        Il il = InternalHelper.lif(i5l, this.getDocument());
                        try {
                            i31.lif((I44)il, new I77());
                            break block22;
                        }
                        finally {
                            if (il != null) {
                                il.dispose();
                            }
                        }
                    }
                    finally {
                        if (i5l != null) {
                            i5l.dispose();
                        }
                    }
                }
                imageDevice.process(this.getDocument().getPages().get_Item(this.lIF), i31);
            }
            ++this.lIF;
        }
    }

    @Override
    public void dispose() {
        this.close();
    }

    static {
        lif.setUseParentHandlers(false);
    }
}

