/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import com.aspose.pdf.Document;
import com.aspose.pdf.ExplicitDestination;
import com.aspose.pdf.ExplicitDestinationTypeConverter;
import com.aspose.pdf.ExtendedBoolean;
import com.aspose.pdf.FitHExplicitDestination;
import com.aspose.pdf.GoToAction;
import com.aspose.pdf.GoToRemoteAction;
import com.aspose.pdf.GoToURIAction;
import com.aspose.pdf.IAppointment;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.LaunchAction;
import com.aspose.pdf.NamedDestination;
import com.aspose.pdf.OutlineItemCollection;
import com.aspose.pdf.Page;
import com.aspose.pdf.facades.Bookmark;
import com.aspose.pdf.facades.Bookmarks;
import com.aspose.pdf.facades.PdfContentEditor;
import com.aspose.pdf.facades.SaveableFacade;
import com.aspose.pdf.internal.l165l.I2I;
import com.aspose.pdf.internal.l166l.I1114;
import com.aspose.pdf.internal.l166l.I1121;
import com.aspose.pdf.internal.l1934.I01;
import com.aspose.pdf.internal.l1934.I4;
import com.aspose.pdf.internal.ms.System.I11I;
import com.aspose.pdf.internal.ms.System.I127;
import com.aspose.pdf.internal.ms.System.I14l;
import com.aspose.pdf.internal.ms.System.I16l;
import com.aspose.pdf.internal.ms.System.I177;
import com.aspose.pdf.internal.ms.System.I20l;
import com.aspose.pdf.internal.ms.System.I254;
import com.aspose.pdf.internal.ms.System.I257;
import com.aspose.pdf.internal.ms.System.I44;
import com.aspose.pdf.internal.ms.System.I51;
import com.aspose.pdf.internal.ms.System.IO.I11;
import com.aspose.pdf.internal.ms.System.IO.I5l;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PdfBookmarkEditor
extends SaveableFacade {
    private static final Logger lif = Logger.getLogger(PdfBookmarkEditor.class.getName());
    private static final I01 ll;

    private static void lif(OutlineItemCollection outlineItemCollection, String string, String string2) {
        while (outlineItemCollection != null) {
            if (I254.lIF(I254.lI(outlineItemCollection.getTitle()), I254.lI(string))) {
                outlineItemCollection.setTitle(string2);
            }
            if (outlineItemCollection.getFirst() != null) {
                PdfBookmarkEditor.lif(outlineItemCollection.getFirst(), string, string2);
            }
            outlineItemCollection = outlineItemCollection.getNext();
        }
    }

    private static void lif(I1121 i1121, OutlineItemCollection outlineItemCollection, String string) {
        if (outlineItemCollection == null) {
            return;
        }
        i1121.l0iF("ul");
        while (outlineItemCollection != null) {
            Object object;
            i1121.l0iF("li");
            i1121.lif(0);
            i1121.l0iF("a");
            if (outlineItemCollection.getDestination() != null) {
                PdfBookmarkEditor.lif(i1121, outlineItemCollection.getDestination(), string);
            } else if (outlineItemCollection.getAction() instanceof GoToRemoteAction) {
                object = (GoToRemoteAction)((Object)I4.lif(outlineItemCollection.getAction(), GoToRemoteAction.class));
                String string2 = string;
                if (((GoToRemoteAction)object).getFile().getName() != null) {
                    string2 = ((GoToRemoteAction)object).getFile().getName();
                }
                PdfBookmarkEditor.lif(i1121, ((GoToRemoteAction)object).getDestination(), string2);
            } else if (outlineItemCollection.getAction() instanceof GoToAction) {
                object = (GoToAction)((Object)I4.lif(outlineItemCollection.getAction(), GoToAction.class));
                PdfBookmarkEditor.lif(i1121, ((GoToAction)object).getDestination(), string);
            } else if (outlineItemCollection.getAction() instanceof GoToURIAction) {
                i1121.lI("href", ((GoToURIAction)outlineItemCollection.getAction()).getURI());
            } else if (outlineItemCollection.getAction() instanceof LaunchAction) {
                i1121.lI("href", ((LaunchAction)outlineItemCollection.getAction()).getFile());
            }
            object = new StringBuilder();
            if (outlineItemCollection.getBold()) {
                ((StringBuilder)object).append("font-weight: bold;");
            }
            if (outlineItemCollection.getItalic()) {
                ((StringBuilder)object).append("font-style: italic;");
            }
            if (((StringBuilder)object).length() != 0) {
                i1121.lI("style", ((StringBuilder)object).toString());
            }
            i1121.lIF(I254.lI(outlineItemCollection.getTitle()));
            i1121.l0if();
            if (outlineItemCollection.getFirst() != null) {
                i1121.lif(1);
                PdfBookmarkEditor.lif(i1121, outlineItemCollection.getFirst(), string);
            }
            i1121.l0if();
            i1121.lif(1);
            outlineItemCollection = outlineItemCollection.getNext();
        }
        i1121.l0if();
    }

    private static void lif(I1121 i1121, IAppointment iAppointment, String string) {
        if (iAppointment instanceof ExplicitDestination) {
            i1121.lI("href", I254.lif(new Object[]{string, "#page=", ((ExplicitDestination)iAppointment).getPage().getNumber()}));
        } else if (iAppointment instanceof NamedDestination) {
            i1121.lI("href", I254.lif(new String[]{string, "#nameddest=", ((NamedDestination)iAppointment).getName()}));
        }
    }

    private static void lif(I1121 i1121, OutlineItemCollection outlineItemCollection) {
        while (outlineItemCollection != null) {
            boolean bl;
            Object object;
            i1121.l0iF("Title");
            if (outlineItemCollection.getItalic() || outlineItemCollection.getBold()) {
                object = new StringBuilder();
                if (outlineItemCollection.getItalic() && !outlineItemCollection.getBold()) {
                    ((StringBuilder)object).append("italic");
                } else if (!outlineItemCollection.getItalic() && outlineItemCollection.getBold()) {
                    ((StringBuilder)object).append("bold");
                } else {
                    ((StringBuilder)object).append("italic bold");
                }
                i1121.lI("Style", ((StringBuilder)object).toString());
            }
            if (outlineItemCollection.getColor() instanceof Color) {
                object = outlineItemCollection.getColor();
                String string = I254.lif(com.aspose.pdf.internal.l160l.I01.l1(), "{0} {1} {2}", Float.valueOf((float)(((Color)object).getRed() & 0xFF) / 255.0f), Float.valueOf((float)(((Color)object).getGreen() & 0xFF) / 255.0f), Float.valueOf((float)(((Color)object).getBlue() & 0xFF) / 255.0f));
                i1121.lI("Color", string);
            }
            if (outlineItemCollection.getDestination() != null) {
                PdfBookmarkEditor.lif(i1121, outlineItemCollection.getDestination());
                i1121.lI("Action", "GoTo");
            } else if (outlineItemCollection.getAction() instanceof GoToRemoteAction) {
                object = (GoToRemoteAction)((Object)I4.lif(outlineItemCollection.getAction(), GoToRemoteAction.class));
                i1121.lI("NewWindow", I127.lif(ExtendedBoolean.class, ((GoToRemoteAction)object).getNewWindow()));
                i1121.lI("File", ((GoToRemoteAction)object).getFile().getName());
                PdfBookmarkEditor.lif(i1121, ((GoToRemoteAction)object).getDestination());
                i1121.lI("Action", "GoToR");
            } else if (outlineItemCollection.getAction() instanceof GoToAction) {
                object = (GoToAction)((Object)I4.lif(outlineItemCollection.getAction(), GoToAction.class));
                PdfBookmarkEditor.lif(i1121, ((GoToAction)object).getDestination());
                i1121.lI("Action", "GoTo");
            } else if (outlineItemCollection.getAction() instanceof GoToURIAction) {
                i1121.lI("URI", ((GoToURIAction)((Object)I4.lif(outlineItemCollection.getAction(), GoToURIAction.class))).getURI());
                i1121.lI("Action", "URI");
            } else if (outlineItemCollection.getAction() instanceof LaunchAction) {
                i1121.lI("File", ((LaunchAction)((Object)I4.lif(outlineItemCollection.getAction(), LaunchAction.class))).getFile());
                i1121.lI("Action", "Launch");
            }
            boolean bl2 = bl = outlineItemCollection.getFirst() != null;
            if (bl) {
                i1121.lI("Open", I44.ll(outlineItemCollection.getOpen()));
            }
            PdfBookmarkEditor.lif(i1121, I254.lI(outlineItemCollection.getTitle()));
            if (bl) {
                PdfBookmarkEditor.lif(i1121, outlineItemCollection.getFirst());
            }
            i1121.l0if();
            outlineItemCollection = outlineItemCollection.getNext();
        }
    }

    private static void lif(I1121 i1121, String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ' || c > '\u007f') {
                i1121.llf(I254.lif(new Object[]{"&#", (int)c, Character.valueOf(';')}));
                continue;
            }
            i1121.lIF(I51.l1l(c));
        }
    }

    private static void lif(I1121 i1121, IAppointment iAppointment) {
        if (iAppointment instanceof ExplicitDestination) {
            i1121.lI("Page", iAppointment.toString());
        } else if (iAppointment instanceof NamedDestination) {
            i1121.lI("Named", iAppointment.toString());
        }
    }

    private static void lif(I1114 i1114, IDocument iDocument, OutlineItemCollection outlineItemCollection) {
        do {
            if (!"Title".equals(i1114.l1IF())) continue;
            if (i1114.l1If() == 1) {
                String[] stringArray;
                String string;
                OutlineItemCollection outlineItemCollection2 = new OutlineItemCollection(iDocument.getOutlines());
                String string2 = i1114.lI("Style");
                if (string2 != null) {
                    switch (ll.lif(string2)) {
                        case 0: {
                            outlineItemCollection2.setItalic(true);
                            break;
                        }
                        case 1: {
                            outlineItemCollection2.setBold(true);
                            break;
                        }
                        case 2: 
                        case 3: {
                            outlineItemCollection2.setItalic(true);
                            outlineItemCollection2.setBold(true);
                        }
                    }
                }
                if ((string = i1114.lI("Color")) != null && (stringArray = I254.llf(string, ' ')).length == 3) {
                    int n = (int)((double)(I257.lif(stringArray[0], (I16l)com.aspose.pdf.internal.l160l.I01.l1()) * 255.0f) + 0.5);
                    int n2 = (int)((double)(I257.lif(stringArray[1], (I16l)com.aspose.pdf.internal.l160l.I01.l1()) * 255.0f) + 0.5);
                    int n3 = (int)((double)(I257.lif(stringArray[2], (I16l)com.aspose.pdf.internal.l160l.I01.l1()) * 255.0f) + 0.5);
                    outlineItemCollection2.setColor(new Color(n, n2, n3));
                }
                if (i1114.l1("Action")) {
                    stringArray = i1114.lI("Action");
                    switch (ll.lif((String)stringArray)) {
                        case 4: {
                            outlineItemCollection2.setDestination(PdfBookmarkEditor.lif(i1114, iDocument));
                            break;
                        }
                        case 5: {
                            break;
                        }
                        case 6: {
                            throw new I20l();
                        }
                        case 7: {
                            throw new I20l();
                        }
                    }
                }
                if (i1114.l1("Open")) {
                    outlineItemCollection2.setOpen(I44.lif(i1114.lI("Open")));
                }
                if (i1114.l1I()) {
                    if (outlineItemCollection == null) {
                        iDocument.getOutlines().add(outlineItemCollection2);
                        continue;
                    }
                    outlineItemCollection.add(outlineItemCollection2);
                    continue;
                }
                i1114.lIf();
                if (i1114.l1If() != 3) continue;
                outlineItemCollection2.setTitle(i1114.l2IF());
                if (outlineItemCollection == null) {
                    iDocument.getOutlines().add(outlineItemCollection2);
                } else {
                    outlineItemCollection.add(outlineItemCollection2);
                }
                i1114.lIf();
                if (!"Title".equals(i1114.l1IF()) || i1114.l1If() != 1) continue;
                PdfBookmarkEditor.lif(i1114, iDocument, outlineItemCollection2);
                continue;
            }
            if (i1114.l1If() != 15) continue;
            return;
        } while (i1114.lIf());
    }

    private static IAppointment lif(I1114 i1114, IDocument iDocument) {
        if (i1114.l1("Page")) {
            int n;
            String[] stringArray = I254.lif(i1114.lI("Page"), ' ');
            int n2 = stringArray.length > 1 ? ExplicitDestinationTypeConverter.toEnum(stringArray[1]) : 1;
            double[] dArray = null;
            try {
                n = I177.lif(stringArray[0], (I16l)com.aspose.pdf.internal.l160l.I01.l1());
                if (stringArray.length > 2) {
                    dArray = new double[stringArray.length - 2];
                    for (int i = 2; i < stringArray.length; ++i) {
                        dArray[i - 2] = I11I.lif(stringArray[i], (I16l)com.aspose.pdf.internal.l160l.I01.l1());
                    }
                }
            }
            catch (I14l i14l) {
                lif.log(Level.INFO, "Exception occur", i14l);
                n = 1;
            }
            return ExplicitDestination.createDestination(iDocument.getPages().get_Item(n < 1 ? 1 : n), n2, dArray);
        }
        if (i1114.l1("Named")) {
            throw new I20l();
        }
        return null;
    }

    private static void lif(Bookmarks bookmarks, Bookmarks bookmarks2) {
        for (Bookmark bookmark : bookmarks2) {
            bookmarks.add(bookmark);
            if (bookmark.getChildItem().size() == 0) continue;
            PdfBookmarkEditor.lif(bookmarks, bookmark.getChildItem());
        }
    }

    public void createBookmarks() {
        this.createBookmarks(Color.BLACK, false, false);
    }

    public void createBookmarkOfPage(String bookmarkName, int pageNumber) {
        this.l1();
        OutlineItemCollection outlineItemCollection = new OutlineItemCollection(this.getDocument().getOutlines());
        outlineItemCollection.setTitle(bookmarkName);
        Page page = this.getDocument().getPages().get_Item(1);
        if (pageNumber <= this.getDocument().getPages().size()) {
            page = this.getDocument().getPages().get_Item(pageNumber);
        }
        outlineItemCollection.setDestination(new FitHExplicitDestination(page, page.getRect().getHeight()));
        this.getDocument().getOutlines().add(outlineItemCollection);
    }

    public void createBookmarks(Bookmark bookmark) {
        this.l1();
        this.getDocument().getOutlines().add(bookmark.toOutlineItemCollection(this.getDocument()));
    }

    public void createBookmarks(Color color, boolean boldFlag, boolean italicFlag) {
        this.l1();
        PdfContentEditor pdfContentEditor = new PdfContentEditor();
        pdfContentEditor.bindPdf(this.getDocument());
        for (int i = 1; i <= this.getDocument().getPages().size(); ++i) {
            pdfContentEditor.createBookmarksAction(I254.lif("Page{0}", new Object[]{i}), color, boldFlag, italicFlag, null, "GoTo", I177.ll(i));
        }
    }

    public void createBookmarkOfPage(String[] bookmarkName, int[] pageNumber) {
        this.l1();
        if (bookmarkName.length != pageNumber.length) {
            throw new com.aspose.pdf.internal.ms.System.I01("Each bookmark must have name, but bookmarkName.Length != pageNumber.Length");
        }
        for (int i = 0; i < bookmarkName.length; ++i) {
            this.createBookmarkOfPage(bookmarkName[i], pageNumber[i]);
        }
    }

    public void deleteBookmarks() {
        this.l1();
        this.getDocument().getOutlines().delete();
    }

    public void deleteBookmarks(String title) {
        this.l1();
        this.getDocument().getOutlines().delete(title);
    }

    public void modifyBookmarks(String sTitle, String dTitle) {
        this.l1();
        if (this.getDocument().getOutlines().size() > 0) {
            PdfBookmarkEditor.lif(this.getDocument().getOutlines().getFirst(), sTitle, dTitle);
        }
    }

    public Bookmarks extractBookmarks() {
        return this.extractBookmarks(false);
    }

    public Bookmarks extractBookmarks(boolean upperLevel) {
        Bookmarks bookmarks = new Bookmarks();
        for (OutlineItemCollection outlineItemCollection : this.getDocument().getOutlines()) {
            Bookmark bookmark = Bookmark.lif(outlineItemCollection);
            bookmarks.add(bookmark);
            if (upperLevel || bookmark.getChildItem().size() == 0) continue;
            PdfBookmarkEditor.lif(bookmarks, bookmark.getChildItem());
        }
        return bookmarks;
    }

    public Bookmarks extractBookmarks(String title) {
        Bookmarks bookmarks = new Bookmarks();
        for (Bookmark bookmark : this.extractBookmarks()) {
            if (!I254.lIF(I254.lI(bookmark.getTitle()), I254.lI(title))) continue;
            bookmarks.add(bookmark);
        }
        return bookmarks;
    }

    public Bookmarks extractBookmarks(Bookmark bookmark) {
        Bookmarks bookmarks = this.extractBookmarks();
        for (Bookmark bookmark2 : bookmarks) {
            if (!I254.lIF(I254.lI(bookmark2.getTitle()), I254.lI(bookmark.getTitle()))) continue;
            return bookmark2.getChildItem();
        }
        return new Bookmarks();
    }

    @Deprecated
    public void extractBookmarksToHTML(String pdfFile, String cssFile) {
        String string = com.aspose.pdf.internal.ms.System.IO.I51.ll(com.aspose.pdf.internal.ms.System.IO.I51.llf(pdfFile), com.aspose.pdf.internal.ms.System.IO.I51.ll(pdfFile));
        PdfBookmarkEditor.exportBookmarksToHtml(pdfFile, I254.lif(new String[]{string, "-index.html"}));
    }

    public void exportBookmarksToXML(String xmlFile) {
        I1121 i1121 = new I1121(xmlFile, I2I.l1("iso_8859_1"));
        i1121.lif(1);
        i1121.llf("<?xml version=\"1.0\" encoding=\"iso_8859_1\"?>");
        i1121.l0iF("Bookmark");
        PdfBookmarkEditor.lif(i1121, this.getDocument().getOutlines().getFirst());
        i1121.l0if();
        i1121.llf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportBookmarksToXML(OutputStream output) {
        I5l i5l = new I5l();
        this.ll(i5l);
        try {
            if (((Stream)i5l).canSeek()) {
                ((Stream)i5l).seek(0L, 0);
            }
            byte[] byArray = new byte[i5l.toInputStream().available()];
            i5l.toInputStream().read(byArray);
            output.write(byArray);
        }
        catch (IOException iOException) {
            lif.log(Level.INFO, "Exception occur", iOException);
        }
        finally {
            if (i5l != null) {
                i5l.close();
            }
        }
    }

    void ll(Stream stream) {
        I1121 i1121 = new I1121(stream, I2I.l1("iso-8859-1"));
        i1121.lif(1);
        i1121.llf("<?xml version=\"1.0\" encoding=\"ISO8859-1\"?>");
        i1121.l0iF("Bookmark");
        PdfBookmarkEditor.lif(i1121, this.getDocument().getOutlines().getFirst());
        i1121.l0if();
        i1121.liF();
    }

    public void importBookmarksWithXML(String xmlFile) {
        I1114 i1114 = new I1114(I11.llf(xmlFile));
        i1114.liF(2);
        PdfBookmarkEditor.lif(i1114, this.getDocument(), null);
        i1114.l1();
    }

    void lI(Stream stream) {
        I1114 i1114 = new I1114(stream);
        i1114.liF(2);
        PdfBookmarkEditor.lif(i1114, this.getDocument(), null);
        i1114.l1();
    }

    public void importBookmarksWithXML(InputStream stream) {
        this.lI(Stream.fromJava(stream));
    }

    public PdfBookmarkEditor() {
    }

    public PdfBookmarkEditor(IDocument document) {
        super(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportBookmarksToHtml(String inPdfFile, String outHtmlFile) {
        Document document = new Document(inPdfFile);
        try {
            I2I i2I = I2I.l1lf();
            I1121 i1121 = new I1121(outHtmlFile, i2I);
            i1121.lif(1);
            i1121.lif("html", null, null, null);
            i1121.l0iF("html");
            i1121.l0iF("head");
            i1121.l0iF("title");
            i1121.lIF(com.aspose.pdf.internal.ms.System.IO.I51.ll(outHtmlFile));
            i1121.l0if();
            i1121.l0iF("meta");
            i1121.lI("charset", i2I.l0f());
            i1121.l0if();
            i1121.l0iF("style");
            i1121.lI("type", "text/css");
            i1121.lIF("ul { list-style-type: none; }");
            i1121.l0if();
            i1121.l0if();
            i1121.l0iF("body");
            if (document.getOutlines().size() != 0) {
                PdfBookmarkEditor.lif(i1121, document.getOutlines().getFirst(), com.aspose.pdf.internal.ms.System.IO.I51.lif(inPdfFile));
            } else {
                i1121.lIF("This document has no bookmarks.");
            }
            i1121.l0if();
            i1121.l0if();
            i1121.llf();
        }
        finally {
            if (document != null) {
                document.dispose();
            }
        }
    }

    @Override
    public void close() {
        super.close();
    }

    static {
        lif.setUseParentHandlers(false);
        ll = new I01("italic", "bold", "italic bold", "bold italic", "GoTo", "GoToR", "URI", "Launch");
    }
}

