/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.devices;

import com.aspose.pdf.IDocument;
import com.aspose.pdf.IIndexBitmapConverter;
import com.aspose.pdf.PageSize;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.RenderingOptions;
import com.aspose.pdf.devices.DocumentDevice;
import com.aspose.pdf.devices.I7;
import com.aspose.pdf.devices.Resolution;
import com.aspose.pdf.devices.TiffSettings;
import com.aspose.pdf.exceptions.IndexOutOfRangeException;
import com.aspose.pdf.internal.l1597.Il;
import com.aspose.pdf.internal.l241.I0I;
import com.aspose.pdf.internal.l247.I0l;
import com.aspose.pdf.internal.l25l.I01;
import com.aspose.pdf.internal.l25l.I1;
import com.aspose.pdf.internal.l77.I07;
import com.aspose.pdf.internal.ms.System.I17;
import com.aspose.pdf.internal.ms.System.I201;
import com.aspose.pdf.internal.ms.System.I331;
import com.aspose.pdf.internal.ms.System.IO.I5l;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TiffDevice
extends DocumentDevice {
    private static final Logger lif = Logger.getLogger(TiffDevice.class.getName());
    private Resolution ll;
    private TiffSettings lI = new TiffSettings();
    private IIndexBitmapConverter l1;
    private int lIF = 0;
    private int llf = 0;
    private int liF = 0;
    private boolean lIf = false;
    private RenderingOptions lf = new RenderingOptions();
    private Rectangle l0if = null;

    boolean ll() {
        return this.lIf;
    }

    void lif(boolean bl) {
        this.lIf = bl;
    }

    public RenderingOptions getRenderingOptions() {
        return this.lf;
    }

    public void setRenderingOptions(RenderingOptions value) {
        this.lf = value;
    }

    public int getFormPresentationMode() {
        return this.liF;
    }

    public void setFormPresentationMode(int value) {
        this.liF = value;
    }

    public TiffSettings getSettings() {
        return this.lI;
    }

    public Resolution getResolution() {
        return this.ll;
    }

    public TiffDevice(Resolution resolution) {
        this.ll = resolution;
        this.lI = new TiffSettings();
    }

    public TiffDevice(Resolution resolution, TiffSettings settings) {
        this.ll = resolution;
        this.lI = settings;
    }

    public TiffDevice(Resolution resolution, TiffSettings settings, IIndexBitmapConverter converter) {
        this.ll = resolution;
        this.lI = settings;
        this.l1 = converter;
    }

    public TiffDevice(TiffSettings settings) {
        this.ll = new Resolution(150);
        this.lI = settings;
    }

    public TiffDevice(TiffSettings settings, IIndexBitmapConverter converter) {
        this.ll = new Resolution(150);
        this.lI = settings;
        this.l1 = converter;
    }

    public TiffDevice() {
        this.ll = new Resolution(150);
        this.lI = new TiffSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processInternal(IDocument document, int fromPage, int toPage, Stream output) {
        int n;
        if (document == null) {
            throw new I201("Document is null");
        }
        super.lif(document);
        switch (this.lI.getCompression()) {
            case 0: {
                n = 2;
                break;
            }
            case 1: {
                n = 4;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 5;
                break;
            }
            case 4: {
                n = 6;
                break;
            }
            default: {
                throw new I17();
            }
        }
        I1 i1 = new I1(this.lI.getMargins().getLeft(), this.lI.getMargins().getRight(), this.lI.getMargins().getTop(), this.lI.getMargins().getBottom());
        int n2 = 0;
        switch (this.lI.getDepth()) {
            case 0: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 196865;
                break;
            }
            case 2: {
                n2 = 197634;
                break;
            }
            case 1: {
                n2 = 198659;
            }
        }
        int n3 = this.lI.getShape();
        I01 i01 = new I01(n, n2, i1, this.lI.getIndexedConversionType(), this.lI.getSkipBlankPages(), n3);
        i01.lif(this.lI.getBrightness());
        I0l i0l = null;
        com.aspose.pdf.internal.l25l.I0I i0I = new com.aspose.pdf.internal.l25l.I0I(output, i01, this.ll.getX(), this.ll.getY(), this.l1);
        try {
            try {
                for (int i = fromPage; i <= toPage; ++i) {
                    Il il = null;
                    I7 i7 = new I7(document.getPages().get_Item(i), new Point(0.0, 0.0), this.lIF, this.llf, new Resolution(this.ll.getX(), this.ll.getY()), this.getFormPresentationMode(), this.getRenderingOptions(), this.lI.getCoordinateType());
                    I07 i07 = null;
                    I07[] i07Array = new I07[]{i07};
                    if (this.l0if != null) {
                        if (this.l0if.getHeight() <= 0.0 || this.l0if.getHeight() > document.getPages().get_Item(i).getMediaBox().getHeight() || this.l0if.getWidth() <= 0.0 || this.l0if.getWidth() > document.getPages().get_Item(i).getMediaBox().getWidth()) {
                            throw new IndexOutOfRangeException("Rectangle has falls parametrs");
                        }
                        I0I i0I2 = (I0I)i7.lif();
                        i0I2.lif(this.l0if);
                        i0l = i0I2;
                    } else {
                        i0l = i7.lif(i07Array);
                    }
                    i07 = i07Array[0];
                    try {
                        il = (Il)i0l.ll().l0if();
                        if (this.lI.getSkipBlankPages() && i07.ll().lif(1.0E-5)) continue;
                        i0I.lif(il);
                        continue;
                    }
                    finally {
                        if (i0l != null) {
                            i0l.dispose();
                        }
                    }
                }
            }
            finally {
                i0I.lif();
            }
        }
        finally {
            if (i0I != null) {
                i0I.dispose();
            }
        }
    }

    @Override
    public void process(IDocument document, int fromPage, int toPage, OutputStream output) {
        I5l i5l = new I5l();
        this.processInternal(document, fromPage, toPage, i5l);
        try {
            if (i5l != null) {
                output.write(i5l.l1());
            }
            i5l.close();
        }
        catch (IOException iOException) {
            lif.log(Level.INFO, "Exception occur", iOException);
        }
    }

    public TiffDevice(int width, int height, Resolution resolution, TiffSettings settings) {
        this.lIF = width;
        this.llf = height;
        this.ll = resolution;
        this.lI = settings;
    }

    public TiffDevice(int width, int height, Resolution resolution, TiffSettings settings, IIndexBitmapConverter converter) {
        this.lIF = width;
        this.llf = height;
        this.ll = resolution;
        this.lI = settings;
        this.l1 = converter;
    }

    public TiffDevice(PageSize pageSize, Resolution resolution, TiffSettings settings) {
        float f = pageSize.getWidth();
        float f2 = pageSize.getHeight();
        this.lIF = (int)I331.l1((float)resolution.getX() * f / 72.0f);
        this.llf = (int)I331.l1((float)resolution.getY() * f2 / 72.0f);
        this.ll = resolution;
        this.lI = settings;
    }

    public TiffDevice(PageSize pageSize, Resolution resolution, TiffSettings settings, IIndexBitmapConverter converter) {
        float f = pageSize.getWidth();
        float f2 = pageSize.getHeight();
        this.lIF = (int)I331.l1((float)resolution.getX() * f / 72.0f);
        this.llf = (int)I331.l1((float)resolution.getY() * f2 / 72.0f);
        this.ll = resolution;
        this.lI = settings;
        this.l1 = converter;
    }

    public TiffDevice(int width, int height, Resolution resolution) {
        this(width, height, resolution, new TiffSettings());
    }

    public TiffDevice(PageSize pageSize, Resolution resolution) {
        this(pageSize, resolution, new TiffSettings());
    }

    public TiffDevice(int width, int height, TiffSettings settings) {
        this(width, height, new Resolution(150), settings);
    }

    public TiffDevice(int width, int height, TiffSettings settings, IIndexBitmapConverter converter) {
        this(width, height, new Resolution(150), settings, converter);
    }

    public TiffDevice(PageSize pageSize, TiffSettings settings, IIndexBitmapConverter converter) {
        this(pageSize, new Resolution(150), settings, converter);
    }

    public TiffDevice(PageSize pageSize, TiffSettings settings) {
        this(pageSize, new Resolution(150), settings);
    }

    public TiffDevice(int width, int height) {
        this(width, height, new Resolution(150), new TiffSettings());
    }

    public TiffDevice(PageSize pageSize) {
        this(pageSize, new Resolution(150), new TiffSettings());
    }

    public int getWidth() {
        return this.lIF;
    }

    public int getHeight() {
        return this.llf;
    }

    public Rectangle getCropRectangle() {
        return this.l0if;
    }

    public void setCropRectangle(Rectangle cropRectangle) {
        this.l0if = cropRectangle;
    }

    static {
        lif.setUseParentHandlers(false);
    }
}

