/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.devices;

import com.aspose.pdf.Page;
import com.aspose.pdf.TextAbsorber;
import com.aspose.pdf.TextEncodingInternal;
import com.aspose.pdf.TextExtractionOptions;
import com.aspose.pdf.devices.PageDevice;
import com.aspose.pdf.internal.l165l.I2I;
import com.aspose.pdf.internal.ms.System.I201;
import com.aspose.pdf.internal.ms.System.IO.I5l;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TextDevice
extends PageDevice {
    private static final Logger lif = Logger.getLogger(TextDevice.class.getName());
    private TextExtractionOptions ll;
    private I2I lI;

    private void lif(TextExtractionOptions textExtractionOptions, I2I i2I) {
        this.ll = textExtractionOptions;
        this.lI = i2I;
    }

    public TextExtractionOptions getExtractionOptions() {
        return this.ll;
    }

    public void setExtractionOptions(TextExtractionOptions value) {
        this.ll = value;
    }

    public TextEncodingInternal getEncodingInternal() {
        if (I2I.l1l().equals(this.lI)) {
            return TextEncodingInternal.getASCII();
        }
        if (I2I.l1I().equals(this.lI)) {
            return TextEncodingInternal.getBigEndianUnicode();
        }
        if (I2I.l11().equals(this.lI)) {
            return TextEncodingInternal.getDefault();
        }
        if (I2I.l1f().equals(this.lI)) {
            return TextEncodingInternal.getUnicode();
        }
        if (I2I.l2if().equals(this.lI)) {
            return TextEncodingInternal.getUTF32();
        }
        if (I2I.l2l().equals(this.lI)) {
            return TextEncodingInternal.getUTF32BE();
        }
        if (I2I.l1IF().equals(this.lI)) {
            return TextEncodingInternal.getUTF7();
        }
        if (I2I.l1lf().equals(this.lI)) {
            return TextEncodingInternal.getUTF8();
        }
        if (I2I.l1iF().equals(this.lI)) {
            return TextEncodingInternal.getUTF8Unmarked();
        }
        return null;
    }

    public Charset getEncoding() {
        return I2I.lif(this.lI);
    }

    public void setEncodingInternal(TextEncodingInternal value) {
        this.lI = value.getInternalFormat();
    }

    public void setEncoding(Charset value) {
        this.setEncodingInternal(TextEncodingInternal.getEncoding(value.displayName()));
    }

    @Override
    public void processInternal(Page page, Stream output) {
        if (page == null) {
            throw new I201("Page is null");
        }
        TextAbsorber textAbsorber = new TextAbsorber(this.ll);
        textAbsorber.visit(page);
        byte[] byArray = this.lI.lI(textAbsorber.getText());
        output.write(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Page page, OutputStream output) {
        I5l i5l = new I5l();
        this.processInternal(page, i5l);
        try {
            if (((Stream)i5l).canSeek()) {
                ((Stream)i5l).seek(0L, 0);
            }
            byte[] byArray = new byte[i5l.toInputStream().available()];
            i5l.toInputStream().read(byArray);
            output.write(byArray);
        }
        catch (IOException iOException) {
            lif.log(Level.INFO, "Exception occur", iOException);
        }
        finally {
            if (i5l != null) {
                i5l.close();
            }
        }
    }

    public TextDevice(TextExtractionOptions extractionOptions) {
        this.lif(extractionOptions, I2I.l1f());
    }

    public TextDevice() {
        this.lif(new TextExtractionOptions(0), I2I.l1f());
    }

    public TextDevice(TextEncodingInternal encoding) {
        this.lif(new TextExtractionOptions(0), encoding.getInternalFormat());
    }

    public TextDevice(Charset encoding) {
        this(TextEncodingInternal.getEncoding(encoding.displayName()));
    }

    public TextDevice(TextExtractionOptions extractionOptions, TextEncodingInternal encoding) {
        this.lif(extractionOptions, encoding.getInternalFormat());
    }

    public TextDevice(TextExtractionOptions extractionOptions, Charset encoding) {
        this(extractionOptions, TextEncodingInternal.getEncoding(encoding.displayName()));
    }

    static {
        lif.setUseParentHandlers(false);
    }
}

