/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Annotation;
import com.aspose.pdf.AnnotationSelector;
import com.aspose.pdf.Color;
import com.aspose.pdf.Document;
import com.aspose.pdf.Font;
import com.aspose.pdf.FontRepository;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.Operator;
import com.aspose.pdf.Page;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.Redaction;
import com.aspose.pdf.XForm;
import com.aspose.pdf.internal.l144.I01;
import com.aspose.pdf.internal.l144.I11;
import com.aspose.pdf.internal.l144.I31;
import com.aspose.pdf.internal.l144.I37;
import com.aspose.pdf.internal.l144.I3I;
import com.aspose.pdf.internal.l144.I4;
import com.aspose.pdf.internal.l144.I44;
import com.aspose.pdf.internal.l144.I4I;
import com.aspose.pdf.internal.l144.I6l;
import com.aspose.pdf.internal.l1597.I07;
import com.aspose.pdf.internal.ms.System.Collections.Generic.I27;
import java.util.List;

public final class RedactionAnnotation
extends Annotation {
    RedactionAnnotation(I11 engineAnnot, IDocument document) {
        super(engineAnnot, document);
    }

    @Override
    public void accept(AnnotationSelector visitor) {
        visitor.visit(this);
    }

    public RedactionAnnotation(IDocument document) {
        super(document);
        this.getEngineDict().ll("Subtype", (com.aspose.pdf.internal.l144.I27)new I4I("Redact"));
    }

    public Point[] getQuadPoint() {
        if (this.getEngineDict().l1("QuadPoints")) {
            I4 i4 = this.getEngineDict().lI("QuadPoints").l6lf();
            int n = i4.l0if() / 2;
            Point[] pointArray = new Point[n];
            for (int i = 0; i < n; ++i) {
                pointArray[i] = new Point(i4.lif(2 * i).l7l().lIf(), i4.lif(2 * i + 1).l7l().lIf());
            }
            return pointArray;
        }
        return null;
    }

    public void setQuadPoint(Point[] value) {
        I3I i3I = new I3I(this.getEngineDict());
        for (Point point : value) {
            i3I.lif((com.aspose.pdf.internal.l144.I27)new I44(point.getX()));
            i3I.lif((com.aspose.pdf.internal.l144.I27)new I44(point.getY()));
        }
        this.getEngineDict().lif("QuadPoints", (com.aspose.pdf.internal.l144.I27)i3I);
        this.updateAppearances();
    }

    public RedactionAnnotation(Page page, Rectangle rect) {
        super(page, rect);
        this.getEngineDict().ll("Subtype", (com.aspose.pdf.internal.l144.I27)new I4I("Redact"));
        this.updateAppearances();
    }

    public Color getFillColor() {
        Color color = Color.getBlack();
        if (this.getEngineDict().l1("IC")) {
            com.aspose.pdf.internal.l144.I27 i27 = this.getEngineDict().ll("IC");
            if (i27.l6lf() == null) {
                return color;
            }
            if (i27.l6lf().l0if() < 3) {
                return color;
            }
            color = new Color(new double[]{i27.l6lf().lif(0).l7l().lIf(), i27.l6lf().lif(1).l7l().lIf(), i27.l6lf().lif(2).l7l().lIf()});
        }
        return color;
    }

    public void setFillColor(Color value) {
        this.getEngineDict().lif("IC", (com.aspose.pdf.internal.l144.I27)new I3I((I37)((Object)com.aspose.pdf.internal.l1934.I4.lif(this.getEngineDict(), I37.class)), new I44[]{new I44(com.aspose.pdf.internal.l1934.I4.l0if(value.ll().l0IF(), 6) / 255.0), new I44(com.aspose.pdf.internal.l1934.I4.l0if(value.ll().l0lf(), 6) / 255.0), new I44(com.aspose.pdf.internal.l1934.I4.l0if(value.ll().l0iF(), 6) / 255.0)}));
    }

    public Color getBorderColor() {
        Color color = Color.getBlack();
        if (this.getEngineDict().l1("OC")) {
            com.aspose.pdf.internal.l144.I27 i27 = this.getEngineDict().ll("OC");
            if (i27.l6lf() == null) {
                return color;
            }
            if (i27.l6lf().l0if() < 3) {
                return color;
            }
            color = new Color(new double[]{i27.l6lf().lif(0).l7l().lIf() / 255.0, i27.l6lf().lif(1).l7l().lIf() / 255.0, i27.l6lf().lif(2).l7l().lIf() / 255.0});
        }
        return color;
    }

    public void setBorderColor(Color value) {
        this.getEngineDict().lif("OC", (com.aspose.pdf.internal.l144.I27)new I3I((I37)((Object)com.aspose.pdf.internal.l1934.I4.lif(this.getEngineDict(), I37.class)), new I44[]{new I44(com.aspose.pdf.internal.l1934.I4.l0if(value.ll().l0IF(), 6)), new I44(com.aspose.pdf.internal.l1934.I4.l0if(value.ll().l0lf(), 6)), new I44(com.aspose.pdf.internal.l1934.I4.l0if(value.ll().l0iF(), 6))}));
    }

    public String getOverlayText() {
        com.aspose.pdf.internal.l144.I27 i27;
        if (this.getEngineDict().l1("OverlayText") && (i27 = this.getEngineDict().ll("OverlayText")).l6I() != null) {
            return i27.l6I().lIf();
        }
        return null;
    }

    public void setOverlayText(String value) {
        I6l i6l = new I6l((I37)((Object)com.aspose.pdf.internal.l1934.I4.lif(this.getEngineDict(), I37.class)), value);
        this.getEngineDict().lif("OverlayText", (com.aspose.pdf.internal.l144.I27)i6l);
        this.updateAppearances();
    }

    public boolean isRepeat() {
        if (this.getEngineDict().l1("Repeat") && this.getEngineDict().ll("Repeat").l6If() != null) {
            return this.getEngineDict().ll("Repeat").l6If().ll();
        }
        return false;
    }

    public void setRepeat(boolean value) {
        this.getEngineDict().lif("Repeat", (com.aspose.pdf.internal.l144.I27)new I31(value));
        this.updateAppearances();
    }

    public int getTextAlignment() {
        int n = 1;
        if (this.getEngineDict().l1("Q") && this.getEngineDict().ll("Q").l7l() != null) {
            switch (this.getEngineDict().ll("Q").l7l().ll()) {
                case 0: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 2;
                    break;
                }
                case 2: {
                    n = 3;
                }
            }
        }
        return n;
    }

    public void setTextAlignment(int value) {
        int n = 0;
        switch (value) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
            }
        }
        this.getEngineDict().lif("Q", (com.aspose.pdf.internal.l144.I27)new I44(n));
    }

    @Override
    boolean liF() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void lif(Annotation annotation) {
        if (this._disableUpdateAppearance) {
            return;
        }
        XForm xForm = this.lif("N", annotation);
        XForm xForm2 = this.lif("R", annotation);
        xForm2.getResources().getFonts().add("Helv", "Helvetica");
        Document.startOperation();
        try {
            xForm.getContents().add(this.lI(new Annotation.I7("N"), annotation));
            xForm2.getContents().add(this.lI(new Annotation.I7("R"), annotation));
        }
        finally {
            Document.endOperation();
        }
    }

    I27<Operator> lI(Annotation.I7 i7, Annotation annotation) {
        I27<Operator> i27 = new I27<Operator>();
        i27.addItem(new Operator.GSave());
        if ("R".equals(i7.lif)) {
            i27.addItem(new Operator.SetRGBColor(this.getFillColor().toRgb()));
            i27.addItem(new Operator.SetRGBColorStroke(this.getFillColor().toRgb()));
            i27.addItem(new Operator.Re(0.0, 0.0, this.getRect().getWidth(), this.getRect().getHeight()));
            i27.addItem(new Operator.ClosePathFillStroke());
            if (this.getOverlayText() != null) {
                i27.addItem(new Operator.BT());
                i27.addItem(new Operator.SetRGBColor(this.getColor().toRgb()));
                i27.addItem(new Operator.SetRGBColorStroke(this.getColor().toRgb()));
                double d = 10.0;
                double d2 = this.getRect().getHeight();
                double d3 = 0.0;
                Font font = FontRepository.findFont("Helvetica");
                switch (this.getTextAlignment()) {
                    case 1: {
                        d3 = 0.0;
                        break;
                    }
                    case 2: {
                        d3 = (this.getWidth() - font.ll().lif(this.getOverlayText(), d)) / 2.0;
                        break;
                    }
                    case 3: {
                        d3 = this.getWidth() - font.ll().lif(this.getOverlayText(), d);
                    }
                }
                i27.addItem(new Operator.SelectFont("Helv", d));
                i27.addItem(new Operator.MoveTextPosition(d3, d2));
                do {
                    i27.addItem(new Operator.MoveTextPosition(0.0, -d));
                    i27.addItem(new Operator.ShowText(this.getOverlayText()));
                } while (this.isRepeat() && (d2 -= d) > 0.0);
                i27.addItem(new Operator.ET());
            }
        } else if ("N".equals(i7.lif)) {
            i27.addItem(new Operator.SetRGBColor(this.getBorderColor().toRgb()));
            i27.addItem(new Operator.SetRGBColorStroke(this.getBorderColor().toRgb()));
            i27.addItem(new Operator.SetLineWidth(5.0));
            i27.addItem(new Operator.Re(0.0, 0.0, this.getRect().getWidth(), this.getRect().getHeight()));
            i27.addItem(new Operator.ClosePathStroke());
        }
        i27.addItem(new Operator.GRestore());
        return i27;
    }

    @Override
    public void flatten() {
        I01 i01 = this.getEngineDict().ll("AP").l6IF();
        i01.lif("N", i01.ll("R"));
        super.flatten();
    }

    public void redact() {
        Redaction.redactText(this.lIf(), this.getRect());
        Redaction.lif(this.lIf(), this.getRect(), I07.l1iF().l16IF(), false);
        this.flatten();
    }

    public void redactExact() {
        Redaction.redactText(this.lIf(), this.getRect());
        Redaction.lif(this.lIf(), this.getRect(), this.getFillColor().ll().l16IF(), true);
        this.flatten();
    }

    @Override
    public int getAnnotationType() {
        return 23;
    }

    /* synthetic */ List ll(Annotation.I7 i7, Annotation annotation) {
        return this.lI(i7, annotation);
    }
}

