/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Annotation;
import com.aspose.pdf.Border;
import com.aspose.pdf.Color;
import com.aspose.pdf.I31l;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.LineEndingConverter;
import com.aspose.pdf.MarkupAnnotation;
import com.aspose.pdf.Matrix;
import com.aspose.pdf.Measure;
import com.aspose.pdf.Operator;
import com.aspose.pdf.Page;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.XForm;
import com.aspose.pdf.XfdfReader;
import com.aspose.pdf.internal.l144.I11;
import com.aspose.pdf.internal.l144.I3I;
import com.aspose.pdf.internal.l144.I44;
import com.aspose.pdf.internal.l144.I4I;
import com.aspose.pdf.internal.l166l.I1114;
import com.aspose.pdf.internal.l166l.I118I;
import com.aspose.pdf.internal.l166l.I804;
import com.aspose.pdf.internal.l3l.I4;
import com.aspose.pdf.internal.ms.System.Collections.Generic.I27;
import com.aspose.pdf.internal.ms.System.Collections.Generic.Il;
import com.aspose.pdf.internal.ms.System.I11I;
import com.aspose.pdf.internal.ms.System.I131;
import com.aspose.pdf.internal.ms.System.I16l;
import com.aspose.pdf.internal.ms.System.I254;
import com.aspose.pdf.internal.ms.System.I331;
import com.aspose.pdf.internal.ms.System.IO.I8I;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PolyAnnotation
extends MarkupAnnotation {
    private static final Logger llf = Logger.getLogger(PolyAnnotation.class.getName());
    protected Measure lIF = null;

    PolyAnnotation(I11 annotation, IDocument document) {
        super(annotation, document);
    }

    protected PolyAnnotation(IDocument document, Point[] vertices) {
        super(document);
        this.setVertices(vertices);
    }

    protected PolyAnnotation(Page page, Rectangle rect, Point[] vertices) {
        super(page, rect);
        this.setVertices(vertices);
    }

    public Measure getMeasure() {
        if (this.lIF == null && this.getEngineDict().l1("Measure") && this.getEngineDict().ll("Measure").l6IF() != null) {
            this.lIF = new Measure(this.getEngineDict().ll("Measure").l6IF());
        }
        return this.lIF;
    }

    public void setMeasure(Measure value) {
        if (value == null) {
            this.getEngineDict().lIF("Measure");
        } else {
            this.getEngineDict().lif("Measure", (com.aspose.pdf.internal.l144.I27)value.lif());
        }
        this.lIF = value;
    }

    @Override
    protected void ll(I118I i118I) {
        super.ll(i118I);
        if (this.getEngineDict().l1("AP") && !this.getEngineDict().l1("BS")) {
            this.getBorder().ll(i118I);
        }
        if (this.getEngineDict().l1("BS")) {
            this.getBorder().lif(i118I);
        }
        if (this.getEngineDict().l1("IC")) {
            i118I.lI("interior-color", this.getInteriorColor().toString());
        }
        if (this.getEngineDict().l1("LE")) {
            i118I.lI("head", LineEndingConverter.toString(this.getStartingStyle()));
            i118I.lI("tail", LineEndingConverter.toString(this.getEndingStyle()));
        }
        if (this.getEngineDict().l1("IT")) {
            i118I.lI("intent", I31l.ll(this.getIntent()));
        }
        if (this.getEngineDict().l1("Measure")) {
            i118I.l0iF("measure");
            this.getMeasure().lif(i118I);
            i118I.l0if();
        }
    }

    @Override
    protected void lI(I118I i118I) {
        StringBuilder stringBuilder;
        if (this.getEngineDict().l1("Vertices")) {
            i118I.l0iF("vertices");
            stringBuilder = new StringBuilder();
            for (Point point : this.getVertices()) {
                stringBuilder.append(I254.lif(this.ll, "{0},{1};", point.getX(), point.getY()));
            }
        } else {
            throw new IllegalStateException("Required entry is absent in annotation dictionary");
        }
        stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        i118I.lIF(stringBuilder.toString());
        i118I.l0if();
        super.lI(i118I);
    }

    @Override
    protected void ll(I804 i804) {
        super.ll(i804);
        this.setBorder(new Border(this));
        this.getBorder().lif(i804);
        if (i804.l1("interior-color")) {
            this.setInteriorColor(Color.parse(i804.lI("interior-color")));
        }
        if (i804.l1("head")) {
            this.setStartingStyle(LineEndingConverter.toEnum(i804.lI("head")));
        }
        if (i804.l1("tail")) {
            this.setEndingStyle(LineEndingConverter.toEnum(i804.lI("tail")));
        }
        if (i804.l1("intent")) {
            this.setIntent(I31l.lif(i804.lI("intent")));
        }
    }

    @Override
    protected void lif(Il<String, String> il) {
        Point[] pointArray;
        Object object;
        if (il.containsKey("vertices")) {
            object = I254.llf(il.get_Item("vertices"), ';');
            int n = ((String[])object).length;
            pointArray = new Point[n];
            for (int i = 0; i < n; ++i) {
                String[] stringArray = I254.llf(object[i], ',');
                double d = I11I.lif(stringArray[0], (I16l)this.ll);
                double d2 = I11I.lif(stringArray[1], (I16l)this.ll);
                pointArray[i] = new Point(d, d2);
            }
        } else {
            throw new IllegalStateException("Required attribute is absent in XFDF stream");
        }
        this.setVertices(pointArray);
        if (il.containsKey("measure")) {
            object = new I1114(new I8I(il.get_Item("measure")));
            this.setMeasure(new Measure(this));
            while (((I804)object).lIf() && (((I804)object).l1If() != 1 || !"measure".equals(((I804)object).l1IF()))) {
            }
            this.getMeasure().lif((I804)object);
            while (((I804)object).lIf() && (((I804)object).l1If() != 15 || !"measure".equals(((I804)object).l1IF()))) {
            }
        }
        super.lif(il);
    }

    @Override
    void lif(I804 i804) {
        this.ll(i804);
        this.lif(XfdfReader.lif(i804));
    }

    public Point[] getVertices() {
        try {
            com.aspose.pdf.internal.l144.I4 i4 = this.getEngineDict().lI("Vertices").l6lf();
            int n = i4.l0if() / 2;
            Point[] pointArray = new Point[n];
            for (int i = 0; i < n; ++i) {
                pointArray[i] = new Point(i4.lif(2 * i).l7l().lIf(), i4.lif(2 * i + 1).l7l().lIf());
            }
            return pointArray;
        }
        catch (I131 i131) {
            llf.log(Level.INFO, "Exception occur", i131);
            return null;
        }
    }

    public void setVertices(Point[] value) {
        if (value != null) {
            I3I i3I = new I3I(this.getEngineDict());
            for (Point point : value) {
                i3I.lif((com.aspose.pdf.internal.l144.I27)new I44(point.getX()));
                i3I.lif((com.aspose.pdf.internal.l144.I27)new I44(point.getY()));
            }
            this.getEngineDict().lif("Vertices", (com.aspose.pdf.internal.l144.I27)i3I);
        }
    }

    public Color getInteriorColor() {
        if (this.getEngineDict().l1("IC")) {
            com.aspose.pdf.internal.l144.I4 i4 = this.getEngineDict().lI("IC").l6lf();
            double[] dArray = new double[i4.l0if()];
            for (int i = 0; i < i4.l0if(); ++i) {
                dArray[i] = i4.lif(i).l7l().lIf();
            }
            return new Color(dArray);
        }
        return null;
    }

    public void setInteriorColor(Color value) {
        I3I i3I = new I3I(this.getEngineDict());
        for (double d : value.getData()) {
            i3I.lif((com.aspose.pdf.internal.l144.I27)new I44(d));
        }
        this.getEngineDict().lif("IC", (com.aspose.pdf.internal.l144.I27)i3I);
    }

    public int getStartingStyle() {
        try {
            com.aspose.pdf.internal.l144.I4 i4 = this.getEngineDict().lI("LE").l6lf();
            return LineEndingConverter.toEnum(i4.lif(0).l61().toString());
        }
        catch (I131 i131) {
            llf.log(Level.INFO, "Exception occur", i131);
            return 0;
        }
    }

    public void setStartingStyle(int value) {
        com.aspose.pdf.internal.l144.I4 i4 = null;
        if (this.getEngineDict().l1("LE") && (i4 = this.getEngineDict().lI("LE").l6lf()).l0if() != 2) {
            i4 = null;
        }
        if (i4 == null) {
            i4 = new I3I(this.getEngineDict());
            i4.lif((com.aspose.pdf.internal.l144.I27)new I4I("None"));
            i4.lif((com.aspose.pdf.internal.l144.I27)new I4I("None"));
            this.getEngineDict().lif("LE", (com.aspose.pdf.internal.l144.I27)i4);
        }
        i4.ll(0);
        i4.lif((com.aspose.pdf.internal.l144.I27)new I4I(LineEndingConverter.toString(value)), 0);
    }

    public int getEndingStyle() {
        try {
            com.aspose.pdf.internal.l144.I4 i4 = this.getEngineDict().lI("LE").l6lf();
            return LineEndingConverter.toEnum(i4.lif(1).l61().toString());
        }
        catch (I131 i131) {
            llf.log(Level.INFO, "Exception occur", i131);
            return 0;
        }
    }

    public void setEndingStyle(int value) {
        com.aspose.pdf.internal.l144.I4 i4 = null;
        if (this.getEngineDict().l1("LE") && (i4 = this.getEngineDict().lI("LE").l6lf()).l0if() != 2) {
            i4 = null;
        }
        if (i4 == null) {
            i4 = new I3I(this.getEngineDict());
            i4.lif((com.aspose.pdf.internal.l144.I27)new I4I("None"));
            i4.lif((com.aspose.pdf.internal.l144.I27)new I4I("None"));
            this.getEngineDict().lif("LE", (com.aspose.pdf.internal.l144.I27)i4);
        }
        i4.ll(1);
        i4.lif((com.aspose.pdf.internal.l144.I27)new I4I(LineEndingConverter.toString(value)), 1);
    }

    public int getIntent() {
        return I31l.lif(I4.ll(this.getEngineDict(), "IT"));
    }

    public void setIntent(int value) {
        if (value != 0) {
            this.getEngineDict().lif("IT", (com.aspose.pdf.internal.l144.I27)new I4I(I31l.lif(value)));
        }
    }

    @Override
    boolean liF() {
        return this.l1;
    }

    I27<Operator> lI(Annotation.I7 i7, Annotation annotation) {
        I27<Operator> i27 = new I27<Operator>();
        i27.addItem(new Operator.GSave());
        i27.addItem(new Operator.SetRGBColor(this.getColor().toRgb()));
        i27.addItem(new Operator.SetRGBColorStroke(this.getColor().toRgb()));
        int n = 0;
        for (Point point : this.getVertices()) {
            if (n == 0) {
                i27.addItem(new Operator.MoveTo(point.getX(), point.getY()));
            } else {
                i27.addItem(new Operator.LineTo(point.getX(), point.getY()));
            }
            ++n;
        }
        i27.addItem(new Operator.ClosePathStroke());
        i27.addItem(new Operator.GRestore());
        return i27;
    }

    @Override
    XForm lif(String string, Annotation annotation) {
        XForm xForm = super.lif(string, annotation);
        Rectangle rectangle = null;
        for (Point point : this.getVertices()) {
            if (rectangle == null) {
                rectangle = new Rectangle(point.getX(), point.getY(), point.getX(), point.getY());
                continue;
            }
            double d = I331.l1(rectangle.getLLX(), point.getX());
            double d2 = I331.l1(rectangle.getLLY(), point.getY());
            double d3 = I331.lI(rectangle.getURX(), point.getX());
            double d4 = I331.lI(rectangle.getURY(), point.getY());
            rectangle.setLLX(d);
            rectangle.setLLY(d2);
            rectangle.setURX(d3);
            rectangle.setURY(d4);
        }
        xForm.setBBox(rectangle);
        this.setRect(rectangle);
        xForm.setMatrix(new Matrix(1.0, 0.0, 0.0, 1.0, -rectangle.getLLX(), -rectangle.getLLY()));
        return xForm;
    }

    /* synthetic */ List ll(Annotation.I7 i7, Annotation annotation) {
        return this.lI(i7, annotation);
    }

    static {
        llf.setUseParentHandlers(false);
    }
}

