/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.internal.l144.I27;
import com.aspose.pdf.internal.l144.I37;
import com.aspose.pdf.internal.l144.I3I;
import com.aspose.pdf.internal.l144.I4;
import com.aspose.pdf.internal.l144.I44;
import com.aspose.pdf.internal.ms.System.I01;
import com.aspose.pdf.internal.ms.System.I254;
import com.aspose.pdf.internal.ms.System.I331;

public final class Matrix {
    private double[] lif;

    public double getA() {
        return this.lif[0];
    }

    public void setA(double value) {
        this.lif[0] = value;
    }

    public double getB() {
        return this.lif[1];
    }

    public void setB(double value) {
        this.lif[1] = value;
    }

    public double getC() {
        return this.lif[2];
    }

    public void setC(double value) {
        this.lif[2] = value;
    }

    public double getD() {
        return this.lif[3];
    }

    public void setD(double value) {
        this.lif[3] = value;
    }

    public double getE() {
        return this.lif[4];
    }

    public void setE(double value) {
        this.lif[4] = value;
    }

    public double getF() {
        return this.lif[5];
    }

    public void setF(double value) {
        this.lif[5] = value;
    }

    public Matrix() {
        this.lif = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
    }

    public Matrix(double[] matrixArray) {
        if (matrixArray.length != 6) {
            throw new I01();
        }
        this.lif = matrixArray;
    }

    public Matrix(float[] matrixArray) {
        if (matrixArray.length != 6) {
            throw new I01();
        }
        this.lif = new double[6];
        for (int i = 0; i < 6; ++i) {
            this.lif[i] = matrixArray[i];
        }
    }

    public Matrix(Matrix matrix) {
        this.lif = matrix.lif;
    }

    public float[] getElements() {
        return new float[]{(float)this.lif[0], (float)this.lif[1], (float)this.lif[2], (float)this.lif[3], (float)this.lif[4], (float)this.lif[5]};
    }

    public String toString() {
        return I254.lif("[ {0}, {1}, {2}, {3}, {4}, {5} ]", this.getA(), this.getB(), this.getC(), this.getD(), this.getE(), this.getF());
    }

    public boolean equals(Object obj) {
        Matrix matrix = (Matrix)((Object)com.aspose.pdf.internal.l1934.I4.lif(obj, Matrix.class));
        if (matrix != null) {
            return Double.compare(matrix.getA(), this.getA()) == 0 && Double.compare(matrix.getB(), this.getB()) == 0 && Double.compare(matrix.getC(), this.getC()) == 0 && Double.compare(matrix.getD(), this.getD()) == 0 && Double.compare(matrix.getE(), this.getE()) == 0 && Double.compare(matrix.getF(), this.getF()) == 0;
        }
        return super.equals(obj);
    }

    public I4 getMatrix(I37 trailer) {
        I3I i3I = new I3I(trailer);
        i3I.lif((I27)new I44(this.getA()));
        i3I.lif((I27)new I44(this.getB()));
        i3I.lif((I27)new I44(this.getC()));
        i3I.lif((I27)new I44(this.getD()));
        i3I.lif((I27)new I44(this.getE()));
        i3I.lif((I27)new I44(this.getF()));
        return i3I;
    }

    public static Matrix rotation(double alpha) {
        return new Matrix(new double[]{I331.lIf(alpha), I331.liF(alpha), -I331.liF(alpha), I331.lIf(alpha), 0.0, 0.0});
    }

    public static Matrix skew(double alpha, double beta) {
        return new Matrix(new double[]{1.0, I331.lf(alpha), I331.lf(alpha), 1.0, 0.0, 0.0});
    }

    public static Matrix scale(double x, double y) {
        return new Matrix(new double[]{x, 0.0, 0.0, y, 0.0, 0.0});
    }

    public static double getAngle(int rotation) {
        double d = 0.0;
        switch (rotation) {
            case 1: {
                d = 1.5707963267948966;
                break;
            }
            case 2: {
                d = Math.PI;
                break;
            }
            case 3: {
                d = 4.71238898038469;
            }
        }
        return d;
    }

    static double lif(Matrix matrix) {
        double d = 1.0E-5;
        double d2 = 1.5707963267948966 * (double)I331.llf(matrix.getB());
        if (I331.lif(matrix.getB()) < d) {
            d2 = 0.0;
        } else if (I331.lif(matrix.getA()) >= d) {
            d2 = I331.l0lf(matrix.getB() / matrix.getA());
        }
        if (matrix.getA() < -1.0 * d) {
            d2 += Math.PI;
        }
        if (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        return d2;
    }

    private double[] lif() {
        double[] dArray = new double[]{this.getA(), this.getB(), 0.0, this.getC(), this.getD(), 0.0, this.getE(), this.getF(), 1.0};
        return dArray;
    }

    public Matrix multiply(Matrix other) {
        double[] dArray = this.lif();
        double[] dArray2 = other.lif();
        double[] dArray3 = new double[9];
        int n = 3;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += dArray[i * n + k] * dArray2[k * n + j];
                }
                dArray3[i * n + j] = d;
            }
        }
        return new Matrix(new double[]{dArray3[0], dArray3[1], dArray3[3], dArray3[4], dArray3[6], dArray3[7]});
    }

    public Matrix add(Matrix other) {
        return new Matrix(this.getA() + other.getA(), this.getB() + other.getB(), this.getC() + other.getC(), this.getD() + other.getD(), this.getE() + other.getE(), this.getF() + other.getF());
    }

    public Point transform(Point p) {
        return new Point(p.getX() * this.getA() + p.getY() * this.getC() + this.getE(), p.getX() * this.getB() + p.getY() * this.getD() + this.getF());
    }

    public Rectangle transform(Rectangle rect) {
        Point[] pointArray = new Point[]{new Point(rect.getLLX(), rect.getLLY()), new Point(rect.getLLX(), rect.getURY()), new Point(rect.getURX(), rect.getLLY()), new Point(rect.getURX(), rect.getURY())};
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < pointArray.length; ++i) {
            Point point = this.transform(pointArray[i]);
            if (i == 0) {
                d = d2 = point.getX();
                d3 = d4 = point.getY();
                continue;
            }
            d = I331.l1(d, point.getX());
            d2 = I331.lI(d2, point.getX());
            d3 = I331.l1(d3, point.getY());
            d4 = I331.lI(d4, point.getY());
        }
        return new Rectangle(d, d3, d2, d4);
    }

    public Matrix(double a, double b, double c, double d, double e, double f) {
        this(new double[]{a, b, c, d, e, f});
    }

    public Matrix reverse() {
        double d = this.getA() * this.getD() - this.getC() * this.getB();
        return new Matrix(this.getD() / d, -this.getB() / d, -this.getC() / d, this.getA() / d, (this.getC() * this.getF() - this.getE() * this.getD()) / d, -(this.getA() * this.getF() - this.getE() * this.getB()) / d);
    }

    public int hashCode() {
        return super.hashCode();
    }

    I4 lif(I37 i37) {
        I27[] i27Array = new I27[this.lif.length];
        for (int i = 0; i < this.lif.length; ++i) {
            i27Array[i] = new I44(this.lif[i]);
        }
        I3I i3I = new I3I(i37, i27Array);
        return i3I;
    }

    Matrix(I4 data) {
        if (data.l0if() != 6) {
            throw new I01("Matrix array must have 6 elements");
        }
        this.lif = new double[6];
        for (int i = 1; i <= 6; ++i) {
            if (data.lif(i).l7l() == null) {
                throw new I01("Matrix array must contain only numbers");
            }
            this.lif[i - 1] = data.lif(i).l7l().lIf();
        }
    }

    public static boolean isInt16(double value) {
        return value < 32767.0 && value > -32768.0;
    }

    public boolean isInt16Values() {
        return Matrix.isInt16(this.getA()) && Matrix.isInt16(this.getB()) && Matrix.isInt16(this.getC()) && Matrix.isInt16(this.getD()) && Matrix.isInt16(this.getE()) && Matrix.isInt16(this.getF());
    }
}

