/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.drawing.PatternColorSpace;
import com.aspose.pdf.internal.ms.System.z110;
import com.aspose.pdf.internal.ms.System.z13;
import com.aspose.pdf.internal.ms.System.z133;
import com.aspose.pdf.internal.ms.System.z89;
import com.aspose.pdf.internal.p108.z15;
import com.aspose.pdf.internal.p17.z5;
import com.aspose.pdf.internal.p779.z6;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Color {
    private static final Logger m1 = Logger.getLogger(Color.class.getName());
    private double[] m2;
    private boolean m3 = false;
    private double m4 = 1.0;
    public static final Color Empty;
    private PatternColorSpace m5;

    public double getA() {
        return this.m4;
    }

    public double[] getData() {
        return this.m2;
    }

    public int getColorSpace() {
        if (this.getData() != null) {
            switch (this.getData().length) {
                case 1: {
                    return 2;
                }
                case 4: {
                    return 1;
                }
            }
            return 0;
        }
        return 0;
    }

    public Color() {
    }

    public Color(double[] vector) {
        for (double d : vector) {
            if (!(d > 1.0)) continue;
            throw new IllegalStateException("Invalid input data: color element is out of range [0..1]");
        }
        this.m2 = vector;
    }

    private Color(double[] vector, boolean isEmpty, double alpha) {
        for (double d : vector) {
            if (!(d > 1.0)) continue;
            throw new IllegalStateException("Invalid input data: color element is out of range [0..1]");
        }
        this.m2 = vector;
        this.m3 = isEmpty;
        this.m4 = alpha;
    }

    public Color deepClone() {
        double[] dArray = new double[this.m2.length];
        for (int i = 0; i < this.m2.length; ++i) {
            dArray[i] = this.m2[i];
        }
        return new Color(dArray, this.m1(), this.m4);
    }

    boolean m1() {
        return this.m3;
    }

    public static Color parse(String value) {
        try {
            String string = z133.m5(value, 1);
            double[] dArray = new double[string.length() / 2];
            for (int i = 0; i < string.length(); i += 2) {
                dArray[i / 2] = (double)z89.m1(z133.m2(string, i, 2), 515) / 255.0;
            }
            return new Color(dArray, false, 1.0);
        }
        catch (RuntimeException runtimeException) {
            m1.log(Level.INFO, "Exception occur", runtimeException);
            return Color.m1(z6.m1(value).m158());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#");
        for (double d : this.m2) {
            stringBuilder.append(z133.m1("{0:X2}", new Object[]{(int)(d * 255.0 + 0.5)}));
        }
        return stringBuilder.toString();
    }

    public java.awt.Color toRgb() {
        return this.m2().m1();
    }

    z6 m2() {
        Color color = this.m3();
        return z6.m1((int)(255.0 * color.getData()[0] + 0.5), (int)(255.0 * color.getData()[1] + 0.5), (int)(255.0 * color.getData()[2] + 0.5));
    }

    static Color m1(z6 z6100) {
        return new Color(new double[]{(double)(z6100.m14() & 0xFF) / 255.0, (double)(z6100.m15() & 0xFF) / 255.0, (double)(z6100.m16() & 0xFF) / 255.0}, z6100.m12() || com.aspose.pdf.internal.p953.z5.m5((Object)z6100.m13(), 6) == 0, com.aspose.pdf.internal.p953.z5.m10(z6100.m13(), 6) / 255.0);
    }

    public static Color fromRgb(java.awt.Color color) {
        return Color.m1(z6.m1(color));
    }

    Color m3() {
        if (z13.m1((Object)this.m2).m6() == 1) {
            return Color.fromRgb(this.m2[0], this.m2[0], this.m2[0]);
        }
        if (z13.m1((Object)this.m2).m6() == 4) {
            double d;
            double d2;
            double d3 = this.m2[0];
            double d4 = this.m2[1];
            double d5 = this.m2[2];
            double d6 = this.m2[3];
            double d7 = 1.0 - d3;
            double d8 = 1.0 - d4;
            double d9 = 1.0 - d5;
            double d10 = 1.0 - d6;
            double d11 = d2 = (d = d7 * d8 * d9 * d10);
            double d12 = d2;
            d = d7 * d8 * d9 * d6;
            d12 += 0.1373 * d;
            d11 += 0.1216 * d;
            d2 += 0.1255 * d;
            d = d7 * d8 * d5 * d10;
            d12 += d;
            d11 += 0.949 * d;
            d = d7 * d8 * d5 * d6;
            d12 += 0.1098 * d;
            d11 += 0.102 * d;
            d = d7 * d4 * d9 * d10;
            d12 += 0.9255 * d;
            d2 += 0.549 * d;
            d = d7 * d4 * d9 * d6;
            d12 += 0.1412 * d;
            d = d7 * d4 * d5 * d10;
            d12 += 0.9294 * d;
            d11 += 0.1098 * d;
            d2 += 0.1412 * d;
            d = d7 * d4 * d5 * d6;
            d12 += 0.1333 * d;
            d = d3 * d8 * d9 * d10;
            d11 += 0.6784 * d;
            d2 += 0.9373 * d;
            d = d3 * d8 * d9 * d6;
            d11 += 0.0588 * d;
            d2 += 0.1412 * d;
            d = d3 * d8 * d5 * d10;
            d11 += 0.651 * d;
            d2 += 0.3137 * d;
            d = d3 * d8 * d5 * d6;
            d11 += 0.0745 * d;
            d = d3 * d4 * d9 * d10;
            d12 += 0.1804 * d;
            d11 += 0.1922 * d;
            d2 += 0.5725 * d;
            d = d3 * d4 * d9 * d6;
            d2 += 0.0078 * d;
            d = d3 * d4 * d5 * d10;
            return Color.fromRgb(z15.m1(d12 += 0.2118 * d), z15.m1(d11 += 0.2119 * d), z15.m1(d2 += 0.2235 * d));
        }
        return new Color(this.m2);
    }

    Color m4() {
        if (z13.m1((Object)this.m2).m6() == 3) {
            if (z5.m1(this.m2[0], this.m2[1]) && z5.m1(this.m2[1], this.m2[2])) {
                return new Color(new double[]{this.m2[0]});
            }
            return new Color(new double[]{z15.m1(0.299 * this.m2[0] + 0.587 * this.m2[1] + 0.114 * this.m2[2])});
        }
        if (z13.m1((Object)this.m2).m6() == 4) {
            return this.m3().m4();
        }
        return new Color(this.m2);
    }

    Color m5() {
        if (z13.m1((Object)this.m2).m6() == 1) {
            return new Color(new double[]{0.0, 0.0, 0.0, 1.0 - this.m2[0]});
        }
        if (z13.m1((Object)this.m2).m6() == 3) {
            double[] dArray = new double[4];
            double d = z15.m1(1.0 - this.m2[0]);
            double d2 = z15.m1(1.0 - this.m2[1]);
            double d3 = z15.m1(1.0 - this.m2[2]);
            double d4 = d;
            if (d2 < d4) {
                d4 = d2;
            }
            if (d3 < d4) {
                d4 = d3;
            }
            dArray[0] = z15.m1(d - d4);
            dArray[1] = z15.m1(d2 - d4);
            dArray[2] = z15.m1(d3 - d4);
            dArray[3] = z15.m1(d4);
            return new Color(dArray);
        }
        return new Color(this.m2);
    }

    public static Color fromArgb(int r, int g, int b) {
        return Color.m1(z6.m1(r, g, b).m158());
    }

    public static Color fromArgb(int a, int r, int g, int b) {
        return Color.m1(z6.m1(a, r, g, b).m158());
    }

    public static Color fromRgb(double r, double g, double b) {
        return new Color(new double[]{r, g, b});
    }

    public static Color fromGray(double g) {
        return new Color(new double[]{g});
    }

    public static Color fromCmyk(double c, double m, double y, double k) {
        return new Color(new double[]{c, m, y, k});
    }

    public int hashCode() {
        return super.hashCode();
    }

    boolean m1(Color color) {
        boolean bl = true;
        for (int i = 0; i < color.getData().length; ++i) {
            bl &= z5.m1(color.getData()[i], this.getData()[i]);
        }
        return bl;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Color color = (Color)obj;
        if (this.m3 != color.m3 || color.getData().length != this.getData().length) {
            return false;
        }
        return this.m1(color);
    }

    public static boolean op_Equality(Color x, Color y) {
        if (z110.m2(x, y)) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public static boolean op_Inequality(Color x, Color y) {
        return !Color.op_Equality(x, y);
    }

    public PatternColorSpace getPatternColorSpace() {
        return this.m5;
    }

    public void setPatternColorSpace(PatternColorSpace value) {
        this.m5 = value;
    }

    public static Color getTransparent() {
        return Color.m1(z6.m17().m158());
    }

    public static Color getAliceBlue() {
        return Color.m1(z6.m18().m158());
    }

    public static Color getAntiqueWhite() {
        return Color.m1(z6.m19().m158());
    }

    public static Color getAqua() {
        return Color.m1(z6.m20().m158());
    }

    public static Color getAquamarine() {
        return Color.m1(z6.m21().m158());
    }

    public static Color getAzure() {
        return Color.m1(z6.m22().m158());
    }

    public static Color getBeige() {
        return Color.m1(z6.m23().m158());
    }

    public static Color getBisque() {
        return Color.m1(z6.m24().m158());
    }

    public static Color getBlack() {
        return Color.fromRgb(z6.m25().m158().m1());
    }

    public static Color getBlanchedAlmond() {
        return Color.m1(z6.m26().m158());
    }

    public static Color getBlue() {
        return Color.m1(z6.m27().m158());
    }

    public static Color getBlueViolet() {
        return Color.m1(z6.m28().m158());
    }

    public static Color getBrown() {
        return Color.m1(z6.m29().m158());
    }

    public static Color getBurlyWood() {
        return Color.m1(z6.m30().m158());
    }

    public static Color getCadetBlue() {
        return Color.m1(z6.m31().m158());
    }

    public static Color getChartreuse() {
        return Color.m1(z6.m32().m158());
    }

    public static Color getChocolate() {
        return Color.m1(z6.m33().m158());
    }

    public static Color getCoral() {
        return Color.m1(z6.m34().m158());
    }

    public static Color getCornflowerBlue() {
        return Color.m1(z6.m35().m158());
    }

    public static Color getCornsilk() {
        return Color.m1(z6.m36().m158());
    }

    public static Color getCrimson() {
        return Color.m1(z6.m37().m158());
    }

    public static Color getCyan() {
        return Color.m1(z6.m38().m158());
    }

    public static Color getDarkBlue() {
        return Color.m1(z6.m39().m158());
    }

    public static Color getDarkCyan() {
        return Color.m1(z6.m40().m158());
    }

    public static Color getDarkGoldenrod() {
        return Color.m1(z6.m41().m158());
    }

    public static Color getDarkGray() {
        return Color.m1(z6.m42().m158());
    }

    public static Color getDarkGreen() {
        return Color.m1(z6.m43().m158());
    }

    public static Color getDarkKhaki() {
        return Color.m1(z6.m44().m158());
    }

    public static Color getDarkMagenta() {
        return Color.m1(z6.m45().m158());
    }

    public static Color getDarkOliveGreen() {
        return Color.m1(z6.m46().m158());
    }

    public static Color getDarkOrange() {
        return Color.m1(z6.m47().m158());
    }

    public static Color getDarkOrchid() {
        return Color.m1(z6.m48().m158());
    }

    public static Color getDarkRed() {
        return Color.m1(z6.m49().m158());
    }

    public static Color getDarkSalmon() {
        return Color.m1(z6.m50().m158());
    }

    public static Color getDarkSeaGreen() {
        return Color.m1(z6.m51().m158());
    }

    public static Color getDarkSlateBlue() {
        return Color.m1(z6.m52().m158());
    }

    public static Color getDarkSlateGray() {
        return Color.m1(z6.m53().m158());
    }

    public static Color getDarkTurquoise() {
        return Color.m1(z6.m54().m158());
    }

    public static Color getDarkViolet() {
        return Color.m1(z6.m55().m158());
    }

    public static Color getDeepPink() {
        return Color.m1(z6.m56().m158());
    }

    public static Color getDeepSkyBlue() {
        return Color.m1(z6.m57().m158());
    }

    public static Color getDimGray() {
        return Color.m1(z6.m58().m158());
    }

    public static Color getDodgerBlue() {
        return Color.m1(z6.m59().m158());
    }

    public static Color getFirebrick() {
        return Color.m1(z6.m60().m158());
    }

    public static Color getFloralWhite() {
        return Color.m1(z6.m61().m158());
    }

    public static Color getForestGreen() {
        return Color.m1(z6.m62().m158());
    }

    public static Color getFuchsia() {
        return Color.m1(z6.m63().m158());
    }

    public static Color getGainsboro() {
        return Color.m1(z6.m64().m158());
    }

    public static Color getGhostWhite() {
        return Color.m1(z6.m65().m158());
    }

    public static Color getGold() {
        return Color.m1(z6.m66().m158());
    }

    public static Color getGoldenrod() {
        return Color.m1(z6.m67().m158());
    }

    public static Color getGray() {
        return Color.m1(z6.m68().m158());
    }

    public static Color getGreen() {
        return Color.m1(z6.m69().m158());
    }

    public static Color getGreenYellow() {
        return Color.m1(z6.m70().m158());
    }

    public static Color getHoneydew() {
        return Color.m1(z6.m71().m158());
    }

    public static Color getHotPink() {
        return Color.m1(z6.m72().m158());
    }

    public static Color getIndianRed() {
        return Color.m1(z6.m73().m158());
    }

    public static Color getIndigo() {
        return Color.m1(z6.m74().m158());
    }

    public static Color getIvory() {
        return Color.m1(z6.m75().m158());
    }

    public static Color getKhaki() {
        return Color.m1(z6.m76().m158());
    }

    public static Color getLavender() {
        return Color.m1(z6.m77().m158());
    }

    public static Color getLavenderBlush() {
        return Color.m1(z6.m78().m158());
    }

    public static Color getLawnGreen() {
        return Color.m1(z6.m79().m158());
    }

    public static Color getLemonChiffon() {
        return Color.m1(z6.m80().m158());
    }

    public static Color getLightBlue() {
        return Color.m1(z6.m81().m158());
    }

    public static Color getLightCoral() {
        return Color.m1(z6.m82().m158());
    }

    public static Color getLightCyan() {
        return Color.m1(z6.m83().m158());
    }

    public static Color getLightGoldenrodYellow() {
        return Color.m1(z6.m84().m158());
    }

    public static Color getLightGreen() {
        return Color.m1(z6.m85().m158());
    }

    public static Color getLightGray() {
        return Color.m1(z6.m86().m158());
    }

    public static Color getLightPink() {
        return Color.m1(z6.m87().m158());
    }

    public static Color getLightSalmon() {
        return Color.m1(z6.m88().m158());
    }

    public static Color getLightSeaGreen() {
        return Color.m1(z6.m89().m158());
    }

    public static Color getLightSkyBlue() {
        return Color.m1(z6.m90().m158());
    }

    public static Color getLightSlateGray() {
        return Color.m1(z6.m91().m158());
    }

    public static Color getLightSteelBlue() {
        return Color.m1(z6.m92().m158());
    }

    public static Color getLightYellow() {
        return Color.m1(z6.m93().m158());
    }

    public static Color getLime() {
        return Color.m1(z6.m94().m158());
    }

    public static Color getLimeGreen() {
        return Color.m1(z6.m95().m158());
    }

    public static Color getLinen() {
        return Color.m1(z6.m96().m158());
    }

    public static Color getMagenta() {
        return Color.m1(z6.m97().m158());
    }

    public static Color getMaroon() {
        return Color.m1(z6.m98().m158());
    }

    public static Color getMediumAquamarine() {
        return Color.m1(z6.m99().m158());
    }

    public static Color getMediumBlue() {
        return Color.m1(z6.m100().m158());
    }

    public static Color getMediumOrchid() {
        return Color.m1(z6.m101().m158());
    }

    public static Color getMediumPurple() {
        return Color.m1(z6.m102().m158());
    }

    public static Color getMediumSeaGreen() {
        return Color.m1(z6.m103().m158());
    }

    public static Color getMediumSlateBlue() {
        return Color.m1(z6.m104().m158());
    }

    public static Color getMediumSpringGreen() {
        return Color.m1(z6.m105().m158());
    }

    public static Color getMediumTurquoise() {
        return Color.m1(z6.m106().m158());
    }

    public static Color getMediumVioletRed() {
        return Color.m1(z6.m107().m158());
    }

    public static Color getMidnightBlue() {
        return Color.m1(z6.m108().m158());
    }

    public static Color getMintCream() {
        return Color.m1(z6.m109().m158());
    }

    public static Color getMistyRose() {
        return Color.m1(z6.m110().m158());
    }

    public static Color getMoccasin() {
        return Color.m1(z6.m111().m158());
    }

    public static Color getNavajoWhite() {
        return Color.m1(z6.m112().m158());
    }

    public static Color getNavy() {
        return Color.m1(z6.m113().m158());
    }

    public static Color getOldLace() {
        return Color.m1(z6.m114().m158());
    }

    public static Color getOlive() {
        return Color.m1(z6.m115().m158());
    }

    public static Color getOliveDrab() {
        return Color.m1(z6.m116().m158());
    }

    public static Color getOrange() {
        return Color.m1(z6.m117().m158());
    }

    public static Color getOrangeRed() {
        return Color.m1(z6.m118().m158());
    }

    public static Color getOrchid() {
        return Color.m1(z6.m119().m158());
    }

    public static Color getPaleGoldenrod() {
        return Color.m1(z6.m120().m158());
    }

    public static Color getPaleGreen() {
        return Color.m1(z6.m121().m158());
    }

    public static Color getPaleTurquoise() {
        return Color.m1(z6.m122().m158());
    }

    public static Color getPaleVioletRed() {
        return Color.m1(z6.m123().m158());
    }

    public static Color getPapayaWhip() {
        return Color.m1(z6.m124().m158());
    }

    public static Color getPeachPuff() {
        return Color.m1(z6.m125().m158());
    }

    public static Color getPeru() {
        return Color.m1(z6.m126().m158());
    }

    public static Color getPink() {
        return Color.m1(z6.m127().m158());
    }

    public static Color getPlum() {
        return Color.m1(z6.m128().m158());
    }

    public static Color getPowderBlue() {
        return Color.m1(z6.m129().m158());
    }

    public static Color getPurple() {
        return Color.m1(z6.m130().m158());
    }

    public static Color getRed() {
        return Color.m1(z6.m131().m158());
    }

    public static Color getRosyBrown() {
        return Color.m1(z6.m132().m158());
    }

    public static Color getRoyalBlue() {
        return Color.m1(z6.m133().m158());
    }

    public static Color getSaddleBrown() {
        return Color.m1(z6.m134().m158());
    }

    public static Color getSalmon() {
        return Color.m1(z6.m135().m158());
    }

    public static Color getSandyBrown() {
        return Color.m1(z6.m136().m158());
    }

    public static Color getSeaGreen() {
        return Color.m1(z6.m137().m158());
    }

    public static Color getSeaShell() {
        return Color.m1(z6.m138().m158());
    }

    public static Color getSienna() {
        return Color.m1(z6.m139().m158());
    }

    public static Color getSilver() {
        return Color.m1(z6.m140().m158());
    }

    public static Color getSkyBlue() {
        return Color.m1(z6.m141().m158());
    }

    public static Color getSlateBlue() {
        return Color.m1(z6.m142().m158());
    }

    public static Color getSlateGray() {
        return Color.m1(z6.m143().m158());
    }

    public static Color getSnow() {
        return Color.m1(z6.m144().m158());
    }

    public static Color getSpringGreen() {
        return Color.m1(z6.m145().m158());
    }

    public static Color getSteelBlue() {
        return Color.m1(z6.m146().m158());
    }

    public static Color getTan() {
        return Color.m1(z6.m147().m158());
    }

    public static Color getTeal() {
        return Color.m1(z6.m148().m158());
    }

    public static Color getThistle() {
        return Color.m1(z6.m149().m158());
    }

    public static Color getTomato() {
        return Color.m1(z6.m150().m158());
    }

    public static Color getTurquoise() {
        return Color.m1(z6.m151().m158());
    }

    public static Color getViolet() {
        return Color.m1(z6.m152().m158());
    }

    public static Color getWheat() {
        return Color.m1(z6.m153().m158());
    }

    public static Color getWhite() {
        return Color.m1(z6.m154().m158());
    }

    public static Color getWhiteSmoke() {
        return Color.m1(z6.m155().m158());
    }

    public static Color getYellow() {
        return Color.m1(z6.m156().m158());
    }

    public static Color getYellowGreen() {
        return Color.m1(z6.m157().m158());
    }

    static {
        m1.setUseParentHandlers(false);
        Empty = new Color(new double[]{0.0, 0.0, 0.0}, true, 1.0);
    }
}

