/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Annotation;
import com.aspose.pdf.AnnotationSelector;
import com.aspose.pdf.Border;
import com.aspose.pdf.Color;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.LineEndingConverter;
import com.aspose.pdf.MarkupAnnotation;
import com.aspose.pdf.Matrix;
import com.aspose.pdf.Measure;
import com.aspose.pdf.Operator;
import com.aspose.pdf.Page;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.XForm;
import com.aspose.pdf.XfdfReader;
import com.aspose.pdf.internal.ms.System.z133;
import com.aspose.pdf.internal.ms.System.z172;
import com.aspose.pdf.internal.ms.System.z61;
import com.aspose.pdf.internal.ms.System.z72;
import com.aspose.pdf.internal.ms.System.z85;
import com.aspose.pdf.internal.p609.z17;
import com.aspose.pdf.internal.p621.z9;
import com.aspose.pdf.internal.p652.z400;
import com.aspose.pdf.internal.p652.z585;
import com.aspose.pdf.internal.p68.z14;
import com.aspose.pdf.internal.p68.z16;
import com.aspose.pdf.internal.p68.z22;
import com.aspose.pdf.internal.p68.z23;
import com.aspose.pdf.internal.p68.z27;
import com.aspose.pdf.internal.p68.z29;
import com.aspose.pdf.internal.p68.z5;
import com.aspose.pdf.z124;
import com.aspose.pdf.z35;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LineAnnotation
extends MarkupAnnotation {
    private static final Logger m5 = Logger.getLogger(LineAnnotation.class.getName());
    private Measure m6 = null;

    @Override
    void m1(z585 z5852) {
        z5852.m16("line");
        this.m2(z5852);
        if (!this.getEngineDict().m4("L")) {
            throw new IllegalStateException("Required entry is absent in annotation dictionary");
        }
        z5852.m3("start", z133.m1(this.m2, "{0},{1}", this.getStarting().getX(), this.getStarting().getY()));
        z5852.m3("end", z133.m1(this.m2, "{0},{1}", this.getEnding().getX(), this.getEnding().getY()));
        if (this.getEngineDict().m4("LE")) {
            z5852.m3("head", LineEndingConverter.toString(this.getStartingStyle()));
            z5852.m3("tail", LineEndingConverter.toString(this.getEndingStyle()));
        }
        if (this.getEngineDict().m4("IC")) {
            z5852.m3("interior-color", this.getInteriorColor().toString());
        }
        if (this.getEngineDict().m4("LL")) {
            z5852.m3("leaderLength", z61.m1(this.getLeaderLine(), (z85)this.m2));
        }
        if (this.getEngineDict().m4("LLE")) {
            z5852.m3("leaderExtend", z61.m1(this.getLeaderLineExtension(), (z85)this.m2));
        }
        if (this.getEngineDict().m4("Cap")) {
            z5852.m3("caption", this.getShowCaption() ? "yes" : "no");
        }
        if (this.getEngineDict().m4("IT")) {
            z5852.m3("intent", z124.m2(this.getIntent()));
        }
        if (this.getEngineDict().m4("LLO")) {
            z5852.m3("leader-offset", z61.m1(this.getLeaderLineOffset(), (z85)this.m2));
        }
        if (this.getEngineDict().m4("CP")) {
            z5852.m3("caption-style", z35.m1(this.getCaptionPosition()));
        }
        if (this.getEngineDict().m4("CO")) {
            z5852.m3("caption-offset-h", z61.m1(this.getCaptionOffset().getX(), (z85)this.m2));
            z5852.m3("caption-offset-v", z61.m1(this.getCaptionOffset().getY(), (z85)this.m2));
        }
        if (this.getEngineDict().m4("BS")) {
            this.getBorder().m1(z5852);
        }
        this.m3(z5852);
        z5852.m10();
    }

    @Override
    void m1(z400 z4002) {
        double d;
        double d2;
        String[] stringArray;
        this.m2(z4002);
        if (z4002.m4("start")) {
            stringArray = z133.m6(z4002.m1("start"), ',');
            d2 = z61.m1(stringArray[0], (z85)this.m2);
            d = z61.m1(stringArray[1], (z85)this.m2);
            this.setStarting(new Point(d2, d));
        }
        if (z4002.m4("end")) {
            stringArray = z133.m6(z4002.m1("end"), ',');
            d2 = z61.m1(stringArray[0], (z85)this.m2);
            d = z61.m1(stringArray[1], (z85)this.m2);
            this.setEnding(new Point(d2, d));
        }
        if (z4002.m4("head")) {
            this.setStartingStyle(LineEndingConverter.toEnum(z4002.m1("head")));
        }
        if (z4002.m4("tail")) {
            this.setEndingStyle(LineEndingConverter.toEnum(z4002.m1("tail")));
        }
        if (z4002.m4("interior-color")) {
            this.setInteriorColor(Color.parse(z4002.m1("interior-color")));
        }
        if (z4002.m4("leaderLength")) {
            this.setLeaderLine(z61.m1(z4002.m1("leaderLength"), (z85)this.m2));
        }
        if (z4002.m4("leaderExtend")) {
            this.setLeaderLineExtension(z61.m1(z4002.m1("leaderExtend"), (z85)this.m2));
        }
        if (z4002.m4("caption")) {
            this.setShowCaption("yes".equals(z4002.m1("caption")));
        }
        if (z4002.m4("intent")) {
            this.setIntent(z124.m1(z4002.m1("intent")));
        }
        if (z4002.m4("leader-offset")) {
            this.setLeaderLineOffset(z61.m1(z4002.m1("leader-offset"), (z85)this.m2));
        }
        if (z4002.m4("caption-style")) {
            this.setCaptionPosition(z35.m1(z4002.m1("caption-style")));
        }
        if (z4002.m4("caption-offset-h") && z4002.m4("caption-offset-v")) {
            double d3 = z61.m1(z4002.m1("caption-offset-h"), (z85)z9.m4());
            double d4 = z61.m1(z4002.m1("caption-offset-v"), (z85)z9.m4());
            this.setCaptionOffset(new Point(d3, d4));
        }
        this.setBorder(new Border(this));
        this.getBorder().m1(z4002);
        this.m1(XfdfReader.m1(z4002));
    }

    public Point getStarting() {
        try {
            z5 z5100 = this.getEngineDict().m3("L").m63();
            return new Point(z5100.m1(0).m68().m8(), z5100.m1(1).m68().m8());
        }
        catch (Exception exception) {
            m5.log(Level.INFO, "Exception occur", exception);
            return Point.getTrivial();
        }
    }

    public void setStarting(Point value) {
        z22 z2210 = new z22(this.getEngineObj());
        z2210.m1((z16)new z29(value.getX()));
        z2210.m1((z16)new z29(value.getY()));
        z2210.m1((z16)new z29(this.getEnding().getX()));
        z2210.m1((z16)new z29(this.getEnding().getY()));
        this.getEngineDict().m1("L", (z16)z2210);
    }

    public int getStartingStyle() {
        try {
            z5 z5100 = this.getEngineDict().m3("LE").m63();
            return LineEndingConverter.toEnum(z5100.m1(0).m61().toString());
        }
        catch (z72 z7210) {
            m5.log(Level.INFO, "Exception occur", z7210);
            return 0;
        }
    }

    public void setStartingStyle(int value) {
        z5 z5100 = null;
        if (this.getEngineDict().m4("LE") && (z5100 = this.getEngineDict().m3("LE").m63()).m9() != 2) {
            z5100 = null;
        }
        if (z5100 == null) {
            z5100 = new z22(this.getEngineDict());
            z5100.m1((z16)new z27("None"));
            z5100.m1((z16)new z27("None"));
            this.getEngineDict().m1("LE", (z16)z5100);
        }
        z5100.m2(0);
        z5100.m1((z16)new z27(LineEndingConverter.toString(value)), 0);
        this.updateAppearances();
    }

    public Point getEnding() {
        try {
            z5 z5100 = this.getEngineDict().m3("L").m63();
            return new Point(z5100.m1(2).m68().m8(), z5100.m1(3).m68().m8());
        }
        catch (Exception exception) {
            m5.log(Level.INFO, "Exception occur", exception);
            return Point.getTrivial();
        }
    }

    public void setEnding(Point value) {
        z22 z2210 = new z22(this.getEngineObj());
        z2210.m1((z16)new z29(this.getStarting().getX()));
        z2210.m1((z16)new z29(this.getStarting().getY()));
        z2210.m1((z16)new z29(value.getX()));
        z2210.m1((z16)new z29(value.getY()));
        this.getEngineDict().m1("L", (z16)z2210);
    }

    public int getEndingStyle() {
        try {
            z5 z5100 = this.getEngineDict().m3("LE").m63();
            return LineEndingConverter.toEnum(z5100.m1(1).m61().toString());
        }
        catch (z72 z7210) {
            m5.log(Level.INFO, "Exception occur", z7210);
            return 0;
        }
    }

    public void setEndingStyle(int value) {
        z5 z5100 = null;
        if (this.getEngineDict().m4("LE") && (z5100 = this.getEngineDict().m3("LE").m63()).m9() != 2) {
            z5100 = null;
        }
        if (z5100 == null) {
            z5100 = new z22(this.getEngineDict());
            z5100.m1((z16)new z27("None"));
            z5100.m1((z16)new z27("None"));
            this.getEngineDict().m1("LE", (z16)z5100);
        }
        z5100.m2(1);
        z5100.m1((z16)new z27(LineEndingConverter.toString(value)), 1);
        this.updateAppearances();
    }

    public Color getInteriorColor() {
        if (this.getEngineDict().m4("IC")) {
            z5 z5100 = this.getEngineDict().m3("IC").m63();
            double[] dArray = new double[z5100.m9()];
            for (int i = 0; i < z5100.m9(); ++i) {
                dArray[i] = z5100.m1(i).m68().m8();
            }
            return new Color(dArray);
        }
        return null;
    }

    public void setInteriorColor(Color value) {
        z22 z2210 = new z22(this.getEngineDict());
        for (double d : value.getData()) {
            z2210.m1((z16)new z29(d));
        }
        this.getEngineDict().m1("IC", (z16)z2210);
    }

    public double getLeaderLine() {
        try {
            return this.getEngineDict().m3("LL").m68().m8();
        }
        catch (z72 z7210) {
            m5.log(Level.INFO, "Exception occur", z7210);
            return 0.0;
        }
    }

    public void setLeaderLine(double value) {
        this.getEngineDict().m1("LL", (z16)new z29(value));
    }

    public double getLeaderLineExtension() {
        return com.aspose.pdf.internal.p17.z5.m1(this.getEngineDict(), "LLE", 0.0);
    }

    public void setLeaderLineExtension(double value) {
        this.getEngineDict().m1("LLE", (z16)new z29(value));
    }

    public boolean getShowCaption() {
        return com.aspose.pdf.internal.p17.z5.m1(this.getEngineDict(), "Cap", false);
    }

    public void setShowCaption(boolean value) {
        this.getEngineDict().m1("Cap", (z16)new z23(value));
    }

    public double getLeaderLineOffset() {
        return com.aspose.pdf.internal.p17.z5.m1(this.getEngineDict(), "LLO", 0.0);
    }

    public void setLeaderLineOffset(double value) {
        this.getEngineDict().m1("LLO", (z16)new z29(value));
    }

    public Point getCaptionOffset() {
        try {
            z5 z5100 = this.getEngineDict().m3("CO").m63();
            return new Point(z5100.m1(0).m68().m8(), z5100.m1(1).m68().m8());
        }
        catch (z72 z7210) {
            m5.log(Level.INFO, "Exception occur", z7210);
            return Point.getTrivial();
        }
    }

    public void setCaptionOffset(Point value) {
        z22 z2210 = new z22(this.getEngineDict());
        z2210.m1((z16)new z29(value.getX()));
        z2210.m1((z16)new z29(value.getY()));
        this.getEngineDict().m1("CO", (z16)z2210);
    }

    public int getCaptionPosition() {
        return z35.m1(com.aspose.pdf.internal.p17.z5.m2(this.getEngineDict(), "CP"));
    }

    public void setCaptionPosition(int value) {
        this.getEngineDict().m1("CP", (z16)new z27(z35.m1(value)));
    }

    public Measure getMeasure() {
        if (this.m6 == null && this.getEngineDict().m4("Measure") && this.getEngineDict().m2("Measure").m62() != null) {
            this.m6 = new Measure(this.getEngineDict().m2("Measure").m62());
        }
        return this.m6;
    }

    public void setMeasure(Measure value) {
        if (value == null) {
            this.getEngineDict().m5("Measure");
        } else {
            this.getEngineDict().m1("Measure", (z16)value.m1());
        }
        this.m6 = value;
    }

    @Override
    public void accept(AnnotationSelector visitor) {
        visitor.visit(this);
    }

    public LineAnnotation(IDocument document, Point start, Point end) {
        super(document);
        this.getEngineDict().m2("Subtype", (z16)new z27("Line"));
        this.setStarting(start);
        this.setEnding(end);
        this.setWidth(z172.m1(this.getStarting().getX() - this.getEnding().getX()));
        this.setHeight(z172.m1(this.getStarting().getY() - this.getEnding().getY()));
    }

    LineAnnotation(z14 engineAnnot, IDocument document) {
        super(engineAnnot, document);
    }

    public LineAnnotation(Page page, Rectangle rect, Point start, Point end) {
        super(page, rect);
        this.getEngineDict().m2("Subtype", (z16)new z27("Line"));
        this.setStarting(start);
        this.setEnding(end);
    }

    public int getIntent() {
        return z124.m1(com.aspose.pdf.internal.p17.z5.m2(this.getEngineDict(), "IT"));
    }

    public void setIntent(int value) {
        if (value != 0) {
            this.getEngineDict().m1("IT", (z16)new z27(z124.m1(value)));
        }
    }

    @Override
    boolean m5() {
        return this.m4();
    }

    @Override
    void m2(Page page, Rectangle rectangle) {
        double d = z172.m4(this.getStarting().getX(), this.getEnding().getX());
        double d2 = z172.m4(this.getStarting().getY(), this.getEnding().getY());
        d = rectangle.getLLX() - d;
        d2 = rectangle.getLLY() - d2;
        this.setStarting(new Point(this.getStarting().getX() + d, this.getStarting().getY() + d2));
        this.setEnding(new Point(this.getEnding().getX() + d, this.getEnding().getY() + d2));
    }

    private z17<Operator> m1(Point point, Point point2, double d, double d2, boolean bl) {
        z17<Operator> z1710 = new z17<Operator>();
        d = Math.PI * d / 180.0;
        d2 = Math.PI * d2 / 180.0;
        double d3 = point2.getX() - point.getX();
        double d4 = point2.getY() - point.getY();
        double d5 = z172.m19(d3 * d3 + d4 * d4);
        double d6 = this.m16() * 4.5;
        d3 = d6 * d3 / d5;
        d4 = d6 * d4 / d5;
        double d7 = d3 * z172.m8(d) + d4 * z172.m7(d);
        double d8 = -d3 * z172.m7(d) + d4 * z172.m8(d);
        double d9 = d3 * z172.m8(d2) + d4 * z172.m7(d2);
        double d10 = -d3 * z172.m7(d2) + d4 * z172.m8(d2);
        if (this.getBorder() != null && this.getBorder().getDash() != null) {
            z1710.addItem(new Operator.SetDash(new int[]{this.getBorder().getDash().getOn(), this.getBorder().getDash().getOff()}, 0));
        }
        z1710.addItem(new Operator.MoveTo(point.getX() + d9, point.getY() + d10));
        z1710.addItem(new Operator.LineTo(point.getX(), point.getY()));
        z1710.addItem(new Operator.LineTo(point.getX() + d7, point.getY() + d8));
        if (bl) {
            z1710.addItem(new Operator.LineTo(point.getX() + d9, point.getY() + d10));
        }
        z1710.addItem(new Operator.Stroke());
        return z1710;
    }

    private z17<Operator> m1(Point point, Point point2) {
        return this.m1(point, point2, -60.0, 120.0, false);
    }

    private z17<Operator> m2(Point point, Point point2) {
        return this.m1(point, point2, 90.0, -90.0, false);
    }

    private double m16() {
        int n = 5;
        if (this.getBorder() != null) {
            n = this.getBorder().getWidth() * 2;
        }
        return n;
    }

    private z17<Operator> m1(Point point, Point point2, boolean bl) {
        return this.m1(point, point2, 150.0, -150.0, bl);
    }

    private z17<Operator> m2(Point point, Point point2, boolean bl) {
        return this.m1(point, point2, 30.0, -30.0, bl);
    }

    private z17<Operator> m1(Point point) {
        z17<Operator> z1710 = new z17<Operator>();
        double d = this.m16() * 1.5;
        z1710.addItem(new Operator.MoveTo(point.getX() - d, point.getY() - d));
        z1710.addItem(new Operator.LineTo(point.getX() + d, point.getY() - d));
        z1710.addItem(new Operator.LineTo(point.getX() + d, point.getY() + d));
        z1710.addItem(new Operator.LineTo(point.getX() - d, point.getY() + d));
        z1710.addItem(new Operator.LineTo(point.getX() - d, point.getY() - d));
        z1710.addItem(new Operator.ClosePath());
        z1710.addItem(new Operator.Stroke());
        return z1710;
    }

    private z17<Operator> m2(Point point) {
        z17<Operator> z1710 = new z17<Operator>();
        double d = this.m16();
        z1710.addItem(new Operator.MoveTo(point.getX() - d, point.getY()));
        z1710.addItem(new Operator.LineTo(point.getX(), point.getY() + d));
        z1710.addItem(new Operator.LineTo(point.getX() + d, point.getY()));
        z1710.addItem(new Operator.LineTo(point.getX(), point.getY() - d));
        z1710.addItem(new Operator.LineTo(point.getX() - d, point.getY()));
        z1710.addItem(new Operator.ClosePath());
        z1710.addItem(new Operator.Stroke());
        return z1710;
    }

    private z17<Operator> m3(Point point) {
        double d;
        z17<Operator> z1710 = new z17<Operator>();
        double d2 = 1.3333333333333333 * (z172.m19(2.0) - 1.0);
        double d3 = point.getX();
        double d4 = point.getY();
        double d5 = d = this.m16() * 1.5;
        double d6 = d;
        double d7 = d3 + d5;
        double d8 = d4;
        double d9 = d7;
        double d10 = d8 + d6 * d2;
        double d11 = d3;
        double d12 = d4 + d6;
        double d13 = d11 + d5 * d2;
        double d14 = d12;
        z1710.addItem(new Operator.MoveTo(d7, d8));
        z1710.addItem(new Operator.CurveTo(d9, d10, d13, d14, d11, d12));
        d7 = d11;
        d8 = d12;
        d11 = d3 - d5;
        d12 = d4;
        d9 = d7 - d5 * d2;
        d10 = d8;
        d13 = d11;
        d14 = d12 + d6 * d2;
        z1710.addItem(new Operator.CurveTo(d9, d10, d13, d14, d11, d12));
        d7 = d11;
        d8 = d12;
        d11 = d3;
        d12 = d4 - d6;
        d9 = d7;
        d10 = d8 - d6 * d2;
        d13 = d11 - d5 * d2;
        d14 = d12;
        d7 = d11;
        d8 = d12;
        z1710.addItem(new Operator.CurveTo(d9, d10, d13, d14, d11, d12));
        d7 = d11;
        d8 = d12;
        d11 = d3 + d5;
        d12 = d4;
        d9 = d7 + d5 * d2;
        d10 = d8;
        d13 = d11;
        d14 = d12 - d6 * d2;
        z1710.addItem(new Operator.CurveTo(d9, d10, d13, d14, d11, d12));
        z1710.addItem(new Operator.ClosePath());
        z1710.addItem(new Operator.Stroke());
        return z1710;
    }

    @Override
    XForm m1(String string, Annotation annotation) {
        XForm xForm = super.m1(string, annotation);
        double d = this.m16() * 5.0;
        xForm.setBBox(new Rectangle(z172.m4(this.getStarting().getX(), this.getEnding().getX()) - d, z172.m4(this.getStarting().getY(), this.getEnding().getY()) - d, z172.m3(this.getStarting().getX(), this.getEnding().getX()) + d, z172.m3(this.getStarting().getY(), this.getEnding().getY()) + d));
        xForm.setMatrix(new Matrix(1.0, 0.0, 0.0, 1.0, -xForm.getBBox().getLLX(), -xForm.getBBox().getLLY()));
        annotation.setRect(xForm.getBBox());
        return xForm;
    }

    z17<Operator> m3(Annotation.z1 z1338, Annotation annotation) {
        z17<Operator> z1710 = new z17<Operator>();
        z1710.addItem(new Operator.GSave());
        z1710.addItem(new Operator.SetRGBColor(this.getColor().toRgb()));
        z1710.addItem(new Operator.SetRGBColorStroke(this.getColor().toRgb()));
        double d = this.getEnding().getX() - this.getStarting().getX();
        double d2 = this.getEnding().getY() - this.getStarting().getY();
        double d3 = z172.m19(d * d + d2 * d2);
        d /= d3;
        d2 /= d3;
        if (this.getBorder() != null) {
            d *= (double)this.getBorder().getWidth();
            d2 *= (double)this.getBorder().getWidth();
        }
        Point point = this.getStarting();
        if (this.getStartingStyle() != 0) {
            point = new Point(this.getStarting().getX() + d, this.getStarting().getY() + d2);
        }
        Point point2 = this.getEnding();
        if (this.getEndingStyle() != 0) {
            point2 = new Point(this.getEnding().getX() - d, this.getEnding().getY() - d2);
        }
        Point point3 = new Point(point.getX() + d, point.getY() + d2);
        Point point4 = new Point(point2.getX() - d, point2.getY() - d2);
        if (this.getBorder() != null) {
            z1710.addItem(new Operator.SetLineWidth(this.getBorder().getWidth()));
            if (this.getBorder().getDash() != null) {
                z1710.addItem(new Operator.SetDash(new int[]{this.getBorder().getDash().getOn(), this.getBorder().getDash().getOff()}, 0));
            }
            z1710.addItem(new Operator.SetLineWidth(this.getBorder().getWidth()));
        }
        z1710.addItem(new Operator.MoveTo(point.getX(), point.getY()));
        z1710.addItem(new Operator.LineTo(point2.getX(), point2.getY()));
        z1710.addItem(new Operator.Stroke());
        switch (this.getStartingStyle()) {
            case 4: {
                z1710.m1(this.m2(point3, point4, false));
                break;
            }
            case 5: {
                z1710.m1(this.m2(point3, point4, true));
                break;
            }
            case 2: {
                z1710.m1(this.m3(point3));
                break;
            }
            case 1: {
                z1710.m1(this.m1(point3));
                break;
            }
            case 9: {
                z1710.m1(this.m1(point3, point4));
                break;
            }
            case 3: {
                z1710.m1(this.m2(point3));
                break;
            }
            case 6: {
                z1710.m1(this.m2(point3, point4));
                break;
            }
            case 7: {
                z1710.m1(this.m1(point3, point4, false));
                break;
            }
            case 8: {
                z1710.m1(this.m1(point3, point4, true));
            }
        }
        switch (this.getEndingStyle()) {
            case 4: {
                z1710.m1(this.m2(point4, point3, false));
                break;
            }
            case 5: {
                z1710.m1(this.m2(point4, point3, true));
                break;
            }
            case 2: {
                z1710.m1(this.m3(point4));
                break;
            }
            case 1: {
                z1710.m1(this.m1(point4));
                break;
            }
            case 3: {
                z1710.m1(this.m2(point4));
                break;
            }
            case 9: {
                z1710.m1(this.m1(point4, point3));
                break;
            }
            case 6: {
                z1710.m1(this.m2(point4, point3));
                break;
            }
            case 7: {
                z1710.m1(this.m1(point4, point3, false));
                break;
            }
            case 8: {
                z1710.m1(this.m1(point4, point3, true));
            }
        }
        z1710.addItem(new Operator.GRestore());
        return z1710;
    }

    @Override
    public int getAnnotationType() {
        return 4;
    }

    @Override
    /* synthetic */ List m2(Annotation.z1 z1338, Annotation annotation) {
        return this.m3(z1338, annotation);
    }

    static {
        m5.setUseParentHandlers(false);
    }
}

