/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import aspose.pdf.Pdf;
import com.aspose.pdf.Annotation;
import com.aspose.pdf.Document;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.Matrix;
import com.aspose.pdf.Operator;
import com.aspose.pdf.Page;
import com.aspose.pdf.PageSize;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.XForm;
import com.aspose.pdf.facades.AlignmentType;
import com.aspose.pdf.facades.SaveableFacade;
import com.aspose.pdf.facades.VerticalAlignmentType;
import com.aspose.pdf.internal.ms.System.z106;
import com.aspose.pdf.internal.ms.System.z133;
import com.aspose.pdf.internal.ms.System.z172;
import com.aspose.pdf.internal.ms.System.z8;
import com.aspose.pdf.internal.p21.z15;
import com.aspose.pdf.internal.p21.z19;
import com.aspose.pdf.internal.p600.z2;
import com.aspose.pdf.internal.p606.z176;
import com.aspose.pdf.internal.p613.z32;
import com.aspose.pdf.internal.p613.z41;
import com.aspose.pdf.internal.p68.z14;
import com.aspose.pdf.internal.p68.z16;
import com.aspose.pdf.internal.p68.z25;
import com.aspose.pdf.internal.p68.z27;
import com.aspose.pdf.internal.p68.z29;
import com.aspose.pdf.internal.p781.z5;
import com.aspose.pdf.internal.p781.z9;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PdfPageEditor
extends SaveableFacade {
    private static final Logger m1 = Logger.getLogger(PdfPageEditor.class.getName());
    private static final int m2 = 1;
    private static final int m3 = 2;
    private static final int m4 = 4;
    private int m5 = 0;
    private int m6;
    private int m7;
    private int m8;
    private int[] m9 = null;
    private int m10 = 0;
    private z2<Integer, Integer> m12 = new z2();
    private float m13 = 1.0f;
    private PageSize m14;
    private int m15 = 1;
    private int m16 = 3;
    private Point m17 = null;
    public static final int SPLITVOUT = 1;
    public static final int SPLITHOUT = 2;
    public static final int SPLITVIN = 3;
    public static final int SPLITHIN = 4;
    public static final int BLINDV = 5;
    public static final int BLINDH = 6;
    public static final int INBOX = 7;
    public static final int OUTBOX = 8;
    public static final int LRWIPE = 9;
    public static final int RLWIPE = 10;
    public static final int BTWIPE = 11;
    public static final int TBWIPE = 12;
    public static final int DISSOLVE = 13;
    public static final int LRGLITTER = 14;
    public static final int TBGLITTER = 15;
    public static final int DGLITTER = 16;
    private static final String m18 = "Invalid rotate value. Page rotate must be  expressed in degrees and be multiple of 90.";
    private static final z9 m19;

    public PdfPageEditor() {
    }

    public PdfPageEditor(Document document) {
        super(document);
    }

    public int getTransitionDuration() {
        this.m4();
        return this.m8;
    }

    public void setTransitionDuration(int value) {
        this.m4();
        this.m5 |= 1;
        this.m8 = value;
    }

    public int getTransitionType() {
        this.m4();
        return this.m7;
    }

    public void setTransitionType(int value) {
        this.m4();
        this.m5 |= 2;
        this.m7 = value;
    }

    public int getDisplayDuration() {
        this.m4();
        return this.m6;
    }

    public void setDisplayDuration(int value) {
        this.m4();
        this.m5 |= 4;
        this.m6 = value;
    }

    public int[] getProcessPages() {
        this.m4();
        return this.m9;
    }

    public void setProcessPages(int[] value) {
        this.m9 = value;
    }

    public int getRotation() {
        this.m4();
        if (this.m10 < 0) {
            this.m4();
            this.m10 = Page.rotationToInt(this.getDocument().getPages().get_Item(0).getRotate());
        }
        return this.m10;
    }

    public void setRotation(int value) {
        this.m4();
        this.m3(value);
        this.m10 = value;
    }

    public Map<Integer, Integer> getPageRotations() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (Integer n : this.m1().m4()) {
            hashMap.put(n, this.m1().get_Item(n));
        }
        return hashMap;
    }

    z2<Integer, Integer> m1() {
        this.m4();
        if (this.m12 == null) {
            this.m12 = new z2();
        }
        return this.m12;
    }

    public void setPageRotations(Map<Integer, Integer> value) {
        z2<Integer, Integer> z2100 = new z2<Integer, Integer>();
        for (Integer n : value.keySet()) {
            z2100.addItem(n, value.get(n));
        }
        this.m1(z2100);
    }

    void m1(z2<Integer, Integer> z2100) {
        this.m4();
        this.m2(z2100);
        this.m12 = z2100;
    }

    public float getZoom() {
        this.m4();
        return this.m13;
    }

    public void setZoom(float value) {
        this.m13 = value;
    }

    public PageSize getPageSize() {
        this.m4();
        if (this.m14 == null) {
            this.m14 = new PageSize(-1.0f, -1.0f);
        }
        return this.m14;
    }

    public void setPageSize(PageSize value) {
        this.m4();
        this.m14 = value;
    }

    @Deprecated
    public AlignmentType getAlignment() {
        int n = this.getHorizontalAlignment();
        switch (n) {
            case 1: {
                return AlignmentType.Left;
            }
            case 2: {
                return AlignmentType.Center;
            }
            case 3: {
                return AlignmentType.Right;
            }
        }
        throw new z8("Unknown Alignment type");
    }

    @Deprecated
    public void setAlignment(AlignmentType value) {
        AlignmentType alignmentType = value;
        switch (m19.m1(alignmentType.toString())) {
            case 0: {
                this.setHorizontalAlignment(2);
                break;
            }
            case 1: {
                this.setHorizontalAlignment(1);
                break;
            }
            case 2: {
                this.setHorizontalAlignment(3);
                break;
            }
            default: {
                throw new z106("Center, Right, Left values are valid only");
            }
        }
    }

    public int getHorizontalAlignment() {
        this.m4();
        return this.m15;
    }

    public void setHorizontalAlignment(int value) {
        this.m4();
        this.m15 = value;
    }

    @Deprecated
    public VerticalAlignmentType getVerticalAlignment() {
        int n = this.getVerticalAlignmentType();
        switch (n) {
            case 1: {
                return VerticalAlignmentType.Top;
            }
            case 2: {
                return VerticalAlignmentType.Center;
            }
            case 3: {
                return VerticalAlignmentType.Bottom;
            }
        }
        throw new z8("Unknown Alignment type");
    }

    @Deprecated
    public void setVerticalAlignment(VerticalAlignmentType value) {
        VerticalAlignmentType verticalAlignmentType = value;
        switch (m19.m1(verticalAlignmentType.toString())) {
            case 3: {
                this.setVerticalAlignmentType(1);
                break;
            }
            case 4: {
                this.setVerticalAlignmentType(3);
                break;
            }
            case 0: {
                this.setVerticalAlignmentType(2);
                break;
            }
            default: {
                this.setVerticalAlignmentType(0);
            }
        }
    }

    public int getVerticalAlignmentType() {
        this.m4();
        return this.m16;
    }

    public void setVerticalAlignmentType(int value) {
        this.m4();
        this.m16 = value;
    }

    public void movePosition(float moveX, float moveY) {
        this.m4();
        this.m17 = new Point(moveX, moveY);
    }

    public int getPages() {
        this.m4();
        return this.getDocument().getPages().size();
    }

    public PageSize getPageSize(int page) {
        this.m4();
        z15 z1510 = this.getDocument().getPages().get_Item((int)page).EnginePage.m1();
        z19 z1910 = null;
        if (z1510.m4() != null) {
            z1910 = z1510.m4();
        } else if (z1510.m3() != null) {
            z1910 = z1510.m3();
        } else {
            throw new com.aspose.pdf.internal.ms.System.z9("Page doesn't have required entry MediaBox");
        }
        double d = z172.m1(z1910.m3() - z1910.m1());
        double d2 = z172.m1(z1910.m4() - z1910.m2());
        for (int i = Page.rotationToInt(this.getDocument().getPages().get_Item(page).getRotate()); i > 0; i -= 90) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return new PageSize((float)d, (float)d2);
    }

    public int getPageRotation(int page) {
        this.m4();
        return Page.rotationToInt(this.getDocument().getPages().get_Item(page).getRotate());
    }

    public java.awt.Rectangle getPageBoxSize(int page, String pageBoxName) {
        return this.m1(page, pageBoxName).m1();
    }

    z176 m1(int n, String string) {
        this.m4();
        switch (m19.m1(string)) {
            case 5: {
                return this.m1(this.getDocument().getPages().get_Item(n).getTrimBox());
            }
            case 6: {
                return this.m1(this.getDocument().getPages().get_Item(n).getArtBox());
            }
            case 7: {
                return this.m1(this.getDocument().getPages().get_Item(n).getBleedBox());
            }
            case 8: {
                return this.m1(this.getDocument().getPages().get_Item(n).getCropBox());
            }
            case 9: {
                return this.m1(this.getDocument().getPages().get_Item(n).getMediaBox());
            }
        }
        throw new com.aspose.pdf.internal.ms.System.z9(z133.m1("\"{0}\" is invalid box name", new Object[]{string}));
    }

    @Override
    public void save(String outputFile) {
        this.m2();
        super.save(outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(OutputStream outputStream) {
        z32 z3210 = new z32();
        this.m1(z3210);
        try {
            if (((z41)z3210).canSeek()) {
                ((z41)z3210).seek(0L, 0);
            }
            byte[] byArray = new byte[z3210.toInputStream().available()];
            z3210.toInputStream().read(byArray);
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            m1.log(Level.INFO, "Exception occur", iOException);
        }
        finally {
            if (z3210 != null) {
                z3210.close();
            }
        }
    }

    @Override
    void m1(z41 z4110) {
        this.m2();
        super.m1(z4110);
    }

    public void applyChanges() {
        this.m2();
        this.m9 = new int[0];
    }

    private void m2() {
        this.m4();
        if (this.m9 == null) {
            for (int i = 1; i <= this.getDocument().getPages().size(); ++i) {
                this.m2(i);
            }
        } else {
            for (int n : this.m9) {
                this.m2(n);
            }
        }
    }

    @Override
    public void bindPdf(Pdf pdf) {
        this.bindPdf(new Document(pdf));
    }

    private int m1(int n) {
        int n2 = this.m10;
        if (this.m1().containsKey(n)) {
            n2 = this.m1().get_Item(n);
        }
        return n2 % 360;
    }

    private boolean m1(Page page, String string) {
        return ((z14)((Object)z5.m1(page.EnginePage, z14.class))).m60().m2(string) != null;
    }

    private Rectangle m1(z19 z1910) {
        return new Rectangle(z1910.m1(), z1910.m2(), z1910.m3(), z1910.m4());
    }

    private Rectangle m1(Page page) {
        z19 z1910 = null;
        if (page.EnginePage.m1().m3() != null) {
            z1910 = page.EnginePage.m1().m3();
        }
        if (page.EnginePage.m1().m4() != null) {
            z1910 = page.EnginePage.m1().m4();
        }
        Rectangle rectangle = this.m1(z1910);
        Matrix matrix = Matrix.rotation(-Matrix.getAngle(page.getRotate()));
        Rectangle rectangle2 = new Rectangle(0.0, 0.0, rectangle.getWidth(), rectangle.getHeight());
        rectangle2 = matrix.transform(rectangle2);
        matrix.setE(matrix.getE() - rectangle2.getLLX());
        matrix.setF(matrix.getF() - rectangle2.getLLY());
        rectangle = matrix.transform(rectangle);
        return rectangle;
    }

    private void m2(int n) {
        Object object;
        Page page = this.getDocument().getPages().get_Item(n);
        XForm xForm = XForm.createNewForm(page, this.getDocument());
        xForm.getContents().insert(1, new Operator.GSave());
        xForm.getContents().add(new Operator.GRestore());
        page.getResources().getForms().add(xForm);
        xForm.setBBox(page.getMediaBox());
        page.clearContents();
        Matrix matrix = new Matrix(new double[]{this.m13, 0.0, 0.0, this.m13, 0.0, 0.0});
        int n2 = this.m1(n);
        Matrix matrix2 = Matrix.rotation(Math.PI * (double)(-n2) / 180.0);
        matrix = matrix2.multiply(matrix);
        Rectangle rectangle = this.m1(page);
        Rectangle rectangle2 = new Rectangle(rectangle.getLLX(), rectangle.getLLY(), rectangle.getURX(), rectangle.getURY());
        Rectangle rectangle3 = matrix2.transform(rectangle2);
        Rectangle rectangle4 = matrix.transform(rectangle2);
        matrix.setE(-rectangle4.getLLX());
        matrix.setF(-rectangle4.getLLY());
        PageSize pageSize = this.m14 != null ? new PageSize(this.m14.getWidth(), this.m14.getHeight()) : new PageSize((float)rectangle3.getWidth(), (float)rectangle3.getHeight());
        if (Float.compare(pageSize.getWidth(), -1.0f) == 0) {
            pageSize.setWidth((float)page.getRect().getWidth());
        }
        if (Float.compare(pageSize.getHeight(), -1.0f) == 0) {
            pageSize.setHeight((float)page.getRect().getHeight());
        }
        PageSize pageSize2 = new PageSize((float)rectangle4.getWidth(), (float)rectangle4.getHeight());
        Point point = new Point(0.0, 0.0);
        if (this.m15 == 3) {
            point.setX(pageSize.getWidth() - pageSize2.getWidth());
        } else if (this.m15 == 2) {
            point.setX((pageSize.getWidth() - pageSize2.getWidth()) / 2.0f);
        }
        if (this.m16 == 1) {
            point.setY(pageSize.getHeight() - pageSize2.getHeight());
        } else if (this.m16 == 2) {
            point.setY((pageSize.getHeight() - pageSize2.getHeight()) / 2.0f);
        }
        matrix.setE(matrix.getE() + point.getX());
        matrix.setF(matrix.getF() + point.getY());
        if (this.m17 != null) {
            matrix.setE(matrix.getE() + this.m17.getX());
            matrix.setF(matrix.getF() + this.m17.getY());
        }
        if (page.getRotate() == 3 || page.getRotate() == 1) {
            pageSize = new PageSize(pageSize.getHeight(), pageSize.getWidth());
        }
        page.setMediaBox(new Rectangle(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight()));
        if (this.m1(page, "CropBox")) {
            page.setCropBox(new Rectangle(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight()));
        }
        if (this.m1(page, "ArtBox")) {
            page.setArtBox(new Rectangle(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight()));
        }
        if (this.m1(page, "BleedBox")) {
            page.setBleedBox(new Rectangle(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight()));
        }
        if (this.m1(page, "TrimBox")) {
            page.setTrimBox(new Rectangle(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight()));
        }
        if ((this.m5 & 2) != 0) {
            object = new z1(this.getDocument(), this.getTransitionType());
            if ((this.m5 & 1) != 0) {
                ((z1)object).m1(this.getTransitionDuration());
            }
            page.setTransition(((z1)object).m2());
        }
        if ((this.m5 & 4) != 0) {
            page.setDuration(this.getDisplayDuration());
        }
        object = new ArrayList();
        ((ArrayList)object).add(new Operator.GSave());
        ((ArrayList)object).add(new Operator.ConcatenateMatrix(matrix));
        ((ArrayList)object).add(new Operator.Do(xForm.getName()));
        ((ArrayList)object).add(new Operator.GRestore());
        page.getContents().add((Iterable)object);
        for (Annotation annotation : page.getAnnotations()) {
            annotation.setRect(matrix.transform(annotation.getRect()));
            for (String string : annotation.getAppearance().getKeys()) {
                XForm xForm2 = annotation.getAppearance().get_Item(string);
                Matrix matrix3 = xForm2.getMatrix();
                if (matrix3 == null) {
                    matrix3 = new Matrix();
                }
                if (xForm2.getEngineObj().m60().m4("BBox")) {
                    // empty if block
                }
                xForm2.setMatrix(matrix.multiply(matrix3));
            }
        }
    }

    private void m3(int n) {
        if (n % 90 != 0) {
            throw new com.aspose.pdf.internal.ms.System.z9(m18);
        }
    }

    private void m2(z2<Integer, Integer> z2100) {
        for (Integer n : z2100.m4()) {
            int n2 = z2100.get_Item(n);
            int n3 = n;
            int n4 = n2;
            this.m3(n4);
            this.getDocument().getPages().get_Item(n3);
        }
    }

    private z176 m1(Rectangle rectangle) {
        return new z176((int)rectangle.getLLX(), (int)rectangle.getLLY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
    }

    static {
        m1.setUseParentHandlers(false);
        m19 = new z9("Center", "Left", "Right", "Top", "Bottom", "trim", "art", "bleed", "crop", "media");
    }

    private static class z1 {
        public int m1;
        public IDocument m2;
        public int m3 = 1;

        public z1(IDocument iDocument, int n) {
            this.m1 = n;
            this.m2 = iDocument;
        }

        public int m1() {
            return this.m3;
        }

        public void m1(int n) {
            this.m3 = n;
        }

        public com.aspose.pdf.internal.p68.z9 m2() {
            z25 z2510 = new z25(this.m2.getEngineDoc().m2());
            z2510.m2("Type", (z16)new z27("Trans"));
            z2510.m2("D", (z16)new z29(this.m3));
            String string = z133.m1;
            String string2 = null;
            String string3 = null;
            z29 z2910 = null;
            switch (this.m1) {
                case 1: {
                    string = "Split";
                    string2 = "V";
                    string3 = "O";
                    break;
                }
                case 2: {
                    string = "Split";
                    string2 = "H";
                    string3 = "O";
                    break;
                }
                case 3: {
                    string = "Split";
                    string2 = "V";
                    string3 = "I";
                    break;
                }
                case 4: {
                    string = "Split";
                    string2 = "H";
                    string3 = "I";
                    break;
                }
                case 5: {
                    string = "Blinds";
                    string2 = "V";
                    break;
                }
                case 6: {
                    string = "Blinds";
                    string2 = "H";
                    break;
                }
                case 7: {
                    string = "Box";
                    string3 = "I";
                    break;
                }
                case 8: {
                    string = "Box";
                    string3 = "O";
                    break;
                }
                case 9: {
                    string = "Wipe";
                    z2910 = new z29(0.0);
                    break;
                }
                case 10: {
                    string = "Wipe";
                    z2910 = new z29(180.0);
                    break;
                }
                case 11: {
                    string = "Wipe";
                    z2910 = new z29(90.0);
                    break;
                }
                case 12: {
                    string = "Wipe";
                    z2910 = new z29(270.0);
                    break;
                }
                case 13: {
                    string = "Dissolve";
                    break;
                }
                case 14: {
                    string = "Glitter";
                    z2910 = new z29(0.0);
                    break;
                }
                case 15: {
                    string = "Glitter";
                    z2910 = new z29(270.0);
                    break;
                }
                case 16: {
                    string = "Glitter";
                    z2910 = new z29(315.0);
                }
            }
            z2510.m2("S", (z16)new z27(string));
            if (string2 != null) {
                z2510.m2("Dm", (z16)new z27(string2));
            }
            if (string3 != null) {
                z2510.m2("M", (z16)new z27(string3));
            }
            if (z2910 != null) {
                z2510.m2("Di", (z16)z2910);
            }
            return z2510;
        }
    }
}

