/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import aspose.pdf.Pdf;
import com.aspose.pdf.Annotation;
import com.aspose.pdf.AnnotationSelector;
import com.aspose.pdf.Border;
import com.aspose.pdf.BorderStyleConverter;
import com.aspose.pdf.CaretAnnotation;
import com.aspose.pdf.CaretSymbolConverter;
import com.aspose.pdf.CircleAnnotation;
import com.aspose.pdf.Color;
import com.aspose.pdf.CommonFigureAnnotation;
import com.aspose.pdf.Dash;
import com.aspose.pdf.Document;
import com.aspose.pdf.FileAttachmentAnnotation;
import com.aspose.pdf.FileIconConverter;
import com.aspose.pdf.FileSpecification;
import com.aspose.pdf.FitExplicitDestination;
import com.aspose.pdf.FitHExplicitDestination;
import com.aspose.pdf.FreeTextAnnotation;
import com.aspose.pdf.GoToAction;
import com.aspose.pdf.GoToRemoteAction;
import com.aspose.pdf.GoToURIAction;
import com.aspose.pdf.HighlightAnnotation;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.InkAnnotation;
import com.aspose.pdf.JavascriptAction;
import com.aspose.pdf.LaunchAction;
import com.aspose.pdf.LineAnnotation;
import com.aspose.pdf.LineEndingConverter;
import com.aspose.pdf.LinkAnnotation;
import com.aspose.pdf.Matrix;
import com.aspose.pdf.MovieAnnotation;
import com.aspose.pdf.NamedAction;
import com.aspose.pdf.Operator;
import com.aspose.pdf.OperatorCollection;
import com.aspose.pdf.OutlineItemCollection;
import com.aspose.pdf.Page;
import com.aspose.pdf.PdfAction;
import com.aspose.pdf.Point;
import com.aspose.pdf.PolygonAnnotation;
import com.aspose.pdf.PolylineAnnotation;
import com.aspose.pdf.PopupAnnotation;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.Resources;
import com.aspose.pdf.SoundAnnotation;
import com.aspose.pdf.SoundIconConverter;
import com.aspose.pdf.SquareAnnotation;
import com.aspose.pdf.SquigglyAnnotation;
import com.aspose.pdf.StampAnnotation;
import com.aspose.pdf.StampIconConverter;
import com.aspose.pdf.StrikeOutAnnotation;
import com.aspose.pdf.TextAnnotation;
import com.aspose.pdf.TextEditOptions;
import com.aspose.pdf.TextFragment;
import com.aspose.pdf.TextFragmentAbsorber;
import com.aspose.pdf.TextIconConverter;
import com.aspose.pdf.TextReplaceOptions;
import com.aspose.pdf.TextSearchOptions;
import com.aspose.pdf.TextState;
import com.aspose.pdf.UnderlineAnnotation;
import com.aspose.pdf.XForm;
import com.aspose.pdf.XImage;
import com.aspose.pdf.facades.LineInfo;
import com.aspose.pdf.facades.PdfExtractor;
import com.aspose.pdf.facades.ReplaceTextStrategy;
import com.aspose.pdf.facades.SaveableFacade;
import com.aspose.pdf.facades.StampInfo;
import com.aspose.pdf.internal.ms.System.z13;
import com.aspose.pdf.internal.ms.System.z133;
import com.aspose.pdf.internal.ms.System.z69;
import com.aspose.pdf.internal.ms.System.z70;
import com.aspose.pdf.internal.ms.System.z89;
import com.aspose.pdf.internal.p599.z23;
import com.aspose.pdf.internal.p600.z17;
import com.aspose.pdf.internal.p606.z29;
import com.aspose.pdf.internal.p606.z6;
import com.aspose.pdf.internal.p613.z41;
import com.aspose.pdf.internal.p68.z14;
import com.aspose.pdf.internal.p68.z16;
import com.aspose.pdf.internal.p68.z20;
import com.aspose.pdf.internal.p68.z25;
import com.aspose.pdf.internal.p68.z27;
import com.aspose.pdf.internal.p68.z9;
import com.aspose.pdf.internal.p781.z5;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PdfContentEditor
extends SaveableFacade {
    private static final Logger m1 = Logger.getLogger(PdfContentEditor.class.getName());
    private TextSearchOptions m2 = new TextSearchOptions(false);
    private TextEditOptions m3 = new TextEditOptions(1);
    private TextReplaceOptions m4 = new TextReplaceOptions(0);
    private com.aspose.pdf.internal.p15.z1<Integer, z1[]> m5 = new com.aspose.pdf.internal.p15.z1();
    private ReplaceTextStrategy m6 = new ReplaceTextStrategy();
    private static final String m7 = "HiddenStamp";
    private z70 m8 = new z70(){

        public void m1(Object object, z69 z6910) {
            PdfContentEditor.this.m1(object, z6910);
        }
    };
    public static final String DOCUMENT_OPEN = "DO";
    public static final String DOCUMENT_CLOSE = "WC";
    public static final String DOCUMENT_WILL_SAVE = "WS";
    public static final String DOCUMENT_SAVED = "DS";
    public static final String DOCUMENT_WILL_PRINT = "WP";
    public static final String DOCUMENT_PRINTED = "DP";
    private static final com.aspose.pdf.internal.p781.z9 m9;

    private void m1(PdfAction pdfAction, int[] nArray, boolean bl) {
        if (nArray != null && nArray.length > (bl ? 1 : 0)) {
            int n;
            pdfAction.getNext().add(new NamedAction(nArray[bl ? 1 : 0]));
            int n2 = n = bl ? 2 : 1;
            while (n < nArray.length) {
                pdfAction.getNext().add(new NamedAction(nArray[n]));
                ++n;
            }
        }
    }

    private void m1(PdfAction pdfAction, int[] nArray) {
        this.m1(pdfAction, nArray, false);
    }

    private void m1(Object object, z69 z6910) {
        this.m1();
    }

    private void m1() {
        this.m2 = new TextSearchOptions(this.m6.isRegularExpressionUsed());
        switch (this.m6.getNoCharacterBehavior()) {
            case 2: {
                this.m3 = new TextEditOptions(2);
                break;
            }
            case 0: {
                this.m3 = new TextEditOptions(0);
                break;
            }
            case 1: {
                this.m3 = new TextEditOptions(1);
            }
        }
        switch (this.m6.getReplaceScope()) {
            case 0: {
                this.m4 = new TextReplaceOptions(0);
                break;
            }
            case 1: {
                this.m4 = new TextReplaceOptions(1);
            }
        }
    }

    public TextSearchOptions getTextSearchOptions() {
        return this.m2;
    }

    public void setTextSearchOptions(TextSearchOptions value) {
        if (value != null) {
            this.m2 = value;
            this.m6.setRegularExpressionUsed(this.m2.isRegularExpressionUsed());
        }
    }

    public TextEditOptions getTextEditOptions() {
        return this.m3;
    }

    public void setTextEditOptions(TextEditOptions value) {
        if (value != null) {
            this.m3 = value;
            switch (this.m3.getNoCharacterBehavior()) {
                case 2: {
                    this.m6.setNoCharacterBehavior(2);
                    break;
                }
                case 0: {
                    this.m6.setNoCharacterBehavior(0);
                    break;
                }
                case 1: {
                    this.m6.setNoCharacterBehavior(1);
                }
            }
        }
    }

    public TextReplaceOptions getTextReplaceOptions() {
        return this.m4;
    }

    public void setTextReplaceOptions(TextReplaceOptions value) {
        if (value != null) {
            this.m4 = value;
            switch (this.m4.getReplaceScope()) {
                case 0: {
                    this.m6.setReplaceScope(0);
                    break;
                }
                case 1: {
                    this.m6.setReplaceScope(1);
                }
            }
        }
    }

    public ReplaceTextStrategy getReplaceTextStrategy() {
        return this.m6;
    }

    public void setReplaceTextStrategy(ReplaceTextStrategy value) {
        if (value != null) {
            if (this.m6 != null) {
                this.m6.m1.remove(this.m8);
            }
            this.m6 = value;
            this.m6.m1.add(this.m8);
            this.m1();
        }
    }

    @Override
    public void bindPdf(String inputFile) {
        super.bindPdf(inputFile);
        this.m2();
    }

    void m2(z41 z4110) {
        super.m7(z4110);
        this.m2();
    }

    @Override
    public void bindPdf(InputStream inputStream) {
        super.m6(z41.fromJava(inputStream));
        this.m2();
    }

    public List extractLink() {
        this.m4();
        AnnotationSelector annotationSelector = new AnnotationSelector(new LinkAnnotation(this.getDocument().getPages().get_Item(1), Rectangle.getTrivial()));
        this.getDocument().getPages().accept(annotationSelector);
        return annotationSelector.getSelected();
    }

    public void createWebLink(java.awt.Rectangle rect, String url, int originalPage, java.awt.Color clr, int[] actionName) {
        this.m4();
        GoToURIAction goToURIAction = new GoToURIAction(url);
        this.m1(goToURIAction, actionName);
        LinkAnnotation linkAnnotation = new LinkAnnotation(this.getDocument().getPages().get_Item(originalPage), Rectangle.fromRect(rect));
        linkAnnotation.setColor(Color.fromRgb(clr));
        linkAnnotation.setAction(goToURIAction);
        this.getDocument().getPages().get_Item(originalPage).getAnnotations().add(linkAnnotation);
    }

    public void createWebLink(java.awt.Rectangle rect, String url, int originalPage, java.awt.Color clr) {
        this.createWebLink(rect, url, originalPage, clr, null);
    }

    public void createWebLink(java.awt.Rectangle rect, String url, int originalPage) {
        this.createWebLink(rect, url, originalPage, java.awt.Color.BLACK, null);
    }

    public void createLocalLink(java.awt.Rectangle rect, int desPage, int originalPage, java.awt.Color clr, int[] actionName) {
        this.m4();
        LinkAnnotation linkAnnotation = new LinkAnnotation(this.getDocument().getPages().get_Item(originalPage), Rectangle.fromRect(rect));
        if (!z6.m1(clr).m12()) {
            linkAnnotation.setColor(Color.fromRgb(clr));
        }
        if (actionName != null && actionName.length > 0) {
            GoToAction goToAction = new GoToAction(desPage);
            this.m1(goToAction, actionName);
            linkAnnotation.setAction(goToAction);
        } else {
            linkAnnotation.setDestination(new FitExplicitDestination(this.getDocument().getPages().get_Item(desPage)));
        }
        this.getDocument().getPages().get_Item(originalPage).getAnnotations().add(linkAnnotation);
    }

    public void createLocalLink(java.awt.Rectangle rect, int desPage, int originalPage, java.awt.Color clr) {
        this.createLocalLink(rect, desPage, originalPage, clr, null);
    }

    public void createPdfDocumentLink(java.awt.Rectangle rect, String remotePdf, int originalPage, int destinationPage, java.awt.Color clr, int[] actionName) {
        this.m4();
        LinkAnnotation linkAnnotation = new LinkAnnotation(this.getDocument().getPages().get_Item(originalPage), Rectangle.fromRect(rect));
        GoToRemoteAction goToRemoteAction = new GoToRemoteAction(remotePdf, destinationPage);
        this.m1(goToRemoteAction, actionName);
        linkAnnotation.setAction(goToRemoteAction);
        this.getDocument().getPages().get_Item(originalPage).getAnnotations().add(linkAnnotation);
    }

    public void createPdfDocumentLink(java.awt.Rectangle rect, String remotePdf, int originalPage, int destinationPage, java.awt.Color clr) {
        this.createPdfDocumentLink(rect, remotePdf, originalPage, destinationPage, clr, null);
    }

    public void createPdfDocumentLink(java.awt.Rectangle rect, String remotePdf, int originalPage, int destinationPage) {
        this.m4();
        LinkAnnotation linkAnnotation = new LinkAnnotation(this.getDocument().getPages().get_Item(originalPage), Rectangle.fromRect(rect));
        linkAnnotation.setAction(new GoToRemoteAction(remotePdf, destinationPage));
        this.getDocument().getPages().get_Item(originalPage).getAnnotations().add(linkAnnotation);
    }

    public void createCustomActionLink(java.awt.Rectangle rect, int originalPage, java.awt.Color color, int[] actionName) {
        this.m4();
        if (actionName == null || actionName.length == 0) {
            return;
        }
        LinkAnnotation linkAnnotation = new LinkAnnotation(this.getDocument().getPages().get_Item(originalPage), Rectangle.fromRect(rect));
        linkAnnotation.setColor(Color.fromRgb(color));
        NamedAction namedAction = new NamedAction(actionName[0]);
        this.m1(namedAction, actionName, true);
        linkAnnotation.setAction(namedAction);
        this.getDocument().getPages().get_Item(originalPage).getAnnotations().add(linkAnnotation);
    }

    public void createApplicationLink(java.awt.Rectangle rect, String application, int page, java.awt.Color clr, int[] actionName) {
        this.m4();
        LaunchAction launchAction = new LaunchAction(application);
        this.m1(launchAction, actionName);
        LinkAnnotation linkAnnotation = new LinkAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(rect));
        linkAnnotation.setColor(Color.fromRgb(clr));
        linkAnnotation.setAction(launchAction);
        this.getDocument().getPages().get_Item(page).getAnnotations().add(linkAnnotation);
    }

    public void createApplicationLink(java.awt.Rectangle rect, String application, int page, java.awt.Color clr) {
        this.createApplicationLink(rect, application, page, clr, null);
    }

    public void createApplicationLink(java.awt.Rectangle rect, String application, int page) {
        this.createApplicationLink(rect, application, page, java.awt.Color.WHITE, null);
    }

    public void createJavaScriptLink(String code, java.awt.Rectangle rect, int originalPage, java.awt.Color color) {
        this.m4();
        LinkAnnotation linkAnnotation = new LinkAnnotation(this.getDocument().getPages().get_Item(originalPage), Rectangle.fromRect(rect));
        linkAnnotation.setColor(Color.fromRgb(color));
        linkAnnotation.setAction(new JavascriptAction(code));
        this.getDocument().getPages().get_Item(originalPage).getAnnotations().add(linkAnnotation);
    }

    public void createText(java.awt.Rectangle rect, String title, String contents, boolean open, String icon, int page) {
        this.m4();
        Page page2 = this.getDocument().getPages().get_Item(page);
        TextAnnotation textAnnotation = new TextAnnotation(page2, Rectangle.fromRect(rect));
        textAnnotation.setTitle(title);
        textAnnotation.setContents(contents);
        textAnnotation.setOpen(open);
        textAnnotation.setIcon(TextIconConverter.toEnum(icon));
        page2.getAnnotations().add(textAnnotation);
    }

    public void createFreeText(java.awt.Rectangle rect, String contents, int page) {
        this.m4();
        FreeTextAnnotation freeTextAnnotation = new FreeTextAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(rect), null);
        freeTextAnnotation.setContents(contents);
        this.getDocument().getPages().get_Item(page).getAnnotations().add(freeTextAnnotation);
    }

    public void createMarkup(java.awt.Rectangle rect, String contents, int type, int page, java.awt.Color clr) {
        Annotation annotation = null;
        Page page2 = this.getDocument().getPages().get_Item(page);
        Rectangle rectangle = Rectangle.fromRect(rect);
        switch (type) {
            case 0: {
                annotation = new HighlightAnnotation(page2, rectangle);
                break;
            }
            case 1: {
                annotation = new UnderlineAnnotation(page2, rectangle);
                break;
            }
            case 2: {
                annotation = new StrikeOutAnnotation(page2, rectangle);
                break;
            }
            case 3: {
                annotation = new SquigglyAnnotation(page2, rectangle);
            }
        }
        annotation.setContents(contents);
        annotation.setColor(Color.fromRgb(clr));
        this.getDocument().getPages().get_Item(page).getAnnotations().add(annotation);
    }

    public void createPopup(java.awt.Rectangle rect, String contents, boolean open, int page) {
        this.m4();
        PopupAnnotation popupAnnotation = new PopupAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(rect));
        popupAnnotation.setContents(contents);
        popupAnnotation.setOpen(open);
        this.getDocument().getPages().get_Item(page).getAnnotations().add(popupAnnotation);
    }

    public void createFileAttachment(java.awt.Rectangle rect, String contents, String filePath, int page, String name) {
        this.m4();
        FileAttachmentAnnotation fileAttachmentAnnotation = new FileAttachmentAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(rect), new FileSpecification(filePath));
        fileAttachmentAnnotation.setContents(contents);
        fileAttachmentAnnotation.setIcon(FileIconConverter.toEnum(name));
        this.getDocument().getPages().get_Item(page).getAnnotations().add(fileAttachmentAnnotation);
    }

    void m1(java.awt.Rectangle rectangle, String string, String string2, int n, String string3, double d) {
        this.m4();
        FileAttachmentAnnotation fileAttachmentAnnotation = new FileAttachmentAnnotation(this.getDocument().getPages().get_Item(n), Rectangle.fromRect(rectangle), new FileSpecification(string2));
        fileAttachmentAnnotation.setContents(string);
        fileAttachmentAnnotation.setOpacity(d);
        fileAttachmentAnnotation.setIcon(FileIconConverter.toEnum(string3));
        this.getDocument().getPages().get_Item(n).getAnnotations().add(fileAttachmentAnnotation);
    }

    public void createFileAttachment(java.awt.Rectangle rect, String contents, InputStream attachmentStream, String attachmentName, int page, String name) {
        this.m1(rect, contents, z41.fromJava(attachmentStream), attachmentName, page, name);
    }

    private void m1(java.awt.Rectangle rectangle, String string, z41 z4110, String string2, int n, String string3) {
        this.m4();
        FileAttachmentAnnotation fileAttachmentAnnotation = new FileAttachmentAnnotation(this.getDocument().getPages().get_Item(n), Rectangle.fromRect(rectangle), new FileSpecification(z4110, string2));
        fileAttachmentAnnotation.setContents(string);
        fileAttachmentAnnotation.setIcon(FileIconConverter.toEnum(string3));
        this.getDocument().getPages().get_Item(n).getAnnotations().add(fileAttachmentAnnotation);
    }

    void m1(java.awt.Rectangle rectangle, String string, z41 z4110, String string2, int n, String string3, double d) {
        this.m4();
        FileAttachmentAnnotation fileAttachmentAnnotation = new FileAttachmentAnnotation(this.getDocument().getPages().get_Item(n), Rectangle.fromRect(rectangle), new FileSpecification(z4110, string2));
        fileAttachmentAnnotation.setContents(string);
        fileAttachmentAnnotation.setOpacity(d);
        fileAttachmentAnnotation.setIcon(FileIconConverter.toEnum(string3));
        this.getDocument().getPages().get_Item(n).getAnnotations().add(fileAttachmentAnnotation);
    }

    public void addDocumentAttachment(String fileAttachmentPath, String description) {
        this.m4();
        FileSpecification fileSpecification = new FileSpecification(fileAttachmentPath, description);
        this.getDocument().getEmbeddedFiles().add(fileSpecification);
    }

    public void addDocumentAttachment(InputStream fileAttachmentStream, String fileAttachmentName, String description) {
        this.m1(z41.fromJava(fileAttachmentStream), fileAttachmentName, description);
    }

    void m1(z41 z4110, String string, String string2) {
        this.m4();
        FileSpecification fileSpecification = new FileSpecification(z4110, string, string2);
        this.getDocument().getEmbeddedFiles().add(fileSpecification);
    }

    public void deleteAttachments() {
        this.m4();
        this.getDocument().getEmbeddedFiles().delete();
        AnnotationSelector annotationSelector = new AnnotationSelector(new FileAttachmentAnnotation(this.getDocument().getPages().get_Item(1), Rectangle.getTrivial(), new FileSpecification()));
        for (Page page : this.getDocument().getPages()) {
            page.accept(annotationSelector);
            for (int i = annotationSelector.getSelected().size() - 1; i >= 0; --i) {
                page.getAnnotations().delete((Annotation)((Object)z5.m1(annotationSelector.getSelected().get(i), Annotation.class)));
            }
            annotationSelector.getSelected().clear();
        }
    }

    public void createLine(java.awt.Rectangle rect, String contents, float x1, float y1, float x2, float y2, int page, int border, java.awt.Color clr, String borderStyle, int[] dashArray, String[] LEArray) {
        this.m4();
        LineAnnotation lineAnnotation = new LineAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(rect), new Point(x1, y1), new Point(x2, y2));
        lineAnnotation.setContents(contents);
        Border border2 = new Border(lineAnnotation);
        border2.setWidth(border);
        lineAnnotation.setColor(Color.fromRgb(clr));
        border2.setStyle(BorderStyleConverter.toEnum(borderStyle));
        if (dashArray != null && dashArray.length > 0) {
            border2.setDash(new Dash(dashArray[0], dashArray.length > 1 ? dashArray[1] : dashArray[0]));
        }
        if (LEArray != null && LEArray.length > 0) {
            lineAnnotation.setStartingStyle(LineEndingConverter.toEnum(LEArray[0]));
            if (LEArray.length > 1) {
                lineAnnotation.setEndingStyle(LineEndingConverter.toEnum(LEArray[1]));
            }
        }
        lineAnnotation.setBorder(border2);
        this.getDocument().getPages().get_Item(page).getAnnotations().add(lineAnnotation);
    }

    public void createSquareCircle(java.awt.Rectangle rect, String contents, java.awt.Color clr, boolean square, int page, int borderWidth) {
        this.m4();
        CommonFigureAnnotation commonFigureAnnotation = square ? new SquareAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(rect)) : new CircleAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(rect));
        commonFigureAnnotation.setContents(contents);
        commonFigureAnnotation.setColor(Color.fromRgb(clr));
        commonFigureAnnotation.setBorder(new Border(commonFigureAnnotation));
        commonFigureAnnotation.getBorder().setWidth(borderWidth);
        this.getDocument().getPages().get_Item(page).getAnnotations().add(commonFigureAnnotation);
    }

    public void drawCurve(LineInfo lineInfo, int page, java.awt.Rectangle annotRect, String annotContents) {
        this.m4();
        ArrayList<Point[]> arrayList = new ArrayList<Point[]>();
        int n = lineInfo.getVerticeCoordinate().length / 2;
        Point[] pointArray = new Point[n];
        for (int i = 0; i < n; ++i) {
            pointArray[i] = new Point(lineInfo.getVerticeCoordinate()[2 * i], lineInfo.getVerticeCoordinate()[2 * i + 1]);
        }
        arrayList.add(pointArray);
        InkAnnotation inkAnnotation = new InkAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(annotRect), arrayList);
        inkAnnotation.setBorder(new Border(inkAnnotation));
        if (lineInfo.getVisibility()) {
            inkAnnotation.getBorder().setWidth(lineInfo.getLineWidth());
            inkAnnotation.getBorder().setStyle(lineInfo.getBorderStyle());
            if (lineInfo.getLineDashPattern() != null && lineInfo.getLineDashPattern().length != 0) {
                inkAnnotation.getBorder().setDash(new Dash(lineInfo.getLineDashPattern()[0], lineInfo.getLineDashPattern().length > 1 ? lineInfo.getLineDashPattern()[1] : lineInfo.getLineDashPattern()[0]));
            }
            inkAnnotation.setColor(Color.fromRgb(lineInfo.getLineColor()));
        } else {
            inkAnnotation.getBorder().setWidth(0);
        }
        inkAnnotation.setContents(annotContents);
        this.getDocument().getPages().get_Item(page).getAnnotations().add(inkAnnotation);
    }

    public void createPolygon(LineInfo lineInfo, int page, java.awt.Rectangle annotRect, String annotContents) {
        this.m4();
        int n = lineInfo.getVerticeCoordinate().length / 2;
        Point[] pointArray = new Point[n];
        for (int i = 0; i < n; ++i) {
            pointArray[i] = new Point(lineInfo.getVerticeCoordinate()[2 * i], lineInfo.getVerticeCoordinate()[2 * i + 1]);
        }
        PolygonAnnotation polygonAnnotation = new PolygonAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(annotRect), pointArray);
        if (lineInfo.getVisibility()) {
            Border border = new Border(polygonAnnotation);
            border.setWidth(lineInfo.getLineWidth());
            border.setStyle(lineInfo.getBorderStyle());
            if (lineInfo.getLineDashPattern() != null && lineInfo.getLineDashPattern().length != 0) {
                border.setDash(new Dash(lineInfo.getLineDashPattern()[0], lineInfo.getLineDashPattern().length > 1 ? lineInfo.getLineDashPattern()[1] : lineInfo.getLineDashPattern()[0]));
            }
            polygonAnnotation.setBorder(border);
            polygonAnnotation.setColor(Color.fromRgb(lineInfo.getLineColor()));
        }
        polygonAnnotation.setContents(annotContents);
        this.getDocument().getPages().get_Item(page).getAnnotations().add(polygonAnnotation);
    }

    public void createPolyLine(LineInfo lineInfo, int page, java.awt.Rectangle annotRect, String annotContents) {
        this.m4();
        int n = lineInfo.getVerticeCoordinate().length / 2;
        Point[] pointArray = new Point[n];
        for (int i = 0; i < n; ++i) {
            pointArray[i] = new Point(lineInfo.getVerticeCoordinate()[2 * i], lineInfo.getVerticeCoordinate()[2 * i + 1]);
        }
        PolylineAnnotation polylineAnnotation = new PolylineAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(annotRect), pointArray);
        if (lineInfo.getVisibility()) {
            Border border = new Border(polylineAnnotation);
            border.setWidth(lineInfo.getLineWidth());
            border.setStyle(lineInfo.getBorderStyle());
            if (lineInfo.getLineDashPattern() != null && lineInfo.getLineDashPattern().length != 0) {
                border.setDash(new Dash(lineInfo.getLineDashPattern()[0], lineInfo.getLineDashPattern().length > 1 ? lineInfo.getLineDashPattern()[1] : lineInfo.getLineDashPattern()[0]));
            }
            polylineAnnotation.setBorder(border);
            polylineAnnotation.setColor(Color.fromRgb(lineInfo.getLineColor()));
        }
        polylineAnnotation.setContents(annotContents);
        this.getDocument().getPages().get_Item(page).getAnnotations().add(polylineAnnotation);
    }

    public void createCaret(int page, java.awt.Rectangle annotRect, java.awt.Rectangle caretRect, String symbol, String annotContents, java.awt.Color color) {
        this.m4();
        CaretAnnotation caretAnnotation = new CaretAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(caretRect));
        caretAnnotation.setSymbol(CaretSymbolConverter.toEnum(symbol));
        caretAnnotation.setRect(Rectangle.fromRect(annotRect));
        caretAnnotation.setContents(annotContents);
        caretAnnotation.setColor(Color.fromRgb(color));
        this.getDocument().getPages().get_Item(page).getAnnotations().add(caretAnnotation);
    }

    public void createRubberStamp(int page, java.awt.Rectangle annotRect, String icon, String annotContents, java.awt.Color color) {
        this.m4();
        StampAnnotation stampAnnotation = new StampAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(annotRect));
        stampAnnotation.setIcon(StampIconConverter.toEnum(icon));
        stampAnnotation.setContents(annotContents);
        stampAnnotation.setColor(Color.fromRgb(color));
        this.getDocument().getPages().get_Item(page).getAnnotations().add(stampAnnotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRubberStamp(int page, java.awt.Rectangle annotRect, String annotContents, java.awt.Color color, String appearanceFile) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(appearanceFile);
            try {
                this.createRubberStamp(page, annotRect, annotContents, color, fileInputStream);
            }
            finally {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
        }
        catch (Exception exception) {
            m1.log(Level.INFO, "Exception occur", exception);
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    public void createRubberStamp(int page, java.awt.Rectangle annotRect, String annotContents, java.awt.Color color, InputStream appearanceStream) {
        this.m4();
        StampAnnotation stampAnnotation = new StampAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(annotRect));
        stampAnnotation.setImage(appearanceStream);
        stampAnnotation.setContents(annotContents);
        stampAnnotation.setColor(Color.fromRgb(color));
        this.getDocument().getPages().get_Item(page).getAnnotations().add(stampAnnotation);
    }

    public void createBookmarksAction(String title, java.awt.Color color, boolean boldFlag, boolean italicFlag, String file, String actionType, String destination) {
        this.m4();
        OutlineItemCollection outlineItemCollection = new OutlineItemCollection(this.getDocument().getOutlines());
        outlineItemCollection.setTitle(title);
        outlineItemCollection.setColor(color);
        outlineItemCollection.setBold(boldFlag);
        outlineItemCollection.setItalic(italicFlag);
        PdfAction pdfAction = null;
        switch (m9.m1(actionType)) {
            case 0: {
                try {
                    int n = z89.m1(destination);
                    pdfAction = new GoToRemoteAction(file, n);
                }
                catch (RuntimeException runtimeException) {
                    m1.log(Level.INFO, "Exception occur", runtimeException);
                    pdfAction = new GoToRemoteAction(file, 1);
                }
                break;
            }
            case 1: {
                pdfAction = new LaunchAction(file);
                break;
            }
            case 2: {
                try {
                    int n = z89.m1(destination);
                    Page page = this.getDocument().getPages().get_Item(n);
                    pdfAction = new GoToAction(page);
                    ((GoToAction)pdfAction).setDestination(new FitHExplicitDestination(page, page.getRect().getHeight()));
                }
                catch (RuntimeException runtimeException) {
                    m1.log(Level.INFO, "Exception occur", runtimeException);
                    pdfAction = new GoToAction(this.getDocument().getPages().get_Item(1));
                }
                break;
            }
            case 3: {
                pdfAction = new GoToURIAction(destination);
            }
        }
        outlineItemCollection.setAction(pdfAction);
        this.getDocument().getOutlines().add(outlineItemCollection);
    }

    public void addDocumentAdditionalAction(String eventType, String code) {
        this.m4();
        JavascriptAction javascriptAction = new JavascriptAction(code);
        switch (m9.m1(eventType)) {
            case 4: {
                this.getDocument().setOpenAction(javascriptAction);
                break;
            }
            case 5: {
                this.getDocument().getActions().setBeforeClosing(javascriptAction);
                break;
            }
            case 6: {
                this.getDocument().getActions().setBeforeSaving(javascriptAction);
                break;
            }
            case 7: {
                this.getDocument().getActions().setAfterSaving(javascriptAction);
                break;
            }
            case 8: {
                this.getDocument().getActions().setBeforePrinting(javascriptAction);
                break;
            }
            case 9: {
                this.getDocument().getActions().setAfterPrinting(javascriptAction);
            }
        }
    }

    public void removeDocumentOpenAction() {
        this.m4();
        this.getDocument().setOpenAction(null);
    }

    public void changeViewerPreference(int viewerAttribution) {
        this.m4();
        switch (viewerAttribution) {
            case 0x100000: {
                this.getDocument().setPageMode(4);
                break;
            }
            case 262144: {
                this.getDocument().setDisplayDocTitle(true);
                break;
            }
            case 524288: {
                this.getDocument().setPageMode(3);
                this.getDocument().setNonFullScreenPageMode(4);
                break;
            }
            case 1: {
                this.getDocument().setPageLayout(0);
                break;
            }
            case 2: {
                this.getDocument().setPageLayout(1);
                break;
            }
            case 4: {
                this.getDocument().setPageLayout(2);
                break;
            }
            case 8: {
                this.getDocument().setPageLayout(3);
                break;
            }
            case 16: {
                this.getDocument().setPageMode(0);
                break;
            }
            case 32: {
                this.getDocument().setPageMode(1);
                break;
            }
            case 64: {
                this.getDocument().setPageMode(2);
                break;
            }
            case 128: {
                this.getDocument().setPageMode(3);
                break;
            }
            case 0x200000: {
                this.getDocument().setPageMode(5);
                break;
            }
            case 256: {
                this.getDocument().setHideToolBar(true);
                break;
            }
            case 512: {
                this.getDocument().setHideMenubar(true);
                break;
            }
            case 1024: {
                this.getDocument().setHideWindowUI(true);
                break;
            }
            case 2048: {
                this.getDocument().setFitWindow(true);
                break;
            }
            case 4096: {
                this.getDocument().setCenterWindow(true);
                break;
            }
            case 8192: {
                this.getDocument().setNonFullScreenPageMode(0);
                break;
            }
            case 16384: {
                this.getDocument().setNonFullScreenPageMode(1);
                break;
            }
            case 32768: {
                this.getDocument().setNonFullScreenPageMode(2);
                break;
            }
            case 65536: {
                this.getDocument().setDirection(0);
                break;
            }
            case 131072: {
                this.getDocument().setDirection(1);
            }
        }
    }

    public int getViewerPreference() {
        this.m4();
        int n = 0;
        if (this.getDocument().getHideToolBar()) {
            n |= 0x100;
        }
        if (this.getDocument().getHideMenubar()) {
            n |= 0x200;
        }
        if (this.getDocument().getHideWindowUI()) {
            n |= 0x400;
        }
        if (this.getDocument().getFitWindow()) {
            n |= 0x800;
        }
        if (this.getDocument().getCenterWindow()) {
            n |= 0x1000;
        }
        if (this.getDocument().getDisplayDocTitle()) {
            n |= 0x40000;
        }
        switch (this.getDocument().getDirection()) {
            case 0: {
                n |= 0x10000;
                break;
            }
            case 1: {
                n |= 0x20000;
            }
        }
        switch (this.getDocument().getPageMode()) {
            case 3: {
                n |= 0x80;
                break;
            }
            case 5: {
                n |= 0x200000;
                break;
            }
            case 0: {
                n |= 0x10;
                break;
            }
            case 4: {
                n |= 0x100000;
                break;
            }
            case 1: {
                n |= 0x20;
                break;
            }
            case 2: {
                n |= 0x40;
            }
        }
        switch (this.getDocument().getNonFullScreenPageMode()) {
            case 0: {
                n |= 0x2000;
                break;
            }
            case 4: {
                n |= 0x80000;
                break;
            }
            case 1: {
                n |= 0x4000;
                break;
            }
            case 2: {
                n |= 0x8000;
            }
        }
        switch (this.getDocument().getPageLayout()) {
            case 1: {
                n |= 2;
                break;
            }
            case 0: {
                n |= 1;
                break;
            }
            case 2: {
                n |= 4;
                break;
            }
            case 3: {
                n |= 8;
            }
        }
        return n;
    }

    public void replaceImage(int pageNumber, int index, String imageFile) {
        this.m4();
        z17<XImage> z1710 = new z17<XImage>();
        PdfExtractor pdfExtractor = new PdfExtractor();
        pdfExtractor.m3(z1710, this.getDocument(), pageNumber, pageNumber);
        if (index > 0 && index <= z1710.size()) {
            try {
                ((XImage)((Object)z5.m1(z1710.get_Item(index - 1), XImage.class))).replace(new FileInputStream(imageFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                m1.log(Level.INFO, "Exception occur", fileNotFoundException);
                throw new RuntimeException(fileNotFoundException);
            }
        }
    }

    public void deleteImage(int pageNumber, int[] index) {
        this.m4();
        if (index == null || index.length == 0) {
            throw new com.aspose.pdf.internal.ms.System.z9("Invalid index contents");
        }
        z13.m5(z13.m1((Object)index));
        z17<XImage> z1710 = new z17<XImage>();
        PdfExtractor pdfExtractor = new PdfExtractor();
        pdfExtractor.m3(z1710, this.getDocument(), pageNumber, pageNumber);
        for (int i = index.length - 1; i >= 0; --i) {
            if (index[i] - 1 < 0 || index[i] > z1710.size()) continue;
            ((XImage)((Object)z5.m1(z1710.get_Item(index[i] - 1), XImage.class))).delete();
        }
    }

    public void deleteImage() {
        this.m4();
        for (Page page : this.getDocument().getPages()) {
            page.getResources().getImages().delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceText(String srcString, int thePage, String destString, TextState textState) {
        this.m4();
        TextFragmentAbsorber textFragmentAbsorber = new TextFragmentAbsorber(srcString, this.m2, this.m3);
        if (thePage == 0) {
            textFragmentAbsorber.visit(this.getDocument());
        } else if (thePage <= this.getDocument().getPages().size()) {
            textFragmentAbsorber.visit(this.getDocument().getPages().get_Item(thePage));
        }
        if (textFragmentAbsorber.getTextFragments() != null && textFragmentAbsorber.getTextFragments().size() > 0) {
            if (thePage == 0) {
                for (Object object : this.getDocument().getPages()) {
                    ((Page)object).getContents().suppressUpdate();
                }
            } else {
                this.getDocument().getPages().get_Item(thePage).getContents().suppressUpdate();
            }
            try {
                if (this.m4 != null) {
                    switch (this.m4.getReplaceScope()) {
                        case 0: {
                            textFragmentAbsorber.getTextFragments().get_Item(1).setText(destString);
                            if (textState == null) break;
                            textFragmentAbsorber.getTextFragments().get_Item(1).getTextState().applyChangesFrom(textState);
                            break;
                        }
                        case 1: {
                            for (Object object : textFragmentAbsorber.getTextFragments()) {
                                ((TextFragment)object).setText(destString);
                                if (textState == null) continue;
                                ((TextFragment)object).getTextState().applyChangesFrom(textState);
                            }
                            break;
                        }
                    }
                } else {
                    textFragmentAbsorber.getTextFragments().get_Item(1).setText(destString);
                    if (textState != null) {
                        textFragmentAbsorber.getTextFragments().get_Item(1).getTextState().applyChangesFrom(textState);
                    }
                }
            }
            finally {
                if (thePage == 0) {
                    for (Object object : this.getDocument().getPages()) {
                        ((Page)object).getContents().resumeUpdate();
                    }
                } else {
                    this.getDocument().getPages().get_Item(thePage).getContents().resumeUpdate();
                }
            }
            return true;
        }
        return false;
    }

    public boolean replaceText(String srcString, String destString) {
        return this.replaceText(srcString, 0, destString);
    }

    public boolean replaceText(String srcString, int thePage, String destString) {
        return this.replaceText(srcString, thePage, destString, new TextState());
    }

    public boolean replaceText(String srcString, String destString, TextState textState) {
        return this.replaceText(srcString, 0, destString, textState);
    }

    public void createMovie(java.awt.Rectangle rect, String filePath, int page) {
        this.m4();
        MovieAnnotation movieAnnotation = new MovieAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(rect), filePath);
        this.getDocument().getPages().get_Item(page).getAnnotations().add(movieAnnotation);
    }

    public void createSound(java.awt.Rectangle rect, String filePath, String name, int page, String rate) {
        this.m4();
        SoundAnnotation soundAnnotation = new SoundAnnotation(this.getDocument().getPages().get_Item(page), Rectangle.fromRect(rect), filePath);
        soundAnnotation.setIcon(SoundIconConverter.toEnum(name));
        soundAnnotation.getSoundData().setRate(z89.m1(rate));
        this.getDocument().getPages().get_Item(page).getAnnotations().add(soundAnnotation);
    }

    public void deleteStamp(int pageNumber, int[] index) {
        this.m1(pageNumber, index);
    }

    public void deleteStampByIds(int[] stampIds) {
        this.m4();
        for (int n : stampIds) {
            for (int i = 1; i <= this.getDocument().getPages().size(); ++i) {
                this.deleteStampById(i, n);
            }
        }
    }

    public void deleteStampByIds(int pageNumber, int[] stampIds) {
        this.m4();
        for (int n : stampIds) {
            this.deleteStampById(pageNumber, n);
        }
    }

    public void deleteStampById(int pageNumber, int stampId) {
        if (stampId == 0) {
            return;
        }
        z1[] z1Array = this.m1(pageNumber);
        if (z1Array != null) {
            for (z1 z1338 : z1Array) {
                if (z1338.m8() != stampId) continue;
                z1338.m9();
                break;
            }
        }
    }

    public void hideStampById(int pageNumber, int stampId) {
        if (stampId == 0) {
            return;
        }
        z1[] z1Array = this.m1(pageNumber);
        if (z1Array != null) {
            for (z1 z1338 : z1Array) {
                if (z1338.m8() != stampId) continue;
                z1338.m10();
                break;
            }
        }
    }

    public void showStampById(int pageNumber, int stampId) {
        if (stampId == 0) {
            return;
        }
        z1[] z1Array = this.m1(pageNumber);
        if (z1Array != null) {
            for (z1 z1338 : z1Array) {
                if (z1338.m8() != stampId) continue;
                z1338.m11();
                break;
            }
        }
    }

    public void moveStampById(int pageNumber, int stampId, double x, double y) {
        if (stampId == 0) {
            return;
        }
        z1[] z1Array = this.m1(pageNumber);
        if (z1Array != null) {
            for (z1 z1338 : z1Array) {
                if (z1338.m8() != stampId) continue;
                z1338.m1(x, y);
                break;
            }
        }
    }

    public void moveStamp(int pageNumber, int stampIndex, double x, double y) {
        z1[] z1Array = this.m1(pageNumber);
        if (stampIndex > z1Array.length || stampIndex < 0) {
            throw new com.aspose.pdf.internal.ms.System.z9(z133.m1(new Object[]{"Invalid stamp index. Stamp index must be in range (0, ", z1Array.length, ")"}));
        }
        z1 z1338 = z1Array[stampIndex];
        z1338.m1(x, y);
    }

    public void deleteStampById(int stampId) {
        this.m4();
        for (int i = 1; i <= this.getDocument().getPages().size(); ++i) {
            this.deleteStampById(i, stampId);
        }
    }

    public PdfContentEditor() {
        this(null);
    }

    @Override
    public void bindPdf(Pdf pdf) {
        this.bindPdf(new Document(pdf));
        this.m2();
    }

    public PdfContentEditor(IDocument document) {
        super(document);
        this.m6.m1.add(this.m8);
    }

    public void createLocalLink(java.awt.Rectangle rect, int desPage, int originalPage) {
        this.createLocalLink(rect, desPage, originalPage, z6.m4.m1());
    }

    private boolean m1(OperatorCollection operatorCollection, Operator operator) {
        if (operator.getIndex() < 4) {
            return false;
        }
        if (operator.getIndex() >= operatorCollection.size()) {
            return false;
        }
        return operatorCollection.get_Item(operator.getIndex() - 3) instanceof Operator.GSave && operatorCollection.get_Item(operator.getIndex() - 2) instanceof Operator.GS && operatorCollection.get_Item(operator.getIndex() - 1) instanceof Operator.ConcatenateMatrix && operator instanceof Operator.Do && operatorCollection.get_Item(operator.getIndex() + 1) instanceof Operator.GRestore || operator instanceof Operator.BDC && operatorCollection.get_Item(operator.getIndex() + 1) instanceof Operator.EMC && operatorCollection.get_Item(operator.getIndex() + 2) instanceof Operator.GRestore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean m1(OperatorCollection operatorCollection, List<Object> list) {
        Document.startOperation();
        try {
            for (Object t : list) {
                if (!this.m1(operatorCollection, (Operator)t)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Document.endOperation();
        }
    }

    public boolean replaceText(String srcString, String destString, int fontSize) {
        return this.replaceText(srcString, destString, new TextState(fontSize));
    }

    private void m1(OperatorCollection operatorCollection, Resources resources, z17<z1> z1710, Object object) {
        this.m1(null, operatorCollection, resources, z1710, object);
    }

    private void m1(Matrix matrix, OperatorCollection operatorCollection, Resources resources, z17<z1> z1710, Object object) {
        z23 z2310 = new z23();
        if (matrix == null) {
            matrix = new Matrix();
        }
        Matrix matrix2 = new Matrix();
        for (Operator operator : operatorCollection) {
            z9 z9100;
            if (operator instanceof Operator.GSave) {
                z2310.m2(new Matrix(matrix));
            }
            if (operator instanceof Operator.GRestore) {
                matrix = (Matrix)z2310.m3();
            }
            if (operator instanceof Operator.ConcatenateMatrix) {
                matrix2 = matrix;
                matrix = ((Operator.ConcatenateMatrix)((Object)z5.m1(operator, Operator.ConcatenateMatrix.class))).getMatrix().multiply(matrix);
            }
            if (!(operator instanceof Operator.Do) && (!(operator instanceof Operator.BDC) || !m7.equals(((Operator.BDC)((Object)z5.m1(operator, Operator.BDC.class))).getTag()))) continue;
            XForm xForm = null;
            XImage xImage = null;
            String string = null;
            boolean bl = true;
            if (operator instanceof Operator.Do) {
                string = ((Operator.Do)((Object)z5.m1(operator, Operator.Do.class))).getName();
            }
            if (operator instanceof Operator.BDC) {
                z9100 = ((Operator.BDC)((Object)z5.m1(operator, Operator.BDC.class))).getPropertiesDictionary();
                if (z9100.m4("Name") && z9100.m2("Name").m59() != null) {
                    string = z9100.m2("Name").m59().toString();
                }
                bl = false;
            }
            z9100 = resources.getEngineDict().m2("XObject").m60().m2(string).m60();
            String string2 = null;
            if (z9100.m2("Subtype").m59() != null) {
                string2 = z9100.m2("Subtype").m59().toString();
            } else if (z9100.m2("Subtype").m58() != null) {
                string2 = z9100.m2("Subtype").m58().m8();
            }
            if ("Form".equals(string2)) {
                xForm = resources.getForms().get_Item(string);
            } else if ("Image".equals(string2)) {
                xImage = resources.getImages().get_Item(string);
            }
            if (this.m1(operatorCollection, operator) || z9100.m4("StampId")) {
                if (xForm != null) {
                    Rectangle rectangle = xForm.getRectangle();
                    rectangle = matrix.transform(rectangle);
                    z1710.addItem(new z1(this, xForm, object, string, rectangle, matrix2, bl));
                    continue;
                }
                if (xImage == null) continue;
                z1710.addItem(new z1(this, xImage, object, string, matrix.transform(new Rectangle(0.0, 0.0, 1.0, 1.0)), matrix2, bl));
                continue;
            }
            if (xForm == null) continue;
            this.m1(matrix, xForm.getContents(), xForm.getResources(), z1710, xForm);
        }
    }

    private void m2(OperatorCollection operatorCollection, Resources resources, z17<z1> z1710, Object object) {
        if (resources.getEngineDict().m4("XObject")) {
            for (String string : resources.getEngineDict().m2("XObject").m60().m29()) {
                z9 z9100 = resources.getEngineDict().m2("XObject").m60().m2(string).m60();
                List<Object> list = Page.findReferences(operatorCollection, string);
                XForm xForm = null;
                XImage xImage = null;
                if (list.size() <= 0) continue;
                String string2 = null;
                if (z9100.m2("Subtype").m59() != null) {
                    string2 = z9100.m2("Subtype").m59().toString();
                } else if (z9100.m2("Subtype").m58() != null) {
                    string2 = z9100.m2("Subtype").m58().m8();
                }
                if ("Form".equals(string2)) {
                    xForm = resources.getForms().get_Item(string);
                } else if ("Image".equals(string2)) {
                    xImage = resources.getImages().get_Item(string);
                }
                if (this.m1(operatorCollection, list) || z9100.m4("StampId")) {
                    if (xForm != null) {
                        z1710.addItem(new z1(this, xForm, object, string, null, new Matrix(), true));
                    } else if (xImage != null) {
                        z1710.addItem(new z1(this, xImage, object, string, null, new Matrix(), true));
                    }
                }
                if (xForm == null) continue;
                this.m1(xForm.getContents(), xForm.getResources(), z1710, xForm);
            }
        }
    }

    private z1[] m1(int n) {
        Page page;
        z1[] z1Array;
        if (n > this.getDocument().getPages().size()) {
            n = this.getDocument().getPages().size();
        }
        if ((z1Array = z5.m3((Object)this.m5.m1(n), z1[].class)) == null && (page = this.getDocument().getPages().get_Item(n)) != null) {
            z17<z1> z1710 = new z17<z1>();
            this.m1(page.getContents(), page.getResources(), z1710, page);
            z1Array = z1710.toArray((z1[])new z1[0]);
        }
        this.m5.m1(n, z1Array);
        return z1Array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StampInfo[] getStamps(int pageNumber) {
        Document.startOperation();
        try {
            this.m4();
            StampInfo[] stampInfoArray = null;
            z1[] z1Array = this.m1(pageNumber);
            if (z1Array != null) {
                stampInfoArray = new StampInfo[z1Array.length];
                for (int i = 0; i < z1Array.length; ++i) {
                    if (z1Array[i].m7() != null) {
                        stampInfoArray[i] = new StampInfo(z1Array[i].m8(), z1Array[i].m5(), i, z1Array[i].m2(), z1Array[i].m7(), z1Array[i].m3());
                        continue;
                    }
                    z29 z2910 = null;
                    if (z1Array[i].m6() != null) {
                        z2910 = z1Array[i].m6().getImage();
                    }
                    stampInfoArray[i] = new StampInfo(z1Array[i].m8(), z1Array[i].m5(), i, z1Array[i].m2(), z2910, z1Array[i].m3());
                }
            }
            if (stampInfoArray == null) {
                stampInfoArray = new StampInfo[]{};
            }
            StampInfo[] stampInfoArray2 = stampInfoArray;
            return stampInfoArray2;
        }
        finally {
            Document.endOperation();
        }
    }

    private boolean m1(int n, int[] nArray) {
        this.m4();
        boolean bl = false;
        z1[] z1Array = this.m1(n);
        if (z1Array != null) {
            for (int n2 : nArray) {
                if (n2 < 0 || n2 >= z1Array.length) continue;
                z1 z1338 = z1Array[n2];
                z1338.m9();
            }
            this.m5 = new com.aspose.pdf.internal.p15.z1();
            bl = true;
        }
        return bl;
    }

    private void m2() {
        this.m5 = new com.aspose.pdf.internal.p15.z1();
    }

    @Override
    public void close() {
        super.close();
    }

    boolean m1(z14 z1410) {
        for (Page page : this.getDocument().getPages()) {
            if (!page.getResources().getEngineDict().m4("XObject")) continue;
            z9 z9100 = page.getResources().getEngineDict().m2("XObject").m60();
            for (String string : z9100.m29()) {
                z14 z1411 = z9100.m2(string).m64();
                if (z1411.m42() != z1410.m42()) continue;
                return true;
            }
        }
        return false;
    }

    static {
        m1.setUseParentHandlers(false);
        m9 = new com.aspose.pdf.internal.p781.z9("GoToR", "Launch", "GoTo", "URI", DOCUMENT_OPEN, DOCUMENT_CLOSE, DOCUMENT_WILL_SAVE, DOCUMENT_SAVED, DOCUMENT_WILL_PRINT, DOCUMENT_PRINTED);
    }

    private static class z1 {
        private Page m1;
        private XForm m2;
        private String m3;
        private Matrix m4;
        private PdfContentEditor m5;
        private Rectangle m6;
        private boolean m7;
        private Object m8;

        public String m1() {
            return this.m3;
        }

        public Rectangle m2() {
            if (this.m6 == null) {
                this.m6 = this.m14();
            }
            return this.m6;
        }

        public boolean m3() {
            return this.m7;
        }

        public z9 m4() {
            if (this.m6() != null) {
                return this.m6().getEngineImg().m60();
            }
            if (this.m7() != null) {
                return this.m7().getEngineObj().m60();
            }
            return null;
        }

        public int m5() {
            if (this.m6() != null) {
                return 1;
            }
            if (this.m7() != null) {
                return 0;
            }
            return 0;
        }

        public XImage m6() {
            if (this.m8 instanceof XImage) {
                return (XImage)((Object)z5.m1(this.m8, XImage.class));
            }
            return null;
        }

        public XForm m7() {
            if (this.m8 instanceof XForm) {
                return (XForm)((Object)z5.m1(this.m8, XForm.class));
            }
            return null;
        }

        public z1(PdfContentEditor pdfContentEditor, XImage xImage, Object object, String string, Rectangle rectangle, Matrix matrix, boolean bl) {
            this.m8 = xImage;
            if (object instanceof Page) {
                this.m1 = (Page)((Object)z5.m1(object, Page.class));
            } else if (object instanceof XForm) {
                this.m2 = (XForm)((Object)z5.m1(object, XForm.class));
            }
            this.m3 = string;
            this.m5 = pdfContentEditor;
            this.m6 = rectangle;
            this.m4 = matrix;
            this.m7 = bl;
        }

        public z1(PdfContentEditor pdfContentEditor, XForm xForm, Object object, String string, Rectangle rectangle, Matrix matrix, boolean bl) {
            this.m8 = xForm;
            if (object instanceof Page) {
                this.m1 = (Page)((Object)z5.m1(object, Page.class));
            } else if (object instanceof XForm) {
                this.m2 = (XForm)((Object)z5.m1(object, XForm.class));
            }
            this.m3 = string;
            this.m5 = pdfContentEditor;
            this.m6 = rectangle;
            this.m4 = matrix;
            this.m7 = bl;
        }

        public int m8() {
            int n = 0;
            if (this.m4() != null && this.m4().m4("StampId")) {
                n = this.m4().m2("StampId").m56() ? this.m4().m2("StampId").m66().m1() : 0;
            }
            return n;
        }

        private Rectangle m1(Matrix matrix) {
            Rectangle rectangle = null;
            if (this.m8 instanceof XForm) {
                rectangle = matrix.transform(((XForm)((Object)z5.m1(this.m8, XForm.class))).getRectangle());
            } else if (this.m8 instanceof XImage) {
                rectangle = new Rectangle(0.0, 0.0, 1.0, 1.0);
                rectangle = matrix.transform(rectangle);
            }
            return rectangle;
        }

        private OperatorCollection m12() {
            if (this.m1 != null) {
                return this.m1.getContents();
            }
            if (this.m2 != null) {
                return this.m2.getContents();
            }
            return null;
        }

        private Resources m13() {
            if (this.m1 != null) {
                return this.m1.getResources();
            }
            if (this.m2 != null) {
                return this.m2.getResources();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Rectangle m14() {
            Document.startOperation();
            try {
                Rectangle rectangle = null;
                z23 z2310 = new z23();
                Matrix matrix = new Matrix();
                for (Operator operator : this.m12()) {
                    if (operator instanceof Operator.GSave) {
                        z2310.m2(new Matrix(matrix));
                    }
                    if (operator instanceof Operator.GRestore) {
                        matrix = (Matrix)z2310.m3();
                    }
                    if (operator instanceof Operator.ConcatenateMatrix) {
                        matrix = ((Operator.ConcatenateMatrix)((Object)z5.m1(operator, Operator.ConcatenateMatrix.class))).getMatrix().multiply(matrix);
                    }
                    if (!(operator instanceof Operator.Do) || !z133.m5(((Operator.Do)((Object)z5.m1(operator, Operator.Do.class))).getName(), this.m1())) continue;
                    rectangle = this.m1(matrix);
                    break;
                }
                Iterator iterator = rectangle;
                return iterator;
            }
            finally {
                Document.endOperation();
            }
        }

        public boolean m1(double d, double d2) {
            Operator.ConcatenateMatrix concatenateMatrix;
            Object object;
            boolean bl = false;
            int n = -1;
            OperatorCollection operatorCollection = this.m12();
            for (int i = 1; i <= operatorCollection.size(); ++i) {
                object = operatorCollection.get_Item(i);
                if (!(object instanceof Operator.Do) || !z133.m5(((Operator.Do)((Object)z5.m1(object, Operator.Do.class))).getName(), this.m1())) continue;
                n = i;
                break;
            }
            if (n != -1 && (concatenateMatrix = (Operator.ConcatenateMatrix)((Object)z5.m1(operatorCollection.get_Item(n - 1), Operator.ConcatenateMatrix.class))) != null) {
                object = new Matrix(this.m4.getA(), this.m4.getB(), this.m4.getC(), this.m4.getD(), 0.0, 0.0);
                object = ((Matrix)object).reverse();
                Point point = new Point(d - this.m2().getLLX(), d2 - this.m2().getLLY());
                point = ((Matrix)object).transform(point);
                Operator.ConcatenateMatrix concatenateMatrix2 = new Operator.ConcatenateMatrix(concatenateMatrix.getMatrix().getA(), concatenateMatrix.getMatrix().getB(), concatenateMatrix.getMatrix().getC(), concatenateMatrix.getMatrix().getD(), concatenateMatrix.getMatrix().getE() + point.getX(), concatenateMatrix.getMatrix().getF() + point.getY());
                operatorCollection.set_Item(n - 1, concatenateMatrix2);
                bl = true;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean m1(boolean bl) {
            boolean bl2 = false;
            Document.startOperation();
            try {
                Resources resources = this.m13();
                if (resources.isCommonResource() || !bl) {
                    if (this.m1() != null) {
                        Page.removeObjectReferences(this.m12(), this.m1());
                    }
                    bl2 = true;
                } else if (this.m1() != null) {
                    if (this.m7() != null) {
                        resources.getForms().delete(this.m1());
                        bl2 = true;
                    } else if (this.m6() != null) {
                        z9 z9100 = resources.getEngineDict().m2("XObject").m60();
                        z14 z1410 = null;
                        if (z9100 != null) {
                            z1410 = z9100.m2(this.m1()).m64();
                        }
                        resources.getImages().delete(this.m1());
                        if (z1410 != null && !this.m5.m1(z1410)) {
                            z9100.m69().m3(z1410);
                        }
                        bl2 = true;
                    }
                }
                if (bl2) {
                    this.m5.m2();
                }
            }
            finally {
                Document.endOperation();
            }
            return bl2;
        }

        public boolean m9() {
            return this.m1(true);
        }

        public boolean m10() {
            Object object;
            OperatorCollection operatorCollection = this.m12();
            int n = -1;
            for (int i = 1; i <= operatorCollection.size(); ++i) {
                object = operatorCollection.get_Item(i);
                if (!(object instanceof Operator.Do) || !z133.m5(((Operator.Do)((Object)z5.m1(object, Operator.Do.class))).getName(), this.m1())) continue;
                n = i;
                break;
            }
            if (n != -1) {
                operatorCollection.delete(n);
                z17<Operator> z1710 = new z17<Operator>();
                object = new z25((z20)((Object)z5.m1(this.m1.EnginePage, z20.class)));
                object.m2("Name", (z16)new z27(this.m1()));
                z1710.addItem(new Operator.BDC(PdfContentEditor.m7, (z9)object));
                z1710.addItem(new Operator.EMC());
                operatorCollection.insert(n, z1710);
            }
            return n != -1;
        }

        public boolean m11() {
            OperatorCollection operatorCollection = this.m12();
            int n = -1;
            for (int i = 1; i <= operatorCollection.size(); ++i) {
                z9 z9100;
                Operator operator = operatorCollection.get_Item(i);
                if (!(operator instanceof Operator.BDC) || !z133.m5(((Operator.BDC)((Object)z5.m1(operator, Operator.BDC.class))).getTag(), PdfContentEditor.m7) || (z9100 = ((Operator.BDC)((Object)z5.m1(operator, Operator.BDC.class))).getPropertiesDictionary()) == null || !z9100.m4("Name") || z9100.m2("Name").m59() == null || !z133.m5(z9100.m2("Name").m59().toString(), this.m1())) continue;
                n = i;
                break;
            }
            if (n != -1) {
                operatorCollection.delete(n);
                if (n <= operatorCollection.size() && operatorCollection.get_Item(n) instanceof Operator.EMC) {
                    operatorCollection.delete(n);
                }
                operatorCollection.insert(n, new Operator.Do(this.m1()));
            }
            return n != -1;
        }
    }
}

