/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.note;

import com.aspose.note.ColorMode;
import com.aspose.note.ImageBinarizationOptions;
import com.aspose.note.SaveOptions;
import com.aspose.note.TiffCompression;
import com.aspose.note.internal.b.dK;
import com.aspose.note.system.drawing.ImageFormat;

public class ImageSaveOptions
extends SaveOptions {
    static final int TiffCompressionDefaultValue = 0;
    static final float DefaultImageResolution = 96.0f;
    static final int ColorModeDefaultValue = 0;
    private ImageBinarizationOptions a;
    private int b;
    private float c;
    private int d;
    private int e;

    public ImageSaveOptions(int format) {
        super(format);
        this.toImageFormat();
        this.setPageCount(1);
        this.setResolution(96.0f);
        this.setQuality(90);
        this.setTiffCompression(0);
        this.setColorMode(0);
    }

    public float getResolution() {
        return this.c;
    }

    public void setResolution(float value) {
        if (value <= 0.0f) {
            throw new IllegalArgumentException("Resolution MUST BE positive");
        }
        this.c = value;
    }

    public final int getQuality() {
        return this.d;
    }

    public final void setQuality(int value) {
        this.d = Math.min(Math.max(value, 1), 100);
    }

    public final int getColorMode() {
        return this.e;
    }

    public final void setColorMode(int value) {
        dK.a(ColorMode.class, value, "ColorMode");
        this.a(value);
        this.e = value;
    }

    public final ImageBinarizationOptions getBinarizationOptions() {
        if (this.a == null) {
            this.a = new ImageBinarizationOptions();
        }
        return this.a;
    }

    public final void setBinarizationOptions(ImageBinarizationOptions value) {
        this.a = value;
    }

    public final int getTiffCompression() {
        return this.b;
    }

    public final void setTiffCompression(int value) {
        dK.a(TiffCompression.class, value, "TiffCompression");
        this.b(value);
        this.b = value;
    }

    ImageFormat toImageFormat() {
        switch (this.getSaveFormat()) {
            case 1: {
                return ImageFormat.getPng();
            }
            case 2: {
                return ImageFormat.getBmp();
            }
            case 3: {
                return ImageFormat.getJpeg();
            }
            case 4: {
                return ImageFormat.getGif();
            }
            case 5: {
                return ImageFormat.getTiff();
            }
        }
        throw new IllegalArgumentException("The argument does not represent an image format.");
    }

    private static void a(int n2, int n3) {
        if (n3 != 2 && (n2 == 1 || n2 == 2 || n2 == 3)) {
            throw new IllegalArgumentException(String.format("%s tiff compression is applied only to black-on-white images.", TiffCompression.getName(TiffCompression.class, n2)));
        }
    }

    private void a(int n2) {
        ImageSaveOptions.a(this.getTiffCompression(), n2);
    }

    private void b(int n2) {
        ImageSaveOptions.a(n2, this.getColorMode());
    }
}

