/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.note;

import java.util.Locale;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;

public final class DocumentPrintAttributeSet
extends HashAttributeSet {
    public DocumentPrintAttributeSet(int copies) {
        this.setCopies(copies);
        this.setPrintRange(1, Integer.MAX_VALUE);
    }

    public DocumentPrintAttributeSet(String printerName, int copies) {
        this(copies);
        this.setPrinterName(printerName);
    }

    public DocumentPrintAttributeSet(String printerName) {
        this(printerName, 1);
    }

    public DocumentPrintAttributeSet() {
        this(1);
    }

    public void setCollate(boolean value) {
        if (value) {
            super.add(SheetCollate.COLLATED);
        } else {
            super.add(SheetCollate.UNCOLLATED);
        }
    }

    public int getCopies() {
        return ((Copies)super.get(Copies.class)).getValue();
    }

    public void setCopies(int value) {
        super.add(new Copies(value));
    }

    public void setDuplex(boolean value) {
        if (value) {
            super.add(Sides.DUPLEX);
        } else {
            super.add(Sides.ONE_SIDED);
        }
    }

    public String getPrinterName() {
        if (super.containsKey(PrinterName.class)) {
            return ((PrinterName)super.get(PrinterName.class)).getValue();
        }
        return "";
    }

    public void setPrinterName(String printerName, Locale locale) {
        super.add(new PrinterName(printerName, locale));
    }

    public void setPrinterName(String printerName) {
        this.setPrinterName(printerName, null);
    }

    public boolean getLandscape() {
        return super.containsValue(OrientationRequested.LANDSCAPE);
    }

    public void setLandscape(boolean value) {
        if (value) {
            super.add(OrientationRequested.LANDSCAPE);
        } else {
            super.add(OrientationRequested.PORTRAIT);
        }
    }

    public void setPrintRange(int from, int to) {
        super.add(new PageRanges(from, to));
    }

    public void setPrintRange(int page) {
        super.add(new PageRanges(page));
    }
}

