/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.system.collections.Generic;

import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.InvalidOperationException;
import com.aspose.imaging.internal.Exceptions.NotImplementedException;
import com.aspose.imaging.internal.li.K;
import com.aspose.imaging.internal.li.aA;
import com.aspose.imaging.internal.li.aD;
import com.aspose.imaging.internal.li.aK;
import com.aspose.imaging.internal.li.bB;
import com.aspose.imaging.internal.li.g;
import com.aspose.imaging.internal.li.z;
import com.aspose.imaging.internal.qm.i;
import com.aspose.imaging.system.IDisposable;
import com.aspose.imaging.system.SerializableAttribute;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerable;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerator;
import com.aspose.imaging.system.collections.Generic.IGenericList;
import com.aspose.imaging.system.collections.Generic.e;
import com.aspose.imaging.system.collections.Generic.f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@SerializableAttribute
public class List<T>
implements IGenericList<T>,
java.util.List<T> {
    private Object[] a;
    private int b;
    private int c;
    @aA
    private final Object d = new Object();
    static Object[] EmptyArray = new Object[0];
    private static final int e = 4;

    public List() {
        this.a = EmptyArray;
    }

    public List(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.a = EmptyArray;
        this.a(collection);
    }

    public List(Collection<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.a = EmptyArray;
        this.addAll((Collection<? extends T>)collection);
    }

    public List(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: capacity");
        }
        this.a = new Object[capacity];
    }

    public List(T[] data) {
        this.a = data;
        this.b = data.length;
    }

    private List(T[] data, int size) {
        this.a = data;
        this.b = size;
    }

    protected int getVersion() {
        return this.c;
    }

    @Override
    public void addItem(T item) {
        if (this.b == this.a.length) {
            this.a(1);
        }
        this.a[this.b++] = item;
        ++this.c;
    }

    private void a(int n2) {
        int n3 = this.b + n2;
        if (n3 > this.a.length) {
            this.setCapacity(Math.max(Math.max(this.getCapacity() * 2, 4), n3));
        }
    }

    private void a(int n2, int n3) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)n2 & 0xFFFFFFFFL) + ((long)n3 & 0xFFFFFFFFL) > ((long)this.b & 0xFFFFFFFFL)) {
            throw new ArgumentException("index and count exceed length of list");
        }
    }

    private void a(IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t2 : iGenericEnumerable) {
            this.addItem(t2);
        }
    }

    public void addRange(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.a(collection);
        ++this.c;
    }

    public void addRange(T[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (T t2 : collection) {
            this.addItem(t2);
        }
        ++this.c;
    }

    public com.aspose.imaging.internal.ll.e<T> asReadOnly() {
        return new com.aspose.imaging.internal.ll.e(this);
    }

    public int binarySearch(T item) {
        return bB.a(this.a, 0, this.b, item);
    }

    public int binarySearch(T item, Comparator<T> comparer) {
        return bB.a(this.a, 0, this.b, item, comparer);
    }

    public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
        this.a(index, count);
        return bB.a(this.a, index, count, item, comparer);
    }

    @Override
    public void clear() {
        bB.b(this.a, 0, this.a.length);
        this.b = 0;
        ++this.c;
    }

    public <TOutput> List<TOutput> convertAll(K<T, TOutput> converter) {
        if (converter == null) {
            throw new ArgumentNullException("converter");
        }
        List<T> list = new List<T>(this.b);
        for (int i2 = 0; i2 < this.b; ++i2) {
            list.a[i2] = converter.a(this.a[i2]);
        }
        list.b = this.b;
        return list;
    }

    public void copyTo(T[] array) {
        g.a(this.a, 0, array, 0, this.b);
    }

    @Override
    public void copyToTArray(T[] array, int arrayIndex) {
        g.a(this.a, 0, array, arrayIndex, this.b);
    }

    public void copyTo(int index, T[] array, int arrayIndex, int count) {
        this.a(index, count);
        g.a(this.a, index, array, arrayIndex, count);
    }

    public boolean exists(aK<T> match) {
        List.checkMatch(match);
        return this.a(0, this.b, match) != -1;
    }

    public T find(aK<T> match) {
        List.checkMatch(match);
        int n2 = this.a(0, this.b, match);
        return (T)(n2 != -1 ? this.a[n2] : null);
    }

    static <T> void checkMatch(aK<T> match) {
        if (match == null) {
            throw new ArgumentNullException("match");
        }
    }

    public List<T> findAll(aK<T> match) {
        List.checkMatch(match);
        return this.a(match);
    }

    private List<T> a(aK<T> aK2) {
        List<Object> list = new List<Object>();
        for (int i2 = 0; i2 < this.b; ++i2) {
            if (!aK2.a(this.a[i2])) continue;
            list.addItem(this.a[i2]);
        }
        return list;
    }

    public int findIndex(aK<T> match) {
        List.checkMatch(match);
        return this.a(0, this.b, match);
    }

    public int findIndex(int startIndex, aK<T> match) {
        List.checkMatch(match);
        this.b(startIndex);
        return this.a(startIndex, this.b - startIndex, match);
    }

    public int findIndex(int startIndex, int count, aK<T> match) {
        List.checkMatch(match);
        this.a(startIndex, count);
        return this.a(startIndex, count, match);
    }

    private int a(int n2, int n3, aK<T> aK2) {
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            if (!aK2.a(this.a[i2])) continue;
            return i2;
        }
        return -1;
    }

    public T findLast(aK<T> match) {
        List.checkMatch(match);
        int n2 = this.b(0, this.b, match);
        if (n2 == -1) {
            return null;
        }
        return this.get_Item(n2);
    }

    public int findLastIndex(aK<T> match) {
        List.checkMatch(match);
        return this.b(0, this.b, match);
    }

    public int findLastIndex(int startIndex, aK<T> match) {
        List.checkMatch(match);
        this.b(startIndex);
        return this.b(0, startIndex + 1, match);
    }

    public int findLastIndex(int startIndex, int count, aK<T> match) {
        List.checkMatch(match);
        int n2 = startIndex - count + 1;
        this.a(n2, count);
        return this.b(n2, count, match);
    }

    private int b(int n2, int n3, aK<T> aK2) {
        int n4 = n2 + n3;
        while (n4 != n2) {
            if (!aK2.a(this.a[--n4])) continue;
            return n4;
        }
        return -1;
    }

    @Override
    public void forEach(com.aspose.imaging.internal.li.a<T> action) {
        if (action == null) {
            throw new ArgumentNullException("action");
        }
        for (int i2 = 0; i2 < this.b; ++i2) {
            action.a(this.a[i2]);
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    public List<T> getRange(int index, int count) {
        this.a(index, count);
        Object[] objectArray = new Object[count];
        g.a(this.a, index, objectArray, 0, count);
        return new List<Object>(objectArray, count);
    }

    @Override
    public int indexOfItem(T item) {
        return g.a(this.a, item, 0, this.b);
    }

    public int indexOf(T item, int index) {
        this.b(index);
        return g.a(this.a, item, index, this.b - index);
    }

    public int indexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.b & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
        }
        return bB.a(this.a, item, index, count);
    }

    private void b(int n2, int n3) {
        if (n3 < 0) {
            n2 -= n3;
        }
        if (n2 < this.b) {
            g.a(this.a, n2, this.a, n2 + n3, this.b - n2);
        }
        this.b += n3;
        if (n3 < 0) {
            bB.b(this.a, this.b, -n3);
        }
    }

    private void b(int n2) {
        if (n2 < 0 || ((long)n2 & 0xFFFFFFFFL) > ((long)this.b & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
    }

    @Override
    public void insertItem(int index, T item) {
        this.b(index);
        if (this.b == this.a.length) {
            this.a(1);
        }
        this.b(index, 1);
        this.a[index] = item;
        ++this.c;
    }

    void insertRangeFromThis(int index) {
        Object[] objectArray = new Object[this.b];
        this.copyToTArray(objectArray, 0);
        this.a(this.b);
        this.b(index, objectArray.length);
        g.b(g.a(objectArray), 0, g.a(this.a), index, objectArray.length);
    }

    public void insertRange(int index, IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.b(index);
        if (collection == this) {
            this.insertRangeFromThis(index);
        } else {
            this.a(index, collection);
        }
        ++this.c;
    }

    private void a(int n2, IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t2 : iGenericEnumerable) {
            this.insertItem(n2++, t2);
        }
    }

    @Override
    public int lastIndexOf(Object item) {
        if (this.b == 0) {
            return -1;
        }
        return bB.b(this.a, item, this.b - 1, this.b);
    }

    public int lastIndexOf(T item, int index) {
        this.b(index);
        return bB.b(this.a, item, index, index + 1);
    }

    public int lastIndexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", index, "index is negative");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", count, "count is negative");
        }
        if (index - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("cound", count, "count is too large");
        }
        return bB.b(this.a, item, index, count);
    }

    @Override
    public boolean removeItem(T item) {
        int n2 = this.indexOfItem(item);
        if (n2 != -1) {
            this.removeAt(n2);
        }
        return n2 != -1;
    }

    public int removeAll(aK<T> match) {
        List.checkMatch(match);
        int n2 = 0;
        int n3 = 0;
        for (n2 = 0; n2 < this.b && !match.a(this.a[n2]); ++n2) {
        }
        if (n2 == this.b) {
            return 0;
        }
        ++this.c;
        for (n3 = n2 + 1; n3 < this.b; ++n3) {
            if (match.a(this.a[n3])) continue;
            this.a[n2++] = this.a[n3];
        }
        if (n3 - n2 > 0) {
            bB.b(this.a, n2, n3 - n2);
        }
        this.b = n2;
        return n3 - n2;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.b & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.b(index, -1);
        bB.b(this.a, this.b, 1);
        ++this.c;
    }

    public void removeRange(int index, int count) {
        this.a(index, count);
        if (count > 0) {
            this.b(index, -count);
            bB.b(this.a, this.b, count);
            ++this.c;
        }
    }

    public void reverse() {
        bB.a(this.a, 0, this.b);
        ++this.c;
    }

    public void reverse(int index, int count) {
        this.a(index, count);
        bB.a(this.a, index, count);
        ++this.c;
    }

    public void sort() {
        Arrays.sort(this.a, 0, this.b);
        ++this.c;
    }

    @Override
    public void sort(Comparator<? super T> comparer) {
        Arrays.sort(this.a, 0, this.b, comparer);
        ++this.c;
    }

    @Override
    public void sort(z<T> comparison) {
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        Arrays.sort(this.a, 0, this.b, new bB.a<T>(comparison));
        ++this.c;
    }

    public void sort(int index, int count, Comparator<T> comparer) {
        this.a(index, count);
        Arrays.sort(this.a, index, index + count, comparer);
        ++this.c;
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        if (a2.length < this.b) {
            return Arrays.copyOf(this.a, this.b, a2.getClass());
        }
        System.arraycopy(this.a, 0, a2, 0, this.b);
        if (a2.length > this.b) {
            a2[this.b] = null;
        }
        return a2;
    }

    public void trimExcess() {
        this.setCapacity(this.b);
    }

    public boolean trueForAll(aK<T> match) {
        List.checkMatch(match);
        for (int i2 = 0; i2 < this.b; ++i2) {
            if (match.a(this.a[i2])) continue;
            return false;
        }
        return true;
    }

    public int getCapacity() {
        return this.a.length;
    }

    public void setCapacity(int value) {
        if (((long)value & 0xFFFFFFFFL) < ((long)this.b & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        this.a = Arrays.copyOf(this.a, value);
    }

    @Override
    public int size() {
        return this.b;
    }

    @Override
    public T get_Item(int index) {
        if (((long)index & 0xFFFFFFFFL) >= ((long)this.b & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        return (T)this.a[index];
    }

    @Override
    public void set_Item(int index, T value) {
        this.b(index);
        if ((long)index == (long)this.b) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.a[index] = value;
        ++this.c;
    }

    public void copyTo(g array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.i() > 1 || array.d(0) != 0) {
            throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
        }
        g.b(g.a(this.a), 0, array, arrayIndex, this.b);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean isSynchronized() {
        return false;
    }

    public Object getSyncRoot() {
        return this.d;
    }

    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.b == 0;
    }

    @Override
    public boolean contains(Object o2) {
        if (o2 == null) {
            for (int i2 = 0; i2 < this.b; ++i2) {
                if (this.a[i2] != null) continue;
                return true;
            }
            return false;
        }
        for (int i3 = 0; i3 < this.b; ++i3) {
            if (!this.a[i3].equals(o2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsItem(T item) {
        if (item == null) {
            for (int i2 = 0; i2 < this.b; ++i2) {
                if (this.a[i2] != null) continue;
                return true;
            }
            return false;
        }
        for (int i3 = 0; i3 < this.b; ++i3) {
            if (!this.a[i3].equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.b];
        System.arraycopy(this.a, 0, objectArray, 0, this.b);
        return objectArray;
    }

    @Override
    public boolean add(T t2) {
        int n2 = this.b;
        this.addItem(t2);
        return n2 != this.b;
    }

    @Override
    public boolean remove(Object o2) {
        int n2 = this.b;
        this.removeItem(o2);
        return n2 != this.b;
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        for (Object obj : c2) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c2) {
        int n2 = 0;
        int n3 = this.size();
        for (T t2 : c2) {
            this.insertItem(n2++, t2);
        }
        return n3 != this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c2) {
        int n2 = index;
        int n3 = this.size();
        for (T t2 : c2) {
            this.insertItem(n2++, t2);
        }
        return n3 != this.size();
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        int n2 = this.size();
        for (Object obj : c2) {
            this.remove(obj);
        }
        return n2 != this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        Object[] objectArray;
        int n2 = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c2.contains(object)) continue;
            this.remove(object);
        }
        return n2 != this.size();
    }

    @Override
    public T get(int index) {
        return this.get_Item(index);
    }

    @Override
    public T set(int index, T element) {
        T t2 = this.get_Item(index);
        this.set_Item(index, element);
        return t2;
    }

    @Override
    public void add(int index, T element) {
        this.insertItem(index, element);
    }

    @Override
    public T remove(int index) {
        T t2 = this.get_Item(index);
        this.removeAt(index);
        return t2;
    }

    @Override
    public int indexOf(Object o2) {
        if (o2 == null) {
            for (int i2 = 0; i2 < this.b; ++i2) {
                if (this.a[i2] != null) continue;
                return i2;
            }
            return -1;
        }
        for (int i3 = 0; i3 < this.b; ++i3) {
            if (!o2.equals(this.a[i3])) continue;
            return i3;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return new c(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new c(index);
    }

    @Override
    public java.util.List<T> subList(int fromIndex, int toIndex) {
        int n2 = toIndex - fromIndex;
        List<T> list = this.getRange(fromIndex, n2);
        return list;
    }

    public static <T> List<T> fromJava(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new b<T>(list);
    }

    public static <T> java.util.List<T> toJava(List<T> list) {
        return list;
    }

    /* synthetic */ List(Object[] x0, int x1, e x2) {
        this(x0, x1);
    }

    static class b<T>
    extends List<T> {
        private final java.util.List<T> a;
        private int b;

        public b() {
            this.a = new ArrayList<T>();
        }

        public b(java.util.List<T> list) {
            super(list.size());
            for (T t2 : list) {
                super.addItem(t2);
            }
            this.a = list;
        }

        public b(IGenericEnumerable<T> iGenericEnumerable) {
            if (iGenericEnumerable == null) {
                throw new ArgumentNullException("collection");
            }
            this.a = new ArrayList<T>();
            this.a(iGenericEnumerable);
        }

        public b(int n2) {
            if (n2 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: capacity");
            }
            this.a = new ArrayList<T>(n2);
        }

        @Override
        protected int getVersion() {
            return this.b;
        }

        @Override
        public void addRange(IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            this.a(collection);
            ++this.b;
        }

        @Override
        public void addRange(T[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            for (T t2 : collection) {
                this.addItem(t2);
            }
            ++this.b;
        }

        @Override
        public com.aspose.imaging.internal.ll.e<T> asReadOnly() {
            return new com.aspose.imaging.internal.ll.e(this);
        }

        @Override
        public int binarySearch(T item) {
            return bB.a(this.a.toArray(), 0, this.a.size(), item);
        }

        @Override
        public int binarySearch(T item, Comparator<T> comparer) {
            return bB.a(this.a.toArray(), 0, this.a.size(), item, comparer);
        }

        @Override
        public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
            this.a(index, count);
            return bB.a(this.a.toArray(), index, count, item, comparer);
        }

        @Override
        private void a(int n2, int n3) {
            if (n2 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (n3 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)n2 & 0xFFFFFFFFL) + ((long)n3 & 0xFFFFFFFFL) > ((long)this.a.size() & 0xFFFFFFFFL)) {
                throw new ArgumentException("index and count exceed length of list");
            }
        }

        @Override
        public <TOutput> List<TOutput> convertAll(K<T, TOutput> converter) {
            if (converter == null) {
                throw new ArgumentNullException("converter");
            }
            int n2 = this.a.size();
            List list = new List(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                list.a[i2] = converter.a(this.get_Item(i2));
            }
            list.b = n2;
            return list;
        }

        @Override
        public void copyTo(T[] array) {
            g.a(this.a.toArray(), 0, array, 0, this.a.size());
        }

        @Override
        public void copyToTArray(T[] array, int arrayIndex) {
            g.a(this.a.toArray(), 0, array, arrayIndex, this.a.size());
        }

        @Override
        public void copyTo(int index, T[] array, int arrayIndex, int count) {
            this.a(index, count);
            g.a(this.a.toArray(), index, array, arrayIndex, count);
        }

        @Override
        public boolean exists(aK<T> match) {
            com.aspose.imaging.system.collections.Generic.List$b.a(match);
            return this.a(0, this.a.size(), match) != -1;
        }

        @Override
        private int a(int n2, int n3, aK<T> aK2) {
            int n4 = n2 + n3;
            for (int i2 = n2; i2 < n4; ++i2) {
                if (!aK2.a(this.a.get(i2))) continue;
                return i2;
            }
            return -1;
        }

        static <T> void a(aK<T> aK2) {
            if (aK2 == null) {
                throw new ArgumentNullException("match");
            }
        }

        @Override
        public T find(aK<T> match) {
            com.aspose.imaging.system.collections.Generic.List$b.a(match);
            int n2 = this.a(0, this.a.size(), match);
            return n2 != -1 ? (T)this.a.get(n2) : null;
        }

        @Override
        public List<T> findAll(aK<T> match) {
            com.aspose.imaging.system.collections.Generic.List$b.a(match);
            return this.b(match);
        }

        private List<T> b(aK<T> aK2) {
            List<T> list = new List<T>();
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!aK2.a(this.a.get(i2))) continue;
                list.addItem(this.a.get(i2));
            }
            return list;
        }

        @Override
        public int findIndex(aK<T> match) {
            com.aspose.imaging.system.collections.Generic.List$b.a(match);
            return this.a(0, this.a.size(), match);
        }

        @Override
        public int findIndex(int startIndex, aK<T> match) {
            com.aspose.imaging.system.collections.Generic.List$b.a(match);
            this.a(startIndex);
            return this.a(startIndex, this.a.size() - startIndex, match);
        }

        @Override
        private void a(int n2) {
            if (n2 < 0 || ((long)n2 & 0xFFFFFFFFL) > ((long)this.a.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
        }

        @Override
        public int findIndex(int startIndex, int count, aK<T> match) {
            com.aspose.imaging.system.collections.Generic.List$b.a(match);
            this.a(startIndex, count);
            return this.a(startIndex, count, match);
        }

        @Override
        public T findLast(aK<T> match) {
            com.aspose.imaging.system.collections.Generic.List$b.a(match);
            int n2 = this.b(0, this.a.size(), match);
            if (n2 == -1) {
                return null;
            }
            return this.get_Item(n2);
        }

        @Override
        private int b(int n2, int n3, aK<T> aK2) {
            int n4 = n2 + n3;
            while (n4 != n2) {
                if (!aK2.a(this.a.get(--n4))) continue;
                return n4;
            }
            return -1;
        }

        @Override
        public int findLastIndex(aK<T> match) {
            com.aspose.imaging.system.collections.Generic.List$b.a(match);
            return this.b(0, this.a.size(), match);
        }

        @Override
        public int findLastIndex(int startIndex, aK<T> match) {
            com.aspose.imaging.system.collections.Generic.List$b.a(match);
            this.a(startIndex);
            return this.b(0, startIndex + 1, match);
        }

        @Override
        public int findLastIndex(int startIndex, int count, aK<T> match) {
            com.aspose.imaging.system.collections.Generic.List$b.a(match);
            int n2 = startIndex - count + 1;
            this.a(n2, count);
            return this.b(n2, count, match);
        }

        @Override
        public void forEach(com.aspose.imaging.internal.li.a<T> action) {
            if (action == null) {
                throw new ArgumentNullException("action");
            }
            int n2 = this.a.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                action.a(this.a.get(i2));
            }
        }

        @Override
        public Enumerator<T> iterator() {
            return new Enumerator(this);
        }

        @Override
        public List<T> getRange(int index, int count) {
            this.a(index, count);
            Object[] objectArray = new Object[count];
            g.b(g.a(this.a.toArray()), index, g.a(objectArray), 0, count);
            return new List(objectArray, count, null);
        }

        @Override
        public int indexOfItem(T item) {
            return this.a.indexOf(item);
        }

        @Override
        public int indexOf(T item, int index) {
            this.a(index);
            return g.a(this.a.toArray(), item, index, this.a.size() - index);
        }

        @Override
        public int indexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.a.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
            }
            return bB.a(this.a.toArray(), item, index, count);
        }

        @Override
        public int lastIndexOf(Object item) {
            if (this.a.size() == 0) {
                return -1;
            }
            return bB.b(this.a.toArray(), item, this.a.size() - 1, this.a.size());
        }

        @Override
        public int lastIndexOf(T item, int index) {
            this.a(index);
            return bB.b(this.a.toArray(), item, index, index + 1);
        }

        @Override
        public int lastIndexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "index is negative");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "count is negative");
            }
            if (index - count + 1 < 0) {
                throw new ArgumentOutOfRangeException("cound", count, "count is too large");
            }
            return bB.b(this.a.toArray(), item, index, count);
        }

        @Override
        public boolean removeItem(T item) {
            int n2 = this.indexOfItem(item);
            if (n2 != -1) {
                this.removeAt(n2);
            }
            return n2 != -1;
        }

        @Override
        public <T1> T1[] toArray(T1[] a2) {
            return this.a.toArray(a2);
        }

        @Override
        public void trimExcess() {
            this.setCapacity(this.a.size());
        }

        @Override
        public boolean trueForAll(aK<T> match) {
            com.aspose.imaging.system.collections.Generic.List$b.a(match);
            int n2 = this.a.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (match.a(this.a.get(i2))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getCapacity() {
            return this.a.size();
        }

        @Override
        public void setCapacity(int value) {
            if (((long)value & 0xFFFFFFFFL) < ((long)this.a.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException();
            }
            int n2 = value - this.a.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.a.add(null);
            }
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public T get_Item(int index) {
            return this.a.get(index);
        }

        @Override
        public void copyTo(g array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.i() > 1 || array.d(0) != 0) {
                throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
            }
            g.b(g.a(this.a.toArray()), 0, array, arrayIndex, this.a.size());
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public boolean contains(Object o2) {
            int n2 = this.a.size();
            if (o2 == null) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.get(i2) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!this.get(i3).equals(o2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsItem(T item) {
            int n2 = this.a.size();
            if (item == null) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.a.get(i2) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!this.a.get(i3).equals(item)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            return this.a.toArray();
        }

        @Override
        public boolean add(T t2) {
            ++this.b;
            return this.a.add(t2);
        }

        @Override
        public boolean remove(Object o2) {
            ++this.b;
            return this.a.remove(o2);
        }

        @Override
        public boolean containsAll(Collection<?> c2) {
            return this.a.containsAll(c2);
        }

        @Override
        public boolean addAll(Collection<? extends T> c2) {
            ++this.b;
            return this.a.addAll(c2);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c2) {
            ++this.b;
            return this.a.addAll(index, c2);
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            ++this.b;
            return this.a.removeAll(c2);
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            ++this.b;
            return this.a.retainAll(c2);
        }

        @Override
        public T get(int index) {
            return this.a.get(index);
        }

        @Override
        public T set(int index, T element) {
            ++this.b;
            return this.a.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            ++this.b;
            this.a.add(index, element);
        }

        @Override
        public T remove(int index) {
            ++this.b;
            return this.a.remove(index);
        }

        @Override
        public int indexOf(Object o2) {
            return this.a.indexOf(o2);
        }

        @Override
        public ListIterator listIterator() {
            return this.a.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.a.listIterator(index);
        }

        @Override
        public java.util.List<T> subList(int fromIndex, int toIndex) {
            return this.a.subList(fromIndex, toIndex);
        }

        @Override
        public void addItem(T item) {
            this.a.add(item);
            ++this.b;
        }

        @Override
        public void clear() {
            this.a.clear();
            ++this.b;
        }

        @Override
        public void insertItem(int index, T item) {
            this.a.add(index, item);
            ++this.b;
        }

        @Override
        public void insertRange(int index, IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            if (index < 0 || ((long)index & 0xFFFFFFFFL) > ((long)this.a.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            int n2 = index;
            if (collection == this) {
                Object[] objectArray = new Object[this.size()];
                this.copyTo(objectArray);
                for (Object object : objectArray) {
                    this.a.add(n2++, object);
                }
            } else {
                for (Object e2 : collection) {
                    this.a.add(n2++, e2);
                }
            }
            ++this.b;
        }

        @Override
        public int removeAll(aK<T> match) {
            com.aspose.imaging.system.collections.Generic.List$b.a(match);
            int n2 = 0;
            int n3 = 0;
            int n4 = this.a.size();
            for (n2 = 0; n2 < n4 && !match.a(this.a.get(n2)); ++n2) {
            }
            if (n2 == n4) {
                return 0;
            }
            ++this.b;
            for (n3 = n2 + 1; n3 < n4; ++n3) {
                if (match.a(this.a.get(n3))) continue;
                this.a.set(n2++, this.a.get(n3));
            }
            if (n3 - n2 > 0) {
                for (int i2 = 0; i2 < n3 - n2; ++i2) {
                    this.a.remove(this.a.size() - 1);
                }
            }
            return n3 - n2;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.a.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.a.remove(index);
            ++this.b;
        }

        @Override
        public void removeRange(int index, int count) {
            this.a(index, count);
            if (count > 0) {
                for (int i2 = 0; i2 < count; ++i2) {
                    this.a.remove(index);
                }
                ++this.b;
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.size());
        }

        @Override
        public void reverse(int index, int count) {
            this.a(index, count);
            int n2 = index;
            for (int i2 = index + count - 1; n2 < i2; ++n2, --i2) {
                T t2 = this.a.get(n2);
                this.a.set(n2, this.a.get(i2));
                this.a.set(i2, t2);
            }
            ++this.b;
        }

        @Override
        public void sort() {
            Collections.sort(this.a, null);
            ++this.b;
        }

        @Override
        public void sort(Comparator<? super T> comparer) {
            Collections.sort(this.a, comparer);
            ++this.b;
        }

        @Override
        public void sort(z<T> tComparison) {
            if (tComparison == null) {
                throw new ArgumentNullException("comparison");
            }
            Collections.sort(this.a, new f(this, tComparison));
            ++this.b;
        }

        @Override
        public void sort(int index, int count, Comparator<T> comparer) {
            this.a(index, count);
            java.util.List<T> list = this.a.subList(index, count);
            Collections.sort(list, comparer);
            for (int i2 = 0; i2 < count; ++i2) {
                this.a.set(index + i2, list.get(i2));
            }
            ++this.b;
        }

        @Override
        public void set_Item(int index, T value) {
            this.a(index);
            if ((long)index == (long)this.a.size()) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.a.set(index, value);
            ++this.b;
        }

        @Override
        private void a(IGenericEnumerable<T> iGenericEnumerable) {
            for (Object t2 : iGenericEnumerable) {
                this.addItem(t2);
            }
        }
    }

    @SerializableAttribute
    public static class Enumerator<T>
    extends i<Enumerator<T>>
    implements IDisposable,
    IGenericEnumerator<T> {
        private List<T> a = new List();
        private int b;
        private int c;
        private T d;

        public Enumerator() {
        }

        Enumerator(List<T> l2) {
            this();
            this.a = l2;
            this.c = l2.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void a() {
            if (this.c != this.a.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.c == this.a.getVersion()) {
                if (this.b < 0) {
                    return false;
                }
                if (this.b < this.a.size()) {
                    this.d = this.a.get_Item(this.b++);
                    return true;
                }
            } else {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.b = this.a.size() + 1;
            return false;
        }

        @Override
        public void reset() {
            this.a();
            this.b = 0;
        }

        @Override
        public T next() {
            if (this.b < 0 || this.b >= this.a.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            return this.d;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator<T> that) {
            that.a = this.a;
            that.b = this.b;
            that.c = this.c;
            that.d = this.d;
        }

        @Override
        public Enumerator<T> Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean a(Enumerator enumerator) {
            return aD.a(enumerator.a, this.a) && enumerator.b == this.b && enumerator.c == this.c && aD.a(enumerator.d, this.d);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (aD.b(null, obj)) {
                return false;
            }
            if (aD.b(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.a((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n2 = this.a != null ? this.a.hashCode() : 0;
            n2 = 31 * n2 + this.b;
            n2 = 31 * n2 + this.c;
            n2 = 31 * n2 + (this.d != null ? this.d.hashCode() : 0);
            return n2;
        }
    }

    private class c
    extends a<T>
    implements ListIterator<T> {
        c(int n2) {
            super(null);
            this.a = n2;
        }

        @Override
        public boolean hasPrevious() {
            return this.a != 0;
        }

        @Override
        public int nextIndex() {
            return this.a;
        }

        @Override
        public int previousIndex() {
            return this.a - 1;
        }

        @Override
        public T previous() {
            int n2 = this.a - 1;
            if (n2 < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.a;
            if (n2 >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.a = n2;
            this.b = n2;
            return objectArray[this.b];
        }

        @Override
        public void set(T e2) {
            if (this.b < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.set(this.b, e2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(T e2) {
            try {
                int n2 = this.a;
                List.this.add(n2, e2);
                this.a = n2 + 1;
                this.b = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class a<T>
    implements Iterator<T> {
        int a;
        int b = -1;

        private a() {
        }

        @Override
        public boolean hasNext() {
            return this.a != List.this.b;
        }

        @Override
        public T next() {
            int n2 = this.a;
            if (n2 >= List.this.b) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.a;
            if (n2 >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.a = n2 + 1;
            this.b = n2;
            return (T)objectArray[this.b];
        }

        @Override
        public void remove() {
            if (this.b < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.remove(this.b);
                this.a = this.b;
                this.b = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        /* synthetic */ a(e e2) {
            this();
        }
    }
}

