/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.x509;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.DERBitString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.TBSCertificate;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Time;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.V1TBSCertificateGenerator;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.X509Name;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory;
import com.aspose.imaging.internal.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.aspose.imaging.internal.bouncycastle.jcajce.util.JcaJceHelper;
import com.aspose.imaging.internal.bouncycastle.jce.X509Principal;
import com.aspose.imaging.internal.bouncycastle.x509.c;
import com.aspose.imaging.internal.bouncycastle.x509.e;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;

public class X509V1CertificateGenerator {
    private final JcaJceHelper a = new BCJcaJceHelper();
    private final CertificateFactory b = new CertificateFactory();
    private V1TBSCertificateGenerator c = new V1TBSCertificateGenerator();
    private ASN1ObjectIdentifier d;
    private AlgorithmIdentifier e;
    private String f;

    public void reset() {
        this.c = new V1TBSCertificateGenerator();
    }

    public void setSerialNumber(BigInteger bigInteger) {
        if (bigInteger.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException("serial number must be a positive integer");
        }
        this.c.setSerialNumber(new ASN1Integer(bigInteger));
    }

    public void setIssuerDN(X500Principal x500Principal) {
        try {
            this.c.setIssuer(new X509Principal(x500Principal.getEncoded()));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("can't process principal: " + iOException);
        }
    }

    public void setIssuerDN(X509Name x509Name) {
        this.c.setIssuer(x509Name);
    }

    public void setNotBefore(Date date) {
        this.c.setStartDate(new Time(date));
    }

    public void setNotAfter(Date date) {
        this.c.setEndDate(new Time(date));
    }

    public void setSubjectDN(X500Principal x500Principal) {
        try {
            this.c.setSubject(new X509Principal(x500Principal.getEncoded()));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("can't process principal: " + iOException);
        }
    }

    public void setSubjectDN(X509Name x509Name) {
        this.c.setSubject(x509Name);
    }

    public void setPublicKey(PublicKey publicKey) {
        try {
            this.c.setSubjectPublicKeyInfo(SubjectPublicKeyInfo.getInstance(publicKey.getEncoded()));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("unable to process key - " + exception.toString());
        }
    }

    public void setSignatureAlgorithm(String string) {
        this.f = string;
        try {
            this.d = com.aspose.imaging.internal.bouncycastle.x509.e.a(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unknown signature type requested");
        }
        this.e = com.aspose.imaging.internal.bouncycastle.x509.e.a(this.d, string);
        this.c.setSignature(this.e);
    }

    public X509Certificate generateX509Certificate(PrivateKey privateKey) throws SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generateX509Certificate(privateKey, "BC", null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SecurityException("BC provider not installed!");
        }
    }

    public X509Certificate generateX509Certificate(PrivateKey privateKey, SecureRandom secureRandom) throws SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generateX509Certificate(privateKey, "BC", secureRandom);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SecurityException("BC provider not installed!");
        }
    }

    public X509Certificate generateX509Certificate(PrivateKey privateKey, String string) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        return this.generateX509Certificate(privateKey, string, null);
    }

    public X509Certificate generateX509Certificate(PrivateKey privateKey, String string, SecureRandom secureRandom) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generate(privateKey, string, secureRandom);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
        catch (SignatureException signatureException) {
            throw signatureException;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SecurityException("exception: " + generalSecurityException);
        }
    }

    public X509Certificate generate(PrivateKey privateKey) throws CertificateEncodingException, IllegalStateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        return this.generate(privateKey, (SecureRandom)null);
    }

    public X509Certificate generate(PrivateKey privateKey, SecureRandom secureRandom) throws CertificateEncodingException, IllegalStateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        byte[] byArray;
        TBSCertificate tBSCertificate = this.c.generateTBSCertificate();
        try {
            byArray = com.aspose.imaging.internal.bouncycastle.x509.e.a(this.d, this.f, privateKey, secureRandom, tBSCertificate);
        }
        catch (IOException iOException) {
            throw new c("exception encoding TBS cert", iOException);
        }
        return this.a(tBSCertificate, byArray);
    }

    public X509Certificate generate(PrivateKey privateKey, String string) throws CertificateEncodingException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        return this.generate(privateKey, string, null);
    }

    public X509Certificate generate(PrivateKey privateKey, String string, SecureRandom secureRandom) throws CertificateEncodingException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        byte[] byArray;
        TBSCertificate tBSCertificate = this.c.generateTBSCertificate();
        try {
            byArray = com.aspose.imaging.internal.bouncycastle.x509.e.a(this.d, this.f, string, privateKey, secureRandom, tBSCertificate);
        }
        catch (IOException iOException) {
            throw new c("exception encoding TBS cert", iOException);
        }
        return this.a(tBSCertificate, byArray);
    }

    private X509Certificate a(TBSCertificate tBSCertificate, byte[] byArray) throws CertificateEncodingException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(tBSCertificate);
        aSN1EncodableVector.add(this.e);
        aSN1EncodableVector.add(new DERBitString(byArray));
        try {
            return (X509Certificate)this.b.engineGenerateCertificate(new ByteArrayInputStream(new DERSequence(aSN1EncodableVector).getEncoded("DER")));
        }
        catch (Exception exception) {
            throw new c("exception producing certificate object", exception);
        }
    }

    public Iterator getSignatureAlgNames() {
        return com.aspose.imaging.internal.bouncycastle.x509.e.a();
    }
}

