/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.tsp.cms;

import com.aspose.imaging.internal.bouncycastle.asn1.DERIA5String;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.AttributeTable;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.ContentInfoParser;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.TimeStampedDataParser;
import com.aspose.imaging.internal.bouncycastle.cms.CMSContentInfoParser;
import com.aspose.imaging.internal.bouncycastle.cms.CMSException;
import com.aspose.imaging.internal.bouncycastle.operator.DigestCalculator;
import com.aspose.imaging.internal.bouncycastle.operator.DigestCalculatorProvider;
import com.aspose.imaging.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.imaging.internal.bouncycastle.tsp.TimeStampToken;
import com.aspose.imaging.internal.bouncycastle.tsp.cms.ImprintDigestInvalidException;
import com.aspose.imaging.internal.bouncycastle.tsp.cms.b;
import com.aspose.imaging.internal.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;

public class CMSTimeStampedDataParser
extends CMSContentInfoParser {
    private TimeStampedDataParser a;
    private b b;

    public CMSTimeStampedDataParser(InputStream inputStream) throws CMSException {
        super(inputStream);
        this.a(this._contentInfo);
    }

    public CMSTimeStampedDataParser(byte[] byArray) throws CMSException {
        this(new ByteArrayInputStream(byArray));
    }

    private void a(ContentInfoParser contentInfoParser) throws CMSException {
        try {
            if (!CMSObjectIdentifiers.timestampedData.equals(contentInfoParser.getContentType())) {
                throw new IllegalArgumentException("Malformed content - type must be " + CMSObjectIdentifiers.timestampedData.getId());
            }
            this.a = TimeStampedDataParser.getInstance(contentInfoParser.getContent(16));
        }
        catch (IOException iOException) {
            throw new CMSException("parsing exception: " + iOException.getMessage(), iOException);
        }
    }

    public byte[] calculateNextHash(DigestCalculator digestCalculator) throws CMSException {
        return this.b.b(digestCalculator);
    }

    public InputStream getContent() {
        if (this.a.getContent() != null) {
            return this.a.getContent().getOctetStream();
        }
        return null;
    }

    public URI getDataUri() throws URISyntaxException {
        DERIA5String dERIA5String = this.a.getDataUri();
        if (dERIA5String != null) {
            return new URI(dERIA5String.getString());
        }
        return null;
    }

    public String getFileName() {
        return this.b.c();
    }

    public String getMediaType() {
        return this.b.d();
    }

    public AttributeTable getOtherMetaData() {
        return this.b.e();
    }

    public void initialiseMessageImprintDigestCalculator(DigestCalculator digestCalculator) throws CMSException {
        this.b.a(digestCalculator);
    }

    public DigestCalculator getMessageImprintDigestCalculator(DigestCalculatorProvider digestCalculatorProvider) throws OperatorCreationException {
        try {
            this.a();
        }
        catch (CMSException cMSException) {
            throw new OperatorCreationException("unable to extract algorithm ID: " + cMSException.getMessage(), cMSException);
        }
        return this.b.a(digestCalculatorProvider);
    }

    public TimeStampToken[] getTimeStampTokens() throws CMSException {
        this.a();
        return this.b.a();
    }

    public void validate(DigestCalculatorProvider digestCalculatorProvider, byte[] byArray) throws ImprintDigestInvalidException, CMSException {
        this.a();
        this.b.a(digestCalculatorProvider, byArray);
    }

    public void validate(DigestCalculatorProvider digestCalculatorProvider, byte[] byArray, TimeStampToken timeStampToken) throws ImprintDigestInvalidException, CMSException {
        this.a();
        this.b.a(digestCalculatorProvider, byArray, timeStampToken);
    }

    private void a() throws CMSException {
        try {
            if (this.b == null) {
                InputStream inputStream = this.getContent();
                if (inputStream != null) {
                    Streams.drain(inputStream);
                }
                this.b = new b(this.a);
            }
        }
        catch (IOException iOException) {
            throw new CMSException("unable to parse evidence block: " + iOException.getMessage(), iOException);
        }
    }
}

