/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.tsp;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Boolean;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.DERNull;
import com.aspose.imaging.internal.bouncycastle.asn1.tsp.MessageImprint;
import com.aspose.imaging.internal.bouncycastle.asn1.tsp.TimeStampReq;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.ExtensionsGenerator;
import com.aspose.imaging.internal.bouncycastle.tsp.TSPIOException;
import com.aspose.imaging.internal.bouncycastle.tsp.TSPUtil;
import com.aspose.imaging.internal.bouncycastle.tsp.TimeStampRequest;
import java.io.IOException;
import java.math.BigInteger;

public class TimeStampRequestGenerator {
    private ASN1ObjectIdentifier a;
    private ASN1Boolean b;
    private ExtensionsGenerator c = new ExtensionsGenerator();

    public void setReqPolicy(String string) {
        this.a = new ASN1ObjectIdentifier(string);
    }

    public void setReqPolicy(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.a = aSN1ObjectIdentifier;
    }

    public void setCertReq(boolean bl2) {
        this.b = ASN1Boolean.getInstance(bl2);
    }

    public void addExtension(String string, boolean bl2, ASN1Encodable aSN1Encodable) throws IOException {
        this.addExtension(string, bl2, aSN1Encodable.toASN1Primitive().getEncoded());
    }

    public void addExtension(String string, boolean bl2, byte[] byArray) {
        this.c.addExtension(new ASN1ObjectIdentifier(string), bl2, byArray);
    }

    public void addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, ASN1Encodable aSN1Encodable) throws TSPIOException {
        TSPUtil.addExtension(this.c, aSN1ObjectIdentifier, bl2, aSN1Encodable);
    }

    public void addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, byte[] byArray) {
        this.c.addExtension(aSN1ObjectIdentifier, bl2, byArray);
    }

    public TimeStampRequest generate(String string, byte[] byArray) {
        return this.generate(string, byArray, null);
    }

    public TimeStampRequest generate(String string, byte[] byArray, BigInteger bigInteger) {
        if (string == null) {
            throw new IllegalArgumentException("No digest algorithm specified");
        }
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(aSN1ObjectIdentifier, DERNull.INSTANCE);
        MessageImprint messageImprint = new MessageImprint(algorithmIdentifier, byArray);
        Extensions extensions = null;
        if (!this.c.isEmpty()) {
            extensions = this.c.generate();
        }
        if (bigInteger != null) {
            return new TimeStampRequest(new TimeStampReq(messageImprint, this.a, new ASN1Integer(bigInteger), this.b, extensions));
        }
        return new TimeStampRequest(new TimeStampReq(messageImprint, this.a, null, this.b, extensions));
    }

    public TimeStampRequest generate(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray) {
        return this.generate(aSN1ObjectIdentifier.getId(), byArray);
    }

    public TimeStampRequest generate(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray, BigInteger bigInteger) {
        return this.generate(aSN1ObjectIdentifier.getId(), byArray, bigInteger);
    }
}

