/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.pqc.jcajce.provider.sphincs;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.jcajce.interfaces.SPHINCSKey;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.PublicKey;

public class BCSphincs256PublicKey
implements SPHINCSKey,
PublicKey {
    private static final long a = 1L;
    private final ASN1ObjectIdentifier b;
    private final SPHINCSPublicKeyParameters c;

    public BCSphincs256PublicKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, SPHINCSPublicKeyParameters sPHINCSPublicKeyParameters) {
        this.b = aSN1ObjectIdentifier;
        this.c = sPHINCSPublicKeyParameters;
    }

    public BCSphincs256PublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.b = SPHINCS256KeyParams.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters()).getTreeDigest().getAlgorithm();
        this.c = new SPHINCSPublicKeyParameters(subjectPublicKeyInfo.getPublicKeyData().getBytes());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSphincs256PublicKey) {
            BCSphincs256PublicKey bCSphincs256PublicKey = (BCSphincs256PublicKey)object;
            return this.b.equals(bCSphincs256PublicKey.b) && Arrays.areEqual(this.c.getKeyData(), bCSphincs256PublicKey.c.getKeyData());
        }
        return false;
    }

    public int hashCode() {
        return this.b.hashCode() + 37 * Arrays.hashCode(this.c.getKeyData());
    }

    @Override
    public final String getAlgorithm() {
        return "SPHINCS-256";
    }

    @Override
    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(new AlgorithmIdentifier(this.b)));
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, this.c.getKeyData());
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getKeyData() {
        return this.c.getKeyData();
    }

    CipherParameters getKeyParams() {
        return this.c;
    }
}

