/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.pqc.jcajce.provider.mceliece;

import com.aspose.imaging.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.mceliece.McElieceKeyGenerationParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.mceliece.McElieceKeyPairGenerator;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.mceliece.McElieceParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.mceliece.McEliecePublicKeyParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePrivateKey;
import com.aspose.imaging.internal.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePublicKey;
import com.aspose.imaging.internal.bouncycastle.pqc.jcajce.spec.McElieceKeyGenParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class McElieceKeyPairGeneratorSpi
extends KeyPairGenerator {
    McElieceKeyPairGenerator kpg;

    public McElieceKeyPairGeneratorSpi() {
        super("McEliece");
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.kpg = new McElieceKeyPairGenerator();
        super.initialize(algorithmParameterSpec);
        McElieceKeyGenParameterSpec mcElieceKeyGenParameterSpec = (McElieceKeyGenParameterSpec)algorithmParameterSpec;
        McElieceKeyGenerationParameters mcElieceKeyGenerationParameters = new McElieceKeyGenerationParameters(new SecureRandom(), new McElieceParameters(mcElieceKeyGenParameterSpec.getM(), mcElieceKeyGenParameterSpec.getT()));
        this.kpg.init(mcElieceKeyGenerationParameters);
    }

    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        McElieceKeyGenParameterSpec mcElieceKeyGenParameterSpec = new McElieceKeyGenParameterSpec();
        try {
            this.initialize(mcElieceKeyGenParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.kpg.generateKeyPair();
        McEliecePrivateKeyParameters mcEliecePrivateKeyParameters = (McEliecePrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        McEliecePublicKeyParameters mcEliecePublicKeyParameters = (McEliecePublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        return new KeyPair(new BCMcEliecePublicKey(mcEliecePublicKeyParameters), new BCMcEliecePrivateKey(mcEliecePrivateKeyParameters));
    }
}

