/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.pqc.crypto.newhope;

import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.imaging.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.aspose.imaging.internal.bouncycastle.crypto.KeyGenerationParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.util.DEROtherInfo;
import com.aspose.imaging.internal.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.ExchangePair;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.newhope.NHAgreement;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.newhope.NHExchangePairGenerator;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.newhope.NHKeyPairGenerator;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import java.io.IOException;
import java.security.SecureRandom;

public class NHOtherInfoGenerator {
    protected final DEROtherInfo.Builder otherInfoBuilder;
    protected final SecureRandom random;

    public NHOtherInfoGenerator(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        this.otherInfoBuilder = new DEROtherInfo.Builder(algorithmIdentifier, byArray, byArray2);
        this.random = secureRandom;
    }

    private static byte[] a(NHPublicKeyParameters nHPublicKeyParameters) {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, nHPublicKeyParameters.getPubData());
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static NHPublicKeyParameters a(byte[] byArray) {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(byArray);
        return new NHPublicKeyParameters(subjectPublicKeyInfo.getPublicKeyData().getOctets());
    }

    public static class PartyU
    extends NHOtherInfoGenerator {
        private AsymmetricCipherKeyPair a;
        private NHAgreement b = new NHAgreement();

        public PartyU(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
            super(algorithmIdentifier, byArray, byArray2, secureRandom);
            NHKeyPairGenerator nHKeyPairGenerator = new NHKeyPairGenerator();
            nHKeyPairGenerator.init(new KeyGenerationParameters(secureRandom, 2048));
            this.a = nHKeyPairGenerator.generateKeyPair();
            this.b.init(this.a.getPrivate());
        }

        public NHOtherInfoGenerator withSuppPubInfo(byte[] byArray) {
            this.otherInfoBuilder.withSuppPubInfo(byArray);
            return this;
        }

        public byte[] getSuppPrivInfoPartA() {
            return NHOtherInfoGenerator.a((NHPublicKeyParameters)this.a.getPublic());
        }

        public DEROtherInfo generate(byte[] byArray) {
            this.otherInfoBuilder.withSuppPrivInfo(this.b.calculateAgreement(NHOtherInfoGenerator.a(byArray)));
            return this.otherInfoBuilder.build();
        }
    }

    public static class PartyV
    extends NHOtherInfoGenerator {
        public PartyV(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
            super(algorithmIdentifier, byArray, byArray2, secureRandom);
        }

        public NHOtherInfoGenerator withSuppPubInfo(byte[] byArray) {
            this.otherInfoBuilder.withSuppPubInfo(byArray);
            return this;
        }

        public byte[] getSuppPrivInfoPartB(byte[] byArray) {
            NHExchangePairGenerator nHExchangePairGenerator = new NHExchangePairGenerator(this.random);
            ExchangePair exchangePair = nHExchangePairGenerator.generateExchange(NHOtherInfoGenerator.a(byArray));
            this.otherInfoBuilder.withSuppPrivInfo(exchangePair.getSharedValue());
            return NHOtherInfoGenerator.a((NHPublicKeyParameters)exchangePair.getPublicKey());
        }

        public DEROtherInfo generate() {
            return this.otherInfoBuilder.build();
        }
    }
}

