/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.pkcs;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.ContentInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.SafeBag;
import com.aspose.imaging.internal.bouncycastle.cms.CMSEncryptedData;
import com.aspose.imaging.internal.bouncycastle.cms.CMSException;
import com.aspose.imaging.internal.bouncycastle.operator.InputDecryptorProvider;
import com.aspose.imaging.internal.bouncycastle.pkcs.PKCS12SafeBag;
import com.aspose.imaging.internal.bouncycastle.pkcs.PKCSException;

public class PKCS12SafeBagFactory {
    private ASN1Sequence a;

    public PKCS12SafeBagFactory(ContentInfo contentInfo) {
        if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.encryptedData)) {
            throw new IllegalArgumentException("encryptedData requires constructor with decryptor.");
        }
        this.a = ASN1Sequence.getInstance(ASN1OctetString.getInstance(contentInfo.getContent()).getOctets());
    }

    public PKCS12SafeBagFactory(ContentInfo contentInfo, InputDecryptorProvider inputDecryptorProvider) throws PKCSException {
        if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.encryptedData)) {
            CMSEncryptedData cMSEncryptedData = new CMSEncryptedData(com.aspose.imaging.internal.bouncycastle.asn1.cms.ContentInfo.getInstance(contentInfo));
            try {
                this.a = ASN1Sequence.getInstance(cMSEncryptedData.getContent(inputDecryptorProvider));
            }
            catch (CMSException cMSException) {
                throw new PKCSException("unable to extract data: " + cMSException.getMessage(), cMSException);
            }
            return;
        }
        throw new IllegalArgumentException("encryptedData requires constructor with decryptor.");
    }

    public PKCS12SafeBag[] getSafeBags() {
        PKCS12SafeBag[] pKCS12SafeBagArray = new PKCS12SafeBag[this.a.size()];
        for (int i2 = 0; i2 != this.a.size(); ++i2) {
            pKCS12SafeBagArray[i2] = new PKCS12SafeBag(SafeBag.getInstance(this.a.getObjectAt(i2)));
        }
        return pKCS12SafeBagArray;
    }
}

