/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.math.ec.custom.sec;

import com.aspose.imaging.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECFieldElement;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECLookupTable;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECMultiplier;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.imaging.internal.bouncycastle.math.ec.WTauNafMultiplier;
import com.aspose.imaging.internal.bouncycastle.math.ec.custom.sec.C;
import com.aspose.imaging.internal.bouncycastle.math.ec.custom.sec.SecT571FieldElement;
import com.aspose.imaging.internal.bouncycastle.math.ec.custom.sec.SecT571K1Point;
import com.aspose.imaging.internal.bouncycastle.math.raw.Nat576;
import com.aspose.imaging.internal.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT571K1Curve
extends ECCurve.AbstractF2m {
    private static final int c = 6;
    protected SecT571K1Point infinity = new SecT571K1Point(this, null, null);

    public SecT571K1Curve() {
        super(571, 2, 5, 10);
        this.a = this.fromBigInteger(BigInteger.valueOf(0L));
        this.b = this.fromBigInteger(BigInteger.valueOf(1L));
        this.order = new BigInteger(1, Hex.decode("020000000000000000000000000000000000000000000000000000000000000000000000131850E1F19A63E4B391A8DB917F4138B630D84BE5D639381E91DEB45CFE778F637C1001"));
        this.cofactor = BigInteger.valueOf(4L);
        this.coord = 6;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecT571K1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n2) {
        switch (n2) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected ECMultiplier createDefaultMultiplier() {
        return new WTauNafMultiplier();
    }

    @Override
    public int getFieldSize() {
        return 571;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT571FieldElement(bigInteger);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl2) {
        return new SecT571K1Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl2);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl2) {
        return new SecT571K1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl2);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return true;
    }

    public int getM() {
        return 571;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 2;
    }

    public int getK2() {
        return 5;
    }

    public int getK3() {
        return 10;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n2, int n3) {
        long[] lArray = new long[n3 * 9 * 2];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ECPoint eCPoint = eCPointArray[n2 + i2];
            Nat576.copy64(((SecT571FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n4);
            Nat576.copy64(((SecT571FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n4 += 9);
            n4 += 9;
        }
        return new C(this, n3, lArray);
    }
}

