/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.math.ec.custom.sec;

import com.aspose.imaging.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECFieldElement;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECLookupTable;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.imaging.internal.bouncycastle.math.ec.custom.sec.SecP160R1FieldElement;
import com.aspose.imaging.internal.bouncycastle.math.ec.custom.sec.SecP160R1Point;
import com.aspose.imaging.internal.bouncycastle.math.ec.custom.sec.c;
import com.aspose.imaging.internal.bouncycastle.math.raw.Nat160;
import com.aspose.imaging.internal.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP160R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFF"));
    private static final int c = 2;
    protected SecP160R1Point infinity = new SecP160R1Point(this, null, null);

    public SecP160R1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("1C97BEFC54BD7A8B65ACF89F81D4D4ADC565FA45")));
        this.order = new BigInteger(1, Hex.decode("0100000000000000000001F4C8F927AED3CA752257"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecP160R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n2) {
        switch (n2) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP160R1FieldElement(bigInteger);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl2) {
        return new SecP160R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl2);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl2) {
        return new SecP160R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl2);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n2, int n3) {
        int[] nArray = new int[n3 * 5 * 2];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ECPoint eCPoint = eCPointArray[n2 + i2];
            Nat160.copy(((SecP160R1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n4);
            Nat160.copy(((SecP160R1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n4 += 5);
            n4 += 5;
        }
        return new c(this, n3, nArray);
    }
}

