/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.math.ec;

import com.aspose.imaging.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.imaging.internal.bouncycastle.math.ec.FixedPointPreCompInfo;
import com.aspose.imaging.internal.bouncycastle.math.ec.PreCompInfo;
import java.math.BigInteger;

public class FixedPointUtil {
    public static final String PRECOMP_NAME = "bc_fixed_point";

    public static int getCombSize(ECCurve eCCurve) {
        BigInteger bigInteger = eCCurve.getOrder();
        return bigInteger == null ? eCCurve.getFieldSize() + 1 : bigInteger.bitLength();
    }

    public static FixedPointPreCompInfo getFixedPointPreCompInfo(PreCompInfo preCompInfo) {
        if (preCompInfo != null && preCompInfo instanceof FixedPointPreCompInfo) {
            return (FixedPointPreCompInfo)preCompInfo;
        }
        return new FixedPointPreCompInfo();
    }

    public static FixedPointPreCompInfo precompute(ECPoint eCPoint, int n2) {
        return FixedPointUtil.precompute(eCPoint);
    }

    public static FixedPointPreCompInfo precompute(ECPoint eCPoint) {
        ECCurve eCCurve = eCPoint.getCurve();
        int n2 = FixedPointUtil.getCombSize(eCCurve) > 257 ? 6 : 5;
        int n3 = 1 << n2;
        FixedPointPreCompInfo fixedPointPreCompInfo = FixedPointUtil.getFixedPointPreCompInfo(eCCurve.getPreCompInfo(eCPoint, PRECOMP_NAME));
        ECPoint[] eCPointArray = fixedPointPreCompInfo.getPreComp();
        if (eCPointArray == null || eCPointArray.length < n3) {
            int n4;
            int n5 = FixedPointUtil.getCombSize(eCCurve);
            int n6 = (n5 + n2 - 1) / n2;
            ECPoint[] eCPointArray2 = new ECPoint[n2 + 1];
            eCPointArray2[0] = eCPoint;
            for (n4 = 1; n4 < n2; ++n4) {
                eCPointArray2[n4] = eCPointArray2[n4 - 1].timesPow2(n6);
            }
            eCPointArray2[n2] = eCPointArray2[0].subtract(eCPointArray2[1]);
            eCCurve.normalizeAll(eCPointArray2);
            eCPointArray = new ECPoint[n3];
            eCPointArray[0] = eCPointArray2[0];
            for (n4 = n2 - 1; n4 >= 0; --n4) {
                int n7;
                ECPoint eCPoint2 = eCPointArray2[n4];
                for (int i2 = n7 = 1 << n4; i2 < n3; i2 += n7 << 1) {
                    eCPointArray[i2] = eCPointArray[i2 - n7].add(eCPoint2);
                }
            }
            eCCurve.normalizeAll(eCPointArray);
            fixedPointPreCompInfo.setLookupTable(eCCurve.createCacheSafeLookupTable(eCPointArray, 0, eCPointArray.length));
            fixedPointPreCompInfo.setOffset(eCPointArray2[n2]);
            fixedPointPreCompInfo.setPreComp(eCPointArray);
            fixedPointPreCompInfo.setWidth(n2);
            eCCurve.setPreCompInfo(eCPoint, PRECOMP_NAME, fixedPointPreCompInfo);
        }
        return fixedPointPreCompInfo;
    }
}

