/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.jcajce.provider.digest;

import com.aspose.imaging.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherKeyGenerator;
import com.aspose.imaging.internal.bouncycastle.crypto.digests.SHA512Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.digests.SHA512tDigest;
import com.aspose.imaging.internal.bouncycastle.crypto.macs.HMac;
import com.aspose.imaging.internal.bouncycastle.crypto.macs.OldHMac;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.digest.a;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class SHA512 {
    private SHA512() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new SHA512Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest digest = (Digest)super.clone();
            digest.digest = new SHA512Digest((SHA512Digest)this.digest);
            return digest;
        }
    }

    public static class DigestT
    extends BCMessageDigest
    implements Cloneable {
        public DigestT(int n2) {
            super(new SHA512tDigest(n2));
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            DigestT digestT = (DigestT)super.clone();
            digestT.digest = new SHA512tDigest((SHA512tDigest)this.digest);
            return digestT;
        }
    }

    public static class DigestT224
    extends DigestT {
        public DigestT224() {
            super(224);
        }
    }

    public static class DigestT256
    extends DigestT {
        public DigestT256() {
            super(256);
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new SHA512Digest()));
        }
    }

    public static class HashMacT224
    extends BaseMac {
        public HashMacT224() {
            super(new HMac(new SHA512tDigest(224)));
        }
    }

    public static class HashMacT256
    extends BaseMac {
        public HashMacT256() {
            super(new HMac(new SHA512tDigest(256)));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACSHA512", 512, new CipherKeyGenerator());
        }
    }

    public static class KeyGeneratorT224
    extends BaseKeyGenerator {
        public KeyGeneratorT224() {
            super("HMACSHA512/224", 224, new CipherKeyGenerator());
        }
    }

    public static class KeyGeneratorT256
    extends BaseKeyGenerator {
        public KeyGeneratorT256() {
            super("HMACSHA512/256", 256, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends a {
        private static final String a = SHA512.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.SHA-512", a + "$Digest");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest.SHA512", "SHA-512");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha512, "SHA-512");
            configurableProvider.addAlgorithm("MessageDigest.SHA-512/224", a + "$DigestT224");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest.SHA512/224", "SHA-512/224");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha512_224, "SHA-512/224");
            configurableProvider.addAlgorithm("MessageDigest.SHA-512/256", a + "$DigestT256");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest.SHA512256", "SHA-512/256");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha512_256, "SHA-512/256");
            configurableProvider.addAlgorithm("Mac.OLDHMACSHA512", a + "$OldSHA512");
            configurableProvider.addAlgorithm("Mac.PBEWITHHMACSHA512", a + "$HashMac");
            this.addHMACAlgorithm(configurableProvider, "SHA512", a + "$HashMac", a + "$KeyGenerator");
            this.addHMACAlias(configurableProvider, "SHA512", PKCSObjectIdentifiers.id_hmacWithSHA512);
            this.addHMACAlgorithm(configurableProvider, "SHA512/224", a + "$HashMacT224", a + "$KeyGeneratorT224");
            this.addHMACAlgorithm(configurableProvider, "SHA512/256", a + "$HashMacT256", a + "$KeyGeneratorT256");
        }
    }

    public static class OldSHA512
    extends BaseMac {
        public OldSHA512() {
            super(new OldHMac(new SHA512Digest()));
        }
    }
}

