/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.x509;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.SignedData;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.CertificateList;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.x509.PKIXCertPath;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.x509.b;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.x509.d;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.x509.e;
import com.aspose.imaging.internal.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.aspose.imaging.internal.bouncycastle.jcajce.util.JcaJceHelper;
import com.aspose.imaging.internal.bouncycastle.util.io.Streams;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CertificateFactory
extends CertificateFactorySpi {
    private final JcaJceHelper a = new BCJcaJceHelper();
    private static final b b = new b("CERTIFICATE");
    private static final b c = new b("CRL");
    private static final b d = new b("PKCS7");
    private ASN1Set e = null;
    private int f = 0;
    private InputStream g = null;
    private ASN1Set h = null;
    private int i = 0;
    private InputStream j = null;

    private Certificate a(ASN1InputStream aSN1InputStream) throws IOException, CertificateParsingException {
        return this.a(ASN1Sequence.getInstance(aSN1InputStream.readObject()));
    }

    private Certificate a(InputStream inputStream) throws IOException, CertificateParsingException {
        return this.a(b.a(inputStream));
    }

    private Certificate a(ASN1Sequence aSN1Sequence) throws CertificateParsingException {
        if (aSN1Sequence == null) {
            return null;
        }
        if (aSN1Sequence.size() > 1 && aSN1Sequence.getObjectAt(0) instanceof ASN1ObjectIdentifier && aSN1Sequence.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.e = SignedData.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true)).getCertificates();
            return this.a();
        }
        return new e(this.a, com.aspose.imaging.internal.bouncycastle.asn1.x509.Certificate.getInstance(aSN1Sequence));
    }

    private Certificate a() throws CertificateParsingException {
        if (this.e != null) {
            while (this.f < this.e.size()) {
                ASN1Encodable aSN1Encodable;
                if (!((aSN1Encodable = this.e.getObjectAt(this.f++)) instanceof ASN1Sequence)) continue;
                return new e(this.a, com.aspose.imaging.internal.bouncycastle.asn1.x509.Certificate.getInstance(aSN1Encodable));
            }
        }
        return null;
    }

    protected CRL createCRL(CertificateList certificateList) throws CRLException {
        return new d(this.a, certificateList);
    }

    private CRL b(InputStream inputStream) throws IOException, CRLException {
        return this.b(c.a(inputStream));
    }

    private CRL b(ASN1InputStream aSN1InputStream) throws IOException, CRLException {
        return this.b(ASN1Sequence.getInstance(aSN1InputStream.readObject()));
    }

    private CRL b(ASN1Sequence aSN1Sequence) throws CRLException {
        if (aSN1Sequence == null) {
            return null;
        }
        if (aSN1Sequence.size() > 1 && aSN1Sequence.getObjectAt(0) instanceof ASN1ObjectIdentifier && aSN1Sequence.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.h = SignedData.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true)).getCRLs();
            return this.b();
        }
        return this.createCRL(CertificateList.getInstance(aSN1Sequence));
    }

    private CRL b() throws CRLException {
        if (this.h == null || this.i >= this.h.size()) {
            return null;
        }
        return this.createCRL(CertificateList.getInstance(this.h.getObjectAt(this.i++)));
    }

    @Override
    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        if (this.g == null) {
            this.g = inputStream;
            this.e = null;
            this.f = 0;
        } else if (this.g != inputStream) {
            this.g = inputStream;
            this.e = null;
            this.f = 0;
        }
        try {
            if (this.e != null) {
                if (this.f != this.e.size()) {
                    return this.a();
                }
                this.e = null;
                this.f = 0;
                return null;
            }
            InputStream inputStream2 = inputStream.markSupported() ? inputStream : new ByteArrayInputStream(Streams.readAll(inputStream));
            inputStream2.mark(1);
            int n2 = inputStream2.read();
            if (n2 == -1) {
                return null;
            }
            inputStream2.reset();
            if (n2 != 48) {
                return this.a(inputStream2);
            }
            return this.a(new ASN1InputStream(inputStream2));
        }
        catch (Exception exception) {
            throw new a("parsing issue: " + exception.getMessage(), exception);
        }
    }

    public Collection engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        Certificate certificate;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        while ((certificate = this.engineGenerateCertificate(bufferedInputStream)) != null) {
            arrayList.add(certificate);
        }
        return arrayList;
    }

    @Override
    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        if (this.j == null) {
            this.j = inputStream;
            this.h = null;
            this.i = 0;
        } else if (this.j != inputStream) {
            this.j = inputStream;
            this.h = null;
            this.i = 0;
        }
        try {
            if (this.h != null) {
                if (this.i != this.h.size()) {
                    return this.b();
                }
                this.h = null;
                this.i = 0;
                return null;
            }
            InputStream inputStream2 = inputStream.markSupported() ? inputStream : new ByteArrayInputStream(Streams.readAll(inputStream));
            inputStream2.mark(1);
            int n2 = inputStream2.read();
            if (n2 == -1) {
                return null;
            }
            inputStream2.reset();
            if (n2 != 48) {
                return this.b(inputStream2);
            }
            return this.b(new ASN1InputStream(inputStream2, true));
        }
        catch (CRLException cRLException) {
            throw cRLException;
        }
        catch (Exception exception) {
            throw new CRLException(exception.toString());
        }
    }

    public Collection engineGenerateCRLs(InputStream inputStream) throws CRLException {
        CRL cRL;
        ArrayList<CRL> arrayList = new ArrayList<CRL>();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        while ((cRL = this.engineGenerateCRL(bufferedInputStream)) != null) {
            arrayList.add(cRL);
        }
        return arrayList;
    }

    public Iterator engineGetCertPathEncodings() {
        return PKIXCertPath.certPathEncodings.iterator();
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inputStream) throws CertificateException {
        return this.engineGenerateCertPath(inputStream, "PkiPath");
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inputStream, String string) throws CertificateException {
        return new PKIXCertPath(inputStream, string);
    }

    public CertPath engineGenerateCertPath(List list) throws CertificateException {
        for (Object e2 : list) {
            if (e2 == null || e2 instanceof X509Certificate) continue;
            throw new CertificateException("list contains non X509Certificate object while creating CertPath\n" + e2.toString());
        }
        return new PKIXCertPath(list);
    }

    private class a
    extends CertificateException {
        private Throwable b;

        public a(Throwable throwable) {
            this.b = throwable;
        }

        public a(String string, Throwable throwable) {
            super(string);
            this.b = throwable;
        }

        @Override
        public Throwable getCause() {
            return this.b;
        }
    }
}

