/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.ecgost12;

import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9IntegerConverter;
import com.aspose.imaging.internal.bouncycastle.crypto.DerivationFunction;
import com.aspose.imaging.internal.bouncycastle.crypto.agreement.ECVKOAgreement;
import com.aspose.imaging.internal.bouncycastle.crypto.digests.GOST3411_2012_256Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.digests.GOST3411_2012_512Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithUKM;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.ecgost12.BCECGOST3410_2012PublicKey;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.ecgost12.a;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util.BaseAgreementSpi;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.aspose.imaging.internal.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import com.aspose.imaging.internal.bouncycastle.jce.interfaces.ECPrivateKey;
import com.aspose.imaging.internal.bouncycastle.jce.interfaces.ECPublicKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class KeyAgreementSpi
extends BaseAgreementSpi {
    private static final X9IntegerConverter a = new X9IntegerConverter();
    private String b;
    private ECDomainParameters c;
    private ECVKOAgreement d;
    private byte[] e;

    protected KeyAgreementSpi(String string, ECVKOAgreement eCVKOAgreement, DerivationFunction derivationFunction) {
        super(string, derivationFunction);
        this.b = string;
        this.d = eCVKOAgreement;
    }

    @Override
    protected Key engineDoPhase(Key key, boolean bl2) throws InvalidKeyException, IllegalStateException {
        if (this.c == null) {
            throw new IllegalStateException(this.b + " not initialised.");
        }
        if (!bl2) {
            throw new IllegalStateException(this.b + " can only be between two parties.");
        }
        if (!(key instanceof PublicKey)) {
            throw new InvalidKeyException(this.b + " key agreement requires " + KeyAgreementSpi.a(ECPublicKey.class) + " for doPhase");
        }
        AsymmetricKeyParameter asymmetricKeyParameter = KeyAgreementSpi.generatePublicKeyParameter((PublicKey)key);
        try {
            this.e = this.d.calculateAgreement(asymmetricKeyParameter);
        }
        catch (Exception exception) {
            throw new a(this, "calculation failed: " + exception.getMessage(), exception);
        }
        return null;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof UserKeyingMaterialSpec)) {
            throw new InvalidAlgorithmParameterException("No algorithm parameters supported");
        }
        this.a(key, algorithmParameterSpec);
    }

    @Override
    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.a(key, null);
    }

    private void a(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException {
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException(this.b + " key agreement requires " + KeyAgreementSpi.a(ECPrivateKey.class) + " for initialisation");
        }
        ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)key);
        this.c = eCPrivateKeyParameters.getParameters();
        this.ukmParameters = algorithmParameterSpec instanceof UserKeyingMaterialSpec ? ((UserKeyingMaterialSpec)algorithmParameterSpec).getUserKeyingMaterial() : null;
        this.d.init(new ParametersWithUKM(eCPrivateKeyParameters, this.ukmParameters));
    }

    private static String a(Class clazz) {
        String string = clazz.getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey publicKey) throws InvalidKeyException {
        return publicKey instanceof BCECGOST3410_2012PublicKey ? ((BCECGOST3410_2012PublicKey)publicKey).engineGetKeyParameters() : ECUtil.generatePublicKeyParameter(publicKey);
    }

    @Override
    protected byte[] calcSecret() {
        return this.e;
    }

    public static class ECVKO256
    extends KeyAgreementSpi {
        public ECVKO256() {
            super("ECGOST3410-2012-256", new ECVKOAgreement(new GOST3411_2012_256Digest()), null);
        }
    }

    public static class ECVKO512
    extends KeyAgreementSpi {
        public ECVKO512() {
            super("ECGOST3410-2012-512", new ECVKOAgreement(new GOST3411_2012_512Digest()), null);
        }
    }
}

