/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.ecgost;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERBitString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERNull;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import com.aspose.imaging.internal.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.sec.ECPrivateKey;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X962Parameters;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9ECParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.ecgost.BCECGOST3410PublicKey;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.aspose.imaging.internal.bouncycastle.jce.ECGOST3410NamedCurveTable;
import com.aspose.imaging.internal.bouncycastle.jce.interfaces.ECPointEncoder;
import com.aspose.imaging.internal.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import com.aspose.imaging.internal.bouncycastle.jce.provider.BouncyCastleProvider;
import com.aspose.imaging.internal.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import com.aspose.imaging.internal.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.aspose.imaging.internal.bouncycastle.jce.spec.ECPrivateKeySpec;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECCurve;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.util.Enumeration;

public class BCECGOST3410PrivateKey
implements ECPointEncoder,
com.aspose.imaging.internal.bouncycastle.jce.interfaces.ECPrivateKey,
PKCS12BagAttributeCarrier,
java.security.interfaces.ECPrivateKey {
    static final long serialVersionUID = 7245981689601667138L;
    private String a = "ECGOST3410";
    private boolean b;
    private transient ASN1Encodable c;
    private transient BigInteger d;
    private transient ECParameterSpec e;
    private transient DERBitString f;
    private transient PKCS12BagAttributeCarrierImpl g = new PKCS12BagAttributeCarrierImpl();

    protected BCECGOST3410PrivateKey() {
    }

    public BCECGOST3410PrivateKey(java.security.interfaces.ECPrivateKey eCPrivateKey) {
        this.d = eCPrivateKey.getS();
        this.a = eCPrivateKey.getAlgorithm();
        this.e = eCPrivateKey.getParams();
    }

    public BCECGOST3410PrivateKey(ECPrivateKeySpec eCPrivateKeySpec) {
        this.d = eCPrivateKeySpec.getD();
        if (eCPrivateKeySpec.getParams() != null) {
            ECCurve eCCurve = eCPrivateKeySpec.getParams().getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, eCPrivateKeySpec.getParams().getSeed());
            this.e = EC5Util.convertSpec(ellipticCurve, eCPrivateKeySpec.getParams());
        } else {
            this.e = null;
        }
    }

    public BCECGOST3410PrivateKey(java.security.spec.ECPrivateKeySpec eCPrivateKeySpec) {
        this.d = eCPrivateKeySpec.getS();
        this.e = eCPrivateKeySpec.getParams();
    }

    public BCECGOST3410PrivateKey(BCECGOST3410PrivateKey bCECGOST3410PrivateKey) {
        this.d = bCECGOST3410PrivateKey.d;
        this.e = bCECGOST3410PrivateKey.e;
        this.b = bCECGOST3410PrivateKey.b;
        this.g = bCECGOST3410PrivateKey.g;
        this.f = bCECGOST3410PrivateKey.f;
        this.c = bCECGOST3410PrivateKey.c;
    }

    public BCECGOST3410PrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters, BCECGOST3410PublicKey bCECGOST3410PublicKey, ECParameterSpec eCParameterSpec) {
        this.a = string;
        this.d = eCPrivateKeyParameters.getD();
        if (eCParameterSpec == null) {
            ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed());
            this.e = new ECParameterSpec(ellipticCurve, EC5Util.convertPoint(eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
        } else {
            this.e = eCParameterSpec;
        }
        this.c = bCECGOST3410PublicKey.getGostParams();
        this.f = this.a(bCECGOST3410PublicKey);
    }

    public BCECGOST3410PrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters, BCECGOST3410PublicKey bCECGOST3410PublicKey, com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec) {
        this.a = string;
        this.d = eCPrivateKeyParameters.getD();
        if (eCParameterSpec == null) {
            ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed());
            this.e = new ECParameterSpec(ellipticCurve, EC5Util.convertPoint(eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
        } else {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getSeed());
            this.e = new ECParameterSpec(ellipticCurve, EC5Util.convertPoint(eCParameterSpec.getG()), eCParameterSpec.getN(), eCParameterSpec.getH().intValue());
        }
        this.c = bCECGOST3410PublicKey.getGostParams();
        this.f = this.a(bCECGOST3410PublicKey);
    }

    public BCECGOST3410PrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters) {
        this.a = string;
        this.d = eCPrivateKeyParameters.getD();
        this.e = null;
    }

    BCECGOST3410PrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.a(privateKeyInfo);
    }

    private void a(PrivateKeyInfo privateKeyInfo) throws IOException {
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getPrivateKeyAlgorithm();
        ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
        ASN1Primitive aSN1Primitive = aSN1Encodable.toASN1Primitive();
        if (aSN1Primitive instanceof ASN1Sequence && (ASN1Sequence.getInstance(aSN1Primitive).size() == 2 || ASN1Sequence.getInstance(aSN1Primitive).size() == 3)) {
            GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = GOST3410PublicKeyAlgParameters.getInstance(aSN1Encodable);
            this.c = gOST3410PublicKeyAlgParameters;
            ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECGOST3410NamedCurveTable.getParameterSpec(ECGOST3410NamedCurves.getName(gOST3410PublicKeyAlgParameters.getPublicKeyParamSet()));
            ECCurve eCCurve = eCNamedCurveParameterSpec.getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, eCNamedCurveParameterSpec.getSeed());
            this.e = new ECNamedCurveSpec(ECGOST3410NamedCurves.getName(gOST3410PublicKeyAlgParameters.getPublicKeyParamSet()), ellipticCurve, EC5Util.convertPoint(eCNamedCurveParameterSpec.getG()), eCNamedCurveParameterSpec.getN(), eCNamedCurveParameterSpec.getH());
            ASN1Encodable aSN1Encodable2 = privateKeyInfo.parsePrivateKey();
            if (aSN1Encodable2 instanceof ASN1Integer) {
                this.d = ASN1Integer.getInstance(aSN1Encodable2).getPositiveValue();
            } else {
                byte[] byArray = ASN1OctetString.getInstance(aSN1Encodable2).getOctets();
                byte[] byArray2 = new byte[byArray.length];
                for (int i2 = 0; i2 != byArray.length; ++i2) {
                    byArray2[i2] = byArray[byArray.length - 1 - i2];
                }
                this.d = new BigInteger(1, byArray2);
            }
        } else {
            Object object;
            ASN1Encodable aSN1Encodable3;
            X962Parameters x962Parameters = X962Parameters.getInstance(aSN1Encodable);
            if (x962Parameters.isNamedCurve()) {
                String string;
                Object object2;
                aSN1Encodable3 = ASN1ObjectIdentifier.getInstance(x962Parameters.getParameters());
                object = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)aSN1Encodable3);
                if (object == null) {
                    object2 = ECGOST3410NamedCurves.getByOID((ASN1ObjectIdentifier)aSN1Encodable3);
                    object = new X9ECParameters(((ECDomainParameters)object2).getCurve(), ((ECDomainParameters)object2).getG(), ((ECDomainParameters)object2).getN(), ((ECDomainParameters)object2).getH(), ((ECDomainParameters)object2).getSeed());
                    string = ECGOST3410NamedCurves.getName((ASN1ObjectIdentifier)aSN1Encodable3);
                } else {
                    string = ECUtil.getCurveName((ASN1ObjectIdentifier)aSN1Encodable3);
                }
                object2 = EC5Util.convertCurve(((X9ECParameters)object).getCurve(), ((X9ECParameters)object).getSeed());
                this.e = new ECNamedCurveSpec(string, (EllipticCurve)object2, EC5Util.convertPoint(((X9ECParameters)object).getG()), ((X9ECParameters)object).getN(), ((X9ECParameters)object).getH());
            } else if (x962Parameters.isImplicitlyCA()) {
                this.e = null;
            } else {
                aSN1Encodable3 = X9ECParameters.getInstance(x962Parameters.getParameters());
                object = EC5Util.convertCurve(((X9ECParameters)aSN1Encodable3).getCurve(), ((X9ECParameters)aSN1Encodable3).getSeed());
                this.e = new ECParameterSpec((EllipticCurve)object, EC5Util.convertPoint(((X9ECParameters)aSN1Encodable3).getG()), ((X9ECParameters)aSN1Encodable3).getN(), ((X9ECParameters)aSN1Encodable3).getH().intValue());
            }
            aSN1Encodable3 = privateKeyInfo.parsePrivateKey();
            if (aSN1Encodable3 instanceof ASN1Integer) {
                object = ASN1Integer.getInstance(aSN1Encodable3);
                this.d = ((ASN1Integer)object).getValue();
            } else {
                object = ECPrivateKey.getInstance(aSN1Encodable3);
                this.d = ((ECPrivateKey)object).getKey();
                this.f = ((ECPrivateKey)object).getPublicKey();
            }
        }
    }

    @Override
    public String getAlgorithm() {
        return this.a;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        ASN1Object aSN1Object;
        int n2;
        X962Parameters x962Parameters;
        Object object;
        if (this.c != null) {
            byte[] byArray = new byte[32];
            this.a(byArray, 0, this.getS());
            try {
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, this.c), new DEROctetString(byArray));
                return privateKeyInfo.getEncoded("DER");
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (this.e instanceof ECNamedCurveSpec) {
            object = ECUtil.getNamedCurveOid(((ECNamedCurveSpec)this.e).getName());
            if (object == null) {
                object = new ASN1ObjectIdentifier(((ECNamedCurveSpec)this.e).getName());
            }
            x962Parameters = new X962Parameters((ASN1ObjectIdentifier)object);
            n2 = ECUtil.getOrderBitLength(BouncyCastleProvider.CONFIGURATION, this.e.getOrder(), this.getS());
        } else if (this.e == null) {
            x962Parameters = new X962Parameters(DERNull.INSTANCE);
            n2 = ECUtil.getOrderBitLength(BouncyCastleProvider.CONFIGURATION, null, this.getS());
        } else {
            object = EC5Util.convertCurve(this.e.getCurve());
            aSN1Object = new X9ECParameters((ECCurve)object, EC5Util.convertPoint((ECCurve)object, this.e.getGenerator(), this.b), this.e.getOrder(), BigInteger.valueOf(this.e.getCofactor()), this.e.getCurve().getSeed());
            x962Parameters = new X962Parameters((X9ECParameters)aSN1Object);
            n2 = ECUtil.getOrderBitLength(BouncyCastleProvider.CONFIGURATION, this.e.getOrder(), this.getS());
        }
        aSN1Object = this.f != null ? new ECPrivateKey(n2, this.getS(), this.f, x962Parameters) : new ECPrivateKey(n2, this.getS(), (ASN1Encodable)x962Parameters);
        try {
            object = new PrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, x962Parameters.toASN1Primitive()), ((ECPrivateKey)aSN1Object).toASN1Primitive());
            return ((ASN1Object)object).getEncoded("DER");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void a(byte[] byArray, int n2, BigInteger bigInteger) {
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length < 32) {
            byte[] byArray3 = new byte[32];
            System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
            byArray2 = byArray3;
        }
        for (int i2 = 0; i2 != 32; ++i2) {
            byArray[n2 + i2] = byArray2[byArray2.length - 1 - i2];
        }
    }

    @Override
    public ECParameterSpec getParams() {
        return this.e;
    }

    @Override
    public com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec getParameters() {
        if (this.e == null) {
            return null;
        }
        return EC5Util.convertSpec(this.e, this.b);
    }

    com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec engineGetSpec() {
        if (this.e != null) {
            return EC5Util.convertSpec(this.e, this.b);
        }
        return BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    @Override
    public BigInteger getS() {
        return this.d;
    }

    @Override
    public BigInteger getD() {
        return this.d;
    }

    @Override
    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.g.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    @Override
    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.g.getBagAttribute(aSN1ObjectIdentifier);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.g.getBagAttributeKeys();
    }

    @Override
    public void setPointFormat(String string) {
        this.b = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCECGOST3410PrivateKey)) {
            return false;
        }
        BCECGOST3410PrivateKey bCECGOST3410PrivateKey = (BCECGOST3410PrivateKey)object;
        return this.getD().equals(bCECGOST3410PrivateKey.getD()) && this.engineGetSpec().equals(bCECGOST3410PrivateKey.engineGetSpec());
    }

    public int hashCode() {
        return this.getD().hashCode() ^ this.engineGetSpec().hashCode();
    }

    public String toString() {
        return ECUtil.privateKeyToString(this.a, this.d, this.engineGetSpec());
    }

    private DERBitString a(BCECGOST3410PublicKey bCECGOST3410PublicKey) {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(bCECGOST3410PublicKey.getEncoded()));
            return subjectPublicKeyInfo.getPublicKeyData();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void a(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.a(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray)));
        this.g = new PKCS12BagAttributeCarrierImpl();
    }

    private void a(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

