/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.ec;

import com.aspose.imaging.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.imaging.internal.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import com.aspose.imaging.internal.bouncycastle.crypto.engines.AESEngine;
import com.aspose.imaging.internal.bouncycastle.crypto.engines.DESedeEngine;
import com.aspose.imaging.internal.bouncycastle.crypto.engines.IESEngine;
import com.aspose.imaging.internal.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.aspose.imaging.internal.bouncycastle.crypto.generators.EphemeralKeyPairGenerator;
import com.aspose.imaging.internal.bouncycastle.crypto.generators.KDF2BytesGenerator;
import com.aspose.imaging.internal.bouncycastle.crypto.macs.HMac;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.CBCBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.IESWithCipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.imaging.internal.bouncycastle.crypto.parsers.ECIESPublicKeyParser;
import com.aspose.imaging.internal.bouncycastle.crypto.util.DigestFactory;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.ec.a;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.ec.b;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util.IESUtil;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.util.BadBlockException;
import com.aspose.imaging.internal.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.aspose.imaging.internal.bouncycastle.jcajce.util.JcaJceHelper;
import com.aspose.imaging.internal.bouncycastle.jce.interfaces.ECKey;
import com.aspose.imaging.internal.bouncycastle.jce.interfaces.IESKey;
import com.aspose.imaging.internal.bouncycastle.jce.spec.IESParameterSpec;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.imaging.internal.bouncycastle.util.Strings;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class IESCipher
extends CipherSpi {
    private final JcaJceHelper a = new BCJcaJceHelper();
    private int b;
    private IESEngine c;
    private int d = -1;
    private ByteArrayOutputStream e = new ByteArrayOutputStream();
    private AlgorithmParameters f = null;
    private IESParameterSpec g = null;
    private AsymmetricKeyParameter h;
    private SecureRandom i;
    private boolean j = false;
    private AsymmetricKeyParameter k = null;

    public IESCipher(IESEngine iESEngine) {
        this.c = iESEngine;
        this.b = 0;
    }

    public IESCipher(IESEngine iESEngine, int n2) {
        this.c = iESEngine;
        this.b = n2;
    }

    @Override
    public int engineGetBlockSize() {
        if (this.c.getCipher() != null) {
            return this.c.getCipher().getBlockSize();
        }
        return 0;
    }

    @Override
    public int engineGetKeySize(Key key) {
        if (key instanceof ECKey) {
            return ((ECKey)((Object)key)).getParameters().getCurve().getFieldSize();
        }
        throw new IllegalArgumentException("not an EC key");
    }

    @Override
    public byte[] engineGetIV() {
        if (this.g != null) {
            return this.g.getNonce();
        }
        return null;
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        if (this.f == null && this.g != null) {
            try {
                this.f = this.a.createAlgorithmParameters("IES");
                this.f.init(this.g);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }
        return this.f;
    }

    @Override
    public void engineSetMode(String string) throws NoSuchAlgorithmException {
        String string2 = Strings.toUpperCase(string);
        if (string2.equals("NONE")) {
            this.j = false;
        } else if (string2.equals("DHAES")) {
            this.j = true;
        } else {
            throw new IllegalArgumentException("can't support mode " + string);
        }
    }

    @Override
    public int engineGetOutputSize(int n2) {
        int n3;
        int n4;
        if (this.h == null) {
            throw new IllegalStateException("cipher not initialised");
        }
        int n5 = this.c.getMac().getMacSize();
        if (this.k == null) {
            ECCurve eCCurve = ((ECKeyParameters)this.h).getParameters().getCurve();
            int n6 = (eCCurve.getFieldSize() + 7) / 8;
            n4 = 2 * n6;
        } else {
            n4 = 0;
        }
        if (this.c.getCipher() == null) {
            n3 = n2;
        } else if (this.d == 1 || this.d == 3) {
            n3 = this.c.getCipher().getOutputSize(n2);
        } else if (this.d == 2 || this.d == 4) {
            n3 = this.c.getCipher().getOutputSize(n2 - n5 - n4);
        } else {
            throw new IllegalStateException("cipher not initialised");
        }
        if (this.d == 1 || this.d == 3) {
            return this.e.size() + n5 + 1 + n4 + n3;
        }
        if (this.d == 2 || this.d == 4) {
            return this.e.size() - n5 - n4 + n3;
        }
        throw new IllegalStateException("cipher not initialised");
    }

    @Override
    public void engineSetPadding(String string) throws NoSuchPaddingException {
        String string2 = Strings.toUpperCase(string);
        if (!(string2.equals("NOPADDING") || string2.equals("PKCS5PADDING") || string2.equals("PKCS7PADDING"))) {
            throw new NoSuchPaddingException("padding not available with IESCipher");
        }
    }

    @Override
    public void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IESParameterSpec iESParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                iESParameterSpec = algorithmParameters.getParameterSpec(IESParameterSpec.class);
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException("cannot recognise parameters: " + exception.toString());
            }
        }
        this.f = algorithmParameters;
        this.engineInit(n2, key, iESParameterSpec, secureRandom);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        byte[] byArray;
        this.k = null;
        if (algorithmParameterSpec == null) {
            byArray = null;
            if (this.b != 0 && n2 == 1) {
                byArray = new byte[this.b];
                secureRandom.nextBytes(byArray);
            }
            this.g = IESUtil.guessParameterSpec(this.c.getCipher(), byArray);
        } else {
            if (!(algorithmParameterSpec instanceof IESParameterSpec)) throw new InvalidAlgorithmParameterException("must be passed IES parameters");
            this.g = (IESParameterSpec)algorithmParameterSpec;
        }
        byArray = this.g.getNonce();
        if (this.b != 0 && (byArray == null || byArray.length != this.b)) {
            throw new InvalidAlgorithmParameterException("NONCE in IES Parameters needs to be " + this.b + " bytes long");
        }
        if (n2 == 1 || n2 == 3) {
            if (key instanceof PublicKey) {
                this.h = com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.ec.a.a((PublicKey)key);
            } else {
                if (!(key instanceof IESKey)) throw new InvalidKeyException("must be passed recipient's public EC key for encryption");
                IESKey iESKey = (IESKey)key;
                this.h = com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.ec.a.a(iESKey.getPublic());
                this.k = ECUtil.generatePrivateKeyParameter(iESKey.getPrivate());
            }
        } else {
            if (n2 != 2 && n2 != 4) throw new InvalidKeyException("must be passed EC key");
            if (key instanceof PrivateKey) {
                this.h = ECUtil.generatePrivateKeyParameter((PrivateKey)key);
            } else {
                if (!(key instanceof IESKey)) throw new InvalidKeyException("must be passed recipient's private EC key for decryption");
                IESKey iESKey = (IESKey)key;
                this.k = com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.ec.a.a(iESKey.getPublic());
                this.h = ECUtil.generatePrivateKeyParameter(iESKey.getPrivate());
            }
        }
        this.i = secureRandom;
        this.d = n2;
        this.e.reset();
    }

    @Override
    public void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n2, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException("cannot handle supplied parameter spec: " + invalidAlgorithmParameterException.getMessage());
        }
    }

    @Override
    public byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        this.e.write(byArray, n2, n3);
        return null;
    }

    @Override
    public int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        this.e.write(byArray, n2, n3);
        return 0;
    }

    @Override
    public byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        if (n3 != 0) {
            this.e.write(byArray, n2, n3);
        }
        byte[] byArray2 = this.e.toByteArray();
        this.e.reset();
        CipherParameters cipherParameters = new IESWithCipherParameters(this.g.getDerivationV(), this.g.getEncodingV(), this.g.getMacKeySize(), this.g.getCipherKeySize());
        if (this.g.getNonce() != null) {
            cipherParameters = new ParametersWithIV(cipherParameters, this.g.getNonce());
        }
        ECDomainParameters eCDomainParameters = ((ECKeyParameters)this.h).getParameters();
        if (this.k != null) {
            try {
                if (this.d == 1 || this.d == 3) {
                    this.c.init(true, this.k, this.h, cipherParameters);
                } else {
                    this.c.init(false, this.h, this.k, cipherParameters);
                }
                return this.c.processBlock(byArray2, 0, byArray2.length);
            }
            catch (Exception exception) {
                throw new BadBlockException("unable to process block", exception);
            }
        }
        if (this.d == 1 || this.d == 3) {
            ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
            eCKeyPairGenerator.init(new ECKeyGenerationParameters(eCDomainParameters, this.i));
            boolean bl2 = this.g.getPointCompression();
            EphemeralKeyPairGenerator ephemeralKeyPairGenerator = new EphemeralKeyPairGenerator(eCKeyPairGenerator, new b(this, bl2));
            try {
                this.c.init(this.h, cipherParameters, ephemeralKeyPairGenerator);
                return this.c.processBlock(byArray2, 0, byArray2.length);
            }
            catch (Exception exception) {
                throw new BadBlockException("unable to process block", exception);
            }
        }
        if (this.d == 2 || this.d == 4) {
            try {
                this.c.init(this.h, cipherParameters, new ECIESPublicKeyParser(eCDomainParameters));
                return this.c.processBlock(byArray2, 0, byArray2.length);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new BadBlockException("unable to process block", invalidCipherTextException);
            }
        }
        throw new IllegalStateException("cipher not initialised");
    }

    @Override
    public int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray3 = this.engineDoFinal(byArray, n2, n3);
        System.arraycopy(byArray3, 0, byArray2, n4, byArray3.length);
        return byArray3.length;
    }

    public static class ECIES
    extends IESCipher {
        public ECIES() {
            super(new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(DigestFactory.createSHA1()), new HMac(DigestFactory.createSHA1())));
        }
    }

    public static class ECIESwithAESCBC
    extends ECIESwithCipher {
        public ECIESwithAESCBC() {
            super(new CBCBlockCipher(new AESEngine()), 16);
        }
    }

    public static class ECIESwithCipher
    extends IESCipher {
        public ECIESwithCipher(BlockCipher blockCipher, int n2) {
            super(new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(DigestFactory.createSHA1()), new HMac(DigestFactory.createSHA1()), new PaddedBufferedBlockCipher(blockCipher)), n2);
        }
    }

    public static class ECIESwithDESedeCBC
    extends ECIESwithCipher {
        public ECIESwithDESedeCBC() {
            super(new CBCBlockCipher(new DESedeEngine()), 8);
        }
    }
}

