/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.ec;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.DERBitString;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X962Parameters;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.ec.a;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.aspose.imaging.internal.bouncycastle.jce.interfaces.ECPointEncoder;
import com.aspose.imaging.internal.bouncycastle.jce.interfaces.ECPrivateKey;
import com.aspose.imaging.internal.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import com.aspose.imaging.internal.bouncycastle.jce.provider.BouncyCastleProvider;
import com.aspose.imaging.internal.bouncycastle.jce.spec.ECPrivateKeySpec;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECPoint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.util.Enumeration;

public class BCECPrivateKey
implements ECPointEncoder,
ECPrivateKey,
PKCS12BagAttributeCarrier,
java.security.interfaces.ECPrivateKey {
    static final long serialVersionUID = 994553197664784084L;
    private String a = "EC";
    private boolean b;
    private transient BigInteger c;
    private transient ECParameterSpec d;
    private transient ProviderConfiguration e;
    private transient DERBitString f;
    private transient PKCS12BagAttributeCarrierImpl g = new PKCS12BagAttributeCarrierImpl();

    protected BCECPrivateKey() {
    }

    public BCECPrivateKey(java.security.interfaces.ECPrivateKey eCPrivateKey, ProviderConfiguration providerConfiguration) {
        this.c = eCPrivateKey.getS();
        this.a = eCPrivateKey.getAlgorithm();
        this.d = eCPrivateKey.getParams();
        this.e = providerConfiguration;
    }

    public BCECPrivateKey(String string, ECPrivateKeySpec eCPrivateKeySpec, ProviderConfiguration providerConfiguration) {
        this.a = string;
        this.c = eCPrivateKeySpec.getD();
        if (eCPrivateKeySpec.getParams() != null) {
            ECCurve eCCurve = eCPrivateKeySpec.getParams().getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, eCPrivateKeySpec.getParams().getSeed());
            this.d = EC5Util.convertSpec(ellipticCurve, eCPrivateKeySpec.getParams());
        } else {
            this.d = null;
        }
        this.e = providerConfiguration;
    }

    public BCECPrivateKey(String string, java.security.spec.ECPrivateKeySpec eCPrivateKeySpec, ProviderConfiguration providerConfiguration) {
        this.a = string;
        this.c = eCPrivateKeySpec.getS();
        this.d = eCPrivateKeySpec.getParams();
        this.e = providerConfiguration;
    }

    public BCECPrivateKey(String string, BCECPrivateKey bCECPrivateKey) {
        this.a = string;
        this.c = bCECPrivateKey.c;
        this.d = bCECPrivateKey.d;
        this.b = bCECPrivateKey.b;
        this.g = bCECPrivateKey.g;
        this.f = bCECPrivateKey.f;
        this.e = bCECPrivateKey.e;
    }

    public BCECPrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters, BCECPublicKey bCECPublicKey, ECParameterSpec eCParameterSpec, ProviderConfiguration providerConfiguration) {
        this.a = string;
        this.c = eCPrivateKeyParameters.getD();
        this.e = providerConfiguration;
        if (eCParameterSpec == null) {
            ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed());
            this.d = new ECParameterSpec(ellipticCurve, EC5Util.convertPoint(eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
        } else {
            this.d = eCParameterSpec;
        }
        this.f = this.a(bCECPublicKey);
    }

    public BCECPrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters, BCECPublicKey bCECPublicKey, com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec, ProviderConfiguration providerConfiguration) {
        this.a = string;
        this.c = eCPrivateKeyParameters.getD();
        this.e = providerConfiguration;
        if (eCParameterSpec == null) {
            ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed());
            this.d = new ECParameterSpec(ellipticCurve, EC5Util.convertPoint(eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
        } else {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getSeed());
            this.d = EC5Util.convertSpec(ellipticCurve, eCParameterSpec);
        }
        try {
            this.f = this.a(bCECPublicKey);
        }
        catch (Exception exception) {
            this.f = null;
        }
    }

    public BCECPrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters, ProviderConfiguration providerConfiguration) {
        this.a = string;
        this.c = eCPrivateKeyParameters.getD();
        this.d = null;
        this.e = providerConfiguration;
    }

    BCECPrivateKey(String string, PrivateKeyInfo privateKeyInfo, ProviderConfiguration providerConfiguration) throws IOException {
        this.a = string;
        this.e = providerConfiguration;
        this.a(privateKeyInfo);
    }

    private void a(PrivateKeyInfo privateKeyInfo) throws IOException {
        X962Parameters x962Parameters = X962Parameters.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
        ECCurve eCCurve = EC5Util.getCurve(this.e, x962Parameters);
        this.d = EC5Util.convertToSpec(x962Parameters, eCCurve);
        ASN1Encodable aSN1Encodable = privateKeyInfo.parsePrivateKey();
        if (aSN1Encodable instanceof ASN1Integer) {
            ASN1Integer aSN1Integer = ASN1Integer.getInstance(aSN1Encodable);
            this.c = aSN1Integer.getValue();
        } else {
            com.aspose.imaging.internal.bouncycastle.asn1.sec.ECPrivateKey eCPrivateKey = com.aspose.imaging.internal.bouncycastle.asn1.sec.ECPrivateKey.getInstance(aSN1Encodable);
            this.c = eCPrivateKey.getKey();
            this.f = eCPrivateKey.getPublicKey();
        }
    }

    @Override
    public String getAlgorithm() {
        return this.a;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        X962Parameters x962Parameters = com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.ec.a.a(this.d, this.b);
        int n2 = this.d == null ? ECUtil.getOrderBitLength(this.e, null, this.getS()) : ECUtil.getOrderBitLength(this.e, this.d.getOrder(), this.getS());
        com.aspose.imaging.internal.bouncycastle.asn1.sec.ECPrivateKey eCPrivateKey = this.f != null ? new com.aspose.imaging.internal.bouncycastle.asn1.sec.ECPrivateKey(n2, this.getS(), this.f, x962Parameters) : new com.aspose.imaging.internal.bouncycastle.asn1.sec.ECPrivateKey(n2, this.getS(), (ASN1Encodable)x962Parameters);
        try {
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), eCPrivateKey);
            return privateKeyInfo.getEncoded("DER");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public ECParameterSpec getParams() {
        return this.d;
    }

    @Override
    public com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec getParameters() {
        if (this.d == null) {
            return null;
        }
        return EC5Util.convertSpec(this.d, this.b);
    }

    com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec engineGetSpec() {
        if (this.d != null) {
            return EC5Util.convertSpec(this.d, this.b);
        }
        return this.e.getEcImplicitlyCa();
    }

    @Override
    public BigInteger getS() {
        return this.c;
    }

    @Override
    public BigInteger getD() {
        return this.c;
    }

    @Override
    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.g.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    @Override
    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.g.getBagAttribute(aSN1ObjectIdentifier);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.g.getBagAttributeKeys();
    }

    @Override
    public void setPointFormat(String string) {
        this.b = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCECPrivateKey)) {
            return false;
        }
        BCECPrivateKey bCECPrivateKey = (BCECPrivateKey)object;
        return this.getD().equals(bCECPrivateKey.getD()) && this.engineGetSpec().equals(bCECPrivateKey.engineGetSpec());
    }

    public int hashCode() {
        return this.getD().hashCode() ^ this.engineGetSpec().hashCode();
    }

    public String toString() {
        return ECUtil.privateKeyToString("EC", this.c, this.engineGetSpec());
    }

    private ECPoint a(com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec) {
        return eCParameterSpec.getG().multiply(this.c).normalize();
    }

    private DERBitString a(BCECPublicKey bCECPublicKey) {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(bCECPublicKey.getEncoded()));
            return subjectPublicKeyInfo.getPublicKeyData();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void a(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.e = BouncyCastleProvider.CONFIGURATION;
        this.a(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray)));
        this.g = new PKCS12BagAttributeCarrierImpl();
    }

    private void a(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

