/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.parsers;

import com.aspose.imaging.internal.bouncycastle.crypto.KeyParser;
import com.aspose.imaging.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.aspose.imaging.internal.bouncycastle.util.io.Streams;
import java.io.IOException;
import java.io.InputStream;

public class ECIESPublicKeyParser
implements KeyParser {
    private ECDomainParameters a;

    public ECIESPublicKeyParser(ECDomainParameters eCDomainParameters) {
        this.a = eCDomainParameters;
    }

    @Override
    public AsymmetricKeyParameter readKey(InputStream inputStream) throws IOException {
        byte[] byArray;
        int n2 = inputStream.read();
        switch (n2) {
            case 0: {
                throw new IOException("Sender's public key invalid.");
            }
            case 2: 
            case 3: {
                byArray = new byte[1 + (this.a.getCurve().getFieldSize() + 7) / 8];
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                byArray = new byte[1 + 2 * ((this.a.getCurve().getFieldSize() + 7) / 8)];
                break;
            }
            default: {
                throw new IOException("Sender's public key has invalid point encoding 0x" + Integer.toString(n2, 16));
            }
        }
        byArray[0] = (byte)n2;
        Streams.readFully(inputStream, byArray, 1, byArray.length - 1);
        return new ECPublicKeyParameters(this.a.getCurve().decodePoint(byArray), this.a);
    }
}

