/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.macs;

import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.Mac;
import com.aspose.imaging.internal.bouncycastle.crypto.digests.SkeinEngine;
import com.aspose.imaging.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.imaging.internal.bouncycastle.crypto.params.SkeinParameters;

public class SkeinMac
implements Mac {
    public static final int SKEIN_256 = 256;
    public static final int SKEIN_512 = 512;
    public static final int SKEIN_1024 = 1024;
    private SkeinEngine a;

    public SkeinMac(int n2, int n3) {
        this.a = new SkeinEngine(n2, n3);
    }

    public SkeinMac(SkeinMac skeinMac) {
        this.a = new SkeinEngine(skeinMac.a);
    }

    @Override
    public String getAlgorithmName() {
        return "Skein-MAC-" + this.a.getBlockSize() * 8 + "-" + this.a.getOutputSize() * 8;
    }

    @Override
    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        SkeinParameters skeinParameters;
        if (cipherParameters instanceof SkeinParameters) {
            skeinParameters = (SkeinParameters)cipherParameters;
        } else if (cipherParameters instanceof KeyParameter) {
            skeinParameters = new SkeinParameters.Builder().setKey(((KeyParameter)cipherParameters).getKey()).build();
        } else {
            throw new IllegalArgumentException("Invalid parameter passed to Skein MAC init - " + cipherParameters.getClass().getName());
        }
        if (skeinParameters.getKey() == null) {
            throw new IllegalArgumentException("Skein MAC requires a key parameter.");
        }
        this.a.init(skeinParameters);
    }

    @Override
    public int getMacSize() {
        return this.a.getOutputSize();
    }

    @Override
    public void reset() {
        this.a.reset();
    }

    @Override
    public void update(byte by2) {
        this.a.update(by2);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        this.a.update(byArray, n2, n3);
    }

    @Override
    public int doFinal(byte[] byArray, int n2) {
        return this.a.doFinal(byArray, n2);
    }
}

