/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.macs;

import com.aspose.imaging.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.Mac;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.CBCBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.paddings.BlockCipherPadding;

public class CBCBlockCipherMac
implements Mac {
    private byte[] a;
    private byte[] b;
    private int c;
    private BlockCipher d;
    private BlockCipherPadding e;
    private int f;

    public CBCBlockCipherMac(BlockCipher blockCipher) {
        this(blockCipher, blockCipher.getBlockSize() * 8 / 2, null);
    }

    public CBCBlockCipherMac(BlockCipher blockCipher, BlockCipherPadding blockCipherPadding) {
        this(blockCipher, blockCipher.getBlockSize() * 8 / 2, blockCipherPadding);
    }

    public CBCBlockCipherMac(BlockCipher blockCipher, int n2) {
        this(blockCipher, n2, null);
    }

    public CBCBlockCipherMac(BlockCipher blockCipher, int n2, BlockCipherPadding blockCipherPadding) {
        if (n2 % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        this.d = new CBCBlockCipher(blockCipher);
        this.e = blockCipherPadding;
        this.f = n2 / 8;
        this.a = new byte[blockCipher.getBlockSize()];
        this.b = new byte[blockCipher.getBlockSize()];
        this.c = 0;
    }

    @Override
    public String getAlgorithmName() {
        return this.d.getAlgorithmName();
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        this.reset();
        this.d.init(true, cipherParameters);
    }

    @Override
    public int getMacSize() {
        return this.f;
    }

    @Override
    public void update(byte by2) {
        if (this.c == this.b.length) {
            this.d.processBlock(this.b, 0, this.a, 0);
            this.c = 0;
        }
        this.b[this.c++] = by2;
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n4 = this.d.getBlockSize();
        int n5 = n4 - this.c;
        if (n3 > n5) {
            System.arraycopy(byArray, n2, this.b, this.c, n5);
            this.d.processBlock(this.b, 0, this.a, 0);
            this.c = 0;
            n3 -= n5;
            n2 += n5;
            while (n3 > n4) {
                this.d.processBlock(byArray, n2, this.a, 0);
                n3 -= n4;
                n2 += n4;
            }
        }
        System.arraycopy(byArray, n2, this.b, this.c, n3);
        this.c += n3;
    }

    @Override
    public int doFinal(byte[] byArray, int n2) {
        int n3 = this.d.getBlockSize();
        if (this.e == null) {
            while (this.c < n3) {
                this.b[this.c] = 0;
                ++this.c;
            }
        } else {
            if (this.c == n3) {
                this.d.processBlock(this.b, 0, this.a, 0);
                this.c = 0;
            }
            this.e.addPadding(this.b, this.c);
        }
        this.d.processBlock(this.b, 0, this.a, 0);
        System.arraycopy(this.a, 0, byArray, n2, this.f);
        this.reset();
        return this.f;
    }

    @Override
    public void reset() {
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            this.b[i2] = 0;
        }
        this.c = 0;
        this.d.reset();
    }
}

