/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.macs;

import com.aspose.imaging.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.Mac;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.CBCBlockCipher;

public class BlockCipherMac
implements Mac {
    private byte[] a;
    private byte[] b;
    private int c;
    private BlockCipher d;
    private int e;

    public BlockCipherMac(BlockCipher blockCipher) {
        this(blockCipher, blockCipher.getBlockSize() * 8 / 2);
    }

    public BlockCipherMac(BlockCipher blockCipher, int n2) {
        if (n2 % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        this.d = new CBCBlockCipher(blockCipher);
        this.e = n2 / 8;
        this.a = new byte[blockCipher.getBlockSize()];
        this.b = new byte[blockCipher.getBlockSize()];
        this.c = 0;
    }

    @Override
    public String getAlgorithmName() {
        return this.d.getAlgorithmName();
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        this.reset();
        this.d.init(true, cipherParameters);
    }

    @Override
    public int getMacSize() {
        return this.e;
    }

    @Override
    public void update(byte by2) {
        if (this.c == this.b.length) {
            this.d.processBlock(this.b, 0, this.a, 0);
            this.c = 0;
        }
        this.b[this.c++] = by2;
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n4 = this.d.getBlockSize();
        int n5 = 0;
        int n6 = n4 - this.c;
        if (n3 > n6) {
            System.arraycopy(byArray, n2, this.b, this.c, n6);
            n5 += this.d.processBlock(this.b, 0, this.a, 0);
            this.c = 0;
            n3 -= n6;
            n2 += n6;
            while (n3 > n4) {
                n5 += this.d.processBlock(byArray, n2, this.a, 0);
                n3 -= n4;
                n2 += n4;
            }
        }
        System.arraycopy(byArray, n2, this.b, this.c, n3);
        this.c += n3;
    }

    @Override
    public int doFinal(byte[] byArray, int n2) {
        int n3 = this.d.getBlockSize();
        while (this.c < n3) {
            this.b[this.c] = 0;
            ++this.c;
        }
        this.d.processBlock(this.b, 0, this.a, 0);
        System.arraycopy(this.a, 0, byArray, n2, this.e);
        this.reset();
        return this.e;
    }

    @Override
    public void reset() {
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            this.b[i2] = 0;
        }
        this.c = 0;
        this.d.reset();
    }
}

